/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNDirectory;
import org.tmatesoft.svn.core.internal.wc.SVNEntries;
import org.tmatesoft.svn.core.internal.wc.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExportEditor;
import org.tmatesoft.svn.core.internal.wc.SVNExternalInfo;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNProperties;
import org.tmatesoft.svn.core.internal.wc.SVNReporter;
import org.tmatesoft.svn.core.internal.wc.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.SVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVNUpdateClient
extends SVNBasicClient {
    public SVNUpdateClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    protected SVNUpdateClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doUpdate(File file, SVNRevision revision, boolean recursive) throws SVNException {
        SVNWCAccess wcAccess = this.createWCAccess(file);
        SVNReporter reporter = new SVNReporter(wcAccess, true, recursive);
        try {
            wcAccess.open(true, recursive);
            SVNEntry entry = wcAccess.getAnchor().getEntries().getEntry("", false);
            SVNURL url = entry.getSVNURL();
            SVNUpdateEditor editor = new SVNUpdateEditor(wcAccess, null, recursive, this.isLeaveConflictsUnresolved());
            SVNRepository repos = this.createRepository(url, true);
            String target = "".equals(wcAccess.getTargetName()) ? null : wcAccess.getTargetName();
            long revNumber = this.getRevisionNumber(revision, repos, file);
            repos.update(revNumber, target, recursive, reporter, SVNCancellableEditor.newInstance(editor, this));
            if (editor.getTargetRevision() >= 0L) {
                if (recursive && !this.isIgnoreExternals()) {
                    this.handleExternals(wcAccess);
                }
                this.dispatchEvent(SVNEventFactory.createUpdateCompletedEvent(wcAccess, editor.getTargetRevision()));
            }
            long l = editor.getTargetRevision();
            return l;
        }
        finally {
            wcAccess.close(true);
            this.sleepForTimeStamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doSwitch(File file, SVNURL url, SVNRevision revision, boolean recursive) throws SVNException {
        SVNWCAccess wcAccess = this.createWCAccess(file);
        SVNReporter reporter = new SVNReporter(wcAccess, true, recursive);
        try {
            wcAccess.open(true, recursive);
            SVNEntry entry = wcAccess.getAnchor().getEntries().getEntry("", false);
            if (entry == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", file);
                SVNErrorManager.error(err);
            }
            SVNURL sourceURL = entry.getSVNURL();
            if (url == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", file);
                SVNErrorManager.error(err);
            }
            SVNRepository repository = this.createRepository(sourceURL, true);
            long revNumber = this.getRevisionNumber(revision, repository, file);
            SVNUpdateEditor editor = new SVNUpdateEditor(wcAccess, url.toString(), recursive, this.isLeaveConflictsUnresolved());
            String target = "".equals(wcAccess.getTargetName()) ? null : wcAccess.getTargetName();
            repository.update(url, revNumber, target, recursive, reporter, SVNCancellableEditor.newInstance(editor, this));
            if (editor.getTargetRevision() >= 0L && recursive && !this.isIgnoreExternals()) {
                this.handleExternals(wcAccess);
                this.dispatchEvent(SVNEventFactory.createUpdateCompletedEvent(wcAccess, editor.getTargetRevision()));
            }
            long l = editor.getTargetRevision();
            return l;
        }
        finally {
            wcAccess.close(true);
            this.sleepForTimeStamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doCheckout(SVNURL url, File dstPath, SVNRevision pegRevision, SVNRevision revision, boolean recursive) throws SVNException {
        SVNErrorMessage err;
        if (dstPath == null) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.BAD_FILENAME, "Checkout destination path can not be NULL");
            SVNErrorManager.error(err2);
        }
        SVNRepository repos = this.createRepository(url, null, pegRevision, revision);
        long revNumber = this.getRevisionNumber(revision, repos, null);
        SVNNodeKind targetNodeKind = repos.checkPath("", revNumber);
        String uuid = repos.getRepositoryUUID(true);
        SVNURL repositoryRoot = repos.getRepositoryRoot(true);
        if (targetNodeKind == SVNNodeKind.FILE) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "URL ''{0}'' refers to a file, not a directory", url);
            SVNErrorManager.error(err);
        } else if (targetNodeKind == SVNNodeKind.NONE) {
            err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' doesn't exist", url);
            SVNErrorManager.error(err);
        }
        long result = -1L;
        SVNWCAccess wcAccess = null;
        SVNEntry entry = null;
        try {
            try {
                wcAccess = this.createWCAccess(dstPath);
                entry = wcAccess != null ? wcAccess.getTargetEntry() : null;
            }
            catch (SVNException e) {
                // empty catch block
            }
            if (!dstPath.exists() || wcAccess == null || entry == null) {
                this.createVersionedDirectory(dstPath, url, repositoryRoot, uuid, revNumber);
                result = this.doUpdate(dstPath, revision, recursive);
            } else if (dstPath.isDirectory() && entry != null) {
                if (url.equals(entry.getSVNURL())) {
                    result = this.doUpdate(dstPath, revision, recursive);
                } else {
                    String message = "''{0}'' is already a working copy for a different URL";
                    if (entry.isIncomplete()) {
                        message = message + "; perform update to complete it";
                    }
                    SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, message, dstPath);
                    SVNErrorManager.error(err3);
                }
            } else {
                SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.WC_NODE_KIND_CHANGE, "''{0}'' already exists and is not a directory", dstPath);
                SVNErrorManager.error(err4);
            }
        }
        finally {
            this.sleepForTimeStamp();
        }
        return result;
    }

    public long doExport(SVNURL url, File dstPath, SVNRevision pegRevision, SVNRevision revision, String eolStyle, boolean force, boolean recursive) throws SVNException {
        SVNRepository repository = this.createRepository(url, null, pegRevision, revision);
        long revisionNumber = this.getRevisionNumber(revision, repository, null);
        long exportedRevision = this.doRemoteExport(repository, revisionNumber, dstPath, eolStyle, force, recursive);
        this.dispatchEvent(SVNEventFactory.createUpdateCompletedEvent(null, exportedRevision));
        return exportedRevision;
    }

    public long doExport(File srcPath, File dstPath, SVNRevision pegRevision, SVNRevision revision, String eolStyle, boolean force, boolean recursive) throws SVNException {
        long exportedRevision = -1L;
        if (revision != SVNRevision.BASE && revision != SVNRevision.WORKING && revision != SVNRevision.COMMITTED && revision != SVNRevision.UNDEFINED) {
            SVNRepository repository = this.createRepository(null, srcPath, pegRevision, revision);
            long revisionNumber = this.getRevisionNumber(revision, repository, srcPath);
            exportedRevision = this.doRemoteExport(repository, revisionNumber, dstPath, eolStyle, force, recursive);
        } else {
            if (revision == SVNRevision.UNDEFINED) {
                revision = SVNRevision.WORKING;
            }
            this.copyVersionedDir(srcPath, dstPath, revision, eolStyle, force, recursive);
        }
        this.dispatchEvent(SVNEventFactory.createUpdateCompletedEvent(null, exportedRevision));
        return exportedRevision;
    }

    private void copyVersionedDir(File from, File to, SVNRevision revision, String eolStyle, boolean force, boolean recursive) throws SVNException {
        SVNWCAccess wcAccess = SVNWCAccess.create(from);
        wcAccess.open(false, false);
        SVNEntry targetEntry = wcAccess.getTargetEntry();
        if (targetEntry == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control or doesn't exist", from, 1);
            SVNErrorManager.error(err);
        }
        if (revision == SVNRevision.WORKING && targetEntry.isScheduledForDeletion()) {
            return;
        }
        if (revision != SVNRevision.WORKING && targetEntry.isScheduledForAddition()) {
            return;
        }
        if (targetEntry.isDirectory()) {
            SVNErrorMessage err;
            boolean dirCreated = to.mkdirs();
            if (!to.exists() || to.isFile()) {
                err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create directory ''{0}''", to);
                SVNErrorManager.error(err);
            }
            if (!dirCreated && to.isDirectory() && !force) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "''{0}'' already exists and will not be owerwritten unless forced", to);
                SVNErrorManager.error(err);
            }
            SVNEntries entries = wcAccess.getTarget().getEntries();
            Iterator ents = entries.entries(false);
            while (ents.hasNext()) {
                File childTo;
                SVNEntry entry = (SVNEntry)ents.next();
                if (entry.isDirectory()) {
                    if ("".equals(entry.getName()) || !recursive) continue;
                    childTo = new File(to, entry.getName());
                    File childFrom = new File(from, entry.getName());
                    this.copyVersionedDir(childFrom, childTo, revision, eolStyle, force, recursive);
                    continue;
                }
                if (!entry.isFile()) continue;
                childTo = new File(to, entry.getName());
                this.copyVersionedFile(childTo, wcAccess.getTarget(), entry.getName(), revision, eolStyle);
            }
        } else if (targetEntry.isFile()) {
            this.copyVersionedFile(to, wcAccess.getTarget(), wcAccess.getTargetName(), revision, eolStyle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyVersionedFile(File dstPath, SVNDirectory dir, String fileName, SVNRevision revision, String eol) throws SVNException {
        File srcFile;
        SVNFileType fileType;
        byte[] eols;
        SVNEntries entries = dir.getEntries();
        SVNEntry entry = entries.getEntry(fileName, false);
        if (entry == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control or doesn't exist", dir.getFile(fileName), 1);
            SVNErrorManager.error(err);
        }
        if (revision == SVNRevision.WORKING && entry.isScheduledForDeletion()) {
            return;
        }
        if (revision != SVNRevision.WORKING && entry.isScheduledForAddition()) {
            return;
        }
        boolean modified = false;
        SVNProperties props = null;
        if (revision != SVNRevision.WORKING) {
            props = dir.getBaseProperties(fileName, false);
        } else {
            props = dir.getProperties(fileName, false);
            modified = dir.hasTextModifications(fileName, false);
        }
        boolean special = props.getPropertyValue("svn:special") != null;
        boolean executable = props.getPropertyValue("svn:executable") != null;
        String keywords = props.getPropertyValue("svn:keywords");
        byte[] byArray = eols = eol != null ? SVNTranslator.getEOL(eol) : null;
        if (eols == null) {
            eol = props.getPropertyValue("svn:eol-style");
            eols = SVNTranslator.getWorkingEOL(eol);
        }
        long timestamp = modified && !special ? dir.getFile(fileName).lastModified() : SVNTimeUtil.parseDateAsLong(entry.getCommittedDate());
        Map keywordsMap = null;
        if (keywords != null) {
            String author;
            String rev = Long.toString(entry.getCommittedRevision());
            if (modified) {
                author = "(local)";
                rev = rev + "M";
            } else {
                author = entry.getAuthor();
            }
            keywordsMap = SVNTranslator.computeKeywords(keywords, entry.getURL(), author, entry.getCommittedDate(), rev);
        }
        if ((fileType = SVNFileType.getType(srcFile = revision == SVNRevision.WORKING ? dir.getFile(fileName) : dir.getBaseFile(fileName, false))) == SVNFileType.SYMLINK && revision == SVNRevision.WORKING) {
            File tmpBaseFile = dir.getBaseFile(fileName, true);
            try {
                SVNTranslator.translate(srcFile, tmpBaseFile, eols, keywordsMap, special, false);
                SVNTranslator.translate(tmpBaseFile, dstPath, eols, keywordsMap, special, true);
            }
            finally {
                tmpBaseFile.delete();
            }
        } else {
            SVNTranslator.translate(srcFile, dstPath, eols, keywordsMap, special, true);
        }
        if (executable) {
            SVNFileUtil.setExecutable(dstPath, true);
        }
        if (!special && timestamp > 0L) {
            dstPath.setLastModified(timestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doRemoteExport(SVNRepository repository, final long revNumber, File dstPath, String eolStyle, boolean force, boolean recursive) throws SVNException {
        SVNNodeKind dstKind = repository.checkPath("", revNumber);
        if (dstKind == SVNNodeKind.DIR) {
            SVNExportEditor editor = new SVNExportEditor(this, repository.getLocation().toString(), dstPath, force, eolStyle);
            repository.update(revNumber, null, recursive, new ISVNReporterBaton(){

                public void report(ISVNReporter reporter) throws SVNException {
                    reporter.setPath("", null, revNumber, true);
                    reporter.finishReport();
                }
            }, SVNCancellableEditor.newInstance(editor, this));
            SVNFileType fileType = SVNFileType.getType(dstPath);
            if (fileType == SVNFileType.NONE) {
                editor.openRoot(revNumber);
            }
            if (!this.isIgnoreExternals() && recursive) {
                Map externals = editor.getCollectedExternals();
                Iterator files = externals.keySet().iterator();
                while (files.hasNext()) {
                    File rootFile = (File)files.next();
                    String propValue = (String)externals.get(rootFile);
                    if (propValue == null) continue;
                    SVNExternalInfo[] infos = SVNWCAccess.parseExternals("", propValue);
                    for (int i = 0; i < infos.length; ++i) {
                        File targetDir = new File(rootFile, infos[i].getPath());
                        SVNURL srcURL = infos[i].getOldURL();
                        long externalRevNumber = infos[i].getOldRevision();
                        SVNRevision srcRevision = externalRevNumber >= 0L ? SVNRevision.create(externalRevNumber) : SVNRevision.HEAD;
                        String relativePath = targetDir.equals(dstPath) ? "" : targetDir.getAbsolutePath().substring(dstPath.getAbsolutePath().length() + 1);
                        relativePath = relativePath.replace(File.separatorChar, '/');
                        this.dispatchEvent(SVNEventFactory.createUpdateExternalEvent(null, relativePath));
                        try {
                            this.setEventPathPrefix(relativePath);
                            this.doExport(srcURL, targetDir, srcRevision, srcRevision, eolStyle, force, recursive);
                            continue;
                        }
                        catch (SVNException e) {
                            if (e instanceof SVNCancelException) {
                                throw e;
                            }
                            this.dispatchEvent(new SVNEvent(e.getErrorMessage()));
                            continue;
                        }
                        finally {
                            this.setEventPathPrefix(null);
                        }
                    }
                }
            }
        } else if (dstKind == SVNNodeKind.FILE) {
            String url = repository.getLocation().toString();
            if (dstPath.isDirectory()) {
                dstPath = new File(dstPath, SVNEncodingUtil.uriDecode(SVNPathUtil.tail(url)));
            }
            if (dstPath.exists()) {
                if (!force) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Path ''{0}'' already exists", dstPath);
                    SVNErrorManager.error(err);
                }
            } else {
                dstPath.getParentFile().mkdirs();
            }
            HashMap properties = new HashMap();
            OutputStream os = null;
            File tmpFile = SVNFileUtil.createUniqueFile(dstPath.getParentFile(), dstPath.getName(), ".tmp");
            os = SVNFileUtil.openFileForWriting(tmpFile);
            try {
                repository.getFile("", revNumber, properties, new SVNCancellableOutputStream(os, this));
            }
            finally {
                SVNFileUtil.closeFile(os);
            }
            if (force && dstPath.exists()) {
                SVNFileUtil.deleteAll(dstPath, this);
            }
            Map keywords = SVNTranslator.computeKeywords((String)properties.get("svn:keywords"), url, (String)properties.get("svn:entry:last-author"), (String)properties.get("svn:entry:committed-date"), (String)properties.get("svn:entry:committed-rev"));
            byte[] eols = null;
            if ("native".equals(properties.get("svn:eol-style"))) {
                eols = SVNTranslator.getWorkingEOL(eolStyle != null ? eolStyle : (String)properties.get("svn:eol-style"));
            } else if (properties.containsKey("svn:eol-style")) {
                eols = SVNTranslator.getWorkingEOL((String)properties.get("svn:eol-style"));
            }
            SVNTranslator.translate(tmpFile, dstPath, eols, keywords, properties.get("svn:special") != null, true);
            tmpFile.delete();
            if (properties.get("svn:executable") != null) {
                SVNFileUtil.setExecutable(dstPath, true);
            }
            this.dispatchEvent(SVNEventFactory.createExportAddedEvent(dstPath.getParentFile(), dstPath, SVNNodeKind.FILE));
        }
        return revNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRelocate(File dst, SVNURL oldURL, SVNURL newURL, boolean recursive) throws SVNException {
        SVNWCAccess wcAccess = this.createWCAccess(dst);
        try {
            wcAccess.open(true, recursive);
            SVNEntry entry = wcAccess.getTargetEntry();
            String name = "";
            if (entry != null && entry.isFile()) {
                name = entry.getName();
            }
            this.doRelocate(wcAccess.getTarget(), name, oldURL.toString(), newURL.toString(), recursive, new HashMap());
        }
        finally {
            wcAccess.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCanonicalizeURLs(File dst, boolean omitDefaultPort, boolean recursive) throws SVNException {
        SVNWCAccess wcAccess = this.createWCAccess(dst);
        try {
            wcAccess.open(true, recursive);
            SVNEntry entry = wcAccess.getTargetEntry();
            String name = "";
            if (entry != null && entry.isFile()) {
                name = entry.getName();
            }
            this.doCanonicalizeURLs(wcAccess.getTarget(), name, omitDefaultPort, recursive);
            if (recursive && !this.isIgnoreExternals()) {
                Iterator externals = wcAccess.externals();
                while (externals.hasNext()) {
                    SVNExternalInfo info = (SVNExternalInfo)externals.next();
                    try {
                        this.doCanonicalizeURLs(info.getFile(), omitDefaultPort, true);
                    }
                    catch (SVNCancelException e) {
                        throw e;
                    }
                    catch (SVNException e) {
                        SVNDebugLog.logInfo(e);
                    }
                }
            }
        }
        finally {
            wcAccess.close(true);
        }
    }

    private void doCanonicalizeURLs(SVNDirectory dir, String name, boolean omitDefaultPort, boolean recursive) throws SVNException {
        boolean save = false;
        this.checkCancelled();
        if (!"".equals(name)) {
            SVNEntry entry = dir.getEntries().getEntry(name, true);
            save = SVNUpdateClient.canonicalizeEntry(entry, omitDefaultPort);
            dir.getWCProperties(name).setPropertyValue("svn:wc:ra_dav:version-url", null);
            if (save) {
                dir.getEntries().save(true);
            }
            return;
        }
        String externalsValue = dir.getProperties("", false).getPropertyValue("svn:externals");
        dir.getWCAccess().addExternals(dir, externalsValue);
        if (externalsValue != null) {
            externalsValue = SVNUpdateClient.canonicalizeExtenrals(externalsValue, omitDefaultPort);
            dir.getProperties("", false).setPropertyValue("svn:externals", externalsValue);
        }
        SVNEntry rootEntry = dir.getEntries().getEntry("", true);
        save = SVNUpdateClient.canonicalizeEntry(rootEntry, omitDefaultPort);
        dir.getWCProperties("").setPropertyValue("svn:wc:ra_dav:version-url", null);
        Iterator ents = dir.getEntries().entries(true);
        while (ents.hasNext()) {
            SVNDirectory childDir;
            SVNEntry entry = (SVNEntry)ents.next();
            if ("".equals(entry.getName())) continue;
            this.checkCancelled();
            if (recursive && entry.isDirectory() && (entry.isScheduledForAddition() || !entry.isDeleted()) && !entry.isAbsent() && (childDir = dir.getChildDirectory(entry.getName())) != null) {
                this.doCanonicalizeURLs(childDir, "", omitDefaultPort, recursive);
            }
            save |= SVNUpdateClient.canonicalizeEntry(entry, omitDefaultPort);
            dir.getWCProperties(entry.getName()).setPropertyValue("svn:wc:ra_dav:version-url", null);
        }
        if (save) {
            dir.getEntries().save(true);
        }
    }

    private static String canonicalizeExtenrals(String externals, boolean omitDefaultPort) throws SVNException {
        if (externals == null) {
            return null;
        }
        StringBuffer canonicalized = new StringBuffer();
        StringTokenizer lines = new StringTokenizer(externals, "\r\n", true);
        while (lines.hasMoreTokens()) {
            SVNURL canonicalURL;
            String line = lines.nextToken();
            if (line.trim().length() == 0 || line.trim().startsWith("#") || line.indexOf(13) >= 0 || line.indexOf(10) >= 0) {
                canonicalized.append(line);
                continue;
            }
            String[] tokens = line.split("[ \t]");
            int index = tokens.length - 1;
            SVNURL url = null;
            if (index >= 1) {
                try {
                    url = SVNURL.parseURIEncoded(tokens[index]);
                }
                catch (SVNException e) {
                    url = null;
                }
            }
            if ((canonicalURL = SVNUpdateClient.canonicalizeURL(url, omitDefaultPort)) == null) {
                canonicalized.append(line);
                continue;
            }
            canonicalized.append(tokens[0]);
            canonicalized.append(' ');
            if (index == 2) {
                canonicalized.append(tokens[1]);
                canonicalized.append(' ');
            }
            canonicalized.append(canonicalURL.toString());
        }
        return canonicalized.toString();
    }

    private static boolean canonicalizeEntry(SVNEntry entry, boolean omitDefaultPort) throws SVNException {
        SVNURL copyFrom;
        SVNURL url;
        boolean updated = false;
        SVNURL root = SVNUpdateClient.canonicalizeURL(entry.getRepositoryRootURL(), omitDefaultPort);
        if (root != null) {
            updated |= entry.setRepositoryRootURL(root);
        }
        if ((url = SVNUpdateClient.canonicalizeURL(entry.getSVNURL(), omitDefaultPort)) != null) {
            updated |= entry.setURL(url.toString());
        }
        if ((copyFrom = SVNUpdateClient.canonicalizeURL(entry.getCopyFromSVNURL(), omitDefaultPort)) != null) {
            updated |= entry.setCopyFromURL(copyFrom.toString());
        }
        return updated;
    }

    private static SVNURL canonicalizeURL(SVNURL url, boolean omitDefaultPort) throws SVNException {
        if (url == null || url.getPort() <= 0) {
            return null;
        }
        int defaultPort = SVNURL.getDefaultPortNumber(url.getProtocol());
        if (defaultPort <= 0) {
            return null;
        }
        if (omitDefaultPort) {
            if (url.hasPort() && url.getPort() == defaultPort) {
                return SVNURL.create(url.getProtocol(), url.getUserInfo(), url.getHost(), -1, url.getPath(), false);
            }
        } else if (!url.hasPort()) {
            return SVNURL.create(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExternals(SVNWCAccess wcAccess) throws SVNException {
        Iterator externals = wcAccess.externals();
        while (externals.hasNext()) {
            SVNExternalInfo external = (SVNExternalInfo)externals.next();
            if (external.getOldURL() == null && external.getNewURL() == null) continue;
            long revNumber = external.getNewRevision();
            SVNRevision revision = revNumber >= 0L ? SVNRevision.create(revNumber) : SVNRevision.HEAD;
            this.setEventPathPrefix(external.getPath());
            try {
                if (external.getOldURL() == null) {
                    external.getFile().mkdirs();
                    this.dispatchEvent(SVNEventFactory.createUpdateExternalEvent(wcAccess, ""));
                    this.doCheckout(external.getNewURL(), external.getFile(), revision, revision, true);
                    continue;
                }
                if (external.getNewURL() == null) {
                    if (!SVNWCAccess.isVersionedDirectory(external.getFile())) continue;
                    SVNWCAccess externalAccess = this.createWCAccess(external.getFile());
                    try {
                        externalAccess.open(true, true);
                        externalAccess.getAnchor().destroy("", true);
                        continue;
                    }
                    finally {
                        externalAccess.close(true);
                        continue;
                    }
                }
                if (external.isModified()) {
                    this.deleteExternal(external);
                    external.getFile().mkdirs();
                    this.dispatchEvent(SVNEventFactory.createUpdateExternalEvent(wcAccess, ""));
                    this.doCheckout(external.getNewURL(), external.getFile(), revision, revision, true);
                    continue;
                }
                if (!external.getFile().isDirectory()) {
                    external.getFile().mkdirs();
                    this.doCheckout(external.getNewURL(), external.getFile(), revision, revision, true);
                    continue;
                }
                String url = null;
                if (SVNWCAccess.isVersionedDirectory(external.getFile())) {
                    SVNWCAccess externalAccess = this.createWCAccess(external.getFile());
                    SVNEntry entry = externalAccess.getTargetEntry();
                    url = entry.getURL();
                }
                if (!external.getNewURL().toString().equals(url)) {
                    this.deleteExternal(external);
                    external.getFile().mkdirs();
                    this.dispatchEvent(SVNEventFactory.createUpdateExternalEvent(wcAccess, ""));
                    this.doCheckout(external.getNewURL(), external.getFile(), revision, revision, true);
                    continue;
                }
                this.dispatchEvent(SVNEventFactory.createUpdateExternalEvent(wcAccess, ""));
                this.doUpdate(external.getFile(), revision, true);
            }
            catch (SVNException th) {
                if (th instanceof SVNCancelException) {
                    throw th;
                }
                this.dispatchEvent(new SVNEvent(th.getErrorMessage()));
                SVNDebugLog.logInfo(th);
            }
            finally {
                this.setEventPathPrefix(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteExternal(SVNExternalInfo external) throws SVNException {
        if (SVNWCAccess.isVersionedDirectory(external.getFile())) {
            SVNWCAccess externalAccess = this.createWCAccess(external.getFile());
            try {
                externalAccess.open(true, true);
                externalAccess.getAnchor().destroy("", true);
            }
            catch (Throwable th) {
                SVNDebugLog.logInfo(th);
            }
            finally {
                externalAccess.close(true);
            }
        }
        if (external.getFile().exists()) {
            external.getFile().getParentFile().mkdirs();
            File newLocation = SVNFileUtil.createUniqueFile(external.getFile().getParentFile(), external.getFile().getName(), ".OLD");
            SVNFileUtil.rename(external.getFile(), newLocation);
        }
    }

    private SVNDirectory createVersionedDirectory(File dstPath, SVNURL url, SVNURL rootURL, String uuid, long revNumber) throws SVNException {
        SVNDirectory.createVersionedDirectory(dstPath);
        SVNDirectory dir = new SVNDirectory(null, "", dstPath);
        SVNEntries entries = dir.getEntries();
        SVNEntry entry = entries.getEntry("", true);
        if (entry == null) {
            entry = entries.addEntry("");
        }
        entry.setURL(url.toString());
        entry.setUUID(uuid);
        entry.setRepositoryRootURL(rootURL);
        entry.setKind(SVNNodeKind.DIR);
        entry.setRevision(revNumber);
        entry.setIncomplete(true);
        entries.save(true);
        return dir;
    }

    private Map validateRelocateTargetURL(SVNURL targetURL, String expectedUUID, Map validatedURLs) throws SVNException {
        if (validatedURLs == null) {
            return null;
        }
        Iterator targetURLs = validatedURLs.keySet().iterator();
        while (targetURLs.hasNext()) {
            SVNURL validatedURL = (SVNURL)targetURLs.next();
            if (targetURL.toString().startsWith(validatedURL.toString())) continue;
            String validatedUUID = (String)validatedURLs.get(validatedURL);
            if (validatedUUID != null && validatedUUID.equals(expectedUUID)) {
                return validatedURLs;
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_RELOCATION, "The repository at ''{0}'' has uuid ''{1}'', but the WC has ''{2}''", new Object[]{validatedURL, validatedUUID, expectedUUID});
            SVNErrorManager.error(err);
        }
        SVNRepository repos = this.createRepository(targetURL, true);
        String actualUUID = repos.getRepositoryUUID(true);
        if (actualUUID == null || !actualUUID.equals(expectedUUID)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_RELOCATION, "The repository at ''{0}'' has uuid ''{1}'', but the WC has ''{2}''", new Object[]{targetURL, actualUUID, expectedUUID});
            SVNErrorManager.error(err);
        }
        validatedURLs.put(targetURL, actualUUID);
        return validatedURLs;
    }

    private Map relocateEntry(SVNEntry entry, String from, String to, Map validatedURLs) throws SVNException {
        if (entry.getRepositoryRoot() != null) {
            String repos = entry.getRepositoryRoot();
            if (from.length() > repos.length()) {
                String fromPath = from.substring(repos.length());
                if (!to.endsWith(fromPath)) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_RELOCATION, "Relocate can only change the repository part of URL");
                    SVNErrorManager.error(err);
                }
                from = repos;
                to = to.substring(0, to.length() - fromPath.length());
            }
            if (repos.startsWith(from)) {
                entry.setRepositoryRoot(to + repos.substring(from.length()));
            }
        }
        if (entry.getURL() != null && entry.getURL().startsWith(from)) {
            entry.setURL(to + entry.getURL().substring(from.length()));
            if (entry.getUUID() != null && validatedURLs != null) {
                validatedURLs = this.validateRelocateTargetURL(entry.getSVNURL(), entry.getUUID(), validatedURLs);
            }
        }
        if (entry.getCopyFromURL() != null && entry.getCopyFromURL().startsWith(from)) {
            entry.setCopyFromURL(to + entry.getCopyFromURL().substring(from.length()));
            if (entry.getUUID() != null && validatedURLs != null) {
                validatedURLs = this.validateRelocateTargetURL(entry.getCopyFromSVNURL(), entry.getUUID(), validatedURLs);
            }
        }
        return validatedURLs;
    }

    private Map doRelocate(SVNDirectory dir, String name, String from, String to, boolean recursive, Map validatedURLs) throws SVNException {
        if (!"".equals(name)) {
            SVNEntry entry = dir.getEntries().getEntry(name, true);
            this.relocateEntry(entry, from, to, validatedURLs);
            dir.getWCProperties(name).setPropertyValue("svn:wc:ra_dav:version-url", null);
            dir.getEntries().save(true);
            return validatedURLs;
        }
        SVNEntry rootEntry = dir.getEntries().getEntry("", true);
        validatedURLs = this.relocateEntry(rootEntry, from, to, validatedURLs);
        dir.getWCProperties("").setPropertyValue("svn:wc:ra_dav:version-url", null);
        Iterator ents = dir.getEntries().entries(true);
        while (ents.hasNext()) {
            SVNDirectory childDir;
            SVNEntry entry = (SVNEntry)ents.next();
            if ("".equals(entry.getName())) continue;
            if (recursive && entry.isDirectory() && (entry.isScheduledForAddition() || !entry.isDeleted()) && !entry.isAbsent() && (childDir = dir.getChildDirectory(entry.getName())) != null) {
                validatedURLs = this.doRelocate(childDir, "", from, to, recursive, validatedURLs);
            }
            validatedURLs = this.relocateEntry(entry, from, to, validatedURLs);
            dir.getWCProperties(entry.getName()).setPropertyValue("svn:wc:ra_dav:version-url", null);
        }
        dir.getEntries().save(true);
        return validatedURLs;
    }
}

