/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SVNRevision {
    public static final SVNRevision HEAD = new SVNRevision("HEAD", 0);
    public static final SVNRevision WORKING = new SVNRevision("WORKING", 1);
    public static final SVNRevision PREVIOUS = new SVNRevision("PREV", 3);
    public static final SVNRevision BASE = new SVNRevision("BASE", 2);
    public static final SVNRevision COMMITTED = new SVNRevision("COMMITTED", 4);
    public static final SVNRevision UNDEFINED = new SVNRevision("UNDEFINED", 30);
    private static final Map ourValidRevisions = new HashMap();
    private long myRevision;
    private String myName;
    private Date myDate;
    private int myID;
    static /* synthetic */ Class class$org$tmatesoft$svn$core$wc$SVNRevision;

    private SVNRevision(long number) {
        this.myRevision = number;
        this.myName = null;
        this.myID = 10;
    }

    private SVNRevision(String name, int id) {
        this(-1L);
        this.myName = name;
        this.myID = id;
    }

    private SVNRevision(Date date) {
        this(-1L);
        this.myDate = date;
        this.myID = 20;
    }

    public String getName() {
        return this.myName;
    }

    public long getNumber() {
        return this.myRevision;
    }

    public Date getDate() {
        return this.myDate;
    }

    public boolean isValid() {
        return this != UNDEFINED && (this.myDate != null || this.myRevision >= 0L || this.myName != null);
    }

    public int getID() {
        return this.myID;
    }

    public int hashCode() {
        if (this.myRevision >= 0L) {
            return (int)this.myRevision & 0xFFFFFFFF;
        }
        if (this.myDate != null) {
            return this.myDate.hashCode();
        }
        if (this.myName != null) {
            return this.myName.hashCode();
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != (class$org$tmatesoft$svn$core$wc$SVNRevision == null ? (class$org$tmatesoft$svn$core$wc$SVNRevision = SVNRevision.class$("org.tmatesoft.svn.core.wc.SVNRevision")) : class$org$tmatesoft$svn$core$wc$SVNRevision)) {
            return false;
        }
        SVNRevision r = (SVNRevision)o;
        if (this.myRevision >= 0L) {
            return this.myRevision == r.getNumber();
        }
        if (this.myDate != null) {
            return this.myDate.equals(r.getDate());
        }
        if (this.myName != null) {
            return this.myName.equals(r.getName());
        }
        return !r.isValid();
    }

    public static SVNRevision create(long revisionNumber) {
        if (revisionNumber < 0L) {
            return UNDEFINED;
        }
        return new SVNRevision(revisionNumber);
    }

    public static SVNRevision create(Date date) {
        return new SVNRevision(date);
    }

    public boolean isLocal() {
        return this.isValid() && (this == BASE || this == WORKING);
    }

    public static SVNRevision parse(String value) {
        if (value == null) {
            return UNDEFINED;
        }
        if (value.startsWith("-r")) {
            value = value.substring("-r".length());
        }
        if ((value = value.trim()).startsWith("{") && value.endsWith("}")) {
            value = value.substring(1);
            value = value.substring(0, value.length() - 1);
            try {
                Date date = DateFormat.getDateInstance().parse(value);
                return SVNRevision.create(date);
            }
            catch (ParseException e) {
                return UNDEFINED;
            }
        }
        try {
            long number = Long.parseLong(value);
            return SVNRevision.create(number);
        }
        catch (NumberFormatException nfe) {
            SVNRevision revision = (SVNRevision)ourValidRevisions.get(value.toUpperCase());
            if (revision == null) {
                return UNDEFINED;
            }
            return revision;
        }
    }

    public String toString() {
        if (this.myRevision >= 0L) {
            return Long.toString(this.myRevision);
        }
        if (this.myName != null) {
            return this.myName;
        }
        if (this.myDate != null) {
            return DateFormat.getDateTimeInstance().format(this.myDate);
        }
        return "{invalid revision}";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ourValidRevisions.put(HEAD.getName(), HEAD);
        ourValidRevisions.put(WORKING.getName(), WORKING);
        ourValidRevisions.put(PREVIOUS.getName(), PREVIOUS);
        ourValidRevisions.put(BASE.getName(), BASE);
        ourValidRevisions.put(COMMITTED.getName(), COMMITTED);
    }
}

