/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNDirectory;
import org.tmatesoft.svn.core.internal.wc.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNProperties;
import org.tmatesoft.svn.core.internal.wc.SVNWCAccess;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNMoveClient
extends SVNBasicClient {
    private SVNWCClient myWCClient;

    public SVNMoveClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
        this.myWCClient = new SVNWCClient(authManager, options);
    }

    protected SVNMoveClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
        this.myWCClient = new SVNWCClient(repositoryPool, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMove(File src, File dst) throws SVNException {
        SVNErrorMessage err;
        if (dst.exists()) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "File ''{0}'' already exists", dst);
            SVNErrorManager.error(err);
        } else if (!src.exists()) {
            err = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Path ''{0}'' does not exist", src);
            SVNErrorManager.error(err);
        }
        boolean srcIsVersioned = SVNMoveClient.isVersionedFile(src);
        boolean dstParentIsVersioned = SVNMoveClient.isVersionedFile(dst.getParentFile());
        if (!srcIsVersioned && !dstParentIsVersioned) {
            SVNFileUtil.rename(src, dst);
        } else if (!dstParentIsVersioned) {
            SVNFileUtil.copy(src, dst, false, false);
            this.myWCClient.doDelete(src, true, false);
        } else if (!srcIsVersioned) {
            SVNFileUtil.rename(src, dst);
            this.myWCClient.doAdd(dst, false, false, false, true);
        } else {
            boolean sameWC;
            SVNWCAccess srcAccess = SVNWCAccess.create(src);
            SVNWCAccess dstAccess = SVNWCAccess.create(dst);
            SVNEntry srcEntry = srcAccess.getTargetEntry();
            SVNEntry dstEntry = dstAccess.getTargetEntry();
            SVNProperties srcProps = srcAccess.getAnchor().getProperties(srcAccess.getTargetName(), false);
            SVNProperties dstProps = dstAccess.getAnchor().getProperties(dstAccess.getTargetName(), false);
            SVNEntry dstParentEntry = dstAccess.getAnchor().getEntries().getEntry("", false);
            File srcWCRoot = SVNWCUtil.getWorkingCopyRoot(src, true);
            File dstWCRoot = SVNWCUtil.getWorkingCopyRoot(dst, true);
            boolean bl = sameWC = srcWCRoot != null && srcWCRoot.equals(dstWCRoot);
            if (sameWC && dstEntry != null && (dstEntry.isScheduledForDeletion() || dstEntry.getKind() != srcEntry.getKind())) {
                SVNFileUtil.copy(src, dst, false, false);
                try {
                    this.myWCClient.doAdd(dst, false, false, false, true);
                }
                catch (SVNException e) {
                    // empty catch block
                }
                this.myWCClient.doDelete(src, true, false);
                return;
            }
            SVNFileUtil.copy(src, dst, false, sameWC);
            if (!sameWC) {
                try {
                    this.myWCClient.doAdd(dst, false, false, false, true);
                }
                catch (SVNException e) {}
            } else if (srcEntry.isFile()) {
                if (dstEntry == null) {
                    dstEntry = dstAccess.getAnchor().getEntries().addEntry(dst.getName());
                }
                String srcURL = srcEntry.getURL();
                String srcCFURL = srcEntry.getCopyFromURL();
                long srcRevision = srcEntry.getRevision();
                long srcCFRevision = srcEntry.getCopyFromRevision();
                srcProps.copyTo(dstProps);
                if (srcEntry.isScheduledForAddition() && srcEntry.isCopied()) {
                    dstEntry.scheduleForAddition();
                    dstEntry.setCopyFromRevision(srcCFRevision);
                    dstEntry.setCopyFromURL(srcCFURL);
                    dstEntry.setKind(SVNNodeKind.FILE);
                    dstEntry.setRevision(srcRevision);
                    dstEntry.setCopied(true);
                } else if (!srcEntry.isCopied() && !srcEntry.isScheduledForAddition()) {
                    dstEntry.setCopied(true);
                    dstEntry.scheduleForAddition();
                    dstEntry.setKind(SVNNodeKind.FILE);
                    dstEntry.setCopyFromRevision(srcRevision);
                    dstEntry.setCopyFromURL(srcURL);
                } else {
                    dstEntry.scheduleForAddition();
                    dstEntry.setKind(SVNNodeKind.FILE);
                    if (!dstEntry.isScheduledForReplacement()) {
                        dstEntry.setRevision(0L);
                    }
                }
                dstAccess.getAnchor().getEntries().save(true);
            } else if (srcEntry.isDirectory()) {
                if (dstEntry == null) {
                    dstEntry = dstAccess.getAnchor().getEntries().addEntry(dst.getName());
                }
                srcEntry = srcAccess.getTarget().getEntries().getEntry("", false);
                String srcURL = srcEntry.getURL();
                String srcCFURL = srcEntry.getCopyFromURL();
                String dstURL = dstParentEntry.getURL();
                String repositoryRootURL = dstParentEntry.getRepositoryRoot();
                long srcRevision = srcEntry.getRevision();
                long srcCFRevision = srcEntry.getCopyFromRevision();
                dstURL = SVNPathUtil.append(dstURL, SVNEncodingUtil.uriEncode(dst.getName()));
                if (srcEntry.isScheduledForAddition() && srcEntry.isCopied()) {
                    srcProps.copyTo(dstProps);
                    dstEntry.scheduleForAddition();
                    dstEntry.setCopyFromRevision(srcCFRevision);
                    dstEntry.setCopyFromURL(srcCFURL);
                    dstEntry.setKind(SVNNodeKind.DIR);
                    dstEntry.setRevision(srcRevision);
                    dstEntry.setCopied(true);
                    dstAccess.getAnchor().getEntries().save(true);
                    try {
                        dstAccess = SVNWCAccess.create(dst);
                        dstAccess.open(false, true);
                        SVNDirectory dstDir = dstAccess.getTarget();
                        dstDir.updateURL(dstURL, true);
                    }
                    finally {
                        dstAccess.close(false);
                    }
                } else if (!srcEntry.isCopied() && !srcEntry.isScheduledForAddition()) {
                    srcProps.copyTo(dstProps);
                    dstEntry.setCopied(true);
                    dstEntry.scheduleForAddition();
                    dstEntry.setKind(SVNNodeKind.DIR);
                    dstEntry.setCopyFromRevision(srcRevision);
                    dstEntry.setCopyFromURL(srcURL);
                    dstAccess.getAnchor().getEntries().save(true);
                    try {
                        dstAccess = SVNWCAccess.create(dst);
                        dstAccess.open(false, true);
                        SVNDirectory dstDir = dstAccess.getTarget();
                        dstEntry = dstDir.getEntries().getEntry("", false);
                        dstEntry.setCopied(true);
                        dstEntry.scheduleForAddition();
                        dstEntry.setKind(SVNNodeKind.DIR);
                        dstEntry.setCopyFromRevision(srcRevision);
                        dstEntry.setURL(dstURL);
                        dstEntry.setCopyFromURL(srcURL);
                        dstEntry.setRepositoryRoot(repositoryRootURL);
                        SVNCopyClient.updateCopiedDirectory(dstDir, "", dstURL, repositoryRootURL, null, -1L);
                        dstDir.getEntries().save(true);
                    }
                    finally {
                        dstAccess.close(false);
                    }
                } else {
                    dstAccess.getAnchor().getEntries().deleteEntry(dst.getName());
                    dstAccess.getAnchor().getEntries().save(true);
                    SVNFileUtil.deleteAll(dst, this);
                    SVNFileUtil.copy(src, dst, false, false);
                    this.myWCClient.doAdd(dst, false, false, false, true);
                }
            }
            srcAccess.close(false);
            dstAccess.close(false);
            try {
                this.myWCClient.doDelete(src, true, false);
            }
            catch (SVNException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoMove(File src, File dst) throws SVNException {
        if (!src.exists()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Path ''{0}'' does not exist", src);
            SVNErrorManager.error(err);
        }
        boolean srcIsVersioned = SVNMoveClient.isVersionedFile(src);
        boolean dstParentIsVersioned = SVNMoveClient.isVersionedFile(dst.getParentFile());
        if (!srcIsVersioned && !dstParentIsVersioned) {
            SVNFileUtil.rename(src, dst);
        } else if (!dstParentIsVersioned) {
            SVNFileUtil.copy(src, dst, false, false);
            this.myWCClient.doDelete(src, true, false);
        } else if (!srcIsVersioned) {
            SVNFileUtil.rename(src, dst);
            SVNWCAccess dstAccess = SVNWCAccess.create(dst);
            SVNEntry dstEntry = dstAccess.getTargetEntry();
            if (dstEntry != null && dstEntry.isScheduledForDeletion()) {
                this.myWCClient.doRevert(dst, true);
            } else {
                this.myWCClient.doAdd(dst, false, false, false, true);
            }
        } else {
            SVNWCAccess srcAccess = SVNWCAccess.create(src);
            SVNWCAccess dstAccess = SVNWCAccess.create(dst);
            SVNEntry srcEntry = srcAccess.getTargetEntry();
            SVNEntry dstEntry = dstAccess.getTargetEntry();
            SVNEntry dstParentEntry = dstAccess.getAnchor().getEntries().getEntry("", false);
            if (dstEntry != null && dstEntry.isScheduledForDeletion()) {
                this.myWCClient.doRevert(dst, true);
                this.myWCClient.doDelete(src, true, false);
                return;
            }
            boolean sameWC = dstParentEntry.getUUID() != null && dstParentEntry.getUUID().equals(srcEntry.getUUID());
            SVNFileUtil.copy(src, dst, false, sameWC);
            if (dstEntry != null && dstEntry.getKind() != srcEntry.getKind()) {
                this.myWCClient.doDelete(src, true, false);
                return;
            }
            if (!sameWC) {
                try {
                    this.myWCClient.doAdd(dst, false, false, false, true);
                }
                catch (SVNException e) {}
            } else if (srcEntry.isFile()) {
                if (dstEntry == null) {
                    dstEntry = dstAccess.getAnchor().getEntries().addEntry(dst.getName());
                }
                String srcURL = srcEntry.getURL();
                String srcCFURL = srcEntry.getCopyFromURL();
                long srcRevision = srcEntry.getRevision();
                long srcCFRevision = srcEntry.getCopyFromRevision();
                if (srcEntry.isScheduledForAddition() && srcEntry.isCopied()) {
                    dstEntry.scheduleForAddition();
                    dstEntry.setCopyFromRevision(srcCFRevision);
                    dstEntry.setCopyFromURL(srcCFURL);
                    dstEntry.setKind(SVNNodeKind.FILE);
                    dstEntry.setRevision(srcRevision);
                    dstEntry.setCopied(true);
                } else if (!srcEntry.isCopied() && !srcEntry.isScheduledForAddition()) {
                    dstEntry.setCopied(true);
                    dstEntry.scheduleForAddition();
                    dstEntry.setKind(SVNNodeKind.FILE);
                    dstEntry.setCopyFromRevision(srcRevision);
                    dstEntry.setCopyFromURL(srcURL);
                } else {
                    dstEntry.scheduleForAddition();
                    dstEntry.setKind(SVNNodeKind.FILE);
                    if (!dstEntry.isScheduledForReplacement()) {
                        dstEntry.setRevision(0L);
                    }
                }
                dstAccess.getAnchor().getEntries().save(true);
            } else if (srcEntry.isDirectory()) {
                if (dstEntry == null) {
                    dstEntry = dstAccess.getAnchor().getEntries().addEntry(dst.getName());
                }
                String srcURL = srcEntry.getURL();
                String srcCFURL = srcEntry.getCopyFromURL();
                String dstURL = dstParentEntry.getURL();
                long srcRevision = srcEntry.getRevision();
                long srcCFRevision = srcEntry.getCopyFromRevision();
                String repositoryRootURL = srcEntry.getRepositoryRoot();
                dstURL = SVNPathUtil.append(dstURL, SVNEncodingUtil.uriEncode(dst.getName()));
                if (srcEntry.isScheduledForAddition() && srcEntry.isCopied()) {
                    dstEntry.scheduleForAddition();
                    dstEntry.setCopyFromRevision(srcCFRevision);
                    dstEntry.setCopyFromURL(srcCFURL);
                    dstEntry.setKind(SVNNodeKind.DIR);
                    dstEntry.setRevision(srcRevision);
                    dstEntry.setCopied(true);
                    dstAccess.getAnchor().getEntries().save(true);
                    try {
                        dstAccess = SVNWCAccess.create(dst);
                        dstAccess.open(false, true);
                        SVNDirectory dstDir = dstAccess.getTarget();
                        dstDir.updateURL(dstURL, true);
                    }
                    finally {
                        dstAccess.close(false);
                    }
                } else if (!srcEntry.isCopied() && !srcEntry.isScheduledForAddition()) {
                    dstEntry.setCopied(true);
                    dstEntry.scheduleForAddition();
                    dstEntry.setKind(SVNNodeKind.DIR);
                    dstEntry.setCopyFromRevision(srcRevision);
                    dstEntry.setCopyFromURL(srcURL);
                    dstAccess.getAnchor().getEntries().save(true);
                    try {
                        dstAccess = SVNWCAccess.create(dst);
                        dstAccess.open(false, true);
                        SVNDirectory dstDir = dstAccess.getTarget();
                        dstEntry = dstDir.getEntries().getEntry("", false);
                        dstEntry.setCopied(true);
                        dstEntry.scheduleForAddition();
                        dstEntry.setKind(SVNNodeKind.DIR);
                        dstEntry.setCopyFromRevision(srcRevision);
                        dstEntry.setURL(dstURL);
                        dstEntry.setCopyFromURL(srcURL);
                        dstEntry.setRepositoryRoot(repositoryRootURL);
                        SVNCopyClient.updateCopiedDirectory(dstDir, "", dstURL, repositoryRootURL, null, -1L);
                        dstDir.getEntries().save(true);
                    }
                    finally {
                        dstAccess.close(false);
                    }
                } else {
                    dstAccess.getAnchor().getEntries().deleteEntry(dst.getName());
                    dstAccess.getAnchor().getEntries().save(true);
                    SVNFileUtil.deleteAll(dst, this);
                    SVNFileUtil.copy(src, dst, false, false);
                    this.myWCClient.doAdd(dst, false, false, false, true);
                }
            }
            srcAccess.close(false);
            dstAccess.close(false);
            try {
                this.myWCClient.doDelete(src, true, false);
            }
            catch (SVNException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doVirtualCopy(File src, File dst, boolean move) throws SVNException {
        SVNErrorMessage err;
        SVNErrorMessage err2;
        String opName;
        SVNFileType srcType = SVNFileType.getType(src);
        SVNFileType dstType = SVNFileType.getType(dst);
        String string = opName = move ? "move" : "copy";
        if (move && srcType != SVNFileType.NONE) {
            err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Cannot perform 'virtual' {0}: ''{1}'' still exists", new Object[]{opName, src});
            SVNErrorManager.error(err2);
        }
        if (dstType == SVNFileType.NONE) {
            err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Cannot perform 'virtual' {0}: ''{1}'' does not exist", new Object[]{opName, dst});
            SVNErrorManager.error(err2);
        }
        if (dstType == SVNFileType.DIRECTORY) {
            err2 = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot perform 'virtual' {0}: ''{1}'' is a directory", new Object[]{opName, dst});
            SVNErrorManager.error(err2);
        }
        if (!move && srcType == SVNFileType.DIRECTORY) {
            err2 = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot perform 'virtual' {0}: ''{1}'' is a directory", new Object[]{opName, src});
            SVNErrorManager.error(err2);
        }
        SVNWCAccess dstAccess = this.createWCAccess(dst);
        try {
            dstAccess.open(true, false);
            SVNEntry dstEntry = dstAccess.getTargetEntry();
            if (dstEntry != null) {
                SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' is already under version control", dst);
                SVNErrorManager.error(err3);
            }
        }
        finally {
            dstAccess.close(true);
        }
        SVNWCAccess srcAccess = this.createWCAccess(src);
        String cfURL = null;
        boolean added = false;
        long cfRevision = -1L;
        try {
            srcAccess.open(false, false);
            SVNEntry srcEntry = srcAccess.getTargetEntry();
            if (srcEntry == null) {
                err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", src);
                SVNErrorManager.error(err);
            }
            if (srcEntry.isCopied() && !srcEntry.isScheduledForAddition()) {
                cfURL = SVNMoveClient.getCopyFromURL(src.getParentFile(), SVNEncodingUtil.uriEncode(src.getName()));
                cfRevision = SVNMoveClient.getCopyFromRevision(src.getParentFile());
                if (cfURL == null || cfRevision < 0L) {
                    err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Cannot locate copied directory root for ''{0}''", src);
                    SVNErrorManager.error(err);
                }
                added = false;
            } else {
                cfURL = srcEntry.isCopied() ? srcEntry.getCopyFromURL() : srcEntry.getURL();
                cfRevision = srcEntry.isCopied() ? srcEntry.getCopyFromRevision() : srcEntry.getRevision();
                added = srcEntry.isScheduledForAddition() && !srcEntry.isCopied();
            }
        }
        finally {
            srcAccess.close(false);
        }
        if (!move) {
            this.myWCClient.doDelete(src, true, false);
        }
        if (added) {
            this.myWCClient.doAdd(dst, true, false, false, false);
            return;
        }
        dstAccess = this.createWCAccess(dst);
        try {
            dstAccess.open(true, false);
            SVNEntry dstEntry = dstAccess.getTargetEntry();
            if (dstEntry != null) {
                err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' is already under version control", dst);
                SVNErrorManager.error(err);
            }
            dstEntry = dstAccess.getAnchor().getEntries().addEntry(dst.getName());
            dstEntry.setCopyFromURL(cfURL);
            dstEntry.setCopyFromRevision(cfRevision);
            dstEntry.setCopied(true);
            dstEntry.setKind(SVNNodeKind.FILE);
            dstEntry.scheduleForAddition();
            dstAccess.getAnchor().getEntries().save(true);
        }
        finally {
            dstAccess.close(true);
        }
    }

    private static boolean isVersionedFile(File file) {
        SVNWCAccess wcAccess;
        try {
            wcAccess = SVNWCAccess.create(file);
        }
        catch (SVNException e) {
            return false;
        }
        try {
            return wcAccess != null && wcAccess.getTargetEntry() != null;
        }
        catch (SVNException e) {
            return false;
        }
    }

    private static String getCopyFromURL(File path, String urlTail) throws SVNException {
        if (path == null) {
            return null;
        }
        SVNWCAccess wcAccess = null;
        try {
            wcAccess = SVNWCAccess.create(path);
        }
        catch (SVNException e) {
            return null;
        }
        SVNEntry entry = wcAccess.getTargetEntry();
        if (entry == null) {
            return null;
        }
        String cfURL = entry.getCopyFromURL();
        if (cfURL != null) {
            return SVNPathUtil.append(cfURL, urlTail);
        }
        urlTail = SVNPathUtil.append(SVNEncodingUtil.uriEncode(path.getName()), urlTail);
        path = path.getParentFile();
        return SVNMoveClient.getCopyFromURL(path, urlTail);
    }

    private static long getCopyFromRevision(File path) throws SVNException {
        if (path == null) {
            return -1L;
        }
        SVNWCAccess wcAccess = null;
        try {
            wcAccess = SVNWCAccess.create(path);
        }
        catch (SVNException e) {
            return -1L;
        }
        SVNEntry entry = wcAccess.getTargetEntry();
        if (entry == null) {
            return -1L;
        }
        long rev = entry.getCopyFromRevision();
        if (rev >= 0L) {
            return rev;
        }
        path = path.getParentFile();
        return SVNMoveClient.getCopyFromRevision(path);
    }
}

