/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNCommitPathHandler;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNCommitMediator;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCommitter;
import org.tmatesoft.svn.core.internal.wc.SVNDirectory;
import org.tmatesoft.svn.core.internal.wc.SVNEntries;
import org.tmatesoft.svn.core.internal.wc.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNLog;
import org.tmatesoft.svn.core.internal.wc.SVNProperties;
import org.tmatesoft.svn.core.internal.wc.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class SVNCopyClient
extends SVNBasicClient {
    private ISVNCommitHandler myCommitHandler;

    public SVNCopyClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    protected SVNCopyClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public void setCommitHandler(ISVNCommitHandler handler) {
        this.myCommitHandler = handler;
    }

    public ISVNCommitHandler getCommitHandler() {
        if (this.myCommitHandler == null) {
            this.myCommitHandler = new DefaultSVNCommitHandler();
        }
        return this.myCommitHandler;
    }

    public SVNCommitInfo doCopy(SVNURL srcURL, SVNRevision srcRevision, SVNURL dstURL, boolean isMove, String commitMessage) throws SVNException {
        SVNErrorMessage err;
        SVNNodeKind dstKind;
        SVNNodeKind srcKind;
        SVNRepository repository;
        SVNURL topURL = SVNURLUtil.getCommonURLAncestor(srcURL, dstURL);
        if (topURL == null) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Source and dest appear not to be in the same repository (src: ''{0}''; dst: ''{1}'')", new Object[]{srcURL, dstURL});
            SVNErrorManager.error(err2);
        }
        boolean isResurrect = false;
        if (dstURL.equals(srcURL)) {
            topURL = srcURL.removePathTail();
            isResurrect = true;
        }
        if (!dstURL.equals((repository = this.createRepository(topURL, true)).getRepositoryRoot(true)) && srcURL.getPath().startsWith(dstURL.getPath() + "/")) {
            isResurrect = true;
            topURL = topURL.removePathTail();
            repository = this.createRepository(topURL, true);
        }
        String srcPath = srcURL.equals(topURL) ? "" : srcURL.toString().substring(topURL.toString().length() + 1);
        srcPath = SVNEncodingUtil.uriDecode(srcPath);
        String dstPath = dstURL.equals(topURL) ? "" : dstURL.toString().substring(topURL.toString().length() + 1);
        dstPath = SVNEncodingUtil.uriDecode(dstPath);
        if ("".equals(srcPath) && isMove) {
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot move URL ''{0}'' into itself", srcURL);
            SVNErrorManager.error(err3);
        }
        long srcRevNumber = this.getRevisionNumber(srcRevision, repository, null);
        long latestRevision = repository.getLatestRevision();
        if (srcRevNumber < 0L) {
            srcRevNumber = latestRevision;
        }
        if ((srcKind = repository.checkPath(srcPath, srcRevNumber)) == SVNNodeKind.NONE) {
            SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Path ''{0}'' does not exist in revision {1}", new Object[]{srcURL, new Long(srcRevNumber)});
            SVNErrorManager.error(err4);
        }
        if ((dstKind = repository.checkPath(dstPath, latestRevision)) == SVNNodeKind.DIR) {
            if (repository.checkPath(dstPath = SVNPathUtil.append(dstPath, SVNPathUtil.tail(srcURL.getPath())), latestRevision) != SVNNodeKind.NONE) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_ALREADY_EXISTS, "Path ''{0}'' already exists", dstPath);
                SVNErrorManager.error(err);
            }
        } else if (dstKind == SVNNodeKind.FILE) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_ALREADY_EXISTS, "Path ''{0}'' already exists", dstPath);
            SVNErrorManager.error(err);
        }
        ArrayList<SVNCommitItem> commitItems = new ArrayList<SVNCommitItem>(2);
        commitItems.add(new SVNCommitItem(null, dstURL, srcURL, srcKind, SVNRevision.create(srcRevNumber), true, false, false, false, true, false));
        if (isMove) {
            commitItems.add(new SVNCommitItem(null, srcURL, null, srcKind, SVNRevision.create(srcRevNumber), false, true, false, false, false, false));
        }
        if ((commitMessage = this.getCommitHandler().getCommitMessage(commitMessage, commitItems.toArray(new SVNCommitItem[commitItems.size()]))) == null) {
            return SVNCommitInfo.NULL;
        }
        commitMessage = SVNCommitClient.validateCommitMessage(commitMessage);
        ISVNEditor commitEditor = repository.getCommitEditor(commitMessage, null, false, null);
        CopyCommitPathHandler committer = new CopyCommitPathHandler(srcPath, srcRevNumber, srcKind, dstPath, isMove, isResurrect);
        List<String> paths = isMove ? Arrays.asList(srcPath, dstPath) : Collections.singletonList(dstPath);
        SVNCommitInfo result = null;
        try {
            SVNCommitUtil.driveCommitEditor(committer, paths, commitEditor, -1L);
            result = commitEditor.closeEdit();
        }
        catch (SVNException e) {
            try {
                commitEditor.abortEdit();
            }
            catch (SVNException inner) {
                // empty catch block
            }
            SVNErrorMessage nestedErr = e.getErrorMessage();
            SVNErrorMessage err5 = SVNErrorMessage.create(nestedErr.getErrorCode(), "Commit failed (details follow):");
            SVNErrorManager.error(err5, e);
        }
        if (result != null && result.getNewRevision() >= 0L) {
            this.dispatchEvent(SVNEventFactory.createCommitCompletedEvent(null, result.getNewRevision()), -1.0);
        }
        return result != null ? result : SVNCommitInfo.NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNCommitInfo doCopy(File srcPath, SVNRevision srcRevision, SVNURL dstURL, String commitMessage) throws SVNException {
        ISVNEditor commitEditor;
        SVNCommitInfo info;
        SVNWCAccess wcAccess;
        block24: {
            Iterator files2;
            SVNEntry entry;
            TreeMap commitables;
            Collection tmpFiles;
            SVNCommitItem[] items;
            SVNRepository repository;
            block22: {
                SVNCommitInfo sVNCommitInfo;
                block23: {
                    if (srcRevision.isValid() && srcRevision != SVNRevision.WORKING) {
                        SVNErrorMessage err;
                        SVNWCAccess wcAccess2 = this.createWCAccess(srcPath);
                        SVNEntry srcEntry = wcAccess2.getTargetEntry();
                        if (srcEntry == null) {
                            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", srcPath);
                            SVNErrorManager.error(err);
                        }
                        if (srcEntry.getURL() == null) {
                            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", srcPath);
                            SVNErrorManager.error(err);
                        }
                        return this.doCopy(srcEntry.getSVNURL(), srcRevision, dstURL, false, commitMessage);
                    }
                    wcAccess = this.createWCAccess(srcPath);
                    SVNURL dstAnchorURL = dstURL.removePathTail();
                    String dstTarget = SVNPathUtil.tail(dstURL.toString());
                    dstTarget = SVNEncodingUtil.uriDecode(dstTarget);
                    repository = this.createRepository(dstAnchorURL, true);
                    SVNNodeKind dstKind = repository.checkPath(dstTarget, -1L);
                    if (dstKind == SVNNodeKind.DIR) {
                        dstURL = dstURL.appendPath(srcPath.getName(), false);
                    } else if (dstKind == SVNNodeKind.FILE) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_ALREADY_EXISTS, "File ''{0}'' already exists", dstURL);
                        SVNErrorManager.error(err);
                    }
                    items = new SVNCommitItem[]{new SVNCommitItem(null, dstURL, null, SVNNodeKind.NONE, SVNRevision.UNDEFINED, true, false, false, false, true, false)};
                    commitMessage = this.getCommitHandler().getCommitMessage(commitMessage, items);
                    if (commitMessage == null) {
                        return SVNCommitInfo.NULL;
                    }
                    tmpFiles = null;
                    info = null;
                    commitEditor = null;
                    wcAccess.open(false, true);
                    commitables = new TreeMap();
                    entry = wcAccess.getTargetEntry();
                    if (entry != null) break block22;
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", srcPath);
                    SVNErrorManager.error(err);
                    sVNCommitInfo = SVNCommitInfo.NULL;
                    Object var19_23 = null;
                    if (tmpFiles == null) break block23;
                    Iterator files2 = tmpFiles.iterator();
                    while (files2.hasNext()) {
                        File file = (File)files2.next();
                        file.delete();
                    }
                }
                if (commitEditor != null && info == null) {
                    commitEditor.abortEdit();
                }
                if (wcAccess != null) {
                    wcAccess.close(false);
                }
                return sVNCommitInfo;
            }
            try {
                SVNCommitUtil.harvestCommitables(commitables, wcAccess.getTarget(), srcPath, null, entry, dstURL.toString(), entry.getURL(), true, false, false, null, true, false);
                items = commitables.values().toArray(new SVNCommitItem[commitables.values().size()]);
                for (int i = 0; i < items.length; ++i) {
                    items[i].setWCAccess(wcAccess);
                }
                commitables = new TreeMap();
                dstURL = SVNURL.parseURIEncoded(SVNCommitUtil.translateCommitables(items, commitables));
                repository = this.createRepository(dstURL, true);
                SVNCommitMediator mediator = new SVNCommitMediator(commitables);
                tmpFiles = mediator.getTmpFiles();
                commitMessage = SVNCommitClient.validateCommitMessage(commitMessage);
                commitEditor = repository.getCommitEditor(commitMessage, null, false, mediator);
                info = SVNCommitter.commit(tmpFiles, commitables, repository.getRepositoryRoot(true).getPath(), commitEditor);
                commitEditor = null;
                Object var19_24 = null;
                if (tmpFiles == null) break block24;
                files2 = tmpFiles.iterator();
            }
            catch (Throwable throwable) {
                Object var19_25 = null;
                if (tmpFiles != null) {
                    Iterator files2 = tmpFiles.iterator();
                    while (files2.hasNext()) {
                        File file = (File)files2.next();
                        file.delete();
                    }
                }
                if (commitEditor != null && info == null) {
                    commitEditor.abortEdit();
                }
                if (wcAccess != null) {
                    wcAccess.close(false);
                }
                throw throwable;
            }
            while (files2.hasNext()) {
                File file = (File)files2.next();
                file.delete();
            }
        }
        if (commitEditor != null && info == null) {
            commitEditor.abortEdit();
        }
        if (wcAccess != null) {
            wcAccess.close(false);
        }
        if (info != null && info.getNewRevision() >= 0L) {
            this.dispatchEvent(SVNEventFactory.createCommitCompletedEvent(null, info.getNewRevision()), -1.0);
        }
        return info != null ? info : SVNCommitInfo.NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doCopy(SVNURL srcURL, SVNRevision srcRevision, File dstPath) throws SVNException {
        SVNWCAccess dstAccess;
        SVNEntry dstEntry;
        SVNErrorMessage err;
        SVNFileType dstFileType;
        long srcRevisionNumber;
        SVNNodeKind srcKind;
        SVNRepository repository = this.createRepository(srcURL, true);
        if (!srcRevision.isValid()) {
            srcRevision = SVNRevision.HEAD;
        }
        if ((srcKind = repository.checkPath("", srcRevisionNumber = this.getRevisionNumber(srcRevision, repository, null))) == SVNNodeKind.NONE) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Path ''{0}'' not found in revision {1}", new Object[]{srcURL, new Long(srcRevisionNumber)});
            SVNErrorManager.error(err2);
        }
        if ((dstFileType = SVNFileType.getType(dstPath)) == SVNFileType.DIRECTORY) {
            dstPath = new File(dstPath, SVNPathUtil.tail(srcURL.getPath()));
        } else if (dstFileType != SVNFileType.NONE) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "File ''{0}'' already exists", dstPath);
            SVNErrorManager.error(err);
        }
        dstFileType = SVNFileType.getType(dstPath);
        if (dstFileType != SVNFileType.NONE) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "''{0}'' is in the way", dstPath);
            SVNErrorManager.error(err);
        }
        if ((dstEntry = (dstAccess = this.createWCAccess(dstPath)).getTargetEntry()) != null) {
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Entry for ''{0}'' exists (though the working copy file is missing)", dstPath);
            SVNErrorManager.error(err3);
        }
        String srcUUID = null;
        String dstUUID = null;
        SVNWCAccess dstParentAccess = this.createWCAccess(dstPath.getParentFile());
        SVNEntry dstParentEntry = dstParentAccess.getTargetEntry();
        SVNURL repositoryRootURL = repository.getRepositoryRoot(true);
        try {
            srcUUID = repository.getRepositoryUUID(true);
            String string = dstUUID = dstParentEntry != null ? dstParentEntry.getUUID() : null;
            if (dstParentEntry != null && dstParentEntry.getURL() != null && dstUUID == null) {
                SVNURL url = dstParentEntry.getSVNURL();
                SVNRepository dstRepos = this.createRepository(url, false);
                dstUUID = dstRepos.getRepositoryUUID(true);
            }
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NO_REPOS_UUID) {
                dstUUID = null;
                srcUUID = null;
            }
            throw e;
        }
        boolean sameRepositories = dstUUID == null || srcUUID == null ? false : srcUUID.equals(dstUUID);
        long revision = -1L;
        if (srcKind == SVNNodeKind.DIR) {
            SVNUpdateClient updateClient = new SVNUpdateClient(this.getRepositoryPool(), this.getOptions());
            updateClient.setEventHandler(this.getEventDispatcher());
            updateClient.setEventPathPrefix("");
            try {
                revision = updateClient.doCheckout(srcURL, dstPath, srcRevision, srcRevision, true);
            }
            finally {
                updateClient.setEventPathPrefix(null);
            }
            if (sameRepositories) {
                try {
                    SVNEntry newEntry = dstParentAccess.getTarget().getEntries().addEntry(dstPath.getName());
                    newEntry.setKind(SVNNodeKind.DIR);
                    newEntry.scheduleForAddition();
                    dstParentAccess.getTarget().getEntries().save(true);
                    SVNURL newURL = dstParentAccess.getTargetEntry().getSVNURL();
                    newURL = newURL.appendPath(dstPath.getName(), false);
                    this.addDir(dstParentAccess.getTarget(), dstPath.getName(), srcURL.toString(), revision);
                    dstAccess.close(true);
                    dstAccess = this.createWCAccess(dstPath);
                    this.addDir(dstAccess.getTarget(), "", srcURL.toString(), revision);
                    dstAccess.open(true, true);
                    SVNCopyClient.updateCopiedDirectory(dstAccess.getTarget(), "", newURL.toString(), repositoryRootURL.toString(), null, -1L);
                }
                finally {
                    dstAccess.close(true);
                }
            } else {
                SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Source URL ''{0}'' is from foreign repository; leaving it as a disjoint WC", srcURL);
                SVNErrorManager.error(err4);
            }
        } else if (srcKind == SVNNodeKind.FILE) {
            HashMap properties = new HashMap();
            File tmpFile = null;
            File baseTmpFile = dstAccess.getAnchor().getBaseFile(dstPath.getName(), true);
            tmpFile = SVNFileUtil.createUniqueFile(baseTmpFile.getParentFile(), dstPath.getName(), ".tmp");
            OutputStream os = SVNFileUtil.openFileForWriting(tmpFile);
            try {
                repository.getFile("", srcRevisionNumber, properties, new SVNCancellableOutputStream(os, this));
            }
            finally {
                SVNFileUtil.closeFile(os);
            }
            SVNFileUtil.rename(tmpFile, baseTmpFile);
            if (tmpFile != null) {
                tmpFile.delete();
            }
            this.addFile(dstAccess.getAnchor(), dstPath.getName(), properties, sameRepositories ? srcURL.toString() : null, srcRevisionNumber);
            dstAccess.getAnchor().runLogs();
            this.dispatchEvent(SVNEventFactory.createAddedEvent(dstAccess, dstAccess.getAnchor(), dstAccess.getTargetEntry()));
            revision = srcRevisionNumber;
        }
        return revision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCopy(File srcPath, SVNRevision srcRevision, File dstPath, boolean force, boolean isMove) throws SVNException {
        SVNErrorMessage err;
        SVNFileType dstType;
        SVNFileType srcType;
        SVNErrorMessage err2;
        if (srcRevision.isValid() && srcRevision != SVNRevision.WORKING && !isMove) {
            SVNErrorMessage err3;
            SVNWCAccess wcAccess = this.createWCAccess(srcPath);
            SVNEntry srcEntry = wcAccess.getTargetEntry();
            if (srcEntry == null) {
                err3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", srcPath);
                SVNErrorManager.error(err3);
            }
            if (srcEntry.getURL() == null) {
                err3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", srcPath);
                SVNErrorManager.error(err3);
            }
            this.doCopy(srcEntry.getSVNURL(), srcRevision, dstPath);
            return;
        }
        if (SVNPathUtil.isChildOf(srcPath, dstPath)) {
            err2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot copy ''{0}'' into its own child ''{1}''", new Object[]{srcPath, dstPath});
            SVNErrorManager.error(err2);
        }
        if (isMove && srcPath.equals(dstPath)) {
            err2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot move ''{0}'' into itself", srcPath);
            SVNErrorManager.error(err2);
        }
        if ((srcType = SVNFileType.getType(srcPath)) == SVNFileType.NONE) {
            SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Path ''{0}'' does not exist", srcPath);
            SVNErrorManager.error(err4);
        }
        if ((dstType = SVNFileType.getType(dstPath)) == SVNFileType.DIRECTORY) {
            dstType = SVNFileType.getType(dstPath = new File(dstPath, srcPath.getName()));
            if (dstType != SVNFileType.NONE) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "''{0}'' already exists and is in a way", dstPath);
                SVNErrorManager.error(err);
            }
        } else if (dstType != SVNFileType.NONE) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "File ''{0}'' already exists", dstPath);
            SVNErrorManager.error(err);
        }
        SVNWCAccess srcAccess = this.createWCAccess(srcPath);
        SVNWCAccess dstAccess = this.createWCAccess(dstPath);
        try {
            SVNEntry dstParentEntry;
            if (srcAccess.getTargetEntry() == null) {
                SVNErrorMessage err5 = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", srcPath);
                SVNErrorManager.error(err5);
            }
            String srcRepos = srcAccess.getTargetEntry().getRepositoryRoot();
            String dstRepos = dstAccess.getAnchor().getEntries().getEntry("", true).getRepositoryRoot();
            if (srcRepos != null && dstRepos != null && !srcRepos.equals(dstRepos)) {
                SVNErrorMessage err6 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy to ''{0}'', as it is not from repository ''{1}''; it is from ''{2}''", new Object[]{dstPath, srcRepos, dstRepos});
                SVNErrorManager.error(err6);
            }
            if (isMove) {
                if (srcAccess.getAnchor().getRoot().equals(dstAccess.getAnchor().getRoot())) {
                    dstAccess = srcAccess;
                }
                srcAccess.open(true, srcType == SVNFileType.DIRECTORY);
                if (!force) {
                    srcAccess.getAnchor().canScheduleForDeletion(dstAccess.getTargetName(), true);
                }
            }
            if (srcAccess != dstAccess) {
                dstAccess.open(true, srcType == SVNFileType.DIRECTORY);
            }
            if ((dstParentEntry = dstAccess.getAnchor().getEntries().getEntry("", true)).isScheduledForDeletion()) {
                SVNErrorMessage err7 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy to ''{0}'' as it is scheduled for deletion", dstPath);
                SVNErrorManager.error(err7);
            }
            if (srcType == SVNFileType.DIRECTORY) {
                this.copyDirectory(dstAccess, srcAccess, dstPath.getName());
            } else {
                this.copyFile(dstAccess, srcAccess, dstPath.getName());
            }
            if (isMove) {
                srcAccess.getAnchor().scheduleForDeletion(srcPath.getName(), true);
            }
            Object var15_17 = null;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            dstAccess.close(true);
            if (isMove && srcAccess != dstAccess) {
                srcAccess.close(true);
            }
            throw throwable;
        }
        dstAccess.close(true);
        if (isMove && srcAccess != dstAccess) {
            srcAccess.close(true);
        }
    }

    private void addFile(SVNDirectory dir, String fileName, Map properties, String copyFromURL, long copyFromRev) throws SVNException {
        SVNLog log = dir.getLog(0);
        HashMap<String, String> regularProps = new HashMap<String, String>();
        HashMap<String, String> entryProps = new HashMap<String, String>();
        HashMap<String, String> wcProps = new HashMap<String, String>();
        Iterator names = properties.keySet().iterator();
        while (names.hasNext()) {
            String propName = (String)names.next();
            String propValue = (String)properties.get(propName);
            if (propName.startsWith("svn:entry:")) {
                entryProps.put(SVNProperty.shortPropertyName(propName), propValue);
                continue;
            }
            if (propName.startsWith("svn:wc:")) {
                wcProps.put(propName, propValue);
                continue;
            }
            regularProps.put(propName, propValue);
        }
        entryProps.put(SVNProperty.shortPropertyName("svn:entry:kind"), "file");
        entryProps.put(SVNProperty.shortPropertyName("svn:entry:revision"), "0");
        entryProps.put(SVNProperty.shortPropertyName("svn:entry:schedule"), "add");
        if (copyFromURL != null) {
            entryProps.put(SVNProperty.shortPropertyName("svn:entry:copyfrom-rev"), Long.toString(copyFromRev));
            entryProps.put(SVNProperty.shortPropertyName("svn:entry:copyfrom-url"), copyFromURL);
            entryProps.put(SVNProperty.shortPropertyName("svn:entry:copied"), Boolean.TRUE.toString());
        }
        log.logChangedEntryProperties(fileName, entryProps);
        log.logChangedWCProperties(fileName, wcProps);
        dir.mergeProperties(fileName, null, regularProps, true, log);
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("name", SVNFileUtil.getBasePath(dir.getBaseFile(fileName, true)));
        command.put("dest", fileName);
        log.addCommand("cp-and-translate", command, false);
        command.clear();
        command.put("name", SVNFileUtil.getBasePath(dir.getBaseFile(fileName, true)));
        command.put("dest", SVNFileUtil.getBasePath(dir.getBaseFile(fileName, false)));
        log.addCommand("mv", command, false);
        log.save();
    }

    private void copyFile(SVNWCAccess dstAccess, SVNWCAccess srcAccess, String dstName) throws SVNException {
        SVNErrorMessage err;
        SVNEntry srcEntry;
        SVNEntry dstEntry = dstAccess.getAnchor().getEntries().getEntry(dstName, false);
        File dstPath = new File(dstAccess.getAnchor().getRoot(), dstName);
        File srcPath = new File(srcAccess.getAnchor().getRoot(), srcAccess.getTargetName());
        if (dstEntry != null && dstEntry.isFile()) {
            SVNErrorMessage err2;
            if (dstEntry.isScheduledForDeletion()) {
                err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' is scheduled for deletion; it must be committed before being overwritten", dstPath);
                SVNErrorManager.error(err2);
            } else {
                err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "There is already versioned item ''{0}''", dstPath);
                SVNErrorManager.error(err2);
            }
        }
        if ((srcEntry = srcAccess.getTargetEntry()) == null) {
            err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "Cannot copy or move ''{0}'': it's not under version control", srcPath);
            SVNErrorManager.error(err);
        } else if (srcEntry.isScheduledForAddition() || srcEntry.getURL() == null || srcEntry.isCopied()) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot copy or move ''{0}'': it's not in repository yet; try committing first", srcPath);
            SVNErrorManager.error(err);
        }
        SVNFileType srcType = SVNFileType.getType(srcPath);
        if (srcType == SVNFileType.SYMLINK) {
            String name = SVNFileUtil.getSymlinkName(srcPath);
            if (name != null) {
                SVNFileUtil.createSymlink(dstPath, name);
            }
        } else {
            SVNFileUtil.copyFile(srcPath, dstPath, false);
        }
        File srcTextBase = srcAccess.getAnchor().getBaseFile(srcAccess.getTargetName(), false);
        SVNProperties srcProps = srcAccess.getAnchor().getProperties(srcAccess.getTargetName(), false);
        boolean executable = srcProps.getPropertyValue("svn:executable") != null;
        SVNProperties srcBaseProps = srcAccess.getAnchor().getBaseProperties(srcAccess.getTargetName(), false);
        File dstTextBase = dstAccess.getAnchor().getBaseFile(dstName, false);
        SVNProperties dstProps = dstAccess.getAnchor().getProperties(dstName, false);
        SVNProperties dstBaseProps = srcAccess.getAnchor().getBaseProperties(dstName, false);
        if (srcTextBase.exists()) {
            SVNFileUtil.copyFile(srcTextBase, dstTextBase, false);
        }
        if (srcProps.getFile().exists()) {
            srcProps.copyTo(dstProps);
        }
        if (srcBaseProps.getFile().exists()) {
            srcBaseProps.copyTo(dstBaseProps);
        }
        if (executable) {
            SVNFileUtil.setExecutable(dstPath, true);
        }
        String copyFromURL = srcEntry.getURL();
        long copyFromRevision = srcEntry.getRevision();
        SVNEntry entry = dstAccess.getAnchor().add(dstName, false, false);
        entry.setCopied(true);
        entry.setCopyFromRevision(copyFromRevision);
        entry.setCopyFromURL(copyFromURL);
        entry.setRevision(copyFromRevision);
        entry.scheduleForAddition();
        dstAccess.getAnchor().getEntries().save(true);
    }

    private void addDir(SVNDirectory dir, String name, String copyFromURL, long copyFromRev) throws SVNException {
        SVNEntry entry = dir.getEntries().getEntry(name, true);
        if (entry == null) {
            entry = dir.getEntries().addEntry(name);
        }
        entry.setKind(SVNNodeKind.DIR);
        if (copyFromURL != null) {
            entry.setCopyFromRevision(copyFromRev);
            entry.setCopyFromURL(copyFromURL);
            entry.setCopied(true);
        }
        entry.scheduleForAddition();
        if ("".equals(name) && copyFromURL != null) {
            SVNCopyClient.updateCopiedDirectory(dir, name, null, entry.getRepositoryRoot(), null, -1L);
        }
        dir.getEntries().save(true);
    }

    private void copyDirectory(SVNWCAccess dstAccess, SVNWCAccess srcAccess, String dstName) throws SVNException {
        SVNErrorMessage err;
        SVNEntry srcEntry = srcAccess.getTargetEntry();
        if (srcEntry == null) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", srcAccess.getTarget().getRoot());
            SVNErrorManager.error(err);
        } else if (srcEntry.isScheduledForAddition() || srcEntry.getURL() == null || srcEntry.isCopied()) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot copy or move ''{0}'': it is not in repository yet; try committing first", srcAccess.getTarget().getRoot());
            SVNErrorManager.error(err);
        }
        String copyFromURL = srcEntry.getURL();
        long copyFromRev = srcEntry.getRevision();
        String newURL = dstAccess.getAnchor().getEntries().getEntry("", true).getURL();
        String reposRootURL = dstAccess.getAnchor().getEntries().getEntry("", true).getRepositoryRoot();
        newURL = SVNPathUtil.append(newURL, SVNEncodingUtil.uriEncode(dstName));
        File dstPath = new File(dstAccess.getAnchor().getRoot(), dstName);
        SVNFileUtil.copyDirectory(srcAccess.getTarget().getRoot(), dstPath, true, this);
        SVNDirectory newDir = dstAccess.addDirectory(dstName, dstPath, true, true, false);
        SVNEntry entry = dstAccess.getAnchor().getEntries().addEntry(dstName);
        entry.setCopyFromRevision(copyFromRev);
        entry.setKind(SVNNodeKind.DIR);
        entry.scheduleForAddition();
        entry.setCopyFromURL(copyFromURL);
        entry.setCopied(true);
        SVNEvent event = SVNEventFactory.createAddedEvent(dstAccess, dstAccess.getAnchor(), entry);
        this.dispatchEvent(event);
        dstAccess.getTarget().getEntries().save(true);
        SVNCopyClient.updateCopiedDirectory(newDir, "", newURL, reposRootURL, null, -1L);
        SVNEntry newRoot = newDir.getEntries().getEntry("", true);
        newRoot.scheduleForAddition();
        newRoot.setCopyFromRevision(copyFromRev);
        newRoot.setCopyFromURL(copyFromURL);
        newDir.getEntries().save(true);
    }

    static void updateCopiedDirectory(SVNDirectory dir, String name, String newURL, String reposRootURL, String copyFromURL, long copyFromRevision) throws SVNException {
        SVNEntries entries = dir.getEntries();
        SVNEntry entry = entries.getEntry(name, true);
        if (entry != null) {
            entry.setCopied(true);
            if (newURL != null) {
                entry.setURL(newURL);
            }
            entry.setRepositoryRoot(reposRootURL);
            if (entry.isFile()) {
                dir.getWCProperties(name).delete();
                if (copyFromURL != null) {
                    entry.setCopyFromURL(copyFromURL);
                    entry.setCopyFromRevision(copyFromRevision);
                }
            }
            boolean deleted = false;
            if (entry.isDeleted() && newURL != null) {
                deleted = true;
                entry.setDeleted(false);
                entry.scheduleForDeletion();
                if (entry.isDirectory()) {
                    entry.setKind(SVNNodeKind.FILE);
                }
            }
            if (entry.getLockToken() != null && newURL != null) {
                entry.setLockToken(null);
                entry.setLockOwner(null);
                entry.setLockComment(null);
                entry.setLockCreationDate(null);
            }
            if (!"".equals(name) && entry.isDirectory() && !deleted) {
                SVNDirectory childDir = dir.getChildDirectory(name);
                if (childDir != null) {
                    String childCopyFromURL = copyFromURL == null ? null : SVNPathUtil.append(copyFromURL, SVNEncodingUtil.uriEncode(entry.getName()));
                    SVNCopyClient.updateCopiedDirectory(childDir, "", newURL, reposRootURL, childCopyFromURL, copyFromRevision);
                }
            } else if ("".equals(name)) {
                dir.getWCProperties("").delete();
                if (copyFromURL != null) {
                    entry.setCopyFromURL(copyFromURL);
                    entry.setCopyFromRevision(copyFromRevision);
                }
                Iterator ents = entries.entries(true);
                while (ents.hasNext()) {
                    SVNEntry childEntry = (SVNEntry)ents.next();
                    if ("".equals(childEntry.getName())) continue;
                    String childCopyFromURL = copyFromURL == null ? null : SVNPathUtil.append(copyFromURL, SVNEncodingUtil.uriEncode(childEntry.getName()));
                    String newChildURL = newURL == null ? null : SVNPathUtil.append(newURL, SVNEncodingUtil.uriEncode(childEntry.getName()));
                    SVNCopyClient.updateCopiedDirectory(dir, childEntry.getName(), newChildURL, reposRootURL, childCopyFromURL, copyFromRevision);
                }
                entries.save(true);
            }
        }
    }

    private static class CopyCommitPathHandler
    implements ISVNCommitPathHandler {
        private String mySrcPath;
        private String myDstPath;
        private long mySrcRev;
        private boolean myIsMove;
        private boolean myIsResurrect;
        private SVNNodeKind mySrcKind;

        public CopyCommitPathHandler(String srcPath, long srcRev, SVNNodeKind srcKind, String dstPath, boolean isMove, boolean isRessurect) {
            this.mySrcPath = srcPath;
            this.myDstPath = dstPath;
            this.mySrcRev = srcRev;
            this.myIsMove = isMove;
            this.mySrcKind = srcKind;
            this.myIsResurrect = isRessurect;
        }

        public boolean handleCommitPath(String commitPath, ISVNEditor commitEditor) throws SVNException {
            boolean doAdd = false;
            boolean doDelete = false;
            if (this.myIsResurrect) {
                if (!this.myIsMove) {
                    doAdd = true;
                }
            } else if (this.myIsMove) {
                if (commitPath.equals(this.mySrcPath)) {
                    doDelete = true;
                } else {
                    doAdd = true;
                }
            } else {
                doAdd = true;
            }
            if (doDelete) {
                commitEditor.deleteEntry(this.mySrcPath, -1L);
            }
            boolean closeDir = false;
            if (doAdd) {
                if (this.mySrcKind == SVNNodeKind.DIR) {
                    commitEditor.addDir(this.myDstPath, this.mySrcPath, this.mySrcRev);
                    closeDir = true;
                } else {
                    commitEditor.addFile(this.myDstPath, this.mySrcPath, this.mySrcRev);
                    commitEditor.closeFile(this.myDstPath, null);
                }
            }
            return closeDir;
        }
    }
}

