/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.javahl;

import java.io.File;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tigris.subversion.javahl.PromptUserPassword2;
import org.tigris.subversion.javahl.PromptUserPassword3;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.javahl.PromptUserPasswordSSH;
import org.tmatesoft.svn.core.javahl.PromptUserPasswordSSL;
import org.tmatesoft.svn.util.SVNDebugLog;

class JavaHLAuthenticationProvider
implements ISVNAuthenticationProvider {
    private PromptUserPassword myPrompt;

    public JavaHLAuthenticationProvider(PromptUserPassword prompt) {
        this.myPrompt = prompt;
    }

    public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
        String userName;
        if ("svn.ssh".equals(kind) && this.myPrompt instanceof PromptUserPasswordSSH) {
            int port;
            PromptUserPasswordSSH prompt4 = (PromptUserPasswordSSH)this.myPrompt;
            String userName2 = previousAuth != null && previousAuth.getUserName() != null ? previousAuth.getUserName() : System.getProperty("user.name");
            int n = port = url != null ? url.getPort() : -1;
            if (prompt4.promptSSH(realm, userName2, port, authMayBeStored)) {
                String password = prompt4.getPassword();
                String keyPath = prompt4.getSSHPrivateKeyPath();
                String passphrase = prompt4.getSSHPrivateKeyPassphrase();
                userName2 = prompt4.getUsername();
                if (userName2 == null || "".equals(userName2)) {
                    userName2 = System.getProperty("user.name", "user");
                }
                if ("".equals(passphrase)) {
                    passphrase = null;
                }
                if ((port = prompt4.getSSHPort()) < 0 && url != null) {
                    port = url.getPort();
                    SVNDebugLog.logInfo("using URL port: " + port);
                }
                if (port < 0) {
                    port = 22;
                    SVNDebugLog.logInfo("using default port: " + port);
                }
                SVNDebugLog.logInfo("port number from user's prompt is: " + port);
                boolean save = prompt4.userAllowedSave();
                if (keyPath != null && !"".equals(keyPath)) {
                    return new SVNSSHAuthentication(userName2, new File(keyPath), passphrase, port, save);
                }
                if (password != null) {
                    return new SVNSSHAuthentication(userName2, password, port, save);
                }
            }
            return null;
        }
        if ("svn.ssl".equals(kind) && this.myPrompt instanceof PromptUserPasswordSSL) {
            PromptUserPasswordSSL prompt4 = (PromptUserPasswordSSL)this.myPrompt;
            if (prompt4.promptSSL(realm, authMayBeStored)) {
                String cert = prompt4.getSSLClientCertPath();
                String password = prompt4.getSSLClientCertPassword();
                if (cert != null) {
                    if ("".equals(password)) {
                        password = null;
                    }
                    boolean save = prompt4.userAllowedSave();
                    return new SVNSSLAuthentication(new File(cert), password, save);
                }
            }
            return null;
        }
        if ("svn.ssh".equals(kind) && previousAuth == null) {
            String keyPath = System.getProperty("javasvn.ssh2.key");
            String userName3 = System.getProperty("javasvn.ssh2.username");
            if (userName3 == null) {
                userName3 = System.getProperty("user.name");
            }
            String passPhrase = System.getProperty("javasvn.ssh2.passphrase");
            if (userName3 == null) {
                return null;
            }
            if (keyPath != null && previousAuth == null) {
                return new SVNSSHAuthentication(userName3, new File(keyPath), passPhrase, -1, true);
            }
        } else if (!"svn.simple".equals(kind)) {
            return null;
        }
        String string = userName = previousAuth != null && previousAuth.getUserName() != null ? previousAuth.getUserName() : System.getProperty("user.name");
        if (this.myPrompt instanceof PromptUserPassword3) {
            PromptUserPassword3 prompt3 = (PromptUserPassword3)this.myPrompt;
            if (prompt3.prompt(realm, userName, authMayBeStored)) {
                if ("svn.ssh".equals(kind)) {
                    int portNumber = previousAuth instanceof SVNSSHAuthentication ? ((SVNSSHAuthentication)previousAuth).getPortNumber() : -1;
                    return new SVNSSHAuthentication(prompt3.getUsername(), prompt3.getPassword(), portNumber, prompt3.userAllowedSave());
                }
                return new SVNPasswordAuthentication(prompt3.getUsername(), prompt3.getPassword(), prompt3.userAllowedSave());
            }
        } else if (this.myPrompt.prompt(realm, userName)) {
            if ("svn.ssh".equals(kind)) {
                return new SVNSSHAuthentication(userName, this.myPrompt.getPassword(), -1, true);
            }
            return new SVNPasswordAuthentication(this.myPrompt.getUsername(), this.myPrompt.getPassword(), true);
        }
        return null;
    }

    public int acceptServerAuthentication(SVNURL url, String realm, Object serverAuth, boolean resultMayBeStored) {
        if (serverAuth != null && this.myPrompt instanceof PromptUserPassword2) {
            PromptUserPassword2 sslPrompt = (PromptUserPassword2)this.myPrompt;
            Object object = serverAuth = serverAuth instanceof X509Certificate ? JavaHLAuthenticationProvider.getServerCertificateInfo((X509Certificate)serverAuth) : serverAuth;
            if (serverAuth == null) {
                serverAuth = "";
            }
            return sslPrompt.askTrustSSLServer(serverAuth.toString(), resultMayBeStored);
        }
        return 2;
    }

    private static String getFingerprint(X509Certificate cert) {
        StringBuffer s = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(cert.getEncoded());
            byte[] digest = md.digest();
            for (int i = 0; i < digest.length; ++i) {
                int b;
                String hex;
                if (i != 0) {
                    s.append(':');
                }
                if ((hex = Integer.toHexString(b = digest[i] & 0xFF)).length() == 1) {
                    s.append('0');
                }
                s.append(hex.toLowerCase());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s.toString();
    }

    private static String getServerCertificateInfo(X509Certificate cert) {
        StringBuffer info = new StringBuffer();
        info.append(" - Subject: ");
        info.append(cert.getSubjectDN().getName());
        info.append('\n');
        info.append(" - Valid: ");
        info.append("from " + cert.getNotBefore() + " until " + cert.getNotAfter());
        info.append('\n');
        info.append(" - Issuer: ");
        info.append(cert.getIssuerDN().getName());
        info.append('\n');
        info.append(" - Fingerprint: ");
        info.append(JavaHLAuthenticationProvider.getFingerprint(cert));
        return info.toString();
    }
}

