/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io.diff;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffInstruction;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVNDiffWindowBuilder {
    private static final int MAX_DATA_CHUNK_LENGTH = 102400;
    public static final int HEADER = 0;
    public static final int OFFSET = 1;
    public static final int INSTRUCTIONS = 2;
    public static final int DONE = 3;
    private static final byte[] HEADER_BYTES = new byte[]{83, 86, 78, 0};
    private int myState;
    private int[] myOffsets;
    private byte[] myInstructions;
    private byte[] myHeader;
    private SVNDiffWindow myDiffWindow;
    private int myFedDataCount;
    private OutputStream myNewDataStream;

    public static SVNDiffWindowBuilder newInstance() {
        return new SVNDiffWindowBuilder();
    }

    private SVNDiffWindowBuilder() {
        this.reset();
    }

    public void reset() {
        this.reset(0);
    }

    public void reset(int state) {
        int i;
        this.myOffsets = new int[5];
        this.myHeader = new byte[4];
        this.myInstructions = null;
        this.myState = state;
        for (i = 0; i < this.myOffsets.length; ++i) {
            this.myOffsets[i] = -1;
        }
        for (i = 0; i < this.myHeader.length; ++i) {
            this.myHeader[i] = -1;
        }
        this.myDiffWindow = null;
        this.myNewDataStream = null;
        this.myFedDataCount = 0;
    }

    public boolean isBuilt() {
        return this.myState == 3;
    }

    public SVNDiffWindow getDiffWindow() {
        return this.myDiffWindow;
    }

    public byte[] getInstructionsData() {
        return this.myInstructions;
    }

    public int accept(byte[] bytes, int offset) {
        switch (this.myState) {
            case 0: {
                for (int i = 0; i < this.myHeader.length && offset < bytes.length; ++i) {
                    if (this.myHeader[i] >= 0) continue;
                    this.myHeader[i] = bytes[offset++];
                }
                if (this.myHeader[this.myHeader.length - 1] < 0) break;
                this.myState = 1;
                if (offset >= bytes.length) break;
                return this.accept(bytes, offset);
            }
            case 1: {
                for (int i = 0; i < this.myOffsets.length && offset < bytes.length; ++i) {
                    if (this.myOffsets[i] >= 0) continue;
                    offset = SVNDiffWindowBuilder.readInt(bytes, offset, this.myOffsets, i);
                    if (this.myOffsets[i] >= 0) continue;
                    return offset;
                }
                if (this.myOffsets[this.myOffsets.length - 1] < 0) break;
                this.myState = 2;
                if (offset >= bytes.length) break;
                return this.accept(bytes, offset);
            }
            case 2: {
                if (this.myOffsets[3] > 0) {
                    if (this.myInstructions == null) {
                        this.myInstructions = new byte[this.myOffsets[3]];
                    }
                    int length = Math.min(bytes.length - offset, this.myOffsets[3]);
                    System.arraycopy(bytes, offset, this.myInstructions, this.myInstructions.length - this.myOffsets[3], length);
                    this.myOffsets[3] = this.myOffsets[3] - length;
                    if (this.myOffsets[3] == 0) {
                        this.myState = 3;
                        if (this.myDiffWindow == null) {
                            this.myDiffWindow = SVNDiffWindowBuilder.createDiffWindow(this.myOffsets, this.myInstructions);
                        }
                    }
                    return offset + length;
                }
                if (this.myDiffWindow == null) {
                    this.myDiffWindow = SVNDiffWindowBuilder.createDiffWindow(this.myOffsets, this.myInstructions);
                }
                this.myState = 3;
            }
        }
        return offset;
    }

    public boolean accept(InputStream is, ISVNEditor consumer, String path) throws SVNException {
        switch (this.myState) {
            case 0: {
                try {
                    for (int i = 0; i < this.myHeader.length; ++i) {
                        if (this.myHeader[i] >= 0) continue;
                        int r = is.read();
                        if (r >= 0) {
                            this.myHeader[i] = (byte)(r & 0xFF);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                    SVNErrorManager.error(err, e);
                }
                if (this.myHeader[this.myHeader.length - 1] < 0) break;
                this.myState = 1;
                break;
            }
            case 1: {
                for (int i = 0; i < this.myOffsets.length; ++i) {
                    if (this.myOffsets[i] >= 0) continue;
                    try {
                        SVNDiffWindowBuilder.readInt(is, this.myOffsets, i);
                    }
                    catch (IOException e) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                        SVNErrorManager.error(err, e);
                    }
                    if (this.myOffsets[i] >= 0) continue;
                    return false;
                }
                if (this.myOffsets[this.myOffsets.length - 1] < 0) break;
                this.myState = 2;
                break;
            }
            case 2: {
                if (this.myOffsets[3] > 0) {
                    SVNErrorMessage err;
                    if (this.myInstructions == null) {
                        this.myInstructions = new byte[this.myOffsets[3]];
                    }
                    int length = this.myOffsets[3];
                    try {
                        length = is.read(this.myInstructions, this.myInstructions.length - length, length);
                    }
                    catch (IOException e) {
                        err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                        SVNErrorManager.error(err, e);
                    }
                    if (length <= 0) {
                        return false;
                    }
                    this.myOffsets[3] = this.myOffsets[3] - length;
                    if (this.myOffsets[3] != 0) break;
                    this.myState = 3;
                    if (this.myDiffWindow != null) break;
                    this.myDiffWindow = SVNDiffWindowBuilder.createDiffWindow(this.myOffsets, this.myInstructions);
                    this.myFedDataCount = 0;
                    this.myNewDataStream = consumer.textDeltaChunk(path, this.myDiffWindow);
                    if (this.myNewDataStream == null) {
                        this.myNewDataStream = SVNFileUtil.DUMMY_OUT;
                    }
                    try {
                        this.myNewDataStream.write(this.myInstructions);
                    }
                    catch (IOException e) {
                        err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                        SVNErrorManager.error(err, e);
                    }
                    break;
                }
                this.myState = 3;
                if (this.myDiffWindow != null) break;
                this.myDiffWindow = SVNDiffWindowBuilder.createDiffWindow(this.myOffsets, this.myInstructions);
                this.myFedDataCount = 0;
                this.myNewDataStream = consumer.textDeltaChunk(path, this.myDiffWindow);
                if (this.myNewDataStream != null) break;
                this.myNewDataStream = SVNFileUtil.DUMMY_OUT;
                break;
            }
            case 3: {
                try {
                    while ((long)this.myFedDataCount < this.myDiffWindow.getNewDataLength()) {
                        int r = is.read();
                        if (r < 0) {
                            return false;
                        }
                        this.myNewDataStream.write(r);
                        ++this.myFedDataCount;
                    }
                }
                catch (IOException e) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                    SVNErrorManager.error(err, e);
                }
                SVNFileUtil.closeFile(this.myNewDataStream);
                this.reset(1);
                break;
            }
            default: {
                SVNDebugLog.logInfo("invalid diff window builder state: " + this.myState);
                return false;
            }
        }
        return true;
    }

    public static void save(SVNDiffWindow window, boolean saveHeader, OutputStream os) throws IOException {
        if (saveHeader) {
            os.write(HEADER_BYTES);
        }
        if (window.getInstructionsCount() == 0) {
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int i = 0; i < window.getInstructionsCount(); ++i) {
            SVNDiffInstruction instruction = window.getInstructionAt(i);
            byte first = (byte)(instruction.type << 6);
            if (instruction.length <= 63L && instruction.length > 0L) {
                first = (byte)((long)first | instruction.length & 0x3FL);
                bos.write(first & 0xFF);
            } else {
                bos.write(first & 0xFF);
                SVNDiffWindowBuilder.writeInt(bos, instruction.length);
            }
            if (instruction.type != 0 && instruction.type != 1) continue;
            SVNDiffWindowBuilder.writeInt(bos, instruction.offset);
        }
        long[] offsets = new long[]{window.getSourceViewOffset(), window.getSourceViewLength(), window.getTargetViewLength(), bos.size(), window.getNewDataLength()};
        for (int i = 0; i < offsets.length; ++i) {
            SVNDiffWindowBuilder.writeInt(os, offsets[i]);
        }
        bos.writeTo(os);
    }

    public static SVNDiffWindow createReplacementDiffWindow(long dataLength) {
        if (dataLength == 0L) {
            return new SVNDiffWindow(0L, 0L, dataLength, new SVNDiffInstruction[0], dataLength);
        }
        long totalLength = dataLength;
        long offset = 0L;
        int instructionsCount = (int)(dataLength / 102400L + 1L);
        ArrayList<SVNDiffInstruction> instructionsList = new ArrayList<SVNDiffInstruction>(instructionsCount);
        while (dataLength > 102400L) {
            dataLength -= 102400L;
            instructionsList.add(new SVNDiffInstruction(2, 102400L, offset));
            offset += 102400L;
        }
        if (dataLength > 0L) {
            instructionsList.add(new SVNDiffInstruction(2, dataLength, offset));
        }
        SVNDiffInstruction[] instructions = instructionsList.toArray(new SVNDiffInstruction[instructionsList.size()]);
        return new SVNDiffWindow(0L, 0L, totalLength, instructions, totalLength);
    }

    public static SVNDiffWindow[] createReplacementDiffWindows(long dataLength, int maxWindowLength) {
        SVNDiffWindow window;
        SVNDiffInstruction instruction;
        if (dataLength == 0L) {
            return new SVNDiffWindow[]{new SVNDiffWindow(0L, 0L, dataLength, new SVNDiffInstruction[0], dataLength)};
        }
        int instructionsCount = (int)(dataLength / (long)maxWindowLength + 1L);
        ArrayList<SVNDiffWindow> windows = new ArrayList<SVNDiffWindow>(instructionsCount);
        while (dataLength > (long)maxWindowLength) {
            instruction = new SVNDiffInstruction(2, maxWindowLength, 0L);
            window = new SVNDiffWindow(0L, 0L, (long)maxWindowLength, new SVNDiffInstruction[]{instruction}, (long)maxWindowLength);
            windows.add(window);
            dataLength -= (long)maxWindowLength;
        }
        if (dataLength > 0L) {
            instruction = new SVNDiffInstruction(2, dataLength, 0L);
            window = new SVNDiffWindow(0L, 0L, dataLength, new SVNDiffInstruction[]{instruction}, dataLength);
            windows.add(window);
        }
        return windows.toArray(new SVNDiffWindow[windows.size()]);
    }

    private static void writeInt(OutputStream os, long i) throws IOException {
        if (i == 0L) {
            os.write(0);
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while (i > 0L) {
            byte b = (byte)(i & 0x7FL);
            i >>= 7;
            if (bos.size() > 0) {
                b = (byte)(b | 0x80);
            }
            bos.write(b);
        }
        byte[] bytes = bos.toByteArray();
        for (int j = bytes.length - 1; j >= 0; --j) {
            os.write(bytes[j]);
        }
    }

    private static int readInt(byte[] bytes, int offset, int[] target, int index) {
        int newOffset;
        block1: {
            newOffset = offset;
            target[index] = 0;
            do {
                byte b = bytes[newOffset];
                target[index] = target[index] << 7;
                target[index] = target[index] | b & 0x7F;
                if ((b & 0x80) == 0) break block1;
            } while (++newOffset < bytes.length);
            target[index] = -1;
            return offset;
        }
        return newOffset + 1;
    }

    private static void readInt(InputStream is, int[] target, int index) throws IOException {
        byte b;
        target[index] = 0;
        is.mark(10);
        do {
            int r;
            if ((r = is.read()) < 0) {
                is.reset();
                target[index] = -1;
                return;
            }
            b = (byte)(r & 0xFF);
            target[index] = target[index] << 7;
            target[index] = target[index] | b & 0x7F;
        } while ((b & 0x80) != 0);
    }

    private static SVNDiffWindow createDiffWindow(int[] offsets, byte[] instructions) {
        SVNDiffWindow window = new SVNDiffWindow((long)offsets[0], (long)offsets[1], (long)offsets[2], instructions.length, (long)offsets[4]);
        return window;
    }

    public static SVNDiffInstruction[] createInstructions(byte[] bytes) {
        ArrayList<SVNDiffInstruction> instructions = new ArrayList<SVNDiffInstruction>();
        int[] instr = new int[2];
        int i = 0;
        while (i < bytes.length) {
            SVNDiffInstruction instruction = new SVNDiffInstruction();
            instruction.type = (bytes[i] & 0xC0) >> 6;
            instruction.length = bytes[i] & 0x3F;
            ++i;
            if (instruction.length == 0L) {
                i = SVNDiffWindowBuilder.readInt(bytes, i, instr, 0);
                instruction.length = instr[0];
            }
            if (instruction.type == 0 || instruction.type == 1) {
                i = SVNDiffWindowBuilder.readInt(bytes, i, instr, 1);
                instruction.offset = instr[1];
            }
            instructions.add(instruction);
            instr[0] = 0;
            instr[1] = 0;
        }
        return instructions.toArray(new SVNDiffInstruction[instructions.size()]);
    }
}

