/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io.diff;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SVNDiffWindowApplyBaton {
    InputStream mySourceStream;
    OutputStream myTargetStream;
    long mySourceViewOffset;
    long mySourceViewLength;
    long myTargetViewSize;
    byte[] mySourceBuffer;
    byte[] myTargetBuffer;
    MessageDigest myDigest;

    public static SVNDiffWindowApplyBaton create(File source, File target, MessageDigest digest) throws SVNException {
        SVNDiffWindowApplyBaton baton = new SVNDiffWindowApplyBaton();
        baton.mySourceStream = source.exists() ? SVNFileUtil.openFileForReading(source) : SVNFileUtil.DUMMY_IN;
        baton.myTargetStream = SVNFileUtil.openFileForWriting(target, true);
        baton.mySourceBuffer = new byte[0];
        baton.mySourceViewLength = 0L;
        baton.mySourceViewOffset = 0L;
        baton.myDigest = digest;
        return baton;
    }

    public static SVNDiffWindowApplyBaton create(InputStream source, OutputStream target, MessageDigest digest) {
        SVNDiffWindowApplyBaton baton = new SVNDiffWindowApplyBaton();
        baton.mySourceStream = source;
        baton.myTargetStream = target;
        baton.mySourceBuffer = new byte[0];
        baton.mySourceViewLength = 0L;
        baton.mySourceViewOffset = 0L;
        baton.myDigest = digest;
        return baton;
    }

    private SVNDiffWindowApplyBaton() {
    }

    public String close() {
        SVNFileUtil.closeFile(this.mySourceStream);
        SVNFileUtil.closeFile(this.myTargetStream);
        if (this.myDigest != null) {
            return SVNFileUtil.toHexDigest(this.myDigest);
        }
        return null;
    }
}

