/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io.diff;

import java.io.IOException;
import java.io.InputStream;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.diff.SVNDiffInstruction;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindowApplyBaton;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindowBuilder;

public class SVNDiffWindow {
    private final long mySourceViewOffset;
    private final long mySourceViewLength;
    private final long myTargetViewLength;
    private SVNDiffInstruction[] myInstructions;
    private final long myNewDataLength;
    private long myInstructionsLength;

    public SVNDiffWindow(long sourceViewOffset, long sourceViewLength, long targetViewLength, SVNDiffInstruction[] instructions, long newDataLength) {
        this.mySourceViewOffset = sourceViewOffset;
        this.mySourceViewLength = sourceViewLength;
        this.myTargetViewLength = targetViewLength;
        this.myInstructions = instructions;
        this.myNewDataLength = newDataLength;
    }

    public SVNDiffWindow(long sourceViewOffset, long sourceViewLength, long targetViewLength, long instructionsLength, long newDataLength) {
        this.mySourceViewOffset = sourceViewOffset;
        this.mySourceViewLength = sourceViewLength;
        this.myTargetViewLength = targetViewLength;
        this.myInstructionsLength = instructionsLength;
        this.myNewDataLength = newDataLength;
    }

    public long getInstructionsLength() {
        return this.myInstructionsLength;
    }

    public long getSourceViewOffset() {
        return this.mySourceViewOffset;
    }

    public long getSourceViewLength() {
        return this.mySourceViewLength;
    }

    public long getTargetViewLength() {
        return this.myTargetViewLength;
    }

    public int getInstructionsCount() {
        return this.myInstructions.length;
    }

    public SVNDiffInstruction getInstructionAt(int index) {
        return this.myInstructions[index];
    }

    public long getNewDataLength() {
        return this.myNewDataLength;
    }

    public void apply(SVNDiffWindowApplyBaton applyBaton, InputStream newData) throws SVNException {
        SVNErrorMessage err;
        if (applyBaton.myTargetBuffer == null || applyBaton.myTargetViewSize < this.getTargetViewLength()) {
            applyBaton.myTargetBuffer = new byte[(int)this.getTargetViewLength()];
        }
        applyBaton.myTargetViewSize = this.getTargetViewLength();
        int length = 0;
        if (this.getSourceViewOffset() != applyBaton.mySourceViewOffset || this.getSourceViewLength() > applyBaton.mySourceViewLength) {
            byte[] oldSourceBuffer = applyBaton.mySourceBuffer;
            applyBaton.mySourceBuffer = new byte[(int)this.getSourceViewLength()];
            if (applyBaton.mySourceViewOffset + applyBaton.mySourceViewLength > this.getSourceViewOffset()) {
                int start = (int)(this.getSourceViewOffset() - applyBaton.mySourceViewOffset);
                System.arraycopy(oldSourceBuffer, start, applyBaton.mySourceBuffer, 0, (int)(applyBaton.mySourceViewLength - (long)start));
                length = (int)(applyBaton.mySourceViewLength - (long)start);
            }
        }
        if ((long)length < this.getSourceViewLength()) {
            try {
                long toSkip = this.getSourceViewOffset() - (applyBaton.mySourceViewOffset + applyBaton.mySourceViewLength);
                if (toSkip > 0L) {
                    applyBaton.mySourceStream.skip(toSkip);
                }
                applyBaton.mySourceStream.read(applyBaton.mySourceBuffer, length, applyBaton.mySourceBuffer.length - length);
            }
            catch (IOException e) {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                SVNErrorManager.error(err2, e);
            }
        }
        applyBaton.mySourceViewLength = this.getSourceViewLength();
        applyBaton.mySourceViewOffset = this.getSourceViewOffset();
        if (this.myInstructions == null) {
            byte[] instrBytes = new byte[(int)this.getInstructionsLength()];
            try {
                newData.read(instrBytes);
            }
            catch (IOException e) {
                err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                SVNErrorManager.error(err, e);
            }
            this.myInstructions = SVNDiffWindowBuilder.createInstructions(instrBytes);
        }
        int tpos = 0;
        try {
            for (int i = 0; i < this.myInstructions.length; ++i) {
                int iLength = this.myInstructions[i].length < this.getTargetViewLength() - (long)tpos ? (int)this.myInstructions[i].length : (int)this.getTargetViewLength() - tpos;
                switch (this.myInstructions[i].type) {
                    case 2: {
                        newData.read(applyBaton.myTargetBuffer, tpos, iLength);
                        break;
                    }
                    case 1: {
                        int start = (int)this.myInstructions[i].offset;
                        int end = (int)this.myInstructions[i].offset + iLength;
                        int tIndex = tpos;
                        for (int j = start; j < end; ++j) {
                            applyBaton.myTargetBuffer[tIndex] = applyBaton.myTargetBuffer[j];
                            ++tIndex;
                        }
                        break;
                    }
                    case 0: {
                        System.arraycopy(applyBaton.mySourceBuffer, (int)this.myInstructions[i].offset, applyBaton.myTargetBuffer, tpos, iLength);
                        break;
                    }
                }
                tpos = (int)((long)tpos + this.myInstructions[i].length);
                if ((long)tpos >= this.getTargetViewLength()) break;
            }
            this.myInstructions = null;
            if (applyBaton.myDigest != null) {
                applyBaton.myDigest.update(applyBaton.myTargetBuffer, 0, (int)this.getTargetViewLength());
            }
            applyBaton.myTargetStream.write(applyBaton.myTargetBuffer, 0, (int)this.getTargetViewLength());
        }
        catch (IOException e) {
            err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSourceViewOffset());
        sb.append(":");
        sb.append(this.getSourceViewOffset());
        sb.append(":");
        sb.append(this.getTargetViewLength());
        sb.append(":");
        sb.append(this.getInstructionsCount());
        sb.append(":");
        sb.append(this.getNewDataLength());
        sb.append("::");
        for (int i = 0; i < this.getInstructionsCount(); ++i) {
            sb.append(this.getInstructionAt(i).toString());
        }
        sb.append(":");
        return sb.toString();
    }
}

