/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io.diff;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindowApplyBaton;

public class SVNDeltaProcessor {
    private SVNDiffWindow myLastWindow;
    private ByteArrayOutputStream myDataStream;
    private SVNDiffWindowApplyBaton myApplyBaton;

    public SVNDeltaProcessor() {
        this(102400);
    }

    public SVNDeltaProcessor(int inialNewDataSize) {
        this.myDataStream = new ByteArrayOutputStream(inialNewDataSize);
    }

    public void applyTextDelta(InputStream base, OutputStream target, boolean computeCheksum) {
        this.reset();
        MessageDigest digest = null;
        try {
            digest = computeCheksum ? MessageDigest.getInstance("MD5") : null;
        }
        catch (NoSuchAlgorithmException e1) {
            // empty catch block
        }
        base = base == null ? SVNFileUtil.DUMMY_IN : base;
        this.myApplyBaton = SVNDiffWindowApplyBaton.create(base, target, digest);
    }

    public void applyTextDelta(File baseFile, File targetFile, boolean computeCheksum) throws SVNException {
        if (!targetFile.exists()) {
            SVNFileUtil.createEmptyFile(targetFile);
        }
        InputStream base = baseFile != null && baseFile.exists() ? SVNFileUtil.openFileForReading(baseFile) : SVNFileUtil.DUMMY_IN;
        this.applyTextDelta(base, SVNFileUtil.openFileForWriting(targetFile), computeCheksum);
    }

    public OutputStream textDeltaChunk(SVNDiffWindow window) throws SVNException {
        if (this.myLastWindow != null) {
            this.myLastWindow.apply(this.myApplyBaton, new ByteArrayInputStream(this.myDataStream.toByteArray()));
        }
        this.myLastWindow = window;
        this.myDataStream.reset();
        return this.myDataStream;
    }

    private void reset() {
        this.myDataStream.reset();
        if (this.myApplyBaton != null) {
            this.myApplyBaton.close();
            this.myApplyBaton = null;
        }
        this.myLastWindow = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String textDeltaEnd() throws SVNException {
        if (this.myLastWindow != null) {
            this.myLastWindow.apply(this.myApplyBaton, new ByteArrayInputStream(this.myDataStream.toByteArray()));
        }
        this.myLastWindow = null;
        this.myDataStream.reset();
        try {
            String string = this.myApplyBaton.close();
            return string;
        }
        finally {
            this.reset();
        }
    }
}

