/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io.diff;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaAlgorithm;
import org.tmatesoft.svn.core.internal.delta.SVNVDeltaAlgorithm;
import org.tmatesoft.svn.core.internal.delta.SVNXDeltaAlgorithm;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffInstruction;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVNDeltaGenerator {
    private SVNDeltaAlgorithm myXDelta = new SVNXDeltaAlgorithm();
    private SVNDeltaAlgorithm myVDelta = new SVNVDeltaAlgorithm();
    private byte[] mySourceBuffer;
    private byte[] myTargetBuffer;

    public SVNDeltaGenerator() {
        this(102400);
    }

    public SVNDeltaGenerator(int maximumDiffWindowSize) {
        this.mySourceBuffer = new byte[maximumDiffWindowSize];
        this.myTargetBuffer = new byte[maximumDiffWindowSize];
    }

    public String sendDelta(String path, InputStream target, ISVNEditor consumer, boolean computeChecksum) throws SVNException {
        return this.sendDelta(path, SVNFileUtil.DUMMY_IN, target, consumer, computeChecksum);
    }

    public String sendDelta(String path, InputStream source, InputStream target, ISVNEditor consumer, boolean computeChecksum) throws SVNException {
        MessageDigest digest = null;
        if (computeChecksum) {
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {0}", e.getLocalizedMessage());
                SVNErrorManager.error(err, e);
                return null;
            }
        }
        long sourceOffset = 0L;
        while (true) {
            int sourceLength;
            int targetLength;
            try {
                targetLength = target.read(this.myTargetBuffer, 0, this.myTargetBuffer.length);
            }
            catch (IOException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                SVNErrorManager.error(err, e);
                return null;
            }
            if (targetLength <= 0) {
                if (consumer == null) break;
                SVNDiffWindow window = new SVNDiffWindow(sourceOffset, 0L, 0L, new SVNDiffInstruction[0], 0L);
                OutputStream os = consumer.textDeltaChunk(path, window);
                SVNFileUtil.closeFile(os);
                break;
            }
            try {
                sourceLength = source.read(this.mySourceBuffer, 0, this.mySourceBuffer.length);
            }
            catch (IOException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                SVNErrorManager.error(err, e);
                return null;
            }
            if (sourceLength < 0) {
                sourceLength = 0;
            }
            if (digest != null) {
                digest.update(this.myTargetBuffer, 0, targetLength);
            }
            this.sendDelta(path, sourceOffset, this.mySourceBuffer, sourceLength, this.myTargetBuffer, targetLength, consumer);
            sourceOffset += (long)sourceLength;
        }
        if (consumer != null) {
            consumer.textDeltaEnd(path);
        }
        return SVNFileUtil.toHexDigest(digest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDelta(String path, long sourceOffset, byte[] source, int sourceLength, byte[] target, int targetLength, ISVNEditor consumer) throws SVNException {
        SVNDeltaAlgorithm algorithm = sourceLength == 0 ? this.myVDelta : this.myXDelta;
        algorithm.computeDelta(source, sourceLength, target, targetLength);
        if (consumer == null) {
            algorithm.reset();
            return;
        }
        SVNDiffInstruction[] instructions = algorithm.getDiffInstructions();
        ByteArrayOutputStream newData = algorithm.getNewDataStream();
        SVNDiffWindow window = new SVNDiffWindow(sourceOffset, (long)sourceLength, (long)targetLength, instructions, (long)newData.size());
        OutputStream newDataStream = consumer.textDeltaChunk(path, window);
        try {
            newData.writeTo(newDataStream);
        }
        catch (IOException e) {
            SVNDebugLog.logInfo(e);
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
        finally {
            SVNFileUtil.closeFile(newDataStream);
        }
        algorithm.reset();
    }
}

