/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNDirectory;
import org.tmatesoft.svn.core.internal.wc.SVNEntries;
import org.tmatesoft.svn.core.internal.wc.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNLog;
import org.tmatesoft.svn.core.internal.wc.SVNProperties;
import org.tmatesoft.svn.core.internal.wc.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVNUpdateEditor
implements ISVNEditor {
    private String mySwitchURL;
    private String myTarget;
    private String myTargetURL;
    private String myRootURL;
    private boolean myIsRecursive;
    private SVNWCAccess myWCAccess;
    private SVNDirectoryInfo myCurrentDirectory;
    private SVNFileInfo myCurrentFile;
    private long myTargetRevision;
    private boolean myIsRootOpen;
    private boolean myIsTargetDeleted;
    private boolean myIsLeaveConflicts;
    private SVNDeltaProcessor myDeltaProcessor;

    public SVNUpdateEditor(SVNWCAccess wcAccess, String switchURL, boolean recursive, boolean leaveConflicts) throws SVNException {
        this.myWCAccess = wcAccess;
        this.myIsRecursive = recursive;
        this.myTarget = wcAccess.getTargetName();
        this.mySwitchURL = switchURL;
        this.myTargetRevision = -1L;
        this.myIsLeaveConflicts = leaveConflicts;
        this.myDeltaProcessor = new SVNDeltaProcessor();
        SVNEntry entry = wcAccess.getAnchor().getEntries().getEntry("", true);
        this.myTargetURL = entry.getURL();
        this.myRootURL = entry.getRepositoryRoot();
        if (this.myTarget != null) {
            this.myTargetURL = SVNPathUtil.append(this.myTargetURL, SVNEncodingUtil.uriEncode(this.myTarget));
        }
        if (this.mySwitchURL != null && entry != null && entry.getRepositoryRoot() != null && !this.mySwitchURL.startsWith(entry.getRepositoryRoot() + "/") && !this.mySwitchURL.equals(entry.getRepositoryRoot())) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SWITCH, "''{0}''\nis not the same repository as\n''{1}''", new Object[]{this.mySwitchURL, entry.getRepositoryRoot()});
            SVNErrorManager.error(err);
        }
        wcAccess.getTarget().getEntries().close();
        if ("".equals(this.myTarget)) {
            this.myTarget = null;
        }
    }

    public void targetRevision(long revision) throws SVNException {
        this.myTargetRevision = revision;
    }

    public long getTargetRevision() {
        return this.myTargetRevision;
    }

    public void openRoot(long revision) throws SVNException {
        this.myIsRootOpen = true;
        this.myCurrentDirectory = this.createDirectoryInfo(null, "", false);
        if (this.myTarget == null) {
            SVNEntries entries = this.myCurrentDirectory.getDirectory().getEntries();
            SVNEntry entry = entries.getEntry("", true);
            entry.setRevision(this.myTargetRevision);
            entry.setURL(this.myCurrentDirectory.URL);
            entry.setIncomplete(true);
            if (this.mySwitchURL != null) {
                this.clearWCProperty(this.myCurrentDirectory.getDirectory());
            }
            entries.save(true);
        }
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        String name = SVNPathUtil.tail(path);
        SVNEntry entry = this.myCurrentDirectory.getDirectory().getEntries().getEntry(name, true);
        if (entry == null) {
            return;
        }
        SVNLog log = this.myCurrentDirectory.getLog(true);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("name", name);
        log.addCommand("delete-entry", attributes, false);
        SVNNodeKind kind = entry.getKind();
        boolean isDeleted = entry.isDeleted();
        if (path.equals(this.myTarget)) {
            attributes.put("name", name);
            attributes.put(SVNProperty.shortPropertyName("svn:entry:kind"), kind == SVNNodeKind.DIR ? "dir" : "file");
            attributes.put(SVNProperty.shortPropertyName("svn:entry:revision"), Long.toString(this.myTargetRevision));
            attributes.put(SVNProperty.shortPropertyName("svn:entry:deleted"), Boolean.TRUE.toString());
            log.addCommand("modify-entry", attributes, false);
            this.myIsTargetDeleted = true;
        }
        if (this.mySwitchURL != null && kind == SVNNodeKind.DIR) {
            this.myCurrentDirectory.getDirectory().destroy(name, true);
        }
        log.save();
        this.myCurrentDirectory.runLogs();
        if (isDeleted) {
            return;
        }
        this.myWCAccess.handleEvent(SVNEventFactory.createUpdateDeleteEvent(this.myWCAccess, this.myCurrentDirectory.getDirectory(), name));
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        SVNErrorMessage err;
        SVNDirectory parentDir = this.myCurrentDirectory.getDirectory();
        this.myCurrentDirectory = this.createDirectoryInfo(this.myCurrentDirectory, path, true);
        String name = SVNPathUtil.tail(path);
        File file = parentDir.getFile(name);
        if (file.exists()) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add directory ''{0}'': object of the same name already exists", path);
            SVNErrorManager.error(err);
        } else if (SVNFileUtil.getAdminDirectoryName().equals(name)) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add directory ''{0}'':  object of the same name as the administrative directory", path);
            SVNErrorManager.error(err);
        }
        SVNEntry entry = parentDir.getEntries().getEntry(name, true);
        if (entry != null) {
            if (entry.isScheduledForAddition()) {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add directory ''{0}'': object of the same name already exists", path);
                SVNErrorManager.error(err2);
            }
        } else {
            entry = parentDir.getEntries().addEntry(name);
        }
        entry.setKind(SVNNodeKind.DIR);
        entry.setAbsent(false);
        entry.setDeleted(false);
        parentDir.getEntries().save(true);
        SVNDirectory dir = parentDir.createChildDirectory(name, this.myCurrentDirectory.URL, null, this.myTargetRevision);
        if (dir == null) {
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Working copy ''{0}'' is missing or not locked", parentDir.getFile(name));
            SVNErrorManager.error(err3);
        } else {
            dir.getEntries().getEntry("", false).setIncomplete(true);
            dir.getEntries().save(true);
            dir.lock();
        }
        this.myWCAccess.handleEvent(SVNEventFactory.createUpdateAddEvent(this.myWCAccess, parentDir, SVNNodeKind.DIR, entry));
    }

    public void openDir(String path, long revision) throws SVNException {
        this.myCurrentDirectory = this.createDirectoryInfo(this.myCurrentDirectory, path, false);
        if (this.myCurrentDirectory.getDirectory() == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Working copy ''{0}'' is missing or not locked", path);
            SVNErrorManager.error(err);
        }
        SVNEntries entries = this.myCurrentDirectory.getDirectory().getEntries();
        SVNEntry entry = entries.getEntry("", true);
        entry.setRevision(this.myTargetRevision);
        entry.setURL(this.myCurrentDirectory.URL);
        entry.setIncomplete(true);
        if (this.mySwitchURL != null) {
            this.clearWCProperty(this.myCurrentDirectory.getDirectory());
        }
        entries.save(true);
    }

    public void absentDir(String path) throws SVNException {
        this.absentEntry(path, SVNNodeKind.DIR);
    }

    public void absentFile(String path) throws SVNException {
        this.absentEntry(path, SVNNodeKind.FILE);
    }

    private void absentEntry(String path, SVNNodeKind kind) throws SVNException {
        String name = SVNPathUtil.tail(path);
        SVNEntries entries = this.myCurrentDirectory.getDirectory().getEntries();
        SVNEntry entry = entries.getEntry(name, true);
        if (entry != null && entry.isScheduledForAddition()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to mark ''{0}'' absent: item of the same name is already scheduled for addition");
            SVNErrorManager.error(err);
        }
        if (entry == null) {
            entry = entries.addEntry(name);
        }
        if (entry != null) {
            entry.setKind(kind);
            entry.setDeleted(false);
            entry.setRevision(this.myTargetRevision);
            entry.setAbsent(true);
        }
        entries.save(true);
    }

    public void changeDirProperty(String name, String value) throws SVNException {
        this.myCurrentDirectory.propertyChanged(name, value);
    }

    private void clearWCProperty(SVNDirectory dir) throws SVNException {
        if (dir == null) {
            return;
        }
        SVNEntries entires = dir.getEntries();
        Iterator ents = entires.entries(false);
        while (ents.hasNext()) {
            SVNEntry entry = (SVNEntry)ents.next();
            if (entry.isFile() || "".equals(entry.getName())) {
                SVNProperties props = dir.getWCProperties(entry.getName());
                props.setPropertyValue("svn:wc:ra_dav:version-url", null);
                continue;
            }
            this.clearWCProperty(dir.getChildDirectory(entry.getName()));
        }
    }

    public void closeDir() throws SVNException {
        Map modifiedWCProps = this.myCurrentDirectory.getChangedWCProperties();
        Map modifiedEntryProps = this.myCurrentDirectory.getChangedEntryProperties();
        Map modifiedProps = this.myCurrentDirectory.getChangedProperties();
        SVNStatusType propStatus = SVNStatusType.UNCHANGED;
        SVNDirectory dir = this.myCurrentDirectory.getDirectory();
        if (modifiedWCProps != null || modifiedEntryProps != null || modifiedProps != null) {
            SVNLog log = this.myCurrentDirectory.getLog(true);
            if (modifiedProps != null && !modifiedProps.isEmpty()) {
                this.myWCAccess.addExternals(dir, (String)modifiedProps.get("svn:externals"));
                Map oldBaseProps = dir.getBaseProperties("", false).asMap();
                propStatus = dir.mergeProperties("", oldBaseProps, modifiedProps, true, log);
                if (this.myCurrentDirectory.IsAdded && !dir.hasPropModifications("")) {
                    HashMap<String, String> command = new HashMap<String, String>();
                    command.put("name", "");
                    command.put(SVNProperty.shortPropertyName("svn:entry:prop-time"), "working");
                    log.addCommand("modify-entry", command, false);
                }
            }
            log.logChangedEntryProperties("", modifiedEntryProps);
            log.logChangedWCProperties("", modifiedWCProps);
            log.save();
        }
        this.myCurrentDirectory.runLogs();
        this.completeDirectory(this.myCurrentDirectory);
        if (!this.myCurrentDirectory.IsAdded && propStatus != SVNStatusType.UNCHANGED) {
            this.myWCAccess.handleEvent(SVNEventFactory.createUpdateModifiedEvent(this.myWCAccess, dir, "", SVNNodeKind.DIR, SVNEventAction.UPDATE_UPDATE, null, SVNStatusType.UNCHANGED, propStatus, null));
        }
        this.myCurrentDirectory = this.myCurrentDirectory.Parent;
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        if (this.myTarget != null && !this.myWCAccess.getAnchor().getFile(this.myTarget).exists()) {
            this.myCurrentDirectory = this.createDirectoryInfo(null, "", false);
            this.deleteEntry(this.myTarget, this.myTargetRevision);
        }
        if (!this.myIsRootOpen) {
            this.completeDirectory(this.myCurrentDirectory);
        }
        if (!this.myIsTargetDeleted) {
            this.bumpDirectories();
        }
        return null;
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCurrentFile = this.createFileInfo(this.myCurrentDirectory, path, true);
    }

    public void openFile(String path, long revision) throws SVNException {
        this.myCurrentFile = this.createFileInfo(this.myCurrentDirectory, path, false);
    }

    public void changeFileProperty(String commitPath, String name, String value) throws SVNException {
        this.myCurrentFile.propertyChanged(name, value);
        if (this.myWCAccess.getOptions().isUseCommitTimes() && "svn:entry:committed-date".equals(name)) {
            this.myCurrentFile.CommitTime = value;
        }
    }

    public void applyTextDelta(String commitPath, String baseChecksum) throws SVNException {
        SVNDirectory dir = this.myCurrentFile.getDirectory();
        SVNEntries entries = dir.getEntries();
        SVNEntry entry = entries.getEntry(this.myCurrentFile.Name, true);
        File baseFile = dir.getBaseFile(this.myCurrentFile.Name, false);
        if (entry != null && entry.getChecksum() != null) {
            if (baseChecksum == null) {
                baseChecksum = entry.getChecksum();
            }
            String realChecksum = SVNFileUtil.computeChecksum(baseFile);
            if (!(baseChecksum == null || realChecksum != null && realChecksum.equals(baseChecksum))) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT_TEXT_BASE, "Checksum mismatch for ''{0}''; expected: ''{1}'', actual: ''{2}''", new Object[]{this.myCurrentFile.getPath(), baseChecksum, realChecksum});
                SVNErrorManager.error(err);
            }
        }
        File baseTmpFile = dir.getBaseFile(this.myCurrentFile.Name, true);
        this.myCurrentFile.TextUpdated = true;
        this.myDeltaProcessor.applyTextDelta(baseFile, baseTmpFile, true);
    }

    public OutputStream textDeltaChunk(String commitPath, SVNDiffWindow diffWindow) throws SVNException {
        return this.myDeltaProcessor.textDeltaChunk(diffWindow);
    }

    public void textDeltaEnd(String commitPath) throws SVNException {
        this.myCurrentFile.Checksum = this.myDeltaProcessor.textDeltaEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeFile(String commitPath, String textChecksum) throws SVNException {
        boolean isLocallyModified;
        String basePath;
        String tmpPath;
        File textTmpBase;
        SVNStatusType propStatus;
        boolean isLocalPropsModified;
        boolean magicPropsChanged;
        SVNStatusType lockStatus;
        SVNStatusType textStatus;
        HashMap<String, String> command;
        String commitTime;
        String name;
        Map modifiedWCProps;
        SVNLog log;
        SVNDirectory dir;
        String checksum;
        block23: {
            block22: {
                checksum = null;
                if (textChecksum != null && this.myCurrentFile.TextUpdated) {
                    File baseTmpFile = this.myCurrentFile.getDirectory().getBaseFile(this.myCurrentFile.Name, true);
                    String string = checksum = this.myCurrentFile.Checksum != null ? this.myCurrentFile.Checksum : SVNFileUtil.computeChecksum(baseTmpFile);
                    if (!textChecksum.equals(checksum)) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}''; expected: ''{1}'', actual: ''{2}''", new Object[]{this.myCurrentFile.getPath(), textChecksum, checksum});
                        SVNErrorManager.error(err);
                    }
                    checksum = textChecksum;
                }
                dir = this.myCurrentFile.getDirectory();
                log = this.myCurrentDirectory.getLog(true);
                modifiedWCProps = this.myCurrentFile.getChangedWCProperties();
                Map modifiedEntryProps = this.myCurrentFile.getChangedEntryProperties();
                Map modifiedProps = this.myCurrentFile.getChangedProperties();
                name = this.myCurrentFile.Name;
                commitTime = this.myCurrentFile.CommitTime;
                command = new HashMap<String, String>();
                textStatus = SVNStatusType.UNCHANGED;
                lockStatus = SVNStatusType.LOCK_UNCHANGED;
                magicPropsChanged = false;
                if (modifiedProps != null && !modifiedProps.isEmpty()) {
                    magicPropsChanged = modifiedProps.containsKey("svn:executable") || modifiedProps.containsKey("svn:needs-lock") || modifiedProps.containsKey("svn:keywords") || modifiedProps.containsKey("svn:eol-style") || modifiedProps.containsKey("svn:special");
                }
                Map oldBaseProps = dir.getBaseProperties(name, false).asMap();
                isLocalPropsModified = !this.myCurrentFile.IsAdded && dir.hasPropModifications(name);
                propStatus = dir.mergeProperties(name, oldBaseProps, modifiedProps, true, log);
                if (modifiedEntryProps != null) {
                    lockStatus = log.logChangedEntryProperties(name, modifiedEntryProps);
                }
                textTmpBase = dir.getBaseFile(name, true);
                String adminDir = SVNFileUtil.getAdminDirectoryName();
                tmpPath = adminDir + "/tmp/text-base/" + name + ".svn-base";
                basePath = adminDir + "/text-base/" + name + ".svn-base";
                File workingFile = dir.getFile(name);
                if (!this.myCurrentFile.TextUpdated && magicPropsChanged && workingFile.exists()) {
                    command.put("name", name);
                    command.put("dest", tmpPath);
                    log.addCommand("cp-and-detranslate", command, false);
                    command.clear();
                    command.put("name", tmpPath);
                    command.put("dest", name);
                    log.addCommand("cp-and-translate", command, false);
                    command.clear();
                }
                command.put("name", name);
                command.put(SVNProperty.shortPropertyName("svn:entry:kind"), "file");
                command.put(SVNProperty.shortPropertyName("svn:entry:revision"), Long.toString(this.myTargetRevision));
                command.put(SVNProperty.shortPropertyName("svn:entry:deleted"), Boolean.FALSE.toString());
                command.put(SVNProperty.shortPropertyName("svn:entry:absent"), Boolean.FALSE.toString());
                log.addCommand("modify-entry", command, false);
                command.clear();
                command.put("name", name);
                command.put(SVNProperty.shortPropertyName("svn:entry:url"), this.myCurrentFile.URL);
                log.addCommand("modify-entry", command, false);
                command.clear();
                boolean bl = isLocallyModified = !this.myCurrentFile.IsAdded && dir.hasTextModifications(name, false);
                if (!this.myCurrentFile.TextUpdated || !textTmpBase.exists()) break block22;
                textStatus = SVNStatusType.CHANGED;
                if (!isLocallyModified || !workingFile.exists()) {
                    command.put("name", tmpPath);
                    command.put("dest", name);
                    log.addCommand("cp-and-translate", command, false);
                    command.clear();
                    break block23;
                } else {
                    block21: {
                        String oldEolStyle = null;
                        String oldKeywords = null;
                        SVNProperties props = dir.getProperties(this.myCurrentFile.Name, false);
                        try {
                            if (magicPropsChanged && (modifiedProps.containsKey("svn:eol-style") || modifiedProps.containsKey("svn:keywords"))) {
                                oldKeywords = props.getPropertyValue("svn:keywords");
                                oldEolStyle = props.getPropertyValue("svn:eol-style");
                                props.setPropertyValue("svn:eol-style", (String)modifiedProps.get("svn:eol-style"));
                                props.setPropertyValue("svn:keywords", (String)modifiedProps.get("svn:keywords"));
                            }
                            textStatus = dir.mergeText(name, basePath, tmpPath, "", "", "", this.myIsLeaveConflicts, true);
                            Object var28_27 = null;
                            if (!magicPropsChanged || !modifiedProps.containsKey("svn:eol-style") && !modifiedProps.containsKey("svn:keywords")) break block21;
                        }
                        catch (Throwable throwable) {
                            Object var28_28 = null;
                            if (magicPropsChanged && (modifiedProps.containsKey("svn:eol-style") || modifiedProps.containsKey("svn:keywords"))) {
                                props.setPropertyValue("svn:eol-style", oldEolStyle);
                                props.setPropertyValue("svn:keywords", oldKeywords);
                            }
                            throw throwable;
                        }
                        props.setPropertyValue("svn:eol-style", oldEolStyle);
                        props.setPropertyValue("svn:keywords", oldKeywords);
                    }
                    if (textStatus == SVNStatusType.UNCHANGED) {
                        textStatus = SVNStatusType.MERGED;
                    }
                    SVNEntries entries = dir.getEntries();
                    SVNEntry entry = entries.getEntry(name, true);
                    String oldRevisionStr = ".r" + entry.getRevision();
                    String newRevisionStr = ".r" + this.myTargetRevision;
                    entries.close();
                    command.put("name", name);
                    command.put("arg1", basePath);
                    command.put("arg2", tmpPath);
                    command.put("arg3", oldRevisionStr);
                    command.put("arg4", newRevisionStr);
                    command.put("arg5", ".mine");
                    if (textStatus == SVNStatusType.CONFLICTED_UNRESOLVED) {
                        command.put("arg6", Boolean.TRUE.toString());
                    }
                    log.addCommand("merge", command, false);
                    command.clear();
                }
                break block23;
            }
            if (lockStatus == SVNStatusType.LOCK_UNLOCKED) {
                command.put("name", name);
                log.addCommand("maybe-readonly", command, false);
                command.clear();
            }
        }
        if (!isLocalPropsModified) {
            command.put("name", name);
            command.put(SVNProperty.shortPropertyName("svn:entry:prop-time"), "working");
            log.addCommand("modify-entry", command, false);
            command.clear();
        }
        if (this.myCurrentFile.TextUpdated && textTmpBase.exists()) {
            command.put("name", tmpPath);
            command.put("dest", basePath);
            log.addCommand("mv", command, false);
            command.clear();
            command.put("name", basePath);
            log.addCommand("readonly", command, false);
            command.clear();
            command.put("name", name);
            command.put(SVNProperty.shortPropertyName("svn:entry:checksum"), checksum);
            log.addCommand("modify-entry", command, false);
            command.clear();
        }
        if (modifiedWCProps != null) {
            log.logChangedWCProperties(name, modifiedWCProps);
        }
        if (!isLocallyModified) {
            if (commitTime != null) {
                command.put("name", name);
                command.put("timestamp", commitTime);
                log.addCommand("set-timestamp", command, false);
                command.clear();
            }
            if (this.myCurrentFile.TextUpdated && textTmpBase.exists() || magicPropsChanged) {
                command.put("name", name);
                command.put(SVNProperty.shortPropertyName("svn:entry:text-time"), "working");
                log.addCommand("modify-entry", command, false);
                command.clear();
            }
        }
        log.save();
        this.myCurrentFile.TextUpdated = false;
        this.completeDirectory(this.myCurrentDirectory);
        if (!this.myCurrentFile.IsAdded && textStatus == SVNStatusType.UNCHANGED && propStatus == SVNStatusType.UNCHANGED && lockStatus == SVNStatusType.LOCK_UNCHANGED) {
            this.myCurrentFile = null;
            return;
        }
        SVNEventAction action = this.myCurrentFile.IsAdded ? SVNEventAction.UPDATE_ADD : SVNEventAction.UPDATE_UPDATE;
        this.myWCAccess.handleEvent(SVNEventFactory.createUpdateModifiedEvent(this.myWCAccess, dir, this.myCurrentFile.Name, SVNNodeKind.FILE, action, null, textStatus, propStatus, lockStatus));
        this.myCurrentFile = null;
    }

    public void abortEdit() throws SVNException {
    }

    private void bumpDirectories() throws SVNException {
        SVNDirectory dir = this.myWCAccess.getAnchor();
        if (this.myTarget != null) {
            if (dir.getChildDirectory(this.myTarget) == null) {
                SVNEntry entry = dir.getEntries().getEntry(this.myTarget, true);
                boolean save = SVNUpdateEditor.bumpEntry(dir.getEntries(), entry, this.mySwitchURL, this.myRootURL, this.myTargetRevision, false);
                if (save) {
                    dir.getEntries().save(true);
                } else {
                    dir.getEntries().close();
                }
                return;
            }
            dir = dir.getChildDirectory(this.myTarget);
        }
        this.bumpDirectory(dir, this.mySwitchURL, this.myRootURL);
    }

    private void bumpDirectory(SVNDirectory dir, String url, String rootURL) throws SVNException {
        String childURL;
        SVNEntries entries = dir.getEntries();
        boolean save = SVNUpdateEditor.bumpEntry(entries, entries.getEntry("", true), url, rootURL, this.myTargetRevision, false);
        HashMap<SVNDirectory, String> childDirectories = new HashMap<SVNDirectory, String>();
        Iterator ents = entries.entries(true);
        while (ents.hasNext()) {
            SVNEntry entry = (SVNEntry)ents.next();
            if ("".equals(entry.getName())) continue;
            String string = childURL = url != null ? SVNPathUtil.append(url, SVNEncodingUtil.uriEncode(entry.getName())) : null;
            if (entry.getKind() == SVNNodeKind.FILE) {
                save |= SVNUpdateEditor.bumpEntry(entries, entry, childURL, rootURL, this.myTargetRevision, true);
                continue;
            }
            if (!this.myIsRecursive || entry.getKind() != SVNNodeKind.DIR) continue;
            SVNDirectory childDirectory = dir.getChildDirectory(entry.getName());
            if (!(entry.isScheduledForAddition() || childDirectory != null && childDirectory.isVersioned())) {
                this.myWCAccess.handleEvent(SVNEventFactory.createUpdateDeleteEvent(this.myWCAccess, dir, entry));
                entries.deleteEntry(entry.getName());
                save = true;
                continue;
            }
            childDirectories.put(childDirectory, childURL);
        }
        if (save) {
            entries.save(true);
        }
        Iterator children = childDirectories.keySet().iterator();
        while (children.hasNext()) {
            SVNDirectory child = (SVNDirectory)children.next();
            childURL = (String)childDirectories.get(child);
            if (child != null) {
                this.bumpDirectory(child, childURL, rootURL);
                continue;
            }
            SVNDebugLog.logInfo("svn: Directory object is null in bump directories method");
        }
    }

    private static boolean bumpEntry(SVNEntries entries, SVNEntry entry, String url, String rootURL, long revision, boolean delete) {
        if (entry == null) {
            return false;
        }
        boolean save = false;
        if (url != null) {
            save = entry.setURL(url);
        }
        save |= entry.setRepositoryRoot(rootURL);
        if (revision >= 0L && !entry.isScheduledForAddition() && !entry.isScheduledForReplacement()) {
            save |= entry.setRevision(revision);
        }
        if (delete && (entry.isDeleted() || entry.isAbsent() && entry.getRevision() != revision)) {
            entries.deleteEntry(entry.getName());
            save = true;
        }
        return save;
    }

    private void completeDirectory(SVNDirectoryInfo info) throws SVNException {
        while (info != null) {
            --info.RefCount;
            if (info.RefCount > 0) {
                return;
            }
            if (info.Parent == null && this.myTarget != null) {
                return;
            }
            SVNEntries entries = info.getDirectory().getEntries();
            if (entries.getEntry("", true) == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "No root entry found in ''{0}''", info.getDirectory().getPath());
                SVNErrorManager.error(err);
            }
            Iterator ents = entries.entries(true);
            while (ents.hasNext()) {
                SVNEntry entry = (SVNEntry)ents.next();
                if ("".equals(entry.getName())) {
                    entry.setIncomplete(false);
                    continue;
                }
                if (entry.isDeleted()) {
                    if (!entry.isScheduledForAddition()) {
                        entries.deleteEntry(entry.getName());
                        continue;
                    }
                    entry.setDeleted(false);
                    continue;
                }
                if (entry.isAbsent() && entry.getRevision() != this.myTargetRevision) {
                    entries.deleteEntry(entry.getName());
                    continue;
                }
                if (entry.getKind() != SVNNodeKind.DIR) continue;
                SVNDirectory childDirectory = info.getDirectory().getChildDirectory(entry.getName());
                if (!this.myIsRecursive || childDirectory != null && childDirectory.isVersioned() || entry.isAbsent() || entry.isScheduledForAddition()) continue;
                this.myWCAccess.handleEvent(SVNEventFactory.createUpdateDeleteEvent(this.myWCAccess, info.getDirectory(), entry));
                entries.deleteEntry(entry.getName());
            }
            entries.save(true);
            info = info.Parent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNFileInfo createFileInfo(SVNDirectoryInfo parent, String path, boolean added) throws SVNException {
        SVNFileInfo info = new SVNFileInfo(parent, path);
        info.IsAdded = added;
        info.Name = SVNPathUtil.tail(path);
        SVNDirectory dir = parent.getDirectory();
        if (added && dir.getFile(info.Name).exists()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add file ''{0}'': object of the same name already exists", path);
            SVNErrorManager.error(err);
        }
        SVNEntries entries = null;
        try {
            SVNErrorMessage err;
            entries = dir.getEntries();
            SVNEntry entry = entries.getEntry(info.Name, true);
            if (added && entry != null && entry.isScheduledForAddition()) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add file ''{0}'': object of the same name already exists and scheduled for addition", path);
                SVNErrorManager.error(err);
            }
            if (!added && entry == null) {
                err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "File ''{0}'' in directory ''{1}'' is not a versioned resource", new Object[]{info.Name, dir.getRoot()});
                SVNErrorManager.error(err);
            }
            info.URL = this.mySwitchURL != null || entry == null ? SVNPathUtil.append(parent.URL, SVNEncodingUtil.uriEncode(info.Name)) : entry.getURL();
        }
        finally {
            if (entries != null) {
                entries.close();
            }
        }
        ++parent.RefCount;
        return info;
    }

    private SVNDirectoryInfo createDirectoryInfo(SVNDirectoryInfo parent, String path, boolean added) throws SVNException {
        String name;
        SVNDirectoryInfo info = new SVNDirectoryInfo(path);
        info.Parent = parent;
        info.IsAdded = added;
        String string = name = path != null ? SVNPathUtil.tail(path) : "";
        if (this.mySwitchURL == null) {
            SVNDirectory dir;
            SVNDirectory sVNDirectory = dir = added ? null : info.getDirectory();
            if (dir != null && dir.getEntries().getEntry("", true) != null) {
                info.URL = dir.getEntries().getEntry("", true).getURL();
            }
            if (info.URL == null && parent != null) {
                info.URL = SVNPathUtil.append(parent.URL, SVNEncodingUtil.uriEncode(name));
            } else if (info.URL == null && parent == null) {
                info.URL = this.myTargetURL;
            }
        } else {
            info.URL = parent == null ? (this.myTarget == null ? this.mySwitchURL : SVNPathUtil.removeTail(this.mySwitchURL)) : (this.myTarget != null && parent.Parent == null ? this.mySwitchURL : SVNPathUtil.append(parent.URL, SVNEncodingUtil.uriEncode(name)));
        }
        info.RefCount = 1;
        if (info.Parent != null) {
            ++info.Parent.RefCount;
        }
        return info;
    }

    private class SVNDirectoryInfo
    extends SVNEntryInfo {
        public int RefCount;
        private int myLogCount;

        public SVNDirectoryInfo(String path) {
            super(path);
        }

        public SVNDirectory getDirectory() {
            return SVNUpdateEditor.this.myWCAccess.getDirectory(this.getPath());
        }

        public SVNLog getLog(boolean increment) {
            SVNLog log = this.getDirectory().getLog(this.myLogCount);
            if (increment) {
                ++this.myLogCount;
            }
            return log;
        }

        public void runLogs() throws SVNException {
            this.getDirectory().runLogs();
            this.myLogCount = 0;
        }
    }

    private class SVNFileInfo
    extends SVNEntryInfo {
        public String Name;
        public String CommitTime;
        public boolean TextUpdated;
        public String Checksum;

        public SVNFileInfo(SVNDirectoryInfo parent, String path) {
            super(path);
            this.Parent = parent;
        }

        public SVNDirectory getDirectory() {
            return this.Parent.getDirectory();
        }
    }

    private class SVNEntryInfo {
        public String URL;
        public boolean IsAdded;
        public SVNDirectoryInfo Parent;
        private String myPath;
        private Map myChangedProperties;
        private Map myChangedEntryProperties;
        private Map myChangedWCProperties;

        protected SVNEntryInfo(String path) {
            this.myPath = path;
        }

        protected String getPath() {
            return this.myPath;
        }

        public void propertyChanged(String name, String value) {
            if (name.startsWith("svn:entry:")) {
                this.myChangedEntryProperties = this.myChangedEntryProperties == null ? new HashMap() : this.myChangedEntryProperties;
                this.myChangedEntryProperties.put(name.substring("svn:entry:".length()), value);
            } else if (name.startsWith("svn:wc:")) {
                this.myChangedWCProperties = this.myChangedWCProperties == null ? new HashMap() : this.myChangedWCProperties;
                this.myChangedWCProperties.put(name, value);
            } else {
                this.myChangedProperties = this.myChangedProperties == null ? new HashMap() : this.myChangedProperties;
                this.myChangedProperties.put(name, value);
            }
        }

        public Map getChangedWCProperties() {
            return this.myChangedWCProperties;
        }

        public Map getChangedEntryProperties() {
            return this.myChangedEntryProperties;
        }

        public Map getChangedProperties() {
            return this.myChangedProperties;
        }
    }
}

