/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.SVNDirectory;
import org.tmatesoft.svn.core.internal.wc.SVNEntries;
import org.tmatesoft.svn.core.internal.wc.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.SVNExternalInfo;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNProperties;
import org.tmatesoft.svn.core.internal.wc.SVNStatusReporter;
import org.tmatesoft.svn.core.internal.wc.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNStatusEditor
implements ISVNEditor {
    private ISVNOptions myOptions;
    private SVNWCAccess myWCAccess;
    private String myTarget;
    private ISVNStatusHandler myHandler;
    private boolean myIsReportAll;
    private boolean myIsIncludeIgnored;
    private boolean myIsRecursive;
    private long myTargetRevision;
    private boolean myIsRootOpened;
    private Map myExternalsMap;
    private SVNStatusReporter myStatusReporter;
    private DirectoryInfo myCurrentDirectory;
    private FileInfo myCurrentFile;
    private SVNStatus myAnchorStatus;
    private boolean myTargetIsProcessed;

    public SVNStatusEditor(ISVNOptions globalOptions, SVNWCAccess wcAccess, ISVNStatusHandler handler, Map externals, boolean includeIgnored, boolean reportAll, boolean recursive) {
        this.myWCAccess = wcAccess;
        this.myHandler = handler;
        this.myOptions = globalOptions;
        this.myIsIncludeIgnored = includeIgnored;
        this.myIsReportAll = reportAll;
        this.myIsRecursive = recursive;
        this.myExternalsMap = externals;
        this.myTarget = "".equals(this.myWCAccess.getTargetName()) ? null : this.myWCAccess.getTargetName();
        this.myTargetRevision = -1L;
    }

    public void setStatusReporter(SVNStatusReporter reporter) throws SVNException {
        this.myStatusReporter = reporter;
        if (this.myStatusReporter != null) {
            SVNEntry anchorEntry = this.myWCAccess.getAnchor().getEntries().getEntry("", false);
            boolean oldReportAll = this.myIsReportAll;
            this.myIsReportAll = true;
            this.myAnchorStatus = this.createStatus(anchorEntry.getSVNURL(), this.myWCAccess.getAnchor().getRoot(), this.myWCAccess.getAnchor(), null, anchorEntry, false, SVNFileType.DIRECTORY, anchorEntry.asMap());
            this.myIsReportAll = oldReportAll;
        }
    }

    public Map getCollectedExternals() {
        return this.myExternalsMap;
    }

    public long getTargetRevision() {
        return this.myTargetRevision;
    }

    public void targetRevision(long revision) throws SVNException {
        this.myTargetRevision = revision;
    }

    public void openRoot(long revision) throws SVNException {
        this.myIsRootOpened = true;
        this.myCurrentDirectory = new DirectoryInfo(null, "", false);
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        SVNNodeKind kind;
        String name;
        String originalName = name = SVNPathUtil.tail(path);
        File ioFile = new File(this.myWCAccess.getAnchor().getRoot(), path);
        SVNFileType type = SVNFileType.getType(ioFile);
        String dirPath = path;
        if (type != SVNFileType.DIRECTORY) {
            dirPath = SVNPathUtil.removeTail(path);
            kind = SVNNodeKind.FILE;
        } else {
            name = "";
            kind = SVNNodeKind.DIR;
        }
        SVNDirectory dir = this.myWCAccess.getDirectory(dirPath);
        if (dir == null) {
            return;
        }
        if (dir.getEntries().getEntry(name, false) != null) {
            this.myCurrentDirectory.tweakStatus(path, kind, originalName, SVNStatusType.STATUS_DELETED, SVNStatusType.STATUS_NONE, null, SVNRevision.UNDEFINED, null, null);
        }
        if (this.myTarget == null && this.myCurrentDirectory.Parent != null) {
            this.myCurrentDirectory.Parent.tweakStatus(this.myCurrentDirectory.Path, SVNNodeKind.DIR, this.myCurrentDirectory.Name, SVNStatusType.STATUS_MODIFIED, SVNStatusType.STATUS_NONE, null, SVNRevision.UNDEFINED, null, null);
        }
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCurrentDirectory = new DirectoryInfo(this.myCurrentDirectory, path, true);
        this.myCurrentDirectory.Parent.IsContentsChanged = true;
    }

    public void openDir(String path, long revision) throws SVNException {
        this.myCurrentDirectory = new DirectoryInfo(this.myCurrentDirectory, path, false);
    }

    public void changeDirProperty(String name, String value) throws SVNException {
        if (name != null && !name.startsWith("svn:entry:") && !name.startsWith("svn:wc:")) {
            this.myCurrentDirectory.IsPropertiesChanged = true;
        }
        if ("svn:entry:committed-rev".equals(name) && value != null) {
            this.myCurrentDirectory.RemoteRevision = SVNRevision.parse(value);
        } else if ("svn:entry:committed-date".equals(name) && value != null) {
            this.myCurrentDirectory.RemoteDate = SVNTimeUtil.parseDate(value);
        } else if ("svn:entry:last-author".equals(name)) {
            this.myCurrentDirectory.RemoteAuthor = value;
        }
    }

    public void closeDir() throws SVNException {
        if (this.myCurrentDirectory.IsAdded || this.myCurrentDirectory.IsContentsChanged || this.myCurrentDirectory.IsPropertiesChanged) {
            SVNStatusType reposPropStatus;
            SVNStatusType reposContentsStatus;
            if (this.myCurrentDirectory.IsAdded) {
                reposContentsStatus = SVNStatusType.STATUS_ADDED;
                reposPropStatus = this.myCurrentDirectory.IsPropertiesChanged ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NONE;
            } else {
                reposContentsStatus = this.myCurrentDirectory.IsContentsChanged ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NONE;
                SVNStatusType sVNStatusType = reposPropStatus = this.myCurrentDirectory.IsPropertiesChanged ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NONE;
            }
            if (this.myCurrentDirectory.Parent != null) {
                this.myCurrentDirectory.Parent.tweakStatus(this.myCurrentDirectory.Path, SVNNodeKind.DIR, this.myCurrentDirectory.Name, reposContentsStatus, reposPropStatus, null, this.myCurrentDirectory.RemoteRevision, this.myCurrentDirectory.RemoteDate, this.myCurrentDirectory.RemoteAuthor);
            } else if (this.myAnchorStatus != null && this.myTarget == null) {
                this.myAnchorStatus.setRemoteStatus(this.myCurrentDirectory.getURL(), reposContentsStatus, reposPropStatus, null, SVNNodeKind.DIR, this.myCurrentDirectory.RemoteRevision, this.myCurrentDirectory.RemoteDate, this.myCurrentDirectory.RemoteAuthor);
            }
        }
        if (this.myCurrentDirectory.Parent != null && this.myIsRecursive) {
            boolean deleted = false;
            SVNStatus dirStatus = (SVNStatus)this.myCurrentDirectory.Parent.ChildrenStatuses.get(this.myCurrentDirectory.Name);
            if (dirStatus != null && (dirStatus.getRemoteContentsStatus() == SVNStatusType.STATUS_DELETED || dirStatus.getRemoteContentsStatus() == SVNStatusType.STATUS_REPLACED)) {
                deleted = true;
            }
            this.handleDirStatuses(this.myCurrentDirectory, deleted);
            if (dirStatus != null && this.isSendableStatus(dirStatus)) {
                this.myHandler.handleStatus(dirStatus);
            }
            this.myCurrentDirectory.Parent.ChildrenStatuses.remove(this.myCurrentDirectory.Name);
        } else if (this.myCurrentDirectory.Parent == null) {
            if (this.myTarget != null) {
                SVNStatus targetStatus = (SVNStatus)this.myCurrentDirectory.ChildrenStatuses.get(this.myTarget);
                if (targetStatus != null) {
                    if (!this.myTargetIsProcessed) {
                        this.myTargetIsProcessed = true;
                        if (targetStatus.getURL() != null && targetStatus.getKind() == SVNNodeKind.DIR) {
                            this.reportStatus(this.myWCAccess.getTarget(), null, true, this.myIsRecursive);
                        }
                    }
                    if (this.isSendableStatus(targetStatus)) {
                        this.myHandler.handleStatus(targetStatus);
                    }
                }
            } else {
                this.handleDirStatuses(this.myCurrentDirectory, false);
                if (this.myAnchorStatus != null && this.isSendableStatus(this.myAnchorStatus)) {
                    this.myHandler.handleStatus(this.myAnchorStatus);
                }
                this.myAnchorStatus = null;
            }
        } else if (this.myTarget != null) {
            this.myTargetIsProcessed = true;
            this.handleDirStatuses(this.myCurrentDirectory, false);
        }
        this.myCurrentDirectory = this.myCurrentDirectory.Parent;
    }

    private void handleDirStatuses(DirectoryInfo dirInfo, boolean dirIsDeleted) throws SVNException {
        final ISVNStatusHandler oldHalder = this.myHandler;
        if (dirIsDeleted) {
            this.myHandler = new ISVNStatusHandler(){

                public void handleStatus(SVNStatus status) throws SVNException {
                    if (oldHalder != null) {
                        if (status.getRemoteContentsStatus() != SVNStatusType.STATUS_ADDED) {
                            status.setRemoteStatus(SVNStatusType.STATUS_DELETED, null, null, null);
                        }
                        oldHalder.handleStatus(status);
                    }
                }
            };
        }
        SVNDirectory dir = this.myWCAccess.getDirectory(dirInfo.Path);
        File dirFile = new File(this.myWCAccess.getAnchor().getRoot(), dirInfo.Path);
        Iterator names = dirInfo.ChildrenStatuses.keySet().iterator();
        while (names.hasNext()) {
            String path;
            SVNDirectory childDir;
            String name = (String)names.next();
            SVNStatus status = (SVNStatus)dirInfo.ChildrenStatuses.get(name);
            File childFile = new File(dirFile, name);
            SVNFileType currentFileType = SVNFileType.getType(childFile);
            if (currentFileType == SVNFileType.NONE && dir != null && dir.getEntries().getEntry(name, false) != null) {
                SVNEntry currentEntry = dir.getEntries().getEntry(name, false);
                if (currentEntry != null && !currentEntry.isScheduledForDeletion()) {
                    status.setContentsStatus(SVNStatusType.STATUS_MISSING);
                }
            } else if (this.myIsRecursive && status.getURL() != null && status.getKind() == SVNNodeKind.DIR && (childDir = this.myWCAccess.getDirectory(path = "".equals(dirInfo.Path) ? name : SVNPathUtil.append(dirInfo.Path, name))) != null) {
                this.reportStatus(childDir, null, true, this.myIsRecursive);
            }
            if (!this.isSendableStatus(status)) continue;
            this.myHandler.handleStatus(status);
        }
        dirInfo.ChildrenStatuses.clear();
        this.myHandler = oldHalder;
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCurrentFile = new FileInfo(this.myCurrentDirectory, path, true);
        this.myCurrentFile.Parent.IsContentsChanged = true;
    }

    public void openFile(String path, long revision) throws SVNException {
        this.myCurrentFile = new FileInfo(this.myCurrentDirectory, path, false);
    }

    public void applyTextDelta(String commitPath, String baseChecksum) throws SVNException {
        this.myCurrentFile.IsContentsChanged = true;
    }

    public void changeFileProperty(String commitPath, String name, String value) throws SVNException {
        if (name != null && !name.startsWith("svn:entry:") && !name.startsWith("svn:wc:")) {
            this.myCurrentFile.IsPropertiesChanged = true;
        }
        if ("svn:entry:committed-rev".equals(name) && value != null) {
            this.myCurrentFile.RemoteRevision = SVNRevision.parse(value);
        } else if ("svn:entry:committed-date".equals(name) && value != null) {
            this.myCurrentFile.RemoteDate = SVNTimeUtil.parseDate(value);
        } else if ("svn:entry:last-author".equals(name)) {
            this.myCurrentFile.RemoteAuthor = value;
        }
    }

    public void closeFile(String commitPath, String textChecksum) throws SVNException {
        SVNStatusType reposPropStatus;
        SVNStatusType reposContentStatus;
        if (!(this.myCurrentFile.IsAdded || this.myCurrentFile.IsContentsChanged || this.myCurrentFile.IsPropertiesChanged)) {
            return;
        }
        SVNLock lock = null;
        if (this.myCurrentFile.IsAdded) {
            reposContentStatus = SVNStatusType.STATUS_ADDED;
            reposPropStatus = this.myCurrentFile.IsPropertiesChanged ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NONE;
            SVNURL dirURL = this.myCurrentDirectory.getURL();
            if (dirURL != null) {
                dirURL = dirURL.appendPath(this.myCurrentFile.Name, false);
                lock = this.getRepositoryLock(dirURL);
            }
        } else {
            reposContentStatus = this.myCurrentFile.IsContentsChanged ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NONE;
            reposPropStatus = this.myCurrentFile.IsPropertiesChanged ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NONE;
        }
        this.myCurrentDirectory.tweakStatus(this.myCurrentFile.Path, SVNNodeKind.FILE, this.myCurrentFile.Name, reposContentStatus, reposPropStatus, lock, this.myCurrentFile.RemoteRevision, this.myCurrentFile.RemoteDate, this.myCurrentFile.RemoteAuthor);
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        if (this.myIsRootOpened) {
            return new SVNCommitInfo(this.myTargetRevision, null, null);
        }
        if (this.myTarget != null) {
            File file = this.myWCAccess.getAnchor().getFile(this.myTarget);
            SVNEntries entries = this.myWCAccess.getAnchor().getEntries();
            SVNEntry entry = entries.getEntry(this.myTarget, false);
            SVNNodeKind kind = entry == null ? null : entry.getKind();
            entries.close();
            SVNFileType targetType = SVNFileType.getType(file);
            if (targetType == SVNFileType.DIRECTORY && (kind == null || kind == SVNNodeKind.DIR)) {
                if (entry != null) {
                    this.reportStatus(this.myWCAccess.getTarget(), null, false, this.myIsRecursive);
                } else {
                    this.myIsIncludeIgnored = true;
                    this.reportStatus(this.myWCAccess.getAnchor(), this.myTarget, false, this.myIsRecursive);
                }
            } else {
                this.myIsIncludeIgnored = true;
                this.reportStatus(this.myWCAccess.getAnchor(), this.myTarget, false, this.myIsRecursive);
            }
        } else {
            this.reportStatus(this.myWCAccess.getAnchor(), null, false, this.myIsRecursive);
        }
        return null;
    }

    public void abortEdit() throws SVNException {
    }

    public void absentDir(String path) throws SVNException {
    }

    public void absentFile(String path) throws SVNException {
    }

    public OutputStream textDeltaChunk(String commitPath, SVNDiffWindow diffWindow) throws SVNException {
        return null;
    }

    public void textDeltaEnd(String commitPath) throws SVNException {
    }

    public void reportStatus(SVNDirectory dir, String entryName, boolean ignoreRootEntry, boolean recursive) throws SVNException {
        int i;
        boolean anchorOfTarget;
        this.myWCAccess.checkCancelled();
        SVNEntries entries = dir.getEntries();
        boolean bl = anchorOfTarget = this.myTarget != null && dir == this.myWCAccess.getAnchor();
        if (!anchorOfTarget) {
            SVNExternalInfo[] externals = SVNWCAccess.parseExternals(dir.getPath(), dir.getProperties("", false).getPropertyValue("svn:externals"));
            for (i = 0; i < externals.length; ++i) {
                SVNExternalInfo external = externals[i];
                this.myExternalsMap.put(external.getPath(), external);
            }
        }
        if (entryName != null) {
            SVNEntry entry = entries.getEntry(entryName, false);
            if (entry != null) {
                this.sendVersionedStatus(dir, entryName);
            } else if (SVNFileType.getType(dir.getFile(entryName)) != SVNFileType.NONE) {
                this.sendUnversionedStatus(dir, entryName);
            }
            return;
        }
        Object[] ioFiles = dir.getRoot().listFiles();
        if (ioFiles != null) {
            Arrays.sort(ioFiles);
        }
        for (i = 0; ioFiles != null && i < ioFiles.length; ++i) {
            Object ioFile = ioFiles[i];
            String fileName = ((File)ioFile).getName();
            String adminDir = SVNFileUtil.getAdminDirectoryName();
            if (adminDir.equals(fileName) || entries.getEntry(fileName, false) != null) continue;
            this.sendUnversionedStatus(dir, fileName);
        }
        if (!ignoreRootEntry) {
            this.sendVersionedStatus(dir, "");
        }
        Iterator ents = entries.entries(false);
        while (ents.hasNext()) {
            SVNEntry childEntry = (SVNEntry)ents.next();
            if ("".equals(childEntry.getName())) continue;
            File file = dir.getFile(childEntry.getName());
            SVNFileType fType = SVNFileType.getType(file);
            if (fType == SVNFileType.DIRECTORY) {
                SVNDirectory childDir = dir.getChildDirectory(childEntry.getName());
                if (childDir != null && recursive) {
                    this.reportStatus(childDir, null, false, recursive);
                    continue;
                }
                this.sendVersionedStatus(dir, childEntry.getName());
                continue;
            }
            this.sendVersionedStatus(dir, childEntry.getName());
        }
    }

    private void sendVersionedStatus(SVNDirectory dir, String name) throws SVNException {
        SVNEntry parentEntry;
        File file;
        SVNDirectory parentDir = null;
        SVNEntry entry = dir.getEntries().getEntry(name, false);
        if (entry.isDirectory()) {
            if (!"".equals(name)) {
                SVNEntry fullEntry;
                File dirFile;
                parentDir = dir;
                if ((dir = dir.getChildDirectory(name)) == null && SVNFileType.getType(dirFile = parentDir.getFile(name)) == SVNFileType.DIRECTORY) {
                    dir = new SVNDirectory(this.myWCAccess, "".equals(parentDir.getPath()) ? name : SVNPathUtil.append(parentDir.getPath(), name), parentDir.getFile(name));
                }
                SVNEntry sVNEntry = fullEntry = dir != null ? dir.getEntries().getEntry("", false) : null;
                if (fullEntry != null) {
                    entry = fullEntry;
                }
                if (dir == null) {
                    dir = parentDir;
                }
            } else if (!"".equals(dir.getPath())) {
                String parentPath = SVNPathUtil.removeTail(dir.getPath());
                parentDir = this.myWCAccess.getDirectory(parentPath);
            } else {
                parentDir = null;
            }
        } else {
            parentDir = dir;
        }
        SVNEntry entryInParent = entry;
        if (dir == parentDir) {
            file = dir.getFile(name);
            entry = dir.getEntries().getEntry(name, false);
            parentEntry = dir.getEntries().getEntry("", false);
        } else {
            file = dir.getRoot();
            entry = dir.getEntries().getEntry("", false);
            if (entry == null) {
                entry = entryInParent;
                dir = parentDir;
            }
            parentEntry = parentDir != null ? parentDir.getEntries().getEntry("", true) : null;
        }
        SVNFileType fileType = SVNFileType.getType(file);
        SVNStatus status = this.createStatus(entry.getSVNURL(), file, dir, parentEntry, entry, false, fileType, Collections.unmodifiableMap(entry.asMap()));
        if (status != null) {
            this.myHandler.handleStatus(status);
        }
    }

    private void sendUnversionedStatus(SVNDirectory parent, String name) throws SVNException {
        boolean ignored = this.isIgnored(parent, name);
        String path = "".equals(name) ? parent.getPath() : SVNPathUtil.append(parent.getPath(), name);
        SVNURL url = null;
        if (parent.getEntries() != null && parent.getEntries().getEntry("", false) != null && (url = parent.getEntries().getEntry("", false).getSVNURL()) != null) {
            url = url.appendPath(name, false);
        }
        SVNStatus status = this.createStatus(url, parent.getFile(name), parent, null, null, ignored, null, null);
        if (this.myExternalsMap.containsKey(path)) {
            status.markExternal();
        }
        if (status != null && (this.myIsIncludeIgnored || !ignored || this.myExternalsMap.containsKey(path) || status.getRemoteLock() != null)) {
            this.myHandler.handleStatus(status);
        }
    }

    private SVNStatus createStatus(SVNURL url, File file, SVNDirectory entryDir, SVNEntry parentEntry, SVNEntry entry, boolean isIgnored, SVNFileType pathKind, Map allEntryProperties) throws SVNException {
        pathKind = pathKind == null || pathKind == SVNFileType.UNKNOWN ? SVNFileType.getType(file) : pathKind;
        SVNLock remoteLock = null;
        if (url != null && this.myAnchorStatus != null && this.myAnchorStatus.getURL() != null) {
            remoteLock = this.getRepositoryLock(url);
        }
        if (entry == null) {
            SVNStatusType textStatus = SVNStatusType.STATUS_NONE;
            if (pathKind != SVNFileType.NONE) {
                textStatus = isIgnored ? SVNStatusType.STATUS_IGNORED : SVNStatusType.STATUS_UNVERSIONED;
            }
            return new SVNStatus(null, file, null, null, null, null, null, textStatus, SVNStatusType.STATUS_NONE, SVNStatusType.STATUS_NONE, SVNStatusType.STATUS_NONE, false, false, false, null, null, null, null, null, null, remoteLock, null, null);
        }
        SVNStatusType textStatus = SVNStatusType.STATUS_NORMAL;
        SVNStatusType propStatus = SVNStatusType.STATUS_NONE;
        boolean isSwitched = false;
        boolean isLocked = false;
        boolean isDir = entry.isDirectory();
        if (isDir) {
            if (pathKind == SVNFileType.DIRECTORY) {
                if (!SVNWCAccess.isVersionedDirectory(file)) {
                    textStatus = SVNStatusType.STATUS_OBSTRUCTED;
                }
            } else if (!(pathKind == SVNFileType.NONE || this.myWCAccess.getAnchor().getRoot().equals(file) && entry.getKind() == SVNNodeKind.DIR && pathKind == SVNFileType.SYMLINK && file.isDirectory())) {
                textStatus = SVNStatusType.STATUS_OBSTRUCTED;
            }
        }
        if (parentEntry != null && entry.getURL() != null && parentEntry.getURL() != null) {
            String realName = entry.getName();
            if ("".equals(entry.getName())) {
                realName = file.getName();
            }
            if (!realName.equals(SVNEncodingUtil.uriDecode(SVNPathUtil.tail(entry.getURL())))) {
                isSwitched = true;
            }
            if (!isSwitched && !SVNPathUtil.removeTail(entry.getURL()).equals(parentEntry.getURL())) {
                isSwitched = true;
            }
        }
        if (textStatus != SVNStatusType.OBSTRUCTED) {
            SVNProperties props = entryDir.getProperties(entry.getName(), false);
            if (props != null && !props.isEmpty()) {
                propStatus = SVNStatusType.STATUS_NORMAL;
            }
            boolean propsModified = entryDir.hasPropModifications(entry.getName());
            boolean special = !SVNFileUtil.isWindows && !isDir && props.getPropertyValue("svn:special") != null;
            boolean textModified = false;
            if (!isDir && special == (pathKind == SVNFileType.SYMLINK)) {
                textModified = entryDir.hasTextModifications(entry.getName(), false);
            }
            if (propsModified) {
                propStatus = SVNStatusType.STATUS_MODIFIED;
            }
            if (textModified) {
                textStatus = SVNStatusType.STATUS_MODIFIED;
            }
            if (entry.getConflictNew() != null || entry.getConflictOld() != null || entry.getConflictWorking() != null) {
                textStatus = SVNStatusType.STATUS_CONFLICTED;
            }
            if (entry.getPropRejectFile() != null) {
                propStatus = SVNStatusType.STATUS_CONFLICTED;
            }
            if (entry.isScheduledForAddition()) {
                textStatus = SVNStatusType.STATUS_ADDED;
                propStatus = SVNStatusType.STATUS_NONE;
            } else if (entry.isScheduledForDeletion()) {
                textStatus = SVNStatusType.STATUS_DELETED;
                propStatus = SVNStatusType.STATUS_NONE;
            } else if (entry.isScheduledForReplacement()) {
                textStatus = SVNStatusType.STATUS_REPLACED;
                propStatus = SVNStatusType.STATUS_NONE;
            }
            if (entry.isIncomplete() && textStatus != SVNStatusType.STATUS_ADDED && textStatus != SVNStatusType.STATUS_DELETED) {
                textStatus = SVNStatusType.STATUS_INCOMPLETE;
            } else if (pathKind == SVNFileType.NONE) {
                if (textStatus != SVNStatusType.STATUS_DELETED) {
                    textStatus = SVNStatusType.STATUS_MISSING;
                }
            } else if (!SVNFileType.equals(pathKind, entry.getKind())) {
                if (!this.myWCAccess.getAnchor().getRoot().equals(file) || entry.getKind() != SVNNodeKind.DIR || pathKind != SVNFileType.SYMLINK || !file.isDirectory()) {
                    textStatus = SVNStatusType.STATUS_OBSTRUCTED;
                }
            } else if (special != (pathKind == SVNFileType.SYMLINK)) {
                textStatus = SVNStatusType.STATUS_OBSTRUCTED;
            }
            if (isDir && pathKind == SVNFileType.DIRECTORY) {
                isLocked = entryDir.getAdminFile("lock").exists();
            }
        }
        if (!(this.myIsReportAll || textStatus != SVNStatusType.STATUS_NONE && textStatus != SVNStatusType.STATUS_NORMAL || propStatus != SVNStatusType.STATUS_NONE && propStatus != SVNStatusType.STATUS_NORMAL || isLocked || isSwitched || entry.getLockToken() != null)) {
            return null;
        }
        SVNLock localLock = null;
        if (entry.getLockToken() != null) {
            localLock = new SVNLock(null, entry.getLockToken(), entry.getLockOwner(), entry.getLockComment(), SVNTimeUtil.parseDate(entry.getLockCreationDate()), null);
        }
        File conflictOld = null;
        File conflictNew = null;
        File conflictWrk = null;
        File propReject = null;
        if (entry.getConflictOld() != null) {
            conflictOld = entryDir.getFile(entry.getConflictOld());
        }
        if (entry.getConflictNew() != null) {
            conflictNew = entryDir.getFile(entry.getConflictNew());
        }
        if (entry.getConflictWorking() != null) {
            conflictWrk = entryDir.getFile(entry.getConflictWorking());
        }
        if (entry.getPropRejectFile() != null) {
            propReject = entryDir.getFile(entry.getPropRejectFile());
        }
        return new SVNStatus(entry.getSVNURL(), file, entry.getKind(), SVNRevision.create(entry.getRevision()), entry.getCommittedRevision() >= 0L ? SVNRevision.create(entry.getCommittedRevision()) : null, SVNTimeUtil.parseDate(entry.getCommittedDate()), entry.getAuthor(), textStatus, propStatus, SVNStatusType.STATUS_NONE, SVNStatusType.STATUS_NONE, isLocked, entry.isCopied(), isSwitched, conflictNew, conflictOld, conflictWrk, propReject, entry.getCopyFromURL(), SVNRevision.create(entry.getCopyFromRevision()), remoteLock, localLock, allEntryProperties);
    }

    private boolean isIgnored(SVNDirectory dir, String name) throws SVNException {
        if (this.myOptions.isIgnored(name)) {
            return true;
        }
        return dir != null && dir.isIgnored(name);
    }

    private SVNLock getRepositoryLock(SVNURL url) {
        if (this.myStatusReporter == null) {
            return null;
        }
        return this.myStatusReporter.getLock(url);
    }

    private boolean isSendableStatus(SVNStatus status) {
        if (status.getRemoteContentsStatus() != SVNStatusType.STATUS_NONE) {
            return true;
        }
        if (status.getRemotePropertiesStatus() != SVNStatusType.STATUS_NONE) {
            return true;
        }
        if (status.getRemoteLock() != null) {
            return true;
        }
        if (status.getContentsStatus() == SVNStatusType.STATUS_IGNORED && !this.myIsIncludeIgnored) {
            return false;
        }
        if (this.myIsReportAll) {
            return true;
        }
        if (status.getContentsStatus() == SVNStatusType.STATUS_UNVERSIONED) {
            return true;
        }
        if (status.getContentsStatus() != SVNStatusType.STATUS_NONE && status.getContentsStatus() != SVNStatusType.STATUS_NORMAL) {
            return true;
        }
        if (status.getPropertiesStatus() != SVNStatusType.STATUS_NONE && status.getPropertiesStatus() != SVNStatusType.STATUS_NORMAL) {
            return true;
        }
        return status.isLocked() || status.isSwitched() || status.getLocalLock() != null;
    }

    private static class FileInfo {
        public DirectoryInfo Parent;
        public String Path;
        public String Name;
        public boolean IsAdded;
        public boolean IsContentsChanged;
        public boolean IsPropertiesChanged;
        public SVNRevision RemoteRevision;
        public Date RemoteDate;
        public String RemoteAuthor;

        public FileInfo(DirectoryInfo parent, String path, boolean added) {
            this.Parent = parent;
            this.Path = path;
            this.Name = SVNPathUtil.tail(path);
            this.IsAdded = added;
            this.RemoteRevision = SVNRevision.UNDEFINED;
        }
    }

    private class DirectoryInfo {
        public String Path;
        public String Name;
        public DirectoryInfo Parent;
        public SVNRevision RemoteRevision;
        public Date RemoteDate;
        public String RemoteAuthor;
        public boolean IsAdded;
        public boolean IsPropertiesChanged;
        public boolean IsContentsChanged;
        public Map ChildrenStatuses;

        public DirectoryInfo(DirectoryInfo parent, String path, boolean added) throws SVNException {
            SVNStatusType pContent;
            this.Parent = parent;
            if (!"".equals(path)) {
                this.Path = path;
                this.Name = SVNPathUtil.tail(path);
            } else {
                this.Path = "";
                this.Name = null;
            }
            this.IsAdded = added;
            this.ChildrenStatuses = new HashMap();
            SVNStatus parentStatus = this.Parent != null ? (SVNStatus)this.Parent.ChildrenStatuses.get(this.Name) : SVNStatusEditor.this.myAnchorStatus;
            if (parentStatus != null && (pContent = parentStatus.getContentsStatus()) != SVNStatusType.STATUS_UNVERSIONED && pContent != SVNStatusType.STATUS_DELETED && pContent != SVNStatusType.STATUS_MISSING && pContent != SVNStatusType.OBSTRUCTED && pContent != SVNStatusType.STATUS_EXTERNAL && parentStatus.getKind() == SVNNodeKind.DIR && (SVNStatusEditor.this.myIsRecursive || this.Parent == null || !SVNStatusEditor.this.myIsRecursive && this.Parent.Parent == null)) {
                ISVNStatusHandler oldHandler = SVNStatusEditor.this.myHandler;
                boolean oldRecursive = SVNStatusEditor.this.myIsRecursive;
                boolean oldReportAll = SVNStatusEditor.this.myIsReportAll;
                boolean oldIncludeIgnored = SVNStatusEditor.this.myIsIncludeIgnored;
                SVNDirectory dir = SVNStatusEditor.this.myWCAccess.getDirectory(path);
                if (dir == null) {
                    return;
                }
                SVNStatusEditor.this.myIsRecursive = false;
                SVNStatusEditor.this.myIsReportAll = true;
                SVNStatusEditor.this.myIsIncludeIgnored = true;
                SVNStatusEditor.this.myHandler = new ISVNStatusHandler(this){
                    private final /* synthetic */ DirectoryInfo this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void handleStatus(SVNStatus status) {
                        this.this$1.ChildrenStatuses.put(status.getFile().getName(), status);
                    }
                };
                SVNStatusEditor.this.reportStatus(dir, null, true, false);
                SVNStatusEditor.this.myIsRecursive = oldRecursive;
                SVNStatusEditor.this.myIsIncludeIgnored = oldIncludeIgnored;
                SVNStatusEditor.this.myIsReportAll = oldReportAll;
                SVNStatusEditor.this.myHandler = oldHandler;
            }
            this.RemoteRevision = SVNRevision.UNDEFINED;
        }

        public SVNURL getURL() throws SVNException {
            if (this.Name == null && SVNStatusEditor.this.myAnchorStatus != null) {
                return SVNStatusEditor.this.myAnchorStatus.getURL();
            }
            if (this.Parent != null) {
                SVNStatus thisStatus = (SVNStatus)this.Parent.ChildrenStatuses.get(this.Name);
                if (thisStatus != null && thisStatus.getURL() != null) {
                    return thisStatus.getURL();
                }
                SVNURL url = this.Parent.getURL();
                if (url != null) {
                    return url.appendPath(this.Name, false);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tweakStatus(String path, SVNNodeKind kind, String name, SVNStatusType contents, SVNStatusType props, SVNLock lock, SVNRevision remoteRevision, Date remoteDate, String remoteAuthor) throws SVNException {
            SVNStatus existingStatus = (SVNStatus)this.ChildrenStatuses.get(name);
            if (existingStatus == null) {
                SVNURL url;
                if (contents != SVNStatusType.STATUS_ADDED) {
                    return;
                }
                String dirPath = path;
                String target = "";
                if (kind == SVNNodeKind.FILE) {
                    dirPath = SVNPathUtil.removeTail(dirPath);
                    target = SVNPathUtil.tail(path);
                }
                SVNDirectory dir = SVNStatusEditor.this.myWCAccess.getDirectory(dirPath);
                SVNEntry entry = null;
                SVNEntry parentEntry = null;
                if (dir != null && (entry = dir.getEntries().getEntry(target, false)) != null && !"".equals(dirPath)) {
                    if (!"".equals(target)) {
                        parentEntry = dir.getEntries().getEntry("", false);
                    } else {
                        SVNDirectory parentDir = SVNStatusEditor.this.myWCAccess.getDirectory(SVNPathUtil.removeTail(dirPath));
                        if (parentDir != null) {
                            parentEntry = parentDir.getEntries().getEntry("", false);
                        }
                    }
                }
                boolean oldReportAll = SVNStatusEditor.this.myIsReportAll;
                if (entry != null) {
                    url = entry.getSVNURL();
                } else {
                    url = this.getURL();
                    if (url != null) {
                        url = url.appendPath(name, false);
                    }
                }
                try {
                    SVNStatusEditor.this.myIsReportAll = true;
                    existingStatus = SVNStatusEditor.this.createStatus(url, new File(SVNStatusEditor.this.myWCAccess.getAnchor().getRoot(), path), dir, parentEntry, entry, false, SVNFileType.UNKNOWN, entry != null ? entry.asMap() : null);
                }
                finally {
                    SVNStatusEditor.this.myIsReportAll = oldReportAll;
                }
                existingStatus.setRemoteStatus(url, contents, props, lock, kind, remoteRevision, remoteDate, remoteAuthor);
                this.ChildrenStatuses.put(name, existingStatus);
            } else {
                SVNURL url = null;
                if (SVNStatusEditor.this.myAnchorStatus != null) {
                    url = SVNStatusEditor.this.myAnchorStatus.getURL().appendPath(path, false);
                }
                existingStatus.setRemoteStatus(url, contents, props, null, kind, remoteRevision, remoteDate, remoteAuthor);
            }
        }
    }
}

