/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNDirectory;
import org.tmatesoft.svn.core.internal.wc.SVNEntries;
import org.tmatesoft.svn.core.internal.wc.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNLog;
import org.tmatesoft.svn.core.internal.wc.SVNProperties;
import org.tmatesoft.svn.core.internal.wc.SVNWCAccess;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVNMerger {
    private boolean myIsDryRun;
    private SVNWCAccess myWCAccess;
    private boolean myIsForce;
    private String myAddedPath;
    private String myURL;
    private long myTargetRevision;
    private boolean myIsLeaveConflicts;

    public SVNMerger(SVNWCAccess wcAccess, String url, long rev, boolean force, boolean dryRun, boolean leaveConflicts) {
        this.myWCAccess = wcAccess;
        this.myIsDryRun = dryRun;
        this.myIsLeaveConflicts = leaveConflicts;
        this.myIsForce = force;
        this.myTargetRevision = rev;
        this.myURL = url;
    }

    public boolean isDryRun() {
        return this.myIsDryRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNStatusType directoryDeleted(final String path) throws SVNException {
        SVNDirectory parentDir = this.getParentDirectory(path);
        if (parentDir == null) {
            return SVNStatusType.MISSING;
        }
        String name = SVNPathUtil.tail(path);
        File targetFile = parentDir.getFile(name);
        SVNFileType targetFileType = SVNFileType.getType(targetFile);
        if (targetFileType == SVNFileType.DIRECTORY) {
            block14: {
                final ISVNEventHandler oldDispatcher = this.myWCAccess.getEventDispatcher();
                this.myWCAccess.setEventDispatcher(new ISVNEventHandler(){

                    public void handleEvent(SVNEvent event, double progress) throws SVNException {
                        String eventPath = event.getPath();
                        eventPath = eventPath.replace(File.separatorChar, '/');
                        if (event.getPath().equals(path)) {
                            return;
                        }
                        if (oldDispatcher != null) {
                            oldDispatcher.handleEvent(event, progress);
                        }
                    }

                    public void checkCancelled() throws SVNCancelException {
                        if (oldDispatcher != null) {
                            oldDispatcher.checkCancelled();
                        }
                    }
                });
                try {
                    if (!this.myIsForce) {
                        try {
                            parentDir.canScheduleForDeletion(name, false);
                        }
                        catch (SVNException e) {
                            if (e instanceof SVNCancelException) {
                                throw e;
                            }
                            SVNDebugLog.logInfo(e);
                            SVNStatusType sVNStatusType = SVNStatusType.OBSTRUCTED;
                            this.myWCAccess.setEventDispatcher(oldDispatcher);
                            return sVNStatusType;
                        }
                    }
                    if (this.myIsDryRun) break block14;
                    try {
                        parentDir.scheduleForDeletion(name, true);
                    }
                    catch (SVNException e) {
                        if (e instanceof SVNCancelException) {
                            throw e;
                        }
                        SVNStatusType sVNStatusType = SVNStatusType.OBSTRUCTED;
                        this.myWCAccess.setEventDispatcher(oldDispatcher);
                        return sVNStatusType;
                    }
                }
                finally {
                    this.myWCAccess.setEventDispatcher(oldDispatcher);
                }
            }
            return SVNStatusType.CHANGED;
        }
        if (targetFileType.isFile()) {
            return SVNStatusType.OBSTRUCTED;
        }
        return SVNStatusType.MISSING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNStatusType fileDeleted(String path) throws SVNException {
        SVNDirectory parentDir = this.getParentDirectory(path);
        if (parentDir == null) {
            return SVNStatusType.MISSING;
        }
        String name = SVNPathUtil.tail(path);
        File targetFile = parentDir.getFile(name);
        SVNFileType targetFileType = SVNFileType.getType(targetFile);
        if (targetFileType == SVNFileType.DIRECTORY) {
            return SVNStatusType.OBSTRUCTED;
        }
        if (targetFileType.isFile()) {
            block14: {
                final ISVNEventHandler oldDispatcher = this.myWCAccess.getEventDispatcher();
                try {
                    this.myWCAccess.setEventDispatcher(new ISVNEventHandler(){

                        public void handleEvent(SVNEvent event, double progress) throws SVNException {
                        }

                        public void checkCancelled() throws SVNCancelException {
                            if (oldDispatcher != null) {
                                oldDispatcher.checkCancelled();
                            }
                        }
                    });
                    if (!this.myIsForce) {
                        try {
                            parentDir.canScheduleForDeletion(name, false);
                        }
                        catch (SVNException e) {
                            if (e instanceof SVNCancelException) {
                                throw e;
                            }
                            SVNStatusType sVNStatusType = SVNStatusType.OBSTRUCTED;
                            this.myWCAccess.setEventDispatcher(oldDispatcher);
                            return sVNStatusType;
                        }
                    }
                    if (this.myIsDryRun) break block14;
                    try {
                        parentDir.scheduleForDeletion(name, true);
                    }
                    catch (SVNException e) {
                        if (e instanceof SVNCancelException) {
                            throw e;
                        }
                        SVNStatusType sVNStatusType = SVNStatusType.OBSTRUCTED;
                        this.myWCAccess.setEventDispatcher(oldDispatcher);
                        return sVNStatusType;
                    }
                }
                finally {
                    this.myWCAccess.setEventDispatcher(oldDispatcher);
                }
            }
            return SVNStatusType.CHANGED;
        }
        return SVNStatusType.MISSING;
    }

    public SVNStatusType directoryAdded(String path, Map entryProps) throws SVNException {
        SVNDirectory parentDir = this.getParentDirectory(path);
        if (parentDir == null) {
            if (this.myIsDryRun && this.myAddedPath != null && path.startsWith(this.myAddedPath)) {
                return SVNStatusType.CHANGED;
            }
            return SVNStatusType.MISSING;
        }
        String name = SVNPathUtil.tail(path);
        File file = parentDir.getFile(name);
        SVNFileType fileType = SVNFileType.getType(file);
        if (fileType == SVNFileType.NONE) {
            SVNEntry entry = parentDir.getEntries().getEntry(name, true);
            if (entry != null && !entry.isScheduledForDeletion()) {
                return SVNStatusType.OBSTRUCTED;
            }
            if (!this.myIsDryRun) {
                file.mkdirs();
                String url = SVNPathUtil.append(this.myURL, SVNEncodingUtil.uriEncode(this.getPathInURL(path)));
                this.addDirectory(parentDir, name, url, this.myTargetRevision, entryProps);
            } else {
                this.myAddedPath = path + "/";
            }
            return SVNStatusType.CHANGED;
        }
        if (fileType == SVNFileType.DIRECTORY) {
            SVNEntry entry = parentDir.getEntries().getEntry(name, true);
            if (entry == null || entry.isScheduledForDeletion()) {
                if (this.myIsDryRun) {
                    this.myAddedPath = path + "/";
                } else {
                    String url = SVNPathUtil.append(this.myURL, SVNEncodingUtil.uriEncode(this.getPathInURL(path)));
                    this.addDirectory(parentDir, name, url, this.myTargetRevision, entryProps);
                }
                return SVNStatusType.CHANGED;
            }
            return SVNStatusType.OBSTRUCTED;
        }
        if (fileType.isFile()) {
            if (this.myIsDryRun) {
                this.myAddedPath = null;
            }
            return SVNStatusType.OBSTRUCTED;
        }
        return SVNStatusType.MISSING;
    }

    public SVNStatusType[] fileChanged(String path, File older, File yours, long rev1, long rev2, String mimeType1, String mimeType2, Map baseProps, Map propDiff) throws SVNException {
        SVNStatusType[] result = new SVNStatusType[]{SVNStatusType.UNKNOWN, SVNStatusType.UNKNOWN};
        String parentPath = SVNPathUtil.removeTail(path);
        SVNDirectory parentDir = this.myWCAccess.getDirectory(parentPath);
        if (parentDir == null) {
            result[0] = SVNStatusType.MISSING;
            result[1] = SVNStatusType.MISSING;
            return result;
        }
        String name = SVNPathUtil.tail(path);
        File mine = parentDir.getFile(name);
        SVNEntry entry = parentDir.getEntries().getEntry(name, true);
        SVNFileType mineType = SVNFileType.getType(mine);
        if (!mineType.isFile() || entry == null || entry.isHidden()) {
            result[0] = SVNStatusType.MISSING;
            result[1] = SVNStatusType.MISSING;
            return result;
        }
        result[1] = propDiff != null && !propDiff.isEmpty() ? this.propertiesChanged(parentPath, name, baseProps, propDiff) : SVNStatusType.UNCHANGED;
        if (older != null) {
            boolean equals;
            boolean isTextModified = parentDir.hasTextModifications(name, false);
            SVNStatusType mergeResult = null;
            if (!isTextModified && (SVNProperty.isBinaryMimeType(mimeType1) || SVNProperty.isBinaryMimeType(mimeType2)) && (equals = SVNFileUtil.compareFiles(mine, older, null))) {
                if (!this.myIsDryRun) {
                    SVNFileUtil.rename(yours, mine);
                }
                mergeResult = SVNStatusType.MERGED;
            }
            if (mergeResult == null) {
                String minePath = name;
                String olderPath = SVNFileUtil.getBasePath(older);
                String yoursPath = SVNFileUtil.getBasePath(yours);
                String targetLabel = ".working";
                String leftLabel = ".merge-left.r" + rev1;
                String rightLabel = ".merge-right.r" + rev2;
                mergeResult = parentDir.mergeText(minePath, olderPath, yoursPath, targetLabel, leftLabel, rightLabel, this.myIsLeaveConflicts, this.myIsDryRun);
                parentDir.getEntries().save(true);
            }
            result[0] = mergeResult == SVNStatusType.CONFLICTED || mergeResult == SVNStatusType.CONFLICTED_UNRESOLVED ? mergeResult : (isTextModified ? SVNStatusType.MERGED : (mergeResult == SVNStatusType.MERGED ? SVNStatusType.CHANGED : SVNStatusType.UNCHANGED));
        }
        return result;
    }

    public SVNStatusType[] fileAdded(String path, File older, File yours, long rev1, long rev2, String mimeType1, String mimeType2, Map baseProps, Map propDiff, Map entryProps) throws SVNException {
        SVNStatusType[] result = new SVNStatusType[]{SVNStatusType.UNKNOWN, SVNStatusType.UNKNOWN};
        SVNDirectory parentDir = this.getParentDirectory(path);
        if (parentDir == null) {
            if (this.myIsDryRun && this.myAddedPath != null && path.startsWith(this.myAddedPath)) {
                result[0] = SVNStatusType.CHANGED;
                result[1] = propDiff != null && !propDiff.isEmpty() ? SVNStatusType.CHANGED : result[1];
            } else {
                result[0] = SVNStatusType.MISSING;
            }
            return result;
        }
        String name = SVNPathUtil.tail(path);
        File mine = parentDir.getFile(name);
        SVNFileType mineType = SVNFileType.getType(mine);
        if (mineType == SVNFileType.NONE) {
            SVNEntry entry = parentDir.getEntries().getEntry(name, true);
            if (entry != null && !entry.isScheduledForDeletion()) {
                result[0] = SVNStatusType.OBSTRUCTED;
                return result;
            }
            if (!this.myIsDryRun) {
                String pathInURL = this.getPathInURL(path);
                String copyFromURL = SVNPathUtil.append(this.myURL, SVNEncodingUtil.uriEncode(pathInURL));
                this.addFile(parentDir, name, SVNFileUtil.getBasePath(yours), propDiff, copyFromURL, this.myTargetRevision, entryProps);
            }
            result[0] = SVNStatusType.CHANGED;
            if (propDiff != null && !propDiff.isEmpty()) {
                result[1] = SVNStatusType.CHANGED;
            }
        } else if (mineType == SVNFileType.DIRECTORY) {
            result[0] = SVNStatusType.OBSTRUCTED;
        } else if (mineType.isFile()) {
            SVNEntry entry = parentDir.getEntries().getEntry(name, true);
            if (entry == null || entry.isScheduledForDeletion()) {
                result[0] = SVNStatusType.OBSTRUCTED;
            } else {
                return this.fileChanged(path, older, yours, rev1, rev2, mimeType1, mimeType2, baseProps, propDiff);
            }
        }
        return result;
    }

    private String getPathInURL(String path) {
        String pathInURL = path;
        if (!"".equals(this.myWCAccess.getTargetName())) {
            pathInURL = pathInURL.indexOf(47) > 0 ? pathInURL.substring(pathInURL.indexOf(47) + 1) : "";
        }
        return pathInURL;
    }

    public SVNStatusType directoryPropertiesChanged(String path, Map baseProps, Map propDiff) throws SVNException {
        return this.propertiesChanged(path, "", baseProps, propDiff);
    }

    public File getFile(String path, boolean base) throws SVNException {
        SVNDirectory dir = null;
        String parentPath = path;
        while (dir == null && !"".equals(parentPath)) {
            dir = this.getParentDirectory(parentPath);
            parentPath = SVNPathUtil.removeTail(parentPath);
        }
        String name = SVNPathUtil.tail(path);
        if (dir != null) {
            String extension = base ? ".tmp-base" : ".tmp-work";
            return SVNFileUtil.createUniqueFile(dir.getAdminFile("tmp/text-base"), name, extension);
        }
        return null;
    }

    private SVNStatusType propertiesChanged(String path, String name, Map baseProps, Map propDiff) throws SVNException {
        if (propDiff == null || propDiff.isEmpty()) {
            return SVNStatusType.UNCHANGED;
        }
        SVNDirectory dir = this.myWCAccess.getDirectory(path);
        if (dir == null) {
            return SVNStatusType.MISSING;
        }
        SVNStatusType result = null;
        SVNLog log = null;
        if (!this.myIsDryRun) {
            log = dir.getLog(0);
        }
        result = dir.mergeProperties(name, baseProps, propDiff, false, log);
        if (log != null) {
            log.save();
            dir.runLogs();
        }
        return result;
    }

    private void addDirectory(SVNDirectory parentDir, String name, String copyFromURL, long copyFromRev, Map entryProps) throws SVNException {
        SVNEntry root;
        SVNEntries entries = parentDir.getEntries();
        SVNEntry entry = entries.getEntry(name, true);
        String url = null;
        String uuid = entries.getEntry("", true).getUUID();
        String reposRootURL = entries.getEntry("", true).getRepositoryRoot();
        if (entry != null) {
            entry.loadProperties(entryProps);
            if (entry.isScheduledForDeletion()) {
                entry.scheduleForReplacement();
            }
            url = entry.getURL();
        } else {
            entry = parentDir.getEntries().addEntry(name);
            entry.loadProperties(entryProps);
            entry.setKind(SVNNodeKind.DIR);
            entry.scheduleForAddition();
            url = SVNPathUtil.append(entries.getEntry("", true).getURL(), SVNEncodingUtil.uriEncode(name));
        }
        entry.setCopied(true);
        entry.setCopyFromURL(copyFromURL);
        entry.setCopyFromRevision(copyFromRev);
        entries.save(false);
        SVNDirectory childDir = parentDir.getChildDirectory(name);
        if (childDir == null) {
            childDir = parentDir.createChildDirectory(name, url, reposRootURL, copyFromRev);
            root = childDir.getEntries().getEntry("", true);
            root.scheduleForAddition();
            root.setUUID(uuid);
        } else {
            childDir.getWCProperties("").delete();
            root = childDir.getEntries().getEntry("", true);
            if (root.isScheduledForDeletion()) {
                root.scheduleForReplacement();
            }
        }
        entries = childDir.getEntries();
        SVNEntry rootEntry = entries.getEntry("", true);
        rootEntry.setCopyFromURL(copyFromURL);
        rootEntry.setCopyFromRevision(copyFromRev);
        rootEntry.setCopied(true);
        rootEntry.setRepositoryRoot(reposRootURL);
        entries.save(false);
    }

    private void addFile(SVNDirectory parentDir, String name, String filePath, Map baseProps, String copyFromURL, long copyFromRev, Map entryProps) throws SVNException {
        SVNEntries entries = parentDir.getEntries();
        SVNEntry entry = entries.getEntry(name, true);
        if (entry != null) {
            if (entry.isScheduledForDeletion()) {
                entry.scheduleForReplacement();
            }
            entry.loadProperties(entryProps);
        } else {
            entry = parentDir.getEntries().addEntry(name);
            entry.loadProperties(entryProps);
            entry.setKind(SVNNodeKind.FILE);
            entry.scheduleForAddition();
        }
        entry.setCopied(true);
        entry.setCopyFromURL(copyFromURL);
        entry.setCopyFromRevision(copyFromRev);
        String url = SVNPathUtil.append(entries.getEntry("", true).getURL(), SVNEncodingUtil.uriEncode(name));
        entries.save(false);
        parentDir.getWCProperties(name).delete();
        SVNLog log = parentDir.getLog(0);
        HashMap<String, String> command = new HashMap<String, String>();
        SVNProperties wcPropsFile = parentDir.getProperties(name, false);
        SVNProperties basePropsFile = parentDir.getBaseProperties(name, false);
        Iterator propNames = baseProps.keySet().iterator();
        while (propNames.hasNext()) {
            String propName = (String)propNames.next();
            wcPropsFile.setPropertyValue(propName, (String)baseProps.get(propName));
            basePropsFile.setPropertyValue(propName, (String)baseProps.get(propName));
        }
        if (baseProps.isEmpty()) {
            wcPropsFile.setPropertyValue("x", "x");
            basePropsFile.setPropertyValue("x", "x");
            wcPropsFile.setPropertyValue("x", null);
            basePropsFile.setPropertyValue("x", null);
        }
        command.put("name", wcPropsFile.getPath());
        log.addCommand("readonly", command, false);
        command.put("name", basePropsFile.getPath());
        log.addCommand("readonly", command, false);
        command.put("name", name);
        command.put(SVNProperty.shortPropertyName("svn:entry:kind"), "file");
        command.put(SVNProperty.shortPropertyName("svn:entry:revision"), Long.toString(copyFromRev));
        command.put(SVNProperty.shortPropertyName("svn:entry:deleted"), Boolean.FALSE.toString());
        command.put(SVNProperty.shortPropertyName("svn:entry:absent"), Boolean.FALSE.toString());
        command.put(SVNProperty.shortPropertyName("svn:entry:url"), url);
        command.put(SVNProperty.shortPropertyName("svn:entry:copied"), Boolean.TRUE.toString());
        command.put(SVNProperty.shortPropertyName("svn:entry:copyfrom-url"), copyFromURL);
        command.put(SVNProperty.shortPropertyName("svn:entry:copyfrom-rev"), Long.toString(copyFromRev));
        log.addCommand("modify-entry", command, false);
        command.clear();
        String basePath = SVNFileUtil.getBasePath(parentDir.getBaseFile(name, false));
        command.put("name", filePath);
        command.put("dest", basePath);
        log.addCommand("mv", command, false);
        command.clear();
        command.put("name", basePath);
        log.addCommand("readonly", command, false);
        command.clear();
        command.put("name", basePath);
        command.put("dest", name);
        log.addCommand("cp-and-translate", command, false);
        command.clear();
        if (this.myWCAccess.getOptions().isUseCommitTimes() && wcPropsFile.getPropertyValue("svn:special") == null) {
            command.put("name", name);
            command.put("timestamp", entry.getCommittedDate());
            log.addCommand("set-timestamp", command, false);
            command.clear();
        }
        command.put("name", name);
        command.put(SVNProperty.shortPropertyName("svn:entry:prop-time"), "working");
        command.put(SVNProperty.shortPropertyName("svn:entry:text-time"), "working");
        log.addCommand("modify-entry", command, false);
        log.save();
        parentDir.runLogs();
    }

    private SVNDirectory getParentDirectory(String path) {
        path = SVNPathUtil.removeTail(path);
        return this.myWCAccess.getDirectory(path);
    }
}

