/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNDirectory;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNMerger;
import org.tmatesoft.svn.core.internal.wc.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVNMergeEditor
implements ISVNEditor {
    private SVNRepository myRepos;
    private long myRevision1;
    private long myRevision2;
    private SVNWCAccess myWCAccess;
    private String myTarget;
    private SVNDirectoryInfo myCurrentDirectory;
    private SVNFileInfo myCurrentFile;
    private SVNMerger myMerger;
    private SVNDeltaProcessor myDeltaProcessor;
    private ISVNEventHandler myEventHandler;

    public SVNMergeEditor(SVNWCAccess wcAccess, SVNRepository repos, long revision1, long revision2, SVNMerger merger, ISVNEventHandler handler) {
        this.myRepos = repos;
        this.myRevision1 = revision1;
        this.myRevision2 = revision2;
        this.myWCAccess = wcAccess;
        this.myEventHandler = handler;
        this.myMerger = merger;
        this.myTarget = "".equals(this.myWCAccess.getTargetName()) ? null : this.myWCAccess.getTargetName();
        this.myDeltaProcessor = new SVNDeltaProcessor();
    }

    public void targetRevision(long revision) throws SVNException {
    }

    public void openRoot(long revision) throws SVNException {
        this.myCurrentDirectory = new SVNDirectoryInfo(null, "", false);
        this.myCurrentDirectory.myWCPath = this.myTarget != null ? this.myTarget : "";
        this.myCurrentDirectory.myBaseProperties = new HashMap();
        this.myCurrentDirectory.loadFromRepository(this.myRepos, this.myRevision1);
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        SVNNodeKind nodeKind = this.myRepos.checkPath(path, this.myRevision1);
        SVNEventAction action = SVNEventAction.SKIP;
        SVNStatusType mergeResult = null;
        path = SVNPathUtil.append(this.myTarget, path);
        if (nodeKind == SVNNodeKind.FILE) {
            mergeResult = this.myMerger.fileDeleted(path);
        } else if (nodeKind == SVNNodeKind.DIR) {
            mergeResult = this.myMerger.directoryDeleted(path);
        }
        SVNEventAction expectedAction = null;
        if (mergeResult != SVNStatusType.OBSTRUCTED && mergeResult != SVNStatusType.MISSING) {
            action = SVNEventAction.UPDATE_DELETE;
        } else {
            expectedAction = SVNEventAction.UPDATE_DELETE;
        }
        SVNEvent event = SVNEventFactory.createMergeEvent(this.myWCAccess, path, action, expectedAction, null, null, null);
        this.myWCAccess.handleEvent(event, -1.0);
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCurrentDirectory = new SVNDirectoryInfo(this.myCurrentDirectory, path, true);
        this.myCurrentDirectory.myBaseProperties = Collections.EMPTY_MAP;
        String wcPath = SVNPathUtil.append(this.myTarget, path);
        this.myCurrentDirectory.myWCPath = wcPath;
        SVNEventAction action = SVNEventAction.UPDATE_ADD;
        SVNStatusType mergeResult = this.myMerger.directoryAdded(this.myCurrentDirectory.myWCPath, this.myCurrentDirectory.myEntryProps);
        SVNEventAction expectedAction = null;
        if (mergeResult == SVNStatusType.MISSING || mergeResult == SVNStatusType.OBSTRUCTED) {
            action = SVNEventAction.SKIP;
            expectedAction = SVNEventAction.UPDATE_ADD;
        }
        SVNEvent event = SVNEventFactory.createMergeEvent(this.myWCAccess, this.myCurrentDirectory.myWCPath, action, expectedAction, null, null, SVNNodeKind.DIR);
        this.myWCAccess.handleEvent(event, -1.0);
    }

    public void openDir(String path, long revision) throws SVNException {
        this.myCurrentDirectory = new SVNDirectoryInfo(this.myCurrentDirectory, path, false);
        this.myCurrentDirectory.myBaseProperties = new HashMap();
        String wcPath = SVNPathUtil.append(this.myTarget, path);
        this.myCurrentDirectory.myWCPath = wcPath;
        this.myCurrentDirectory.loadFromRepository(this.myRepos, this.myRevision1);
    }

    public void changeDirProperty(String name, String value) throws SVNException {
        if (name != null && this.myCurrentDirectory.myIsAdded && name.startsWith("svn:entry:")) {
            this.myCurrentDirectory.myEntryProps.put(name, value);
            return;
        }
        if (name == null || name.startsWith("svn:wc:") || name.startsWith("svn:entry:")) {
            return;
        }
        if (this.myCurrentDirectory.myPropertyDiff == null) {
            this.myCurrentDirectory.myPropertyDiff = new HashMap();
        }
        this.myCurrentDirectory.myPropertyDiff.put(name, value);
    }

    public void closeDir() throws SVNException {
        SVNStatusType propStatus = SVNStatusType.UNCHANGED;
        if (this.myCurrentDirectory.myPropertyDiff != null) {
            SVNDirectory dir = this.myWCAccess.getDirectory(this.myCurrentDirectory.myWCPath);
            if (dir == null && !this.myMerger.isDryRun()) {
                SVNEventAction expectedAction = this.myCurrentDirectory.myIsAdded ? SVNEventAction.UPDATE_ADD : SVNEventAction.UPDATE_UPDATE;
                SVNEvent event = SVNEventFactory.createMergeEvent(this.myWCAccess, this.myCurrentDirectory.myWCPath, SVNEventAction.SKIP, expectedAction, null, null, SVNNodeKind.DIR);
                this.myWCAccess.handleEvent(event, -1.0);
                this.myCurrentDirectory = this.myCurrentDirectory.myParent;
                return;
            }
            if (!this.myMerger.isDryRun() || dir != null) {
                propStatus = this.myMerger.directoryPropertiesChanged(this.myCurrentDirectory.myWCPath, this.myCurrentDirectory.myBaseProperties, this.myCurrentDirectory.myPropertyDiff);
            }
        }
        if (!this.myCurrentDirectory.myIsAdded && propStatus != SVNStatusType.UNCHANGED) {
            SVNEvent event = SVNEventFactory.createMergeEvent(this.myWCAccess, this.myCurrentDirectory.myWCPath, SVNEventAction.UPDATE_UPDATE, null, propStatus, SVNNodeKind.DIR);
            this.myWCAccess.handleEvent(event, -1.0);
        }
        this.myCurrentDirectory = this.myCurrentDirectory.myParent;
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCurrentFile = new SVNFileInfo(this.myCurrentDirectory, path, true);
        this.myCurrentFile.myBaseProperties = new HashMap();
    }

    public void openFile(String path, long revision) throws SVNException {
        this.myCurrentFile = new SVNFileInfo(this.myCurrentDirectory, path, false);
        this.myCurrentFile.loadFromRepository(this.myCurrentFile.myBaseFile, this.myRepos, this.myRevision1, this.myEventHandler);
    }

    public void changeFileProperty(String commitPath, String name, String value) throws SVNException {
        if (name != null && this.myCurrentFile.myIsAdded && name.startsWith("svn:entry:")) {
            this.myCurrentFile.myEntryProps.put(name, value);
            return;
        }
        if (name == null || name.startsWith("svn:wc:") || name.startsWith("svn:entry:")) {
            return;
        }
        if (this.myCurrentFile.myPropertyDiff == null) {
            this.myCurrentFile.myPropertyDiff = new HashMap();
        }
        this.myCurrentFile.myPropertyDiff.put(name, value);
    }

    public void applyTextDelta(String commitPath, String baseChecksum) throws SVNException {
        this.myCurrentFile.myBaseFile = this.myMerger.getFile(this.myCurrentFile.myWCPath, true);
        if (this.myCurrentFile.myIsAdded) {
            SVNFileUtil.createEmptyFile(this.myCurrentFile.myBaseFile);
        } else {
            this.myCurrentFile.loadFromRepository(this.myCurrentFile.myBaseFile, this.myRepos, this.myRevision1, this.myEventHandler);
        }
        this.myCurrentFile.myFile = this.myMerger.getFile(this.myCurrentFile.myWCPath, false);
        this.myDeltaProcessor.applyTextDelta(this.myCurrentFile.myBaseFile, this.myCurrentFile.myFile, false);
    }

    public OutputStream textDeltaChunk(String commitPath, SVNDiffWindow diffWindow) throws SVNException {
        return this.myDeltaProcessor.textDeltaChunk(diffWindow);
    }

    public void textDeltaEnd(String commitPath) throws SVNException {
        this.myDeltaProcessor.textDeltaEnd();
    }

    public void closeFile(String commitPath, String textChecksum) throws SVNException {
        SVNDirectory dir = this.myWCAccess.getDirectory(this.myCurrentDirectory.myWCPath);
        if (dir == null && !this.myMerger.isDryRun()) {
            SVNEventAction expectedAction = this.myCurrentFile.myIsAdded ? SVNEventAction.UPDATE_ADD : SVNEventAction.UPDATE_UPDATE;
            SVNEvent event = SVNEventFactory.createMergeEvent(this.myWCAccess, this.myCurrentFile.myWCPath, SVNEventAction.SKIP, expectedAction, null, null, SVNNodeKind.FILE);
            this.myWCAccess.handleEvent(event, -1.0);
        } else {
            SVNEventAction action;
            SVNStatusType contents = SVNStatusType.UNCHANGED;
            SVNStatusType props = SVNStatusType.UNCHANGED;
            if (this.myCurrentFile.myPropertyDiff != null || this.myCurrentFile.myFile != null) {
                String mimeType2;
                String mimeType1 = (String)this.myCurrentFile.myBaseProperties.get("svn:mime-type");
                String string = mimeType2 = this.myCurrentFile.myPropertyDiff != null ? (String)this.myCurrentFile.myPropertyDiff.get("svn:mime-type") : null;
                if (mimeType2 == null) {
                    mimeType2 = mimeType1;
                }
                if (this.myCurrentFile.myPropertyDiff == null) {
                    this.myCurrentFile.myPropertyDiff = new HashMap();
                }
                SVNStatusType[] result = null;
                if (this.myCurrentFile.myIsAdded) {
                    try {
                        result = this.myMerger.fileAdded(this.myCurrentFile.myWCPath, this.myCurrentFile.myFile != null ? this.myCurrentFile.myBaseFile : null, this.myCurrentFile.myFile, this.myRevision2, 0L, mimeType1, mimeType2, this.myCurrentFile.myBaseProperties, this.myCurrentFile.myPropertyDiff, this.myCurrentFile.myEntryProps);
                    }
                    catch (Throwable th) {
                        SVNDebugLog.logInfo(th);
                    }
                } else {
                    try {
                        result = this.myMerger.fileChanged(this.myCurrentFile.myWCPath, this.myCurrentFile.myBaseFile, this.myCurrentFile.myFile, this.myRevision1, this.myRevision2, mimeType1, mimeType2, this.myCurrentFile.myBaseProperties, this.myCurrentFile.myPropertyDiff);
                    }
                    catch (Throwable th) {
                        SVNDebugLog.logInfo(th);
                    }
                }
                if (result != null) {
                    contents = result[0];
                    props = result[1];
                }
            }
            SVNEventAction expectedAction = null;
            if (contents == SVNStatusType.MISSING || contents == SVNStatusType.OBSTRUCTED) {
                action = SVNEventAction.SKIP;
                expectedAction = this.myCurrentFile.myIsAdded ? SVNEventAction.UPDATE_ADD : SVNEventAction.UPDATE_UPDATE;
            } else {
                action = this.myCurrentFile.myIsAdded ? SVNEventAction.UPDATE_ADD : SVNEventAction.UPDATE_UPDATE;
            }
            SVNEvent event = SVNEventFactory.createMergeEvent(this.myWCAccess, this.myCurrentFile.myWCPath, action, expectedAction, contents, props, SVNNodeKind.FILE);
            this.myWCAccess.handleEvent(event, -1.0);
        }
        if (this.myCurrentFile.myFile != null) {
            this.myCurrentFile.myFile.delete();
        }
        if (this.myCurrentFile.myBaseFile != null) {
            this.myCurrentFile.myBaseFile.delete();
        }
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        return null;
    }

    public void abortEdit() throws SVNException {
    }

    public void absentDir(String path) throws SVNException {
    }

    public void absentFile(String path) throws SVNException {
    }

    private static class SVNFileInfo {
        private boolean myIsAdded;
        private String myWCPath;
        private String myPath;
        private File myFile;
        private File myBaseFile;
        private Map myBaseProperties;
        private Map myPropertyDiff;
        private Map myEntryProps;

        public SVNFileInfo(SVNDirectoryInfo parent, String path, boolean added) {
            this.myPath = path;
            this.myWCPath = SVNPathUtil.append(parent.myWCPath, SVNPathUtil.tail(path));
            this.myIsAdded = added;
            if (added) {
                this.myEntryProps = new HashMap();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadFromRepository(File dst, SVNRepository repos, long revision, ISVNEventHandler handler) throws SVNException {
            OutputStream os = null;
            this.myBaseProperties = new HashMap();
            try {
                os = dst == null ? null : SVNFileUtil.openFileForWriting(dst);
                repos.getFile(this.myPath, revision, this.myBaseProperties, new SVNCancellableOutputStream(os, handler));
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(os);
                throw throwable;
            }
            SVNFileUtil.closeFile(os);
            ArrayList names = new ArrayList(this.myBaseProperties.keySet());
            Iterator propNames = names.iterator();
            while (propNames.hasNext()) {
                String propName = (String)propNames.next();
                if (!propName.startsWith("svn:entry:") && !propName.startsWith("svn:wc:")) continue;
                this.myBaseProperties.remove(propName);
            }
        }
    }

    private static class SVNDirectoryInfo {
        private boolean myIsAdded;
        private String myPath;
        private String myWCPath;
        private Map myBaseProperties;
        private Map myPropertyDiff;
        private Map myEntryProps;
        private SVNDirectoryInfo myParent;

        public SVNDirectoryInfo(SVNDirectoryInfo parent, String path, boolean added) {
            this.myParent = parent;
            this.myPath = path;
            this.myIsAdded = added;
            if (added) {
                this.myEntryProps = new HashMap();
            }
        }

        public void loadFromRepository(SVNRepository repos, long revision) throws SVNException {
            this.myBaseProperties = new HashMap();
            repos.getDir(this.myPath, revision, this.myBaseProperties, (ISVNDirEntryHandler)null);
            ArrayList names = new ArrayList(this.myBaseProperties.keySet());
            Iterator propNames = names.iterator();
            while (propNames.hasNext()) {
                String propName = (String)propNames.next();
                if (!propName.startsWith("svn:entry:") && !propName.startsWith("svn:wc:")) continue;
                this.myBaseProperties.remove(propName);
            }
        }
    }
}

