/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SVNFileType {
    public static final SVNFileType UNKNOWN = new SVNFileType(0);
    public static final SVNFileType NONE = new SVNFileType(1);
    public static final SVNFileType FILE = new SVNFileType(2);
    public static final SVNFileType SYMLINK = new SVNFileType(3);
    public static final SVNFileType DIRECTORY = new SVNFileType(4);
    private static final boolean fastSymlinkResoution = !"false".equalsIgnoreCase(System.getProperty("javasvn.fastSymlinkResolution"));
    private static final boolean canonPathCacheUsed = !"false".equalsIgnoreCase(System.getProperty("sun.io.useCanonCaches"));
    private static boolean detectSymlinks = !"false".equalsIgnoreCase(System.getProperty("javasvn.symlinks", "true"));
    private static final Set ADMIN_FILE_PARENTS = new HashSet();
    private int myType;

    private SVNFileType(int type) {
        this.myType = type;
    }

    public String toString() {
        switch (this.myType) {
            case 0: {
                return "unknown";
            }
            case 1: {
                return "none";
            }
            case 2: {
                return "file";
            }
            case 3: {
                return "symlink";
            }
            case 4: {
                return "directory";
            }
        }
        return Integer.toString(this.myType);
    }

    public static void setSymlinkSupportEnabled(boolean enabled) {
        detectSymlinks = enabled;
    }

    public static boolean isSymlinkSupportEnabled() {
        return detectSymlinks;
    }

    public static SVNFileType getType(File file) {
        if (file == null) {
            return UNKNOWN;
        }
        if (detectSymlinks && !SVNFileUtil.isWindows && !SVNFileType.isAdminFile(file)) {
            if (canonPathCacheUsed && !fastSymlinkResoution && SVNFileUtil.isSymlink(file)) {
                return SYMLINK;
            }
            if (!canonPathCacheUsed || fastSymlinkResoution) {
                String canonicalPath;
                String absolutePath = file.getAbsolutePath();
                try {
                    canonicalPath = file.getCanonicalPath();
                }
                catch (IOException e) {
                    canonicalPath = file.getAbsolutePath();
                }
                if (!file.exists()) {
                    File[] children = file.getParentFile() != null ? file.getParentFile().listFiles() : null;
                    for (int i = 0; children != null && i < children.length; ++i) {
                        File child = children[i];
                        if (!child.getName().equals(file.getName()) || !SVNFileUtil.isSymlink(file)) continue;
                        return SYMLINK;
                    }
                } else if (!absolutePath.equals(canonicalPath) && SVNFileUtil.isSymlink(file)) {
                    return SYMLINK;
                }
            }
        }
        if (file.isFile()) {
            return FILE;
        }
        if (file.isDirectory()) {
            return DIRECTORY;
        }
        if (!file.exists()) {
            return NONE;
        }
        return UNKNOWN;
    }

    public static boolean equals(SVNFileType type, SVNNodeKind nodeKind) {
        if (nodeKind == SVNNodeKind.DIR) {
            return type == DIRECTORY;
        }
        if (nodeKind == SVNNodeKind.FILE) {
            return type == FILE || type == SYMLINK;
        }
        if (nodeKind == SVNNodeKind.NONE) {
            return type == NONE;
        }
        if (nodeKind == SVNNodeKind.UNKNOWN) {
            return type == UNKNOWN;
        }
        return false;
    }

    private static boolean isAdminFile(File file) {
        String adminDir;
        String path = file.getAbsolutePath().replace(File.separatorChar, '/');
        return path.lastIndexOf((adminDir = "/" + SVNFileUtil.getAdminDirectoryName()) + "/") > 0 || path.endsWith(adminDir);
    }

    public int getID() {
        return this.myType;
    }

    public boolean isFile() {
        return this == FILE || this == SYMLINK;
    }

    static {
        ADMIN_FILE_PARENTS.add("text-base");
        ADMIN_FILE_PARENTS.add("prop-base");
        ADMIN_FILE_PARENTS.add("props");
        ADMIN_FILE_PARENTS.add("wcprops");
        ADMIN_FILE_PARENTS.add("tmp");
    }
}

