/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;

public class SVNErrorManager {
    public static void cancel(String message) throws SVNCancelException {
        throw new SVNCancelException(SVNErrorMessage.create(SVNErrorCode.CANCELLED, message));
    }

    public static void authenticationFailed(String message, Object messageObject) throws SVNAuthenticationException {
        throw new SVNAuthenticationException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, message, messageObject));
    }

    public static void error(SVNErrorMessage err) throws SVNException {
        if (err == null) {
            err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN);
        }
        if (err.getErrorCode() == SVNErrorCode.CANCELLED) {
            throw new SVNCancelException(err);
        }
        if (err.getErrorCode().isAuthentication()) {
            throw new SVNAuthenticationException(err);
        }
        throw new SVNException(err);
    }

    public static void error(SVNErrorMessage err, Throwable cause) throws SVNException {
        if (err == null) {
            err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN);
        }
        if (err.getErrorCode() == SVNErrorCode.CANCELLED) {
            throw new SVNCancelException(err);
        }
        if (err.getErrorCode().isAuthentication()) {
            throw new SVNAuthenticationException(err);
        }
        throw new SVNException(err, cause);
    }

    public static void error(SVNErrorMessage err1, SVNErrorMessage err2) throws SVNException {
        if (err1 == null) {
            SVNErrorManager.error(err2);
        } else if (err2 == null) {
            SVNErrorManager.error(err1);
        }
        err1.setChildErrorMessage(err2);
        if (err1.getErrorCode() == SVNErrorCode.CANCELLED || err2.getErrorCode() == SVNErrorCode.CANCELLED) {
            throw new SVNCancelException(err1);
        }
        if (err1.getErrorCode().isAuthentication() || err2.getErrorCode().isAuthentication()) {
            throw new SVNAuthenticationException(err1);
        }
        throw new SVNException(err1);
    }
}

