/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNEntries;
import org.tmatesoft.svn.core.internal.wc.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNLog;
import org.tmatesoft.svn.core.internal.wc.SVNLogRunner;
import org.tmatesoft.svn.core.internal.wc.SVNProperties;
import org.tmatesoft.svn.core.internal.wc.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.SVNWCAccess;
import org.tmatesoft.svn.core.wc.ISVNMerger;
import org.tmatesoft.svn.core.wc.ISVNMergerFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNDirectory {
    private File myDirectory;
    private SVNEntries myEntries;
    private SVNWCAccess myWCAccess;
    private String myPath;
    private File myAdminRoot;
    private File myLockFile;
    private File myEntriesFile;

    public SVNDirectory(SVNWCAccess wcAccess, String path, File dir) {
        this.myDirectory = dir;
        this.myAdminRoot = new File(dir, SVNFileUtil.getAdminDirectoryName());
        this.myLockFile = new File(this.myAdminRoot, "lock");
        this.myEntriesFile = new File(this.myAdminRoot, "entries");
        this.myPath = path;
        this.myWCAccess = wcAccess;
    }

    public SVNWCAccess getWCAccess() {
        return this.myWCAccess;
    }

    public String getPath() {
        return this.myPath;
    }

    public SVNDirectory[] getChildDirectories() {
        return this.myWCAccess.getChildDirectories(this.myPath);
    }

    public SVNDirectory getChildDirectory(String name) {
        return this.myWCAccess.getDirectory("".equals(this.myPath) ? name : SVNPathUtil.append(this.myPath, name));
    }

    public boolean isVersioned() {
        if (this.getAdminDirectory().isDirectory() && this.myEntriesFile.canRead()) {
            try {
                if (this.getEntries().getEntry("", false) != null) {
                    return true;
                }
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isLocked() {
        return this.getLockFile().isFile();
    }

    public boolean lock() throws SVNException {
        if (!this.isVersioned()) {
            return false;
        }
        return this.innerLock();
    }

    boolean innerLock() throws SVNException {
        if (this.getLockFile().isFile()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy ''{0}'' locked; try performing ''cleanup''", this.getRoot());
            SVNErrorManager.error(err);
        }
        boolean created = false;
        try {
            created = this.getLockFile().createNewFile();
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Cannot lock working copy ''{0}'': {1}", new Object[]{this.getRoot(), e.getLocalizedMessage()});
            SVNErrorManager.error(err, e);
        }
        if (!created) {
            if (this.getLockFile().isFile()) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy ''{0}'' is locked; try performing 'cleanup'", this.getRoot());
                SVNErrorManager.error(err);
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Cannot lock working copy ''{0}''", this.getRoot());
                SVNErrorManager.error(err);
            }
        }
        return created;
    }

    public boolean unlock() throws SVNException {
        if (!this.getLockFile().exists()) {
            return true;
        }
        boolean killMe = this.getAdminFile("KILLME").exists();
        if (killMe) {
            return false;
        }
        File[] logs = this.getAdminDirectory().listFiles();
        for (int i = 0; logs != null && i < logs.length; ++i) {
            File log = logs[i];
            if (!"log".equals(log.getName()) && !log.getName().startsWith("log.")) continue;
            return false;
        }
        boolean deleted = this.getLockFile().delete();
        if (!deleted) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Failed to unlock working copy ''{0}''", this.getRoot());
            SVNErrorManager.error(err);
        }
        return deleted;
    }

    public SVNEntries getEntries() throws SVNException {
        if (this.myEntries == null) {
            this.myEntries = new SVNEntries(this.myEntriesFile);
        }
        this.myEntries.open();
        return this.myEntries;
    }

    public SVNProperties getProperties(String name, boolean tmp) {
        String path = !tmp ? "" : "tmp/";
        path = path + ("".equals(name) ? "dir-props" : "props/" + name + ".svn-work");
        File propertiesFile = this.getAdminFile(path);
        return new SVNProperties(propertiesFile, this.getAdminDirectory().getName() + "/" + path);
    }

    public SVNProperties getBaseProperties(String name, boolean tmp) {
        String path = !tmp ? "" : "tmp/";
        path = path + ("".equals(name) ? "dir-prop-base" : "prop-base/" + name + ".svn-base");
        File propertiesFile = this.getAdminFile(path);
        return new SVNProperties(propertiesFile, this.getAdminDirectory().getName() + "/" + path);
    }

    public SVNProperties getWCProperties(String name) {
        String path = "".equals(name) ? "dir-wcprops" : "wcprops/" + name + ".svn-work";
        File propertiesFile = this.getAdminFile(path);
        return new SVNProperties(propertiesFile, this.getAdminDirectory().getName() + "/" + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNStatusType mergeProperties(String name, Map serverBaseProps, Map propDiff, boolean baseMerge, SVNLog log) throws SVNException {
        serverBaseProps = serverBaseProps == null ? Collections.EMPTY_MAP : serverBaseProps;
        propDiff = propDiff == null ? Collections.EMPTY_MAP : propDiff;
        SVNProperties working = this.getProperties(name, false);
        Map workingProps = working.asMap();
        SVNProperties workingTmp = this.getProperties(name, true);
        SVNProperties base = this.getBaseProperties(name, false);
        SVNProperties baseTmp = this.getBaseProperties(name, true);
        working.copyTo(workingTmp);
        if (baseMerge) {
            base.copyTo(baseTmp);
        }
        ArrayList<String> conflicts = new ArrayList<String>();
        SVNStatusType result = propDiff.isEmpty() ? SVNStatusType.UNCHANGED : SVNStatusType.CHANGED;
        Iterator propEntries = propDiff.entrySet().iterator();
        while (propEntries.hasNext()) {
            Map.Entry incomingEntry = propEntries.next();
            String propName = (String)incomingEntry.getKey();
            String toValue = (String)incomingEntry.getValue();
            String fromValue = (String)serverBaseProps.get(propName);
            String workingValue = (String)workingProps.get(propName);
            if (baseMerge) {
                baseTmp.setPropertyValue(propName, toValue);
            }
            if (fromValue == null) {
                if (workingValue != null) {
                    if (workingValue.equals(toValue)) {
                        result = result != SVNStatusType.CONFLICTED ? SVNStatusType.MERGED : result;
                        continue;
                    }
                    conflicts.add(MessageFormat.format("Trying to add new property ''{0}'' with value ''{1}'',\nbut property already exists with value ''{2}''.", propName, toValue, workingValue));
                    result = SVNStatusType.CONFLICTED;
                    continue;
                }
                workingTmp.setPropertyValue(propName, toValue);
                continue;
            }
            if (workingValue == null) {
                if (toValue != null) {
                    result = SVNStatusType.CONFLICTED;
                    conflicts.add(MessageFormat.format("Trying to change property ''{0}'' from ''{1}'' to ''{2}'',\nbut the property does not exist.", propName, fromValue, toValue));
                    continue;
                }
                result = result != SVNStatusType.CONFLICTED ? SVNStatusType.MERGED : result;
                continue;
            }
            if (workingValue.equals(fromValue)) {
                workingTmp.setPropertyValue(propName, toValue);
                continue;
            }
            if (toValue == null && !workingValue.equals(fromValue)) {
                result = SVNStatusType.CONFLICTED;
                conflicts.add(MessageFormat.format("Trying to delete property ''{0}'' but value has been modified from ''{1}'' to ''{2}''.", propName, fromValue, workingValue));
                continue;
            }
            if (workingValue.equals(toValue)) {
                result = result != SVNStatusType.CONFLICTED ? SVNStatusType.MERGED : result;
                continue;
            }
            result = SVNStatusType.CONFLICTED;
            conflicts.add(MessageFormat.format("Trying to change property ''{0}'' from ''{1}'' to ''{2}'',\nbut property already exists with value ''{3}''.", propName, fromValue, toValue, workingValue));
        }
        HashMap<String, String> command = new HashMap<String, String>();
        if (log != null) {
            command.put("name", workingTmp.getPath());
            command.put("dest", working.getPath());
            log.addCommand("mv", command, false);
            command.clear();
            command.put("name", working.getPath());
            log.addCommand("readonly", command, false);
            if (baseMerge) {
                command.put("name", baseTmp.getPath());
                command.put("dest", base.getPath());
                log.addCommand("mv", command, false);
                command.clear();
                command.put("name", base.getPath());
                log.addCommand("readonly", command, false);
            }
        }
        if (!conflicts.isEmpty()) {
            result = SVNStatusType.CONFLICTED;
            if (log != null) {
                String prejTmpPath = "".equals(name) ? "tmp/dir_conflicts" : "tmp/props/" + name;
                File prejTmpFile = SVNFileUtil.createUniqueFile(this.getAdminDirectory(), prejTmpPath, ".prej");
                prejTmpPath = SVNFileUtil.getBasePath(prejTmpFile);
                String prejPath = this.getEntries().getEntry(name, true).getPropRejectFile();
                this.getEntries().close();
                if (prejPath == null) {
                    prejPath = "".equals(name) ? "dir_conflicts" : name;
                    File prejFile = SVNFileUtil.createUniqueFile(this.getRoot(), prejPath, ".prej");
                    prejPath = SVNFileUtil.getBasePath(prejFile);
                }
                File file = this.getFile(prejTmpPath);
                OutputStream os = SVNFileUtil.openFileForWriting(file);
                try {
                    Iterator lines = conflicts.iterator();
                    while (lines.hasNext()) {
                        String line = (String)lines.next();
                        os.write(line.getBytes("UTF-8"));
                    }
                }
                catch (IOException e) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write properties conflict file: {1}", e.getLocalizedMessage());
                    SVNErrorManager.error(err, e);
                }
                finally {
                    SVNFileUtil.closeFile(os);
                }
                command.put("name", prejTmpPath);
                command.put("dest", prejPath);
                log.addCommand("append", command, false);
                command.clear();
                command.put("name", prejTmpPath);
                log.addCommand("rm", command, false);
                command.clear();
                command.put("name", name);
                command.put(SVNProperty.shortPropertyName("svn:entry:prop-reject-file"), prejPath);
                log.addCommand("modify-entry", command, false);
            }
        }
        if (log == null) {
            workingTmp.delete();
            baseTmp.delete();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNStatusType mergeText(String localPath, String basePath, String latestPath, String localLabel, String baseLabel, String latestLabel, boolean leaveConflict, boolean dryRun) throws SVNException {
        String mimeType = this.getProperties(localPath, false).getPropertyValue("svn:mime-type");
        SVNEntry entry = this.getEntries().getEntry(localPath, true);
        if (SVNProperty.isBinaryMimeType(mimeType)) {
            if (!dryRun) {
                File oldFile = SVNFileUtil.createUniqueFile(this.getRoot(), localPath, baseLabel);
                File newFile = SVNFileUtil.createUniqueFile(this.getRoot(), localPath, latestLabel);
                SVNFileUtil.copyFile(this.getFile(basePath), oldFile, false);
                SVNFileUtil.copyFile(this.getFile(latestPath), newFile, false);
                entry.setConflictNew(SVNFileUtil.getBasePath(newFile));
                entry.setConflictOld(SVNFileUtil.getBasePath(oldFile));
                entry.setConflictWorking(null);
            }
            return SVNStatusType.CONFLICTED;
        }
        File localTmpFile = SVNFileUtil.createUniqueFile(this.getRoot(), localPath, ".tmp");
        SVNTranslator.translate(this, localPath, localPath, SVNFileUtil.getBasePath(localTmpFile), false, false);
        OutputStream result = null;
        File resultFile = dryRun ? null : SVNFileUtil.createUniqueFile(this.getRoot(), localPath, ".result");
        byte[] conflictStart = ("<<<<<<< " + localLabel).getBytes();
        byte[] conflictEnd = (">>>>>>> " + latestLabel).getBytes();
        byte[] separator = "=======".getBytes();
        ISVNMergerFactory factory = this.myWCAccess.getOptions().getMergerFactory();
        ISVNMerger merger = factory.createMerger(conflictStart, separator, conflictEnd);
        result = resultFile == null ? SVNFileUtil.DUMMY_OUT : SVNFileUtil.openFileForWriting(resultFile);
        SVNStatusType status = SVNStatusType.UNCHANGED;
        try {
            status = merger.mergeText(this.getFile(basePath), localTmpFile, this.getFile(latestPath), dryRun, result);
        }
        finally {
            SVNFileUtil.closeFile(result);
        }
        if (dryRun) {
            localTmpFile.delete();
            if (leaveConflict && status == SVNStatusType.CONFLICTED) {
                return SVNStatusType.CONFLICTED_UNRESOLVED;
            }
            return status;
        }
        if (status != SVNStatusType.CONFLICTED) {
            SVNTranslator.translate(this, localPath, SVNFileUtil.getBasePath(resultFile), localPath, true, true);
        } else {
            File mineFile = SVNFileUtil.createUniqueFile(this.getRoot(), localPath, localLabel);
            String minePath = SVNFileUtil.getBasePath(mineFile);
            SVNFileUtil.copyFile(this.getFile(localPath), mineFile, false);
            File oldFile = SVNFileUtil.createUniqueFile(this.getRoot(), localPath, baseLabel);
            String oldPath = SVNFileUtil.getBasePath(oldFile);
            File newFile = SVNFileUtil.createUniqueFile(this.getRoot(), localPath, latestLabel);
            String newPath = SVNFileUtil.getBasePath(newFile);
            SVNTranslator.translate(this, localPath, basePath, oldPath, true, false);
            SVNTranslator.translate(this, localPath, latestPath, newPath, true, false);
            if (!leaveConflict) {
                SVNTranslator.translate(this, localPath, SVNFileUtil.getBasePath(resultFile), localPath, true, true);
            }
            entry.setConflictNew(newPath);
            entry.setConflictOld(oldPath);
            entry.setConflictWorking(minePath);
        }
        localTmpFile.delete();
        if (resultFile != null) {
            resultFile.delete();
        }
        if (status == SVNStatusType.CONFLICTED && leaveConflict) {
            return SVNStatusType.CONFLICTED_UNRESOLVED;
        }
        return status;
    }

    public boolean markResolved(String name, boolean text, boolean props) throws SVNException {
        File file;
        if (!text && !props) {
            return false;
        }
        SVNEntry entry = this.getEntries().getEntry(name, true);
        if (entry == null) {
            return false;
        }
        boolean modified = false;
        if (text && entry.getConflictOld() != null) {
            modified = true;
            file = new File(this.myDirectory, entry.getConflictOld());
            file.delete();
            entry.setConflictOld(null);
        }
        if (text && entry.getConflictNew() != null) {
            modified = true;
            file = new File(this.myDirectory, entry.getConflictNew());
            file.delete();
            entry.setConflictNew(null);
        }
        if (text && entry.getConflictWorking() != null) {
            modified = true;
            file = new File(this.myDirectory, entry.getConflictWorking());
            file.delete();
            entry.setConflictWorking(null);
        }
        if (props && entry.getPropRejectFile() != null) {
            file = new File(this.myDirectory, entry.getPropRejectFile());
            file.delete();
            modified = true;
            entry.setPropRejectFile(null);
        }
        if (modified) {
            this.getEntries().save(false);
        }
        return modified;
    }

    public boolean revert(String name) throws SVNException {
        boolean magicPropsChanged = false;
        boolean wasReverted = false;
        SVNEntry entry = this.getEntries().getEntry(name, true);
        if (entry == null || entry.isHidden()) {
            return wasReverted;
        }
        SVNProperties baseProps = this.getBaseProperties(name, false);
        SVNProperties wcProps = this.getProperties(name, false);
        if (this.hasPropModifications(name)) {
            Map propDiff = baseProps.compareTo(wcProps);
            if (propDiff != null && !propDiff.isEmpty()) {
                boolean bl = magicPropsChanged = propDiff.containsKey("svn:executable") || propDiff.containsKey("svn:keywords") || propDiff.containsKey("svn:needs-lock") || propDiff.containsKey("svn:eol-style") || propDiff.containsKey("svn:special");
            }
            if (baseProps.getFile().isFile()) {
                baseProps.copyTo(wcProps);
                entry.setPropTime(SVNTimeUtil.formatDate(new Date(wcProps.getFile().lastModified())));
            } else {
                wcProps.delete();
                entry.setPropTime(null);
            }
            this.getEntries().save(false);
            wasReverted = true;
        } else if (entry.isScheduledForReplacement()) {
            baseProps.copyTo(wcProps);
            entry.setPropTime(SVNTimeUtil.formatDate(new Date(wcProps.getFile().lastModified())));
            wasReverted = true;
        }
        if (entry.isFile()) {
            boolean textModified = false;
            if (!magicPropsChanged) {
                textModified = this.hasTextModifications(name, false);
            }
            File file = this.getFile(entry.getName());
            if (textModified || magicPropsChanged || !file.exists()) {
                boolean needsLock;
                boolean special = wcProps.getPropertyValue("svn:special") != null;
                File src = this.getBaseFile(name, false);
                File dst = this.getFile(name);
                if (!src.exists()) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LEFT_LOCAL_MOD, "Error restoring text for ''{0}''", dst);
                    SVNErrorManager.error(err);
                }
                SVNTranslator.translate(this, name, SVNFileUtil.getBasePath(src), SVNFileUtil.getBasePath(dst), true, true);
                boolean executable = wcProps.getPropertyValue("svn:executable") != null;
                boolean bl = needsLock = wcProps.getPropertyValue("svn:needs-lock") != null;
                if (executable) {
                    SVNFileUtil.setExecutable(dst, true);
                }
                if (needsLock) {
                    SVNFileUtil.setReadonly(dst, entry.getLockToken() == null);
                }
                long tstamp = dst.lastModified();
                if (this.myWCAccess.getOptions().isUseCommitTimes() && !special) {
                    entry.setTextTime(entry.getCommittedDate());
                    tstamp = SVNTimeUtil.parseDate(entry.getCommittedDate()).getTime();
                    dst.setLastModified(tstamp);
                } else {
                    entry.setTextTime(SVNTimeUtil.formatDate(new Date(tstamp)));
                }
                this.getEntries().save(false);
                wasReverted |= true;
            }
            wasReverted |= this.markResolved(name, true, false);
        }
        return wasReverted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTextModifications(String name, boolean force) throws SVNException {
        long tstamp;
        String textTime;
        long textTimeAsLong;
        SVNFileType fType = SVNFileType.getType(this.getFile(name));
        if (fType == SVNFileType.DIRECTORY || fType == SVNFileType.NONE) {
            return false;
        }
        SVNEntries entries = this.getEntries();
        if (entries == null || entries.getEntry(name, true) == null) {
            return false;
        }
        SVNEntry entry = entries.getEntry(name, true);
        if (entry.isDirectory()) {
            return false;
        }
        if (!force && (textTimeAsLong = SVNFileUtil.roundTimeStamp(SVNTimeUtil.parseDateAsLong(textTime = entry.getTextTime()))) == (tstamp = SVNFileUtil.roundTimeStamp(this.getFile(name).lastModified()))) {
            return false;
        }
        File baseFile = this.getBaseFile(name, false);
        if (!baseFile.isFile()) {
            return true;
        }
        File baseTmpFile = SVNFileUtil.createUniqueFile(this.getRoot(), SVNFileUtil.getBasePath(this.getBaseFile(name, true)), ".tmp");
        if (!baseTmpFile.getParentFile().exists()) {
            baseTmpFile.getParentFile().mkdirs();
        }
        File versionedFile = this.getFile(name);
        SVNTranslator.translate(this, name, name, SVNFileUtil.getBasePath(baseTmpFile), false, false);
        boolean equals = true;
        try {
            String checksum;
            MessageDigest digest = force ? MessageDigest.getInstance("MD5") : null;
            equals = SVNFileUtil.compareFiles(baseFile, baseTmpFile, digest);
            if (force && !(checksum = SVNFileUtil.toHexDigest(digest)).equals(entry.getChecksum())) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT_TEXT_BASE, "Checksum mismatch indicates corrupt text base: ''{0}''\n   expected: {1}\n     actual: {2}\n", new Object[]{baseFile, entry.getChecksum(), checksum});
                SVNErrorManager.error(err);
            }
        }
        catch (NoSuchAlgorithmException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {1}", e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
        finally {
            baseTmpFile.delete();
        }
        if (equals && this.isLocked()) {
            entry.setTextTime(SVNTimeUtil.formatDate(new Date(versionedFile.lastModified())));
            entries.save(false);
        }
        return !equals;
    }

    public boolean hasPropModifications(String name) throws SVNException {
        Map m2;
        String realTimestamp;
        boolean propEmtpy;
        File baseFile;
        File propFile;
        if ("".equals(name)) {
            propFile = this.getAdminFile("dir-props");
            baseFile = this.getAdminFile("dir-prop-base");
        } else {
            propFile = this.getAdminFile("props/" + name + ".svn-work");
            baseFile = this.getAdminFile("prop-base/" + name + ".svn-base");
        }
        SVNEntry entry = this.getEntries().getEntry(name, true);
        long propLength = propFile.length();
        boolean bl = propEmtpy = propLength <= 4L;
        if (entry.isScheduledForReplacement()) {
            return !propEmtpy;
        }
        if (propEmtpy) {
            boolean baseEmtpy;
            boolean bl2 = baseEmtpy = baseFile.length() <= 4L;
            if (baseEmtpy) {
                return !propEmtpy;
            }
            return true;
        }
        if (propLength != baseFile.length()) {
            return true;
        }
        String fullRealTimestamp = realTimestamp = SVNTimeUtil.formatDate(new Date(propFile.lastModified()));
        realTimestamp = realTimestamp.substring(0, 23);
        String timeStamp = entry.getPropTime();
        if (timeStamp != null && realTimestamp.equals(timeStamp = timeStamp.substring(0, 23))) {
            return false;
        }
        Map m1 = this.getProperties(name, false).asMap();
        if (((Object)m1).equals(m2 = this.getBaseProperties(name, false).asMap())) {
            if (this.isLocked()) {
                entry.setPropTime(fullRealTimestamp);
                this.getEntries().save(false);
            }
            return false;
        }
        return true;
    }

    public void cleanup() throws SVNException {
        this.getWCAccess().checkCancelled();
        SVNEntries svnEntries = this.getEntries();
        Iterator entries = svnEntries.entries(true);
        while (entries.hasNext()) {
            SVNEntry entry = (SVNEntry)entries.next();
            if (!"".equals(entry.getName()) && entry.isDirectory()) {
                SVNDirectory childDir = this.getChildDirectory(entry.getName());
                if (childDir == null) continue;
                childDir.cleanup();
                continue;
            }
            this.hasTextModifications(entry.getName(), false);
            this.hasPropModifications(entry.getName());
        }
        svnEntries.save(true);
        if (this.getAdminFile("KILLME").isFile()) {
            this.destroy("", true);
        } else {
            this.runLogs();
        }
        File tmpDir = this.getAdminFile("tmp");
        if (tmpDir.isDirectory()) {
            SVNFileUtil.deleteAll(tmpDir, false, this.getWCAccess());
        }
    }

    public void canScheduleForDeletion(String name, boolean skipIgnored) throws SVNException {
        SVNEntries entries = this.getEntries();
        File[] files = this.getRoot().listFiles();
        if (files == null) {
            return;
        }
        this.getWCAccess().checkCancelled();
        if ("".equals(name) && this.hasPropModifications(name)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_MODIFIED, "''{0}'' has local modifications", this.getPath());
            SVNErrorManager.error(err);
        }
        for (int i = 0; i < files.length; ++i) {
            SVNDirectory childDir;
            SVNErrorMessage err;
            File childFile = files[i];
            if (this.getAdminDirectory().getName().equals(childFile.getName()) || !"".equals(name) && !childFile.getName().equals(name)) continue;
            String fileName = childFile.getName();
            SVNEntry entry = entries.getEntry(fileName, true);
            String path = SVNPathUtil.append(this.getPath(), fileName);
            path = path.replace('/', File.separatorChar);
            if (entry == null || entry.isHidden()) {
                ISVNOptions options;
                if (skipIgnored && this.isIgnored(fileName) || skipIgnored && this.getWCAccess() != null && (options = this.getWCAccess().getOptions()) != null && options.isIgnored(fileName)) continue;
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", path);
                SVNErrorManager.error(err2);
                continue;
            }
            SVNNodeKind kind = entry.getKind();
            SVNFileType fileType = SVNFileType.getType(childFile);
            if (fileType.isFile() && kind == SVNNodeKind.DIR || fileType == SVNFileType.DIRECTORY && kind == SVNNodeKind.FILE) {
                err = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "''{0}'' is in the way of the resource actually under version control", path);
                SVNErrorManager.error(err);
            } else if (kind == SVNNodeKind.FILE && (this.hasTextModifications(entry.getName(), false) || this.hasPropModifications(entry.getName()))) {
                err = SVNErrorMessage.create(SVNErrorCode.CLIENT_MODIFIED, "''{0}'' has local modifications", path);
                SVNErrorManager.error(err);
            }
            if (kind != SVNNodeKind.DIR || (childDir = this.getChildDirectory(childFile.getName())) == null) continue;
            childDir.canScheduleForDeletion("", skipIgnored);
        }
    }

    public void dispose() {
        if (this.myEntries != null) {
            this.myEntries.close();
        }
        this.myEntries = null;
    }

    private File getLockFile() {
        return this.myLockFile;
    }

    public File getAdminDirectory() {
        return this.myAdminRoot;
    }

    public File getFile(String name) {
        return new File(this.getRoot(), name);
    }

    public File getAdminFile(String name) {
        return new File(this.getAdminDirectory(), name);
    }

    public File getBaseFile(String name, boolean tmp) {
        String path = tmp ? "tmp/" : "";
        path = path + "text-base/" + name + ".svn-base";
        return this.getAdminFile(path);
    }

    public File getRoot() {
        return this.myDirectory;
    }

    public SVNLog getLog(int id) {
        return new SVNLog(this, id);
    }

    public void runLogs() throws SVNException {
        int index;
        SVNLogRunner runner = new SVNLogRunner();
        ArrayList<SVNLog> processedLogs = new ArrayList<SVNLog>();
        try {
            while (true) {
                SVNLog log = new SVNLog(this, index);
                this.getWCAccess().checkCancelled();
                if (log.exists()) {
                    log.run(runner);
                    processedLogs.add(log);
                    ++index;
                    continue;
                }
                break;
            }
        }
        catch (SVNException e) {
            File logFile;
            runner.logFailed(this);
            SVNDirectory.deleteLogs(processedLogs);
            int newIndex = 0;
            for (index = 0; index != 0 && (logFile = this.getAdminFile("log." + index)).exists(); ++index) {
                File newFile = this.getAdminFile(newIndex == 0 ? "log" : "log." + newIndex);
                SVNFileUtil.rename(logFile, newFile);
                ++newIndex;
            }
            throw e;
        }
        runner.logCompleted(this);
        SVNDirectory.deleteLogs(processedLogs);
    }

    private static void deleteLogs(Collection logsList) {
        Iterator logs = logsList.iterator();
        while (logs.hasNext()) {
            SVNLog log = (SVNLog)logs.next();
            log.delete();
        }
    }

    public SVNDirectory createChildDirectory(String name, String url, String reposURL, long revision) throws SVNException {
        File dir = new File(this.myDirectory, name);
        SVNDirectory.createVersionedDirectory(dir);
        String childPath = SVNPathUtil.append(this.myPath, name);
        SVNDirectory child = this.myWCAccess.addDirectory(childPath, dir);
        SVNEntry rootEntry = child.getEntries().getEntry("", true);
        if (rootEntry == null) {
            rootEntry = child.getEntries().addEntry("");
        }
        if (url != null) {
            rootEntry.setURL(url);
        }
        rootEntry.setRepositoryRoot(reposURL);
        rootEntry.setRevision(revision);
        rootEntry.setKind(SVNNodeKind.DIR);
        child.getEntries().save(true);
        return child;
    }

    public static void createVersionedDirectory(File dir) throws SVNException {
        dir.mkdirs();
        File adminDir = new File(dir, SVNFileUtil.getAdminDirectoryName());
        adminDir.mkdir();
        SVNFileUtil.setHidden(adminDir, true);
        File lock = new File(adminDir, "lock");
        SVNFileUtil.createEmptyFile(lock);
        SVNAdminUtil.createReadmeFile(adminDir);
        SVNFileUtil.createEmptyFile(new File(adminDir, "empty-file"));
        File[] tmp = new File[]{new File(adminDir, "tmp"), new File(adminDir, "tmp" + File.separatorChar + "props"), new File(adminDir, "tmp" + File.separatorChar + "prop-base"), new File(adminDir, "tmp" + File.separatorChar + "text-base"), new File(adminDir, "tmp" + File.separatorChar + "wcprops"), new File(adminDir, "props"), new File(adminDir, "prop-base"), new File(adminDir, "text-base"), new File(adminDir, "wcprops")};
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i].mkdir();
        }
        SVNAdminUtil.createFormatFile(adminDir);
        SVNFileUtil.deleteFile(lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroy(String name, boolean deleteWorkingFiles) throws SVNException {
        this.getWCAccess().checkCancelled();
        if ("".equals(name)) {
            SVNDirectory parent = null;
            if ("".equals(this.myPath)) {
                block19: {
                    SVNWCAccess parentWCAccess;
                    block20: {
                        parentWCAccess = null;
                        try {
                            try {
                                parentWCAccess = SVNWCAccess.create(this.getRoot().getParentFile());
                                parentWCAccess.open(true, false);
                                parent = parentWCAccess.getAnchor();
                                SVNDirectory.destroyDirectory(parent, this, deleteWorkingFiles);
                            }
                            catch (SVNException e) {
                                parent = null;
                                Object var7_9 = null;
                                if (parent != null) {
                                    parent.getEntries().save(true);
                                }
                                if (parentWCAccess != null) {
                                    parentWCAccess.close(true);
                                }
                                this.myWCAccess.removeDirectory("");
                                break block19;
                            }
                            Object var7_8 = null;
                            if (parent == null) break block20;
                        }
                        catch (Throwable throwable) {
                            Object var7_10 = null;
                            if (parent != null) {
                                parent.getEntries().save(true);
                            }
                            if (parentWCAccess != null) {
                                parentWCAccess.close(true);
                            }
                            this.myWCAccess.removeDirectory("");
                            throw throwable;
                        }
                        parent.getEntries().save(true);
                    }
                    if (parentWCAccess != null) {
                        parentWCAccess.close(true);
                    }
                    this.myWCAccess.removeDirectory("");
                }
                if (parent != null) {
                    return;
                }
            } else {
                String parentPath = SVNPathUtil.removeTail(this.myPath);
                parent = this.myWCAccess.getDirectory(parentPath);
                if (parent != null && !parent.isVersioned()) {
                    parent = null;
                }
            }
            SVNDirectory.destroyDirectory(parent, this, deleteWorkingFiles);
            this.myWCAccess.removeDirectory(this.myPath);
            if (parent != null) {
                parent.getEntries().save(true);
            }
        } else {
            File file = this.getFile(name);
            SVNFileType type = SVNFileType.getType(file);
            if (type == SVNFileType.DIRECTORY) {
                SVNDirectory childDir = this.getChildDirectory(name);
                if (childDir != null && childDir.isVersioned()) {
                    SVNDirectory.destroyDirectory(this, childDir, deleteWorkingFiles);
                    this.myWCAccess.removeDirectory(childDir.getPath());
                }
            } else {
                this.destroyFile(name, deleteWorkingFiles);
            }
        }
        this.getEntries().save(false);
    }

    public void scheduleForDeletion(String name, boolean deleteFiles) throws SVNException {
        SVNEntries entries = this.getEntries();
        SVNEntry entry = entries.getEntry(name, false);
        if (entry == null) {
            if (deleteFiles) {
                SVNFileUtil.deleteAll(this.getFile(name), this.getWCAccess());
            }
            return;
        }
        this.getWCAccess().checkCancelled();
        boolean added = entry.isScheduledForAddition();
        boolean deleted = false;
        SVNNodeKind kind = entry.getKind();
        if (entry.getKind() == SVNNodeKind.DIR) {
            SVNDirectory child;
            String nameInParent;
            SVNDirectory parent;
            if (!"".equals(name)) {
                parent = this;
                nameInParent = name;
                child = this.getChildDirectory(name);
            } else {
                child = this;
                nameInParent = SVNPathUtil.tail(this.myPath);
                String parentPath = SVNPathUtil.removeTail(this.myPath);
                parent = this.myWCAccess.getDirectory(parentPath);
            }
            boolean bl = deleted = parent != null ? parent.getEntries().getEntry(nameInParent, true).isDeleted() : false;
            if (added && !deleted) {
                if (child != null) {
                    child.destroy("", deleteFiles);
                } else {
                    parent.getEntries().deleteEntry(nameInParent);
                    parent.getEntries().save(false);
                }
            } else if (child != null) {
                child.updateEntryProperty("svn:entry:schedule", "delete", true);
            }
            if (parent != null) {
                parent.getEntries().save(false);
            }
            if (child != null) {
                child.getEntries().save(false);
            }
        }
        if (kind != SVNNodeKind.DIR || !added || deleted) {
            entry.scheduleForDeletion();
        }
        SVNEvent event = SVNEventFactory.createDeletedEvent(this.myWCAccess, this, entry.getName());
        this.myWCAccess.handleEvent(event);
        if (deleteFiles) {
            if (added) {
                SVNFileUtil.deleteAll(this.getFile(name), this.getWCAccess());
            } else {
                this.deleteWorkingFiles(name);
            }
        }
        entries.save(true);
    }

    public SVNEntry add(String name, boolean mkdir, boolean force) throws SVNException {
        boolean replace;
        File file = this.getFile(name);
        SVNFileType fileType = SVNFileType.getType(file);
        if (fileType == SVNFileType.NONE && !mkdir) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "''{0}'' not found", file);
            SVNErrorManager.error(err);
        }
        SVNNodeKind fileKind = fileType == SVNFileType.NONE || fileType == SVNFileType.DIRECTORY ? SVNNodeKind.DIR : SVNNodeKind.FILE;
        SVNEntry entry = this.getEntries().getEntry(name, true);
        if (entry != null && !entry.isDeleted() && !entry.isScheduledForDeletion()) {
            if (!force) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' already under version control", file);
                SVNErrorManager.error(err);
            }
            return entry;
        }
        if (entry != null && entry.getKind() != fileKind) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NODE_KIND_CHANGE, "Can''t replace ''{0}'' with a node of different type;\ncommit the deletion, update the parent and then add ''{0}''", file);
            SVNErrorManager.error(err);
        } else if (entry == null && fileType != SVNFileType.SYMLINK && SVNWCUtil.isVersionedDirectory(file)) {
            if (!force) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' already under version control", file);
                SVNErrorManager.error(err);
            }
            return null;
        }
        boolean bl = replace = entry != null && entry.isScheduledForDeletion();
        if (entry == null) {
            entry = this.getEntries().addEntry(name);
        }
        if (replace) {
            entry.scheduleForReplacement();
        } else {
            entry.scheduleForAddition();
        }
        if (!replace) {
            entry.setRevision(0L);
        }
        entry.setKind(fileKind);
        if (replace) {
            this.getProperties(name, false).delete();
        }
        if (fileKind == SVNNodeKind.DIR) {
            String parentURL = this.getEntries().getEntry("", true).getURL();
            String reposURL = this.getEntries().getEntry("", true).getRepositoryRoot();
            String childURL = SVNPathUtil.append(parentURL, SVNEncodingUtil.uriEncode(name));
            SVNDirectory childDir = this.getChildDirectory(name);
            if (childDir != null) {
                String existingURL = childDir.getEntries().getEntry("", true).getURL();
                if (!existingURL.equals(childURL)) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.UNKNOWN));
                }
            } else {
                childDir = this.createChildDirectory(name, childURL, reposURL, 0L);
            }
            if (!replace) {
                childDir.getEntries().getEntry("", true).scheduleForAddition();
            } else {
                childDir.getEntries().getEntry("", true).scheduleForReplacement();
            }
            childDir.getEntries().save(true);
        }
        SVNEvent event = SVNEventFactory.createAddedEvent(this.myWCAccess, this, entry);
        this.myWCAccess.handleEvent(event, -1.0);
        this.getEntries().save(false);
        return entry;
    }

    public void updateEntryProperty(String propertyName, String value, boolean recursive) throws SVNException {
        SVNEntries entries = this.getEntries();
        Iterator ents = entries.entries(false);
        while (ents.hasNext()) {
            SVNDirectory childDir;
            SVNEntry entry = (SVNEntry)ents.next();
            if ("".equals(entry.getName())) continue;
            if (entry.isDirectory() && recursive && (childDir = this.getChildDirectory(entry.getName())) != null) {
                childDir.updateEntryProperty(propertyName, value, recursive);
            }
            entries.setPropertyValue(entry.getName(), propertyName, value);
            if (!"delete".equals(value)) continue;
            SVNEvent event = SVNEventFactory.createDeletedEvent(this.myWCAccess, this, entry.getName());
            this.myWCAccess.handleEvent(event);
        }
        SVNEntry root = entries.getEntry("", true);
        if (!"delete".equals(value) || !root.isScheduledForAddition()) {
            root.scheduleForDeletion();
        }
        entries.save(false);
    }

    public void updateURL(String rootURL, boolean recursive) throws SVNException {
        SVNEntries entries = this.getEntries();
        Iterator ents = entries.entries(false);
        while (ents.hasNext()) {
            SVNEntry entry = (SVNEntry)ents.next();
            if (!"".equals(entry.getName()) && entry.isDirectory() && recursive) {
                SVNDirectory childDir = this.getChildDirectory(entry.getName());
                if (childDir == null) continue;
                String childURL = SVNPathUtil.append(rootURL, SVNEncodingUtil.uriEncode(entry.getName()));
                childDir.updateURL(childURL, recursive);
                continue;
            }
            entries.setPropertyValue(entry.getName(), "svn:entry:url", "".equals(entry.getName()) ? rootURL : SVNPathUtil.append(rootURL, SVNEncodingUtil.uriEncode(entry.getName())));
        }
        entries.save(false);
    }

    private void deleteWorkingFiles(String name) throws SVNException {
        File file = this.getFile(name);
        SVNFileType fileType = SVNFileType.getType(file);
        if (fileType == SVNFileType.DIRECTORY) {
            SVNDirectory childDir = this.getChildDirectory(file.getName());
            if (childDir != null) {
                SVNEntries childEntries = childDir.getEntries();
                Iterator childEnts = childEntries.entries(true);
                while (childEnts.hasNext()) {
                    SVNEntry childEntry = (SVNEntry)childEnts.next();
                    if ("".equals(childEntry.getName())) continue;
                    childDir.deleteWorkingFiles(childEntry.getName());
                }
                File[] allFiles = file.listFiles();
                for (int i = 0; allFiles != null && i < allFiles.length; ++i) {
                    if (this.getAdminDirectory().getName().equals(allFiles[i].getName()) || childEntries.getEntry(allFiles[i].getName(), true) != null) continue;
                    SVNFileUtil.deleteAll(allFiles[i], this.getWCAccess());
                }
            } else {
                SVNFileUtil.deleteAll(file, this.getWCAccess());
            }
        } else {
            file.delete();
        }
    }

    public void setWCAccess(SVNWCAccess wcAccess, String path) {
        this.myWCAccess = wcAccess;
        this.myPath = path;
    }

    private void destroyFile(String name, boolean deleteWorkingFile) throws SVNException {
        SVNEntries entries = this.getEntries();
        if (entries.getEntry(name, true) != null && deleteWorkingFile && !this.hasTextModifications(name, false)) {
            this.getFile(name).delete();
        }
        entries.deleteEntry(name);
        this.getBaseProperties(name, false).delete();
        this.getWCProperties(name).delete();
        this.getProperties(name, false).delete();
        File baseFile = this.getBaseFile(name, false);
        baseFile.delete();
    }

    private static void destroyDirectory(SVNDirectory parent, SVNDirectory dir, boolean deleteWorkingFiles) throws SVNException {
        dir.getWCAccess().checkCancelled();
        SVNEntries entries = dir.getEntries();
        entries.getEntry("", true).setIncomplete(true);
        Iterator ents = entries.entries(true);
        while (ents.hasNext()) {
            SVNEntry entry = (SVNEntry)ents.next();
            if ("".equals(entry.getName())) continue;
            if (entry.getKind() == SVNNodeKind.FILE) {
                dir.destroyFile(entry.getName(), deleteWorkingFiles);
                continue;
            }
            if (entry.getKind() != SVNNodeKind.DIR) continue;
            SVNDirectory childDirectory = dir.getChildDirectory(entry.getName());
            if (childDirectory == null) {
                try {
                    File childFile = dir.getFile(entry.getName());
                    String childPath = SVNPathUtil.append(dir.getPath(), entry.getName());
                    childDirectory = dir.getWCAccess().addDirectory(childPath, childFile, true, true, true);
                }
                catch (SVNException e) {
                    // empty catch block
                }
                if (childDirectory != null) {
                    SVNDirectory.destroyDirectory(dir, childDirectory, deleteWorkingFiles);
                    continue;
                }
                entries.deleteEntry(entry.getName());
                continue;
            }
            SVNDirectory.destroyDirectory(dir, childDirectory, deleteWorkingFiles);
        }
        if (parent != null) {
            SVNEntries parentEntries = parent.getEntries();
            parentEntries.deleteEntry(dir.getRoot().getName());
        }
        dir.getEntries().save(true);
        SVNFileUtil.deleteAll(new File(dir.getRoot(), dir.getAdminDirectory().getName()), dir.getWCAccess());
        if (deleteWorkingFiles) {
            dir.getRoot().delete();
        }
    }

    public void commit(String target, SVNCommitInfo info, Map wcPropChanges, boolean removeLock, boolean recursive, Collection explicitCommitPaths) throws SVNException {
        SVNEntry entry;
        String path;
        String string = path = "".equals(target) ? this.getPath() : SVNPathUtil.append(this.getPath(), target);
        if (!explicitCommitPaths.contains(path) && (entry = this.getEntries().getEntry(target, true)) != null && entry.getCopyFromURL() != null) {
            return;
        }
        SVNLog log = this.getLog(0);
        String checksum = null;
        if (!"".equals(target)) {
            File baseFile = this.getBaseFile(target, true);
            SVNFileType baseType = SVNFileType.getType(baseFile);
            if (baseType == SVNFileType.NONE) {
                baseFile = this.getBaseFile(target, false);
                baseType = SVNFileType.getType(baseFile);
            }
            if (baseType == SVNFileType.FILE) {
                checksum = SVNFileUtil.computeChecksum(baseFile);
            }
            recursive = false;
        }
        HashMap<String, String> command = new HashMap<String, String>();
        if (info != null) {
            command.put("name", target);
            command.put(SVNProperty.shortPropertyName("svn:entry:committed-rev"), Long.toString(info.getNewRevision()));
            command.put(SVNProperty.shortPropertyName("svn:entry:committed-date"), SVNTimeUtil.formatDate(info.getDate()));
            command.put(SVNProperty.shortPropertyName("svn:entry:last-author"), info.getAuthor());
            log.addCommand("modify-entry", command, false);
            command.clear();
        }
        if (checksum != null) {
            command.put("name", target);
            command.put(SVNProperty.shortPropertyName("svn:entry:checksum"), checksum);
            log.addCommand("modify-entry", command, false);
            command.clear();
        }
        if (removeLock) {
            command.put("name", target);
            log.addCommand("delete-lock", command, false);
            command.clear();
        }
        command.put("name", target);
        command.put("revision", info == null ? null : Long.toString(info.getNewRevision()));
        if (!explicitCommitPaths.contains(path)) {
            command.put("implicit", "true");
        }
        log.addCommand("committed", command, false);
        command.clear();
        if (wcPropChanges != null && !wcPropChanges.isEmpty()) {
            Iterator propNames = wcPropChanges.keySet().iterator();
            while (propNames.hasNext()) {
                String propName = (String)propNames.next();
                String propValue = (String)wcPropChanges.get(propName);
                command.put("name", target);
                command.put("propname", propName);
                command.put("propval", propValue);
                log.addCommand("modify-wcprop", command, false);
                command.clear();
            }
        }
        log.save();
        this.runLogs();
        if (recursive) {
            SVNEntries entries = this.getEntries();
            Iterator ents = entries.entries(true);
            while (ents.hasNext()) {
                SVNEntry entry2 = (SVNEntry)ents.next();
                if ("".equals(entry2.getName())) continue;
                if (entry2.getKind() == SVNNodeKind.DIR) {
                    SVNDirectory childDir = this.getChildDirectory(entry2.getName());
                    if (childDir == null) continue;
                    childDir.commit("", info, null, removeLock, true, explicitCommitPaths);
                    continue;
                }
                this.commit(entry2.getName(), info, null, removeLock, false, explicitCommitPaths);
            }
        }
    }

    public boolean isIgnored(String fileName) throws SVNException {
        String ignoredProperty = this.getProperties("", false).getPropertyValue("svn:ignore");
        if (ignoredProperty == null) {
            return false;
        }
        StringTokenizer tokens = new StringTokenizer(ignoredProperty, "\r\n");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.trim().length() == 0 || !DefaultSVNOptions.matches(token, fileName)) continue;
            return true;
        }
        return false;
    }
}

