/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNDirectory;
import org.tmatesoft.svn.core.internal.wc.SVNEntries;
import org.tmatesoft.svn.core.internal.wc.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNProperties;
import org.tmatesoft.svn.core.internal.wc.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;

public class SVNDiffEditor
implements ISVNEditor {
    private SVNWCAccess myWCAccess;
    private ISVNDiffGenerator myDiffGenerator;
    private boolean myUseAncestry;
    private boolean myIsReverseDiff;
    private boolean myIsCompareToBase;
    private OutputStream myResult;
    private boolean myIsRootOpen;
    private long myTargetRevision;
    private SVNDirectoryInfo myCurrentDirectory;
    private SVNFileInfo myCurrentFile;
    private SVNDeltaProcessor myDeltaProcessor;

    public SVNDiffEditor(SVNWCAccess wcAccess, ISVNDiffGenerator diffGenerator, boolean useAncestry, boolean reverseDiff, boolean compareToBase, OutputStream result) {
        this.myWCAccess = wcAccess;
        this.myDiffGenerator = diffGenerator;
        this.myUseAncestry = useAncestry;
        this.myIsReverseDiff = reverseDiff;
        this.myResult = result;
        this.myIsCompareToBase = compareToBase;
        this.myDeltaProcessor = new SVNDeltaProcessor();
    }

    public void targetRevision(long revision) throws SVNException {
        this.myTargetRevision = revision;
    }

    public void openRoot(long revision) throws SVNException {
        this.myIsRootOpen = true;
        this.myCurrentDirectory = this.createDirInfo(null, "", false);
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        SVNDirectory dir = this.myWCAccess.getDirectory(this.myCurrentDirectory.myPath);
        String name = SVNPathUtil.tail(path);
        SVNEntry entry = dir.getEntries().getEntry(name, true);
        String displayPath = dir.getFile(name).getAbsolutePath().replace(File.separatorChar, '/');
        if (entry != null && entry.isFile()) {
            SVNProperties baseProps = dir.getBaseProperties(name, false);
            SVNProperties wcProps = dir.getProperties(name, false);
            String baseMimeType = baseProps.getPropertyValue("svn:mime-type");
            String wcMimeType = wcProps.getPropertyValue("svn:mime-type");
            boolean deleted = entry.isScheduledForDeletion();
            if (this.myIsReverseDiff) {
                File baseFile = deleted ? null : dir.getBaseFile(name, false);
                String revStr = "(revision " + this.myTargetRevision + ")";
                this.myDiffGenerator.displayFileDiff(displayPath, baseFile, null, revStr, null, baseMimeType, wcMimeType, this.myResult);
            } else {
                File baseFile = deleted ? null : dir.getFile(name);
                File emptyFile = null;
                String revStr = "(revision " + entry.getRevision() + ")";
                this.myDiffGenerator.displayFileDiff(displayPath, emptyFile, baseFile, "(revision 0)", revStr, wcMimeType, baseMimeType, this.myResult);
            }
        } else if (entry != null && entry.isDirectory()) {
            SVNDirectoryInfo info = this.createDirInfo(this.myCurrentDirectory, path, true);
            this.localDirectoryDiff(info, true, this.myResult);
        }
        this.myCurrentDirectory.myComparedEntries.add(name);
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCurrentDirectory = this.createDirInfo(this.myCurrentDirectory, path, true);
    }

    public void openDir(String path, long revision) throws SVNException {
        this.myCurrentDirectory = this.createDirInfo(this.myCurrentDirectory, path, false);
    }

    public void changeDirProperty(String name, String value) throws SVNException {
        if (name.startsWith("svn:wc:") || name.startsWith("svn:entry:")) {
            return;
        }
        if (this.myCurrentDirectory.myPropertyDiff == null) {
            this.myCurrentDirectory.myPropertyDiff = new HashMap();
        }
        this.myCurrentDirectory.myPropertyDiff.put(name, value);
        if (this.myCurrentDirectory.myBaseProperties == null) {
            SVNDirectory dir = this.myWCAccess.getDirectory(this.myCurrentDirectory.myPath);
            if (dir != null) {
                this.myCurrentDirectory.myBaseProperties = dir.getBaseProperties("", false).asMap();
            } else {
                this.myCurrentDirectory.myBaseProperties = new HashMap();
            }
        }
    }

    public void closeDir() throws SVNException {
        if (!this.myCurrentDirectory.myIsAdded) {
            this.localDirectoryDiff(this.myCurrentDirectory, false, this.myResult);
        }
        Map diff = this.myCurrentDirectory.myPropertyDiff;
        Map base = this.myCurrentDirectory.myBaseProperties;
        if (diff != null && !diff.isEmpty()) {
            if (!this.myIsReverseDiff) {
                SVNDiffEditor.reversePropChanges(base, diff);
            }
            String displayPath = new File(this.myWCAccess.getAnchor().getRoot(), this.myCurrentDirectory.myPath).getAbsolutePath();
            displayPath = displayPath.replace(File.separatorChar, '/');
            this.myDiffGenerator.displayPropDiff(displayPath, base, diff, this.myResult);
        }
        String name = SVNPathUtil.tail(this.myCurrentDirectory.myPath);
        this.myCurrentDirectory = this.myCurrentDirectory.myParent;
        if (this.myCurrentDirectory != null) {
            this.myCurrentDirectory.myComparedEntries.add(name);
        }
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        String name = SVNPathUtil.tail(path);
        this.myCurrentFile = this.createFileInfo(path, true);
        this.myCurrentDirectory.myComparedEntries.add(name);
    }

    public void openFile(String path, long revision) throws SVNException {
        String name = SVNPathUtil.tail(path);
        this.myCurrentFile = this.createFileInfo(path, false);
        this.myCurrentDirectory.myComparedEntries.add(name);
    }

    public void changeFileProperty(String path, String name, String value) throws SVNException {
        if (name.startsWith("svn:wc:") || name.startsWith("svn:entry:")) {
            return;
        }
        if (this.myCurrentFile.myPropertyDiff == null) {
            this.myCurrentFile.myPropertyDiff = new HashMap();
        }
        this.myCurrentFile.myPropertyDiff.put(name, value);
        if (this.myCurrentFile.myBaseProperties == null) {
            SVNDirectory dir = this.myWCAccess.getDirectory(this.myCurrentDirectory.myPath);
            String fileName = SVNPathUtil.tail(this.myCurrentFile.myPath);
            if (dir != null) {
                this.myCurrentFile.myBaseProperties = dir.getBaseProperties(fileName, false).asMap();
            } else {
                this.myCurrentFile.myBaseProperties = new HashMap();
            }
        }
    }

    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        SVNDirectory dir = this.myWCAccess.getDirectory(this.myCurrentDirectory.myPath);
        String fileName = SVNPathUtil.tail(this.myCurrentFile.myPath);
        if (dir != null) {
            SVNEntry entry = dir.getEntries().getEntry(fileName, true);
            if (entry != null && entry.getCopyFromURL() != null) {
                this.myCurrentFile.myIsAdded = false;
            }
            if (entry != null && entry.isScheduledForDeletion()) {
                this.myCurrentFile.myIsScheduledForDeletion = true;
            }
        }
        File tmpFile = null;
        if (!this.myCurrentFile.myIsAdded) {
            tmpFile = dir.getBaseFile(fileName, true);
            this.myCurrentFile.myBaseFile = dir.getBaseFile(fileName, false);
        } else {
            SVNDirectoryInfo info = this.myCurrentDirectory.myParent;
            while (info != null) {
                SVNDirectory parentDir = this.myWCAccess.getDirectory(info.myPath);
                if (parentDir != null) {
                    tmpFile = SVNFileUtil.createUniqueFile(parentDir.getAdminFile("tmp/text-base"), fileName, ".tmp");
                    this.myCurrentFile.myBaseFile = parentDir.getAdminFile("empty-file");
                    if (this.myCurrentFile.myBaseFile.exists()) break;
                }
                info = info.myParent;
            }
        }
        this.myCurrentFile.myFile = tmpFile;
        this.myDeltaProcessor.applyTextDelta(this.myCurrentFile.myBaseFile, this.myCurrentFile.myFile, false);
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        return this.myDeltaProcessor.textDeltaChunk(diffWindow);
    }

    public void textDeltaEnd(String path) throws SVNException {
        this.myDeltaProcessor.textDeltaEnd();
    }

    public void closeFile(String commitPath, String textChecksum) throws SVNException {
        String reposMimeType = this.myCurrentFile.myPropertyDiff != null ? this.myCurrentFile.myPropertyDiff.get("svn:mime-type") : null;
        String fileName = SVNPathUtil.tail(this.myCurrentFile.myPath);
        SVNDirectory dir = this.myWCAccess.getDirectory(this.myCurrentDirectory.myPath);
        if (reposMimeType == null) {
            if (this.myCurrentFile.myBaseProperties == null) {
                this.myCurrentFile.myBaseProperties = dir != null ? dir.getBaseProperties(fileName, false).asMap() : new HashMap();
            }
            reposMimeType = (String)this.myCurrentFile.myBaseProperties.get("svn:mime-type");
        }
        SVNEntry entry = null;
        if (dir != null) {
            entry = dir.getEntries().getEntry(fileName, true);
        }
        String displayPath = new File(this.myWCAccess.getAnchor().getRoot(), this.myCurrentFile.myPath).getAbsolutePath().replace(File.separatorChar, '/');
        if (this.myCurrentFile.myIsAdded) {
            if (this.myIsReverseDiff) {
                String revStr = entry != null ? "(revision " + entry.getRevision() + ")" : null;
                this.myDiffGenerator.displayFileDiff(displayPath, this.myCurrentFile.myBaseFile, this.myCurrentFile.myFile, "(revision 0)", revStr, null, reposMimeType, this.myResult);
            } else {
                String revStr = "(revision " + this.myTargetRevision + ")";
                this.myDiffGenerator.displayFileDiff(displayPath, this.myCurrentFile.myFile, null, revStr, null, reposMimeType, null, this.myResult);
            }
        } else {
            if (this.myCurrentFile.myFile != null) {
                String wcMimeType = dir.getProperties(fileName, false).getPropertyValue("svn:mime-type");
                if (!this.myIsCompareToBase && this.myCurrentFile.myIsScheduledForDeletion) {
                    this.myCurrentFile.myBaseFile = null;
                } else if (!this.myIsCompareToBase) {
                    File wcTmpFile = SVNFileUtil.createUniqueFile(this.myCurrentFile.myFile.getParentFile(), fileName, ".tmp");
                    String path = SVNFileUtil.getBasePath(wcTmpFile);
                    SVNTranslator.translate(dir, fileName, fileName, path, true, false);
                    this.myCurrentFile.myBaseFile = wcTmpFile;
                }
                String revStr = "(revision " + this.myTargetRevision + ")";
                if (this.myIsReverseDiff) {
                    this.myDiffGenerator.displayFileDiff(displayPath, this.myCurrentFile.myBaseFile, this.myCurrentFile.myFile, null, revStr, wcMimeType, reposMimeType, this.myResult);
                } else {
                    this.myDiffGenerator.displayFileDiff(displayPath, this.myCurrentFile.myFile, this.myCurrentFile.myBaseFile, revStr, null, reposMimeType, wcMimeType, this.myResult);
                }
                if (!(this.myCurrentFile.myBaseFile == null || this.myCurrentFile.myIsScheduledForDeletion || this.myIsCompareToBase || fileName.equals(SVNFileUtil.getBasePath(this.myCurrentFile.myBaseFile)))) {
                    this.myCurrentFile.myBaseFile.delete();
                }
                this.myCurrentFile.myFile.delete();
            }
            if (this.myCurrentFile.myPropertyDiff != null && !this.myCurrentFile.myPropertyDiff.isEmpty()) {
                Map base = this.myCurrentFile.myBaseProperties;
                Map diff = this.myCurrentFile.myPropertyDiff;
                if (!this.myIsReverseDiff) {
                    SVNDiffEditor.reversePropChanges(base, diff);
                }
                this.myDiffGenerator.displayPropDiff(displayPath, base, diff, this.myResult);
            }
        }
        if (this.myCurrentFile.myFile != null) {
            this.myCurrentFile.myFile.delete();
        }
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        if (!this.myIsRootOpen) {
            this.localDirectoryDiff(this.createDirInfo(null, "", false), false, this.myResult);
        }
        return null;
    }

    public void abortEdit() throws SVNException {
    }

    public void absentDir(String path) throws SVNException {
    }

    public void absentFile(String path) throws SVNException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void localDirectoryDiff(SVNDirectoryInfo info, boolean isAdded, OutputStream result) throws SVNException {
        boolean anchor;
        if (this.myIsCompareToBase) {
            return;
        }
        SVNDirectory dir = this.myWCAccess.getDirectory(info.myPath);
        boolean bl = anchor = !"".equals(this.myWCAccess.getTargetName()) && dir == this.myWCAccess.getAnchor();
        if (!anchor && dir.hasPropModifications("")) {
            SVNProperties baseProps = dir.getBaseProperties("", false);
            Map propDiff = baseProps.compareTo(dir.getProperties("", false));
            String displayPath = dir.getRoot().getAbsolutePath().replace(File.separatorChar, '/');
            this.myDiffGenerator.displayPropDiff(displayPath, baseProps.asMap(), propDiff, result);
        }
        SVNEntries svnEntries = dir.getEntries();
        Iterator entries = svnEntries.entries(false);
        while (entries.hasNext()) {
            SVNEntry entry = (SVNEntry)entries.next();
            if (anchor && !this.myWCAccess.getTargetName().equals(entry.getName()) || "".equals(entry.getName()) || info.myComparedEntries.contains(entry.getName())) continue;
            info.myComparedEntries.add(entry.getName());
            if (entry.isDirectory()) {
                SVNDirectoryInfo childInfo = this.createDirInfo(info, SVNPathUtil.append(info.myPath, entry.getName()), false);
                SVNDirectory childDir = this.myWCAccess.getDirectory(childInfo.myPath);
                if (childDir == null) continue;
                this.localDirectoryDiff(childInfo, isAdded, this.myResult);
                continue;
            }
            String name = entry.getName();
            boolean added = entry.isScheduledForAddition() || isAdded;
            boolean replaced = entry.isScheduledForReplacement();
            boolean deleted = entry.isScheduledForDeletion();
            boolean copied = entry.isCopied();
            if (copied) {
                added = false;
                deleted = false;
                replaced = false;
            }
            if (replaced && !this.myUseAncestry) {
                replaced = false;
            }
            SVNProperties props = dir.getProperties(name, false);
            String fullPath = dir.getFile(name).getAbsolutePath().replace(File.separatorChar, '/');
            Map baseProps = dir.getBaseProperties(name, false).asMap();
            Map propDiff = null;
            if (!deleted && dir.hasPropModifications(name)) {
                propDiff = dir.getBaseProperties(name, false).compareTo(dir.getProperties(name, false));
            }
            if (deleted || replaced) {
                String mimeType1 = (String)baseProps.get("svn:mime-type");
                String rev1 = "(revision " + Long.toString(entry.getRevision()) + ")";
                this.myDiffGenerator.displayFileDiff(fullPath, dir.getBaseFile(name, false), null, rev1, null, mimeType1, null, result);
                if (deleted) continue;
            }
            File tmpFile = null;
            try {
                String rev1;
                if (added || replaced) {
                    tmpFile = dir.getBaseFile(name, true);
                    SVNTranslator.translate(dir, name, name, SVNFileUtil.getBasePath(tmpFile), false, false);
                    String mimeType1 = null;
                    String mimeType2 = props.getPropertyValue("svn:mime-type");
                    String rev2 = "(revision " + Long.toString(entry.getRevision()) + ")";
                    rev1 = "(revision 0)";
                    this.myDiffGenerator.displayFileDiff(fullPath, null, tmpFile, rev1, rev2, mimeType1, mimeType2, result);
                    if (propDiff == null || propDiff.size() <= 0) continue;
                    this.myDiffGenerator.displayPropDiff(fullPath, baseProps, propDiff, result);
                    continue;
                }
                boolean isTextModified = dir.hasTextModifications(name, false);
                if (isTextModified) {
                    tmpFile = dir.getBaseFile(name, true);
                    SVNTranslator.translate(dir, name, name, SVNFileUtil.getBasePath(tmpFile), false, false);
                    String mimeType1 = (String)baseProps.get("svn:mime-type");
                    String mimeType2 = props.getPropertyValue("svn:mime-type");
                    rev1 = "(revision " + Long.toString(entry.getRevision()) + ")";
                    this.myDiffGenerator.displayFileDiff(fullPath, dir.getBaseFile(name, false), tmpFile, rev1, null, mimeType1, mimeType2, result);
                }
                if (propDiff == null || propDiff.size() <= 0) continue;
                this.myDiffGenerator.displayPropDiff(fullPath, baseProps, propDiff, result);
            }
            finally {
                if (tmpFile == null) continue;
                tmpFile.delete();
            }
        }
    }

    private SVNDirectoryInfo createDirInfo(SVNDirectoryInfo parent, String path, boolean added) {
        SVNDirectoryInfo info = new SVNDirectoryInfo();
        info.myParent = parent;
        info.myPath = path;
        info.myIsAdded = added;
        return info;
    }

    private SVNFileInfo createFileInfo(String path, boolean added) {
        SVNFileInfo info = new SVNFileInfo();
        info.myPath = path;
        info.myIsAdded = added;
        return info;
    }

    private static void reversePropChanges(Map base, Map diff) {
        ArrayList namesList = new ArrayList(diff.keySet());
        Iterator names = namesList.iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            String newValue = (String)diff.get(name);
            String oldValue = (String)base.get(name);
            if (oldValue == null && newValue != null) {
                base.put(name, newValue);
                diff.put(name, null);
                continue;
            }
            if (oldValue != null && newValue == null) {
                base.put(name, null);
                diff.put(name, oldValue);
                continue;
            }
            if (oldValue == null || newValue == null) continue;
            base.put(name, newValue);
            diff.put(name, oldValue);
        }
    }

    private static class SVNFileInfo {
        private boolean myIsAdded;
        private String myPath;
        private File myFile;
        private File myBaseFile;
        private Map myBaseProperties;
        private Map myPropertyDiff;
        private boolean myIsScheduledForDeletion;

        private SVNFileInfo() {
        }
    }

    private static class SVNDirectoryInfo {
        private boolean myIsAdded;
        private String myPath;
        private Map myBaseProperties;
        private Map myPropertyDiff;
        private SVNDirectoryInfo myParent;
        private Set myComparedEntries = new HashSet();

        private SVNDirectoryInfo() {
        }
    }
}

