/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNDirectory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNProperties;
import org.tmatesoft.svn.core.internal.wc.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.wc.SVNCommitItem;

public class SVNCommitMediator
implements ISVNWorkspaceMediator {
    private Collection myTmpFiles = new ArrayList();
    private Map myTmpFilesMap = new HashMap();
    private Map myWCPropsMap = new HashMap();
    private Map myCommitItems;

    public SVNCommitMediator(Map commitItems) {
        this.myCommitItems = commitItems;
    }

    public Map getWCProperties(SVNCommitItem item) {
        return (Map)this.myWCPropsMap.get(item);
    }

    public Collection getTmpFiles() {
        return this.myTmpFiles;
    }

    public String getWorkspaceProperty(String path, String name) throws SVNException {
        String target;
        SVNDirectory dir;
        SVNCommitItem item = (SVNCommitItem)this.myCommitItems.get(path);
        if (item == null) {
            return null;
        }
        SVNWCAccess wcAccess = item.getWCAccess();
        if (item.getKind() == SVNNodeKind.DIR) {
            dir = wcAccess.getDirectory(item.getPath());
            target = "";
        } else {
            dir = wcAccess.getDirectory(SVNPathUtil.removeTail(item.getPath()));
            target = SVNPathUtil.tail(item.getPath());
        }
        SVNProperties wcProps = dir.getWCProperties(target);
        return wcProps.getPropertyValue(name);
    }

    public void setWorkspaceProperty(String path, String name, String value) throws SVNException {
        if (name == null) {
            return;
        }
        SVNCommitItem item = (SVNCommitItem)this.myCommitItems.get(path);
        if (!this.myWCPropsMap.containsKey(item)) {
            this.myWCPropsMap.put(item, new HashMap());
        }
        ((Map)this.myWCPropsMap.get(item)).put(name, value);
    }

    public OutputStream createTemporaryLocation(String path, Object id) throws SVNException {
        String target;
        SVNDirectory dir;
        SVNCommitItem item = (SVNCommitItem)this.myCommitItems.get(path);
        SVNWCAccess wcAccess = item.getWCAccess();
        if (item.getKind() == SVNNodeKind.DIR) {
            dir = wcAccess.getDirectory(item.getPath());
            target = "";
        } else {
            dir = wcAccess.getDirectory(SVNPathUtil.removeTail(item.getPath()));
            target = SVNPathUtil.tail(item.getPath());
        }
        File tmpFile = dir.getAdminFile("tmp/text-base");
        tmpFile = SVNFileUtil.createUniqueFile(tmpFile, target, ".tmp");
        this.myTmpFiles.add(tmpFile);
        this.myTmpFilesMap.put(id, tmpFile);
        return SVNFileUtil.openFileForWriting(tmpFile);
    }

    public InputStream getTemporaryLocation(Object id) throws SVNException {
        File file = (File)this.myTmpFilesMap.get(id);
        return SVNFileUtil.openFileForReading(file);
    }

    public long getLength(Object id) throws SVNException {
        File file = (File)this.myTmpFilesMap.get(id);
        if (file != null) {
            return file.length();
        }
        return 0L;
    }

    public void deleteTemporaryLocation(Object id) {
        File file = (File)this.myTmpFilesMap.remove(id);
        if (file != null) {
            file.delete();
            this.myTmpFiles.remove(file);
        }
    }
}

