/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.OutputStream;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;

public class SVNCancellableEditor
implements ISVNEditor {
    private ISVNEditor myDelegate;
    private ISVNEventHandler myCancel;

    public static ISVNEditor newInstance(ISVNEditor editor, ISVNEventHandler cancel) {
        if (cancel != null) {
            return new SVNCancellableEditor(editor, cancel);
        }
        return editor;
    }

    private SVNCancellableEditor(ISVNEditor delegate, ISVNEventHandler cancel) {
        this.myDelegate = delegate;
        this.myCancel = cancel;
    }

    public void targetRevision(long revision) throws SVNException {
        this.myCancel.checkCancelled();
        this.myDelegate.targetRevision(revision);
    }

    public void openRoot(long revision) throws SVNException {
        this.myCancel.checkCancelled();
        this.myDelegate.openRoot(revision);
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        this.myCancel.checkCancelled();
        this.myDelegate.deleteEntry(path, revision);
    }

    public void absentDir(String path) throws SVNException {
        this.myCancel.checkCancelled();
        this.myDelegate.absentDir(path);
    }

    public void absentFile(String path) throws SVNException {
        this.myCancel.checkCancelled();
        this.myDelegate.absentFile(path);
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCancel.checkCancelled();
        this.myDelegate.addDir(path, copyFromPath, copyFromRevision);
    }

    public void openDir(String path, long revision) throws SVNException {
        this.myCancel.checkCancelled();
        this.myDelegate.openDir(path, revision);
    }

    public void changeDirProperty(String name, String value) throws SVNException {
        this.myCancel.checkCancelled();
        this.myDelegate.changeDirProperty(name, value);
    }

    public void closeDir() throws SVNException {
        this.myCancel.checkCancelled();
        this.myDelegate.closeDir();
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCancel.checkCancelled();
        this.myDelegate.addFile(path, copyFromPath, copyFromRevision);
    }

    public void openFile(String path, long revision) throws SVNException {
        this.myCancel.checkCancelled();
        this.myDelegate.openFile(path, revision);
    }

    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        this.myCancel.checkCancelled();
        this.myDelegate.applyTextDelta(path, baseChecksum);
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        return this.myDelegate.textDeltaChunk(path, diffWindow);
    }

    public void textDeltaEnd(String path) throws SVNException {
        this.myDelegate.textDeltaEnd(path);
    }

    public void changeFileProperty(String path, String name, String value) throws SVNException {
        this.myCancel.checkCancelled();
        this.myDelegate.changeFileProperty(path, name, value);
    }

    public void closeFile(String path, String textChecksum) throws SVNException {
        this.myCancel.checkCancelled();
        this.myDelegate.closeFile(path, textChecksum);
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        this.myCancel.checkCancelled();
        return this.myDelegate.closeEdit();
    }

    public void abortEdit() throws SVNException {
        this.myDelegate.abortEdit();
    }
}

