/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SVNAdminUtil {
    private static final byte[] FORMAT_TEXT;
    private static final byte[] README_TEXT;
    private static final boolean SKIP_README;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createReadmeFile(File adminDir) throws SVNException {
        if (SKIP_README) {
            return;
        }
        OutputStream os = null;
        try {
            os = SVNFileUtil.openFileForWriting(new File(adminDir, "README.txt"));
            os.write(README_TEXT);
        }
        catch (IOException e) {
            try {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                SVNErrorManager.error(err, e);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(os);
                throw throwable;
            }
            SVNFileUtil.closeFile(os);
        }
        SVNFileUtil.closeFile(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFormatFile(File adminDir) throws SVNException {
        OutputStream os = null;
        try {
            os = SVNFileUtil.openFileForWriting(new File(adminDir, "format"));
            os.write(FORMAT_TEXT);
        }
        catch (IOException e) {
            try {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                SVNErrorManager.error(err, e);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(os);
                throw throwable;
            }
            SVNFileUtil.closeFile(os);
        }
        SVNFileUtil.closeFile(os);
    }

    static {
        String eol = System.getProperty("line.separator");
        FORMAT_TEXT = new byte[]{52, 10};
        README_TEXT = ("This is a Subversion working copy administrative directory." + eol + "Visit http://subversion.tigris.org/ for more information." + eol).getBytes();
        SKIP_README = Boolean.getBoolean("javasvn.skipReadme");
    }
}

