/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import de.regnis.q.sequence.QSequenceDifferenceBlock;
import de.regnis.q.sequence.core.QSequenceException;
import de.regnis.q.sequence.line.QSequenceLine;
import de.regnis.q.sequence.line.QSequenceLineCache;
import de.regnis.q.sequence.line.QSequenceLineMedia;
import de.regnis.q.sequence.line.QSequenceLineRAData;
import de.regnis.q.sequence.line.QSequenceLineResult;
import java.io.IOException;
import java.io.OutputStream;
import org.tmatesoft.svn.core.internal.wc.FSMergerBySequenceList;
import org.tmatesoft.svn.util.SVNDebugLog;

class FSMergerBySequence {
    public static final String DEFAULT_EOL = System.getProperty("line.separator");
    public static final int NOT_MODIFIED = 0;
    public static final int MERGED = 4;
    public static final int CONFLICTED = 2;
    private final byte[] myConflictStart;
    private final byte[] myConflictSeparator;
    private final byte[] myConflictEnd;

    public FSMergerBySequence(byte[] conflictStart, byte[] conflictSeparator, byte[] conflictEnd) {
        this.myConflictStart = conflictStart;
        this.myConflictSeparator = conflictSeparator;
        this.myConflictEnd = conflictEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int merge(QSequenceLineRAData baseData, QSequenceLineRAData localData, QSequenceLineRAData latestData, OutputStream result) throws IOException {
        QSequenceLineResult latestResult;
        QSequenceLineResult localResult;
        try {
            localResult = QSequenceLineMedia.createBlocks(baseData, localData);
            latestResult = QSequenceLineMedia.createBlocks(baseData, latestData);
        }
        catch (QSequenceException ex) {
            throw new IOException(ex.getMessage());
        }
        try {
            QSequenceLineCache baseLines = localResult.getLeftCache();
            QSequenceLineCache localLines = localResult.getRightCache();
            QSequenceLineCache latestLines = latestResult.getRightCache();
            FSMergerBySequenceList local = new FSMergerBySequenceList(localResult.getBlocks());
            FSMergerBySequenceList latest = new FSMergerBySequenceList(latestResult.getBlocks());
            int baseLineIndex = -1;
            boolean conflict = false;
            boolean merged = false;
            while (local.hasCurrent() || latest.hasCurrent()) {
                if (local.hasCurrent() && latest.hasCurrent() && this.isEqualChange(local.current(), latest.current(), localLines, latestLines)) {
                    baseLineIndex = this.appendLines(result, local.current(), localLines, baseLineIndex);
                    local.forward();
                    latest.forward();
                    continue;
                }
                if (local.hasCurrent() && latest.hasCurrent()) {
                    QSequenceDifferenceBlock localStartBlock = local.current();
                    QSequenceDifferenceBlock latestStartBlock = latest.current();
                    if (this.checkConflict(local, latest, localLines, latestLines, baseLines.getLineCount())) {
                        baseLineIndex = this.createConflict(result, localStartBlock, local.current(), latestStartBlock, latest.current(), baseLines, localLines, latestLines, baseLineIndex);
                        local.forward();
                        latest.forward();
                        conflict = true;
                        continue;
                    }
                }
                if (local.hasCurrent() && this.isBefore(local.current(), latest.hasCurrent() ? latest.current() : null)) {
                    baseLineIndex = this.appendLines(result, local.current(), localLines, baseLineIndex);
                    local.forward();
                    merged = true;
                    continue;
                }
                if (!latest.hasCurrent()) continue;
                baseLineIndex = this.appendLines(result, latest.current(), latestLines, baseLineIndex);
                latest.forward();
                merged = true;
            }
            ++baseLineIndex;
            while (baseLineIndex < baseLines.getLineCount()) {
                this.writeLine(result, baseLines.getLine(baseLineIndex));
                ++baseLineIndex;
            }
            if (conflict) {
                int n = 2;
                return n;
            }
            if (merged) {
                int n = 4;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            latestResult.close();
            localResult.close();
        }
    }

    private boolean isBefore(QSequenceDifferenceBlock block1, QSequenceDifferenceBlock block2) {
        return block1 != null && (block2 == null || block1.getLeftTo() < block2.getLeftFrom());
    }

    private boolean intersect(QSequenceDifferenceBlock block1, QSequenceDifferenceBlock block2, int baseLineCount) {
        int from1 = block1.getLeftFrom();
        int from2 = block2.getLeftFrom();
        int to1 = block1.getLeftTo();
        int to2 = block2.getLeftTo();
        if (to1 < from1) {
            if (to2 < from2) {
                return from1 == from2;
            }
            if (from1 == baseLineCount && to2 >= baseLineCount - 1) {
                return true;
            }
            return from1 >= from2 && from1 <= to2;
        }
        if (to2 < from2) {
            if (from2 == baseLineCount && to1 >= baseLineCount - 1) {
                return true;
            }
            return from2 >= from1 && from2 <= to1;
        }
        return from1 >= from2 && from1 <= to2 || from2 >= from1 && from2 <= to1;
    }

    private int appendLines(OutputStream result, QSequenceDifferenceBlock block, QSequenceLineCache changedLines, int baseLineIndex) throws IOException {
        for (int equalLineIndex = block.getRightFrom() - (block.getLeftFrom() - 1 - baseLineIndex); equalLineIndex < block.getRightFrom(); ++equalLineIndex) {
            this.writeLine(result, changedLines.getLine(equalLineIndex));
        }
        for (int changedLineIndex = block.getRightFrom(); changedLineIndex <= block.getRightTo(); ++changedLineIndex) {
            this.writeLine(result, changedLines.getLine(changedLineIndex));
        }
        return block.getLeftTo();
    }

    private boolean isEqualChange(QSequenceDifferenceBlock localBlock, QSequenceDifferenceBlock latestBlock, QSequenceLineCache localLines, QSequenceLineCache latestLines) throws IOException {
        if (localBlock.getLeftFrom() != latestBlock.getLeftFrom() || localBlock.getLeftTo() != latestBlock.getLeftTo()) {
            return false;
        }
        if (localBlock.getRightTo() - localBlock.getRightFrom() != latestBlock.getRightTo() - latestBlock.getRightFrom()) {
            return false;
        }
        for (int index = 0; index < localBlock.getRightTo() - localBlock.getRightFrom() + 1; ++index) {
            QSequenceLine latestLine;
            QSequenceLine localLine = localLines.getLine(localBlock.getRightFrom() + index);
            if (localLine.equals(latestLine = latestLines.getLine(latestBlock.getRightFrom() + index))) continue;
            return false;
        }
        return true;
    }

    private boolean checkConflict(FSMergerBySequenceList localChanges, FSMergerBySequenceList latestChanges, QSequenceLineCache localLines, QSequenceLineCache latestLines, int baseLineCount) throws IOException {
        boolean conflict = false;
        while (this.intersect(localChanges.current(), latestChanges.current(), baseLineCount) && !this.isEqualChange(localChanges.current(), latestChanges.current(), localLines, latestLines)) {
            conflict = true;
            if (localChanges.current().getLeftTo() <= latestChanges.current().getLeftTo()) {
                if (!localChanges.hasNext() || !this.intersect(localChanges.peekNext(), latestChanges.current(), baseLineCount)) break;
                localChanges.forward();
                continue;
            }
            if (!latestChanges.hasNext() || !this.intersect(localChanges.current(), latestChanges.peekNext(), baseLineCount)) break;
            latestChanges.forward();
        }
        return conflict;
    }

    private int createConflict(OutputStream result, QSequenceDifferenceBlock localStart, QSequenceDifferenceBlock localEnd, QSequenceDifferenceBlock latestStart, QSequenceDifferenceBlock latestEnd, QSequenceLineCache baseLines, QSequenceLineCache localLines, QSequenceLineCache latestLines, int baseLineIndex) throws IOException {
        int index;
        int minBaseFrom = Math.min(localStart.getLeftFrom(), latestStart.getLeftFrom());
        int maxBaseTo = Math.max(localEnd.getLeftTo(), latestEnd.getLeftTo());
        ++baseLineIndex;
        while (baseLineIndex < minBaseFrom) {
            this.writeLine(result, baseLines.getLine(baseLineIndex));
            ++baseLineIndex;
        }
        int localFrom = Math.max(0, localStart.getRightFrom() - (localStart.getLeftFrom() - minBaseFrom));
        int localTo = Math.min(localLines.getLineCount() - 1, localEnd.getRightTo() + (maxBaseTo - localEnd.getLeftTo()));
        int latestFrom = Math.max(0, latestStart.getRightFrom() - (latestStart.getLeftFrom() - minBaseFrom));
        int latestTo = Math.min(latestLines.getLineCount() - 1, latestEnd.getRightTo() + (maxBaseTo - latestEnd.getLeftTo()));
        this.writeBytesAndEol(result, this.myConflictStart);
        for (index = localFrom; index <= localTo; ++index) {
            this.writeLine(result, localLines.getLine(index));
        }
        this.writeBytesAndEol(result, this.myConflictSeparator);
        for (index = latestFrom; index <= latestTo; ++index) {
            this.writeLine(result, latestLines.getLine(index));
        }
        this.writeBytesAndEol(result, this.myConflictEnd);
        return maxBaseTo;
    }

    private void writeLine(OutputStream os, QSequenceLine line) throws IOException {
        byte[] bytes = line.getBytes();
        if (bytes.length == 0) {
            return;
        }
        os.write(bytes);
    }

    private void writeBytesAndEol(OutputStream os, byte[] bytes) throws IOException {
        if (bytes.length > 0) {
            os.write(bytes);
            os.write(DEFAULT_EOL.getBytes());
        }
    }

    public static void dump(String name, QSequenceLineRAData data) throws IOException {
        SVNDebugLog.logInfo("=== " + name + " ===");
        byte[] buffer = new byte[(int)data.length()];
        data.get(buffer, 0L, data.length());
        SVNDebugLog.logInfo(new String(buffer));
        SVNDebugLog.logInfo("===");
    }
}

