/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.util.SVNDebugLog;

public class EclipseSVNAuthenticationManager
extends DefaultSVNAuthenticationManager {
    private static URL DEFAULT_URL;

    public EclipseSVNAuthenticationManager(File configDirectory, boolean storeAuth, String userName, String password) {
        super(configDirectory, storeAuth, userName, password);
    }

    protected ISVNAuthenticationProvider createCacheAuthenticationProvider(File authDir) {
        return new KeyringAuthenticationProvider();
    }

    protected ISVNAuthenticationProvider createDefaultAuthenticationProvider(String userName, String password, boolean allowSave) {
        return new ISVNAuthenticationProvider(){

            public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
                return null;
            }

            public int acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored) {
                return 2;
            }
        };
    }

    static {
        try {
            DEFAULT_URL = new URL("http://tmate.org/svn/");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    static class KeyringAuthenticationProvider
    implements ISVNAuthenticationProvider,
    DefaultSVNAuthenticationManager.IPersistentAuthenticationProvider {
        KeyringAuthenticationProvider() {
        }

        public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
            realm = realm == null ? DEFAULT_URL.toString() : realm;
            Map info = Platform.getAuthorizationInfo((URL)DEFAULT_URL, (String)realm, (String)kind);
            if (info != null && "svn.ssl".equals(kind)) {
                String path = (String)info.get("cert");
                String password = (String)info.get("password");
                if (path != null) {
                    return new SVNSSLAuthentication(new File(path), password, authMayBeStored);
                }
            } else if (info != null && !info.isEmpty() && info.get("username") != null) {
                if ("svn.simple".equals(kind)) {
                    return new SVNPasswordAuthentication((String)info.get("username"), (String)info.get("password"), authMayBeStored);
                }
                if ("svn.ssh".equals(kind)) {
                    int port = -1;
                    SVNDebugLog.logInfo("loading ssh auth, from keyring");
                    if (info.get("port") != null) {
                        port = Integer.parseInt((String)info.get("port"));
                    }
                    SVNDebugLog.logInfo("stored port: " + port);
                    if (port < 0) {
                        port = url.getPort();
                        SVNDebugLog.logInfo("URL port: " + port);
                    }
                    if (port < 0) {
                        port = 22;
                        SVNDebugLog.logInfo("default port: " + port);
                    }
                    SVNDebugLog.logInfo("using port: " + port);
                    if (info.get("key") != null) {
                        File keyPath = new File((String)info.get("key"));
                        return new SVNSSHAuthentication((String)info.get("username"), keyPath, (String)info.get("passphrase"), port, authMayBeStored);
                    }
                    if (info.get("password") != null) {
                        return new SVNSSHAuthentication((String)info.get("username"), (String)info.get("password"), port, authMayBeStored);
                    }
                }
            }
            return null;
        }

        public int acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored) {
            return 1;
        }

        public void saveAuthentication(SVNAuthentication auth, String kind, String realm) {
            if (!(auth instanceof SVNSSLAuthentication) && (auth.getUserName() == null || "".equals(auth.getUserName()))) {
                return;
            }
            realm = realm == null ? DEFAULT_URL.toString() : realm;
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("username", auth.getUserName());
            if (auth instanceof SVNPasswordAuthentication) {
                info.put("password", ((SVNPasswordAuthentication)auth).getPassword());
            } else if (auth instanceof SVNSSHAuthentication) {
                SVNDebugLog.logInfo("saving SSH auth: " + auth);
                SVNSSHAuthentication sshAuth = (SVNSSHAuthentication)auth;
                if (sshAuth.getPrivateKeyFile() != null) {
                    info.put("key", sshAuth.getPrivateKeyFile().getAbsolutePath());
                    if (sshAuth.getPassphrase() != null) {
                        info.put("passphrase", sshAuth.getPassphrase());
                    }
                } else if (sshAuth.getPassword() != null) {
                    info.put("password", sshAuth.getPassword());
                }
                if (sshAuth.getPortNumber() >= 0) {
                    SVNDebugLog.logInfo("saving port number: " + sshAuth.getPortNumber());
                    info.put("port", Integer.toString(sshAuth.getPortNumber()));
                } else {
                    SVNDebugLog.logInfo("not saving port number: " + sshAuth.getPortNumber());
                }
            } else if (auth instanceof SVNSSLAuthentication) {
                SVNSSLAuthentication sslAuth = (SVNSSLAuthentication)auth;
                File path = sslAuth.getCertificateFile();
                String password = sslAuth.getPassword();
                if (path != null) {
                    info.put("cert", path.getAbsolutePath());
                    if (password != null && !"".equals(password)) {
                        info.put("password", password);
                    }
                }
            }
            try {
                Platform.addAuthorizationInfo((URL)DEFAULT_URL, (String)realm, (String)kind, info);
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
    }
}

