/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.StringTokenizer;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.auth.ISVNSSLManager;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;

public class SVNSocketFactory {
    private static final ISVNSSLManager DEFAULT_SSL_MANAGER = new ISVNSSLManager(){

        public SSLContext getSSLContext() throws IOException {
            SSLContext context = null;
            try {
                context = SSLContext.getInstance("SSL");
                context.init(new KeyManager[0], new TrustManager[]{new X509TrustManager(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                    }

                    public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                    }
                }}, null);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(e.getMessage());
            }
            catch (KeyManagementException e) {
                throw new IOException(e.getMessage());
            }
            return context;
        }

        public void acknowledgeSSLContext(boolean accepted, SVNErrorMessage errorMessage) {
        }

        public boolean isClientCertPromptRequired() {
            return false;
        }

        public void setClientAuthentication(SVNSSLAuthentication sslAuthentication) {
        }

        public SVNSSLAuthentication getClientAuthentication() {
            return null;
        }
    };
    static /* synthetic */ Class class$java$net$SocketTimeoutException;

    public static Socket createPlainSocket(String host, int port) throws IOException {
        InetAddress address = SVNSocketFactory.createAddres(host);
        Socket socket = new Socket(address, port);
        socket.setTcpNoDelay(true);
        socket.setKeepAlive(true);
        socket.setReuseAddress(true);
        return socket;
    }

    public static Socket createSSLSocket(ISVNSSLManager manager, String host, int port) throws IOException {
        manager = manager == null ? DEFAULT_SSL_MANAGER : manager;
        Socket sslSocket = manager.getSSLContext().getSocketFactory().createSocket(SVNSocketFactory.createAddres(host), port);
        sslSocket.setTcpNoDelay(true);
        sslSocket.setKeepAlive(true);
        sslSocket.setReuseAddress(true);
        return sslSocket;
    }

    public static Socket createSSLSocket(ISVNSSLManager manager, String host, int port, Socket socket) throws IOException {
        manager = manager == null ? DEFAULT_SSL_MANAGER : manager;
        Socket sslSocket = manager.getSSLContext().getSocketFactory().createSocket(socket, host, port, true);
        sslSocket.setTcpNoDelay(true);
        sslSocket.setKeepAlive(true);
        sslSocket.setReuseAddress(true);
        return sslSocket;
    }

    private static InetAddress createAddres(String hostName) throws UnknownHostException {
        byte[] bytes = new byte[4];
        int index = 0;
        StringTokenizer tokens = new StringTokenizer(hostName, ".");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            try {
                byte b = (byte)Integer.parseInt(token);
                if (index < bytes.length) {
                    bytes[index] = b;
                    ++index;
                    continue;
                }
                bytes = null;
            }
            catch (NumberFormatException e) {
                bytes = null;
            }
            break;
        }
        if (bytes != null && index == 4) {
            return InetAddress.getByAddress(hostName, bytes);
        }
        return InetAddress.getByName(hostName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSocketStale(Socket socket) throws IOException {
        boolean isStale;
        block10: {
            isStale = true;
            if (socket != null) {
                isStale = false;
                try {
                    if (socket.getInputStream().available() != 0) break block10;
                    int timeout = socket.getSoTimeout();
                    try {
                        socket.setSoTimeout(1);
                        socket.getInputStream().mark(1);
                        int byteRead = socket.getInputStream().read();
                        if (byteRead == -1) {
                            isStale = true;
                        } else {
                            socket.getInputStream().reset();
                        }
                    }
                    finally {
                        socket.setSoTimeout(timeout);
                    }
                }
                catch (InterruptedIOException e) {
                    if (!(class$java$net$SocketTimeoutException == null ? (class$java$net$SocketTimeoutException = SVNSocketFactory.class$("java.net.SocketTimeoutException")) : class$java$net$SocketTimeoutException).isInstance(e)) {
                        throw e;
                    }
                }
                catch (IOException e) {
                    isStale = true;
                }
            }
        }
        return isStale;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

