/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.tmatesoft.svn.util.ISVNDebugLogger;

public class SVNLogOutputStream
extends FilterOutputStream {
    private ISVNDebugLogger myLogger;
    private ByteArrayOutputStream myBuffer;

    public SVNLogOutputStream(OutputStream out, ISVNDebugLogger logger) {
        super(out);
        this.myLogger = logger;
        this.myBuffer = new ByteArrayOutputStream(2048);
    }

    public void close() throws IOException {
        super.close();
        this.flushBuffer(true);
    }

    public void flush() throws IOException {
        super.flush();
        this.flushBuffer(true);
    }

    public void write(int b) throws IOException {
        super.write(b);
        if (this.myBuffer != null) {
            this.myBuffer.write(b);
        }
        this.flushBuffer(false);
    }

    public void flushBuffer(boolean force) {
        if (!force && this.myBuffer.size() < 1024) {
            return;
        }
        if (this.myLogger != null && this.myBuffer.size() > 0) {
            this.myLogger.log("SENT", this.myBuffer.toByteArray());
        }
        this.myBuffer.reset();
    }
}

