/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tmatesoft.svn.util.ISVNDebugLogger;

public class SVNLogInputStream
extends FilterInputStream {
    private ISVNDebugLogger myLogger;
    private ByteArrayOutputStream myBuffer;

    public SVNLogInputStream(InputStream in, ISVNDebugLogger logger) {
        super(in);
        this.myLogger = logger;
        this.myBuffer = new ByteArrayOutputStream(2048);
    }

    public int read() throws IOException {
        int r = super.read();
        if (r >= 0) {
            this.log(new byte[]{(byte)r}, 0, 1);
        }
        return r;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        if (read > 0) {
            this.log(b, off, read);
        }
        return read;
    }

    public void close() throws IOException {
        super.close();
        this.flushBuffer(true);
    }

    private void log(byte[] data, int off, int len) {
        if (this.myLogger != null && len > 0 && off + len <= data.length && off < data.length) {
            this.myBuffer.write(data, off, len);
            this.flushBuffer(false);
        }
    }

    public void flushBuffer(boolean force) {
        if (!force && this.myBuffer.size() < 1024) {
            return;
        }
        if (this.myLogger != null && this.myBuffer.size() > 0) {
            this.myLogger.log("READ", this.myBuffer.toByteArray());
        }
        this.myBuffer.reset();
    }
}

