/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class SVNFormatUtil {
    private static final DateFormat HUMAN_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss' 'ZZZZ' ('E', 'dd' 'MMM' 'yyyy')'");
    private static final DateFormat SHORT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss'Z'");
    private static final Date NULL_DATE = new Date(0L);

    public static String formatDate(Date date, boolean longFormat) {
        if (longFormat) {
            return HUMAN_DATE_FORMAT.format(date != null ? date : NULL_DATE);
        }
        return SHORT_DATE_FORMAT.format(date != null ? date : NULL_DATE);
    }

    public static String formatString(String src, int width, boolean left) {
        if (src.length() > width) {
            return src.substring(0, width);
        }
        StringBuffer formatted = new StringBuffer();
        if (left) {
            formatted.append(src);
        }
        for (int i = 0; i < width - src.length(); ++i) {
            formatted.append(' ');
        }
        if (!left) {
            formatted.append(src);
        }
        return formatted.toString();
    }

    public static String formatPath(File file) {
        String path = file.getAbsolutePath();
        String rootPath = new File("").getAbsolutePath();
        if ((path = path.replace(File.separatorChar, '/')).equals(rootPath = rootPath.replace(File.separatorChar, '/'))) {
            path = "";
        } else if (path.startsWith(rootPath + "/")) {
            path = path.substring(rootPath.length() + 1);
        }
        path = SVNFormatUtil.condensePath(path);
        path = path.replace('/', File.separatorChar);
        if (path.trim().length() == 0) {
            path = ".";
        }
        return path;
    }

    private static String condensePath(String path) {
        StringBuffer result = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(path, "/", true);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (".".equals(token)) {
                String nextToken;
                if (!tokens.hasMoreTokens() || (nextToken = tokens.nextToken()).equals("/")) continue;
                result.append(nextToken);
                continue;
            }
            result.append(token);
        }
        return result.toString();
    }

    static {
        SHORT_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        HUMAN_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

