/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.svn.SVNConnection;
import org.tmatesoft.svn.core.internal.io.svn.SVNReader;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindowBuilder;

class SVNCommitEditor
implements ISVNEditor {
    private SVNConnection myConnection;
    private SVNRepositoryImpl myRepository;
    private String myCurrentPath;
    private Runnable myCloseCallback;
    private int myDiffWindowCount = 0;
    private boolean myIsAborted;

    public SVNCommitEditor(SVNRepositoryImpl location, SVNConnection connection, Runnable closeCallback) {
        this.myRepository = location;
        this.myConnection = connection;
        this.myCloseCallback = closeCallback;
    }

    public void targetRevision(long revision) throws SVNException {
    }

    public void absentDir(String path) throws SVNException {
    }

    public void absentFile(String path) throws SVNException {
    }

    public void openRoot(long revision) throws SVNException {
        this.myCurrentPath = "";
        this.myConnection.write("(w((n)s))", new Object[]{"open-root", SVNCommitEditor.getRevisionObject(revision), ""});
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        this.myConnection.write("(w(s(n)s))", new Object[]{"delete-entry", path, SVNCommitEditor.getRevisionObject(revision), this.myCurrentPath});
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        if (copyFromPath != null) {
            String rootURL = this.myRepository.getRepositoryRoot(false).toString();
            copyFromPath = SVNPathUtil.append(rootURL, SVNEncodingUtil.uriEncode(this.myRepository.getRepositoryPath(copyFromPath)));
            this.myConnection.write("(w(sss(sn)))", new Object[]{"add-dir", path, this.myCurrentPath, path, copyFromPath, SVNCommitEditor.getRevisionObject(copyFromRevision)});
        } else {
            this.myConnection.write("(w(sss()))", new Object[]{"add-dir", path, this.myCurrentPath, path});
        }
        this.myCurrentPath = path;
    }

    public void openDir(String path, long revision) throws SVNException {
        this.myCurrentPath = path;
        this.myConnection.write("(w(sss(n)))", new Object[]{"open-dir", path, SVNCommitEditor.computeParentPath(path), path, SVNCommitEditor.getRevisionObject(revision)});
    }

    public void changeDirProperty(String name, String value) throws SVNException {
        this.myConnection.write("(w(ss(s)))", new Object[]{"change-dir-prop", this.myCurrentPath, name, value});
    }

    public void closeDir() throws SVNException {
        this.myConnection.write("(w(s))", new Object[]{"close-dir", this.myCurrentPath});
        this.myCurrentPath = SVNCommitEditor.computeParentPath(this.myCurrentPath);
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        if (copyFromPath != null) {
            String host = this.myRepository.getRepositoryRoot(false).toString();
            copyFromPath = SVNPathUtil.append(host, SVNEncodingUtil.uriEncode(this.myRepository.getRepositoryPath(copyFromPath)));
            this.myConnection.write("(w(sss(sn)))", new Object[]{"add-file", path, this.myCurrentPath, path, copyFromPath, SVNCommitEditor.getRevisionObject(copyFromRevision)});
        } else {
            this.myConnection.write("(w(sss()))", new Object[]{"add-file", path, this.myCurrentPath, path});
        }
    }

    public void openFile(String path, long revision) throws SVNException {
        this.myConnection.write("(w(sss(n)))", new Object[]{"open-file", path, SVNCommitEditor.computeParentPath(path), path, SVNCommitEditor.getRevisionObject(revision)});
    }

    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        this.myDiffWindowCount = 0;
        this.myConnection.write("(w(s(s)))", new Object[]{"apply-textdelta", path, baseChecksum});
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        this.myConnection.write("(w(s", new Object[]{"textdelta-chunk", path});
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            SVNDiffWindowBuilder.save(diffWindow, this.myDiffWindowCount == 0, bos);
            byte[] header = bos.toByteArray();
            ++this.myDiffWindowCount;
            this.myConnection.write("b))", new Object[]{header});
            this.myConnection.write("(w(s", new Object[]{"textdelta-chunk", path});
            String length = diffWindow.getNewDataLength() + ":";
            this.myConnection.getOutputStream().write(length.getBytes("UTF-8"));
            return new ChunkOutputStream();
        }
        catch (IOException e) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, e.getMessage()), e);
            return null;
        }
    }

    public void textDeltaEnd(String path) throws SVNException {
        this.myDiffWindowCount = 0;
        this.myConnection.write("(w(s))", new Object[]{"textdelta-end", path});
    }

    public void changeFileProperty(String path, String name, String value) throws SVNException {
        this.myConnection.write("(w(ss(s)))", new Object[]{"change-file-prop", path, name, value});
    }

    public void closeFile(String path, String textChecksum) throws SVNException {
        this.myDiffWindowCount = 0;
        this.myConnection.write("(w(s(s)))", new Object[]{"close-file", path, textChecksum});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNCommitInfo closeEdit() throws SVNException {
        try {
            this.myConnection.write("(w())", new Object[]{"close-edit"});
            this.myConnection.read("[()]", null);
            this.myRepository.authenticate();
            Object[] items = this.myConnection.read("(N(?S)(?S))", new Object[3]);
            long revision = SVNReader.getLong(items, 0);
            Date date = SVNReader.getDate(items, 1);
            SVNCommitInfo sVNCommitInfo = new SVNCommitInfo(revision, (String)items[2], date);
            return sVNCommitInfo;
        }
        finally {
            this.myCloseCallback.run();
            this.myCloseCallback = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortEdit() throws SVNException {
        if (this.myIsAborted || this.myCloseCallback == null) {
            return;
        }
        this.myIsAborted = true;
        try {
            this.myConnection.write("(w())", new Object[]{"abort-edit"});
        }
        finally {
            this.myCloseCallback.run();
            this.myCloseCallback = null;
        }
    }

    private static String computeParentPath(String path) {
        return SVNPathUtil.removeTail(path);
    }

    private static Long getRevisionObject(long rev) {
        return rev >= 0L ? new Long(rev) : null;
    }

    private final class ChunkOutputStream
    extends OutputStream {
        private boolean myIsClosed = false;

        private ChunkOutputStream() {
        }

        public void write(byte[] b, int off, int len) throws IOException {
            try {
                SVNCommitEditor.this.myConnection.getOutputStream().write(b, off, len);
            }
            catch (SVNException e) {
                throw new IOException(e.getMessage());
            }
        }

        public void write(int b) throws IOException {
            try {
                SVNCommitEditor.this.myConnection.getOutputStream().write(b);
            }
            catch (SVNException e) {
                throw new IOException(e.getMessage());
            }
        }

        public void close() throws IOException {
            if (this.myIsClosed) {
                return;
            }
            try {
                SVNCommitEditor.this.myConnection.getOutputStream().write(32);
                SVNCommitEditor.this.myConnection.write("))", null);
            }
            catch (SVNException e) {
                throw new IOException(e.getMessage());
            }
            finally {
                this.myIsClosed = true;
            }
        }
    }
}

