/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.io.File;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVBaselineInfo;
import org.tmatesoft.svn.core.internal.io.dav.DAVConnection;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.DAVUtil;
import org.tmatesoft.svn.core.internal.util.IMeasurable;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;

class DAVResource {
    private String myWURL;
    private String myVURL;
    private String myURL;
    private String myPath;
    private ISVNWorkspaceMediator myMediator;
    private long myRevision;
    private boolean myIsCopy;
    private DAVConnection myConnection;
    private List myDeltaFiles;
    private Map myProperties;
    private boolean myIsAdded;

    public DAVResource(ISVNWorkspaceMediator mediator, DAVConnection connection, String path, long revision) {
        this(mediator, connection, path, revision, false);
    }

    public DAVResource(ISVNWorkspaceMediator mediator, DAVConnection connection, String path, long revision, boolean isCopy) {
        this.myPath = path;
        this.myMediator = mediator;
        String locationPath = SVNEncodingUtil.uriEncode(connection.getLocation().getPath());
        this.myURL = SVNPathUtil.append(locationPath, path);
        this.myRevision = revision;
        this.myConnection = connection;
        this.myIsCopy = isCopy;
    }

    public void setAdded(boolean added) {
        this.myIsAdded = added;
    }

    public boolean isAdded() {
        return this.myIsAdded;
    }

    public boolean isCopy() {
        return this.myIsCopy;
    }

    public String getURL() {
        return this.myURL;
    }

    public String getPath() {
        return this.myPath;
    }

    public String getVersionURL() throws SVNException {
        if (this.myVURL == null && this.myMediator != null) {
            this.myVURL = this.myMediator.getWorkspaceProperty(SVNEncodingUtil.uriDecode(this.myPath), "svn:wc:ra_dav:version-url");
        }
        return this.myVURL;
    }

    public void fetchVersionURL(boolean force) throws SVNException {
        if (!force && this.getVersionURL() != null) {
            return;
        }
        String path = this.myURL;
        if (this.myRevision >= 0L) {
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, null, path, this.myRevision, false, false, null);
            path = SVNPathUtil.append(info.baselineBase, info.baselinePath);
        }
        this.myVURL = DAVUtil.getPropertyValue(this.myConnection, path, null, DAVElement.CHECKED_IN);
    }

    public String getWorkingURL() {
        return this.myWURL;
    }

    public OutputStream addTextDelta() throws SVNException {
        if (this.myDeltaFiles == null) {
            this.myDeltaFiles = new LinkedList();
        }
        if (this.myMediator != null) {
            Integer id = new Integer(this.myDeltaFiles.size());
            this.myDeltaFiles.add(id);
            return this.myMediator.createTemporaryLocation(SVNEncodingUtil.uriDecode(this.myPath), id);
        }
        File tempFile = SVNFileUtil.createTempFile(".javasvn.", ".tmp");
        tempFile.deleteOnExit();
        this.myDeltaFiles.add(tempFile);
        return SVNFileUtil.openFileForWriting(tempFile);
    }

    public int getDeltaCount() {
        return this.myDeltaFiles == null ? 0 : this.myDeltaFiles.size();
    }

    public InputStream getTextDelta(int i) throws SVNException {
        if (this.myMediator != null) {
            long length = this.myMediator.getLength(new Integer(i));
            return new MeasurableStream(this.myMediator.getTemporaryLocation(new Integer(i)), length);
        }
        File file = (File)this.myDeltaFiles.get(i);
        return new MeasurableStream(SVNFileUtil.openFileForReading(file), file.length());
    }

    public long getTextDeltaLength(int i) throws SVNException {
        if (this.myMediator != null) {
            return this.myMediator.getLength(new Integer(i));
        }
        File file = (File)this.myDeltaFiles.get(i);
        return file.length();
    }

    public void dispose() {
        if (this.myDeltaFiles != null) {
            Iterator values = this.myDeltaFiles.iterator();
            while (values.hasNext()) {
                if (this.myMediator != null) {
                    this.myMediator.deleteTemporaryLocation(values.next());
                    continue;
                }
                File file = (File)values.next();
                file.delete();
            }
        }
        this.myDeltaFiles = null;
        this.myProperties = null;
    }

    public void setWorkingURL(String location) {
        this.myWURL = location;
    }

    public void putProperty(String name, String value) {
        if (this.myProperties == null) {
            this.myProperties = new HashMap();
        }
        this.myProperties.put(name, value);
    }

    public Map getProperties() {
        return this.myProperties;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(this.myURL);
        sb.append("][");
        sb.append(this.myVURL);
        sb.append("][");
        sb.append(this.myWURL);
        sb.append("][");
        sb.append(this.myPath);
        sb.append("]");
        return sb.toString();
    }

    private static class MeasurableStream
    extends FilterInputStream
    implements IMeasurable {
        private long myLength;

        protected MeasurableStream(InputStream in, long length) {
            super(in);
            this.myLength = length;
        }

        public long getLength() {
            return this.myLength;
        }
    }
}

