/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVBaselineInfo;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepository;
import org.tmatesoft.svn.core.internal.io.dav.DAVUtil;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVGetLockHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVGetLocksHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVMergeHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVOptionsHandler;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPHeader;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnection;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnectionFactory;
import org.tmatesoft.svn.core.internal.util.IMeasurable;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.xml.sax.helpers.DefaultHandler;

public class DAVConnection {
    private IHTTPConnection myHttpConnection;
    private String myActivityCollectionURL;
    private Map myLocks;
    private boolean myKeepLocks;
    private IHTTPConnectionFactory myConnectionFactory;
    private SVNRepository myRepository;

    public DAVConnection(IHTTPConnectionFactory connectionFactory, SVNRepository repository) {
        this.myRepository = repository;
        this.myConnectionFactory = connectionFactory;
    }

    public SVNURL getLocation() {
        return this.myRepository.getLocation();
    }

    public void updateLocation() {
        this.myActivityCollectionURL = null;
    }

    public void open(DAVRepository repository) throws SVNException {
        if (this.myHttpConnection == null) {
            this.myHttpConnection = this.myConnectionFactory.createHTTPConnection(repository);
        }
    }

    public void fetchRepositoryRoot(DAVRepository repository) throws SVNException {
        if (!repository.hasRepositoryRoot()) {
            String rootPath = repository.getLocation().getURIEncodedPath();
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this, repository, rootPath, -1L, false, false, null);
            rootPath = rootPath.substring(0, rootPath.length() - info.baselinePath.length());
            SVNURL location = repository.getLocation();
            SVNURL url = location.setPath(rootPath, true);
            repository.setRepositoryRoot(url);
        }
    }

    public void fetchRepositoryUUID(DAVRepository repository) throws SVNException {
        if (!repository.hasRepositoryUUID()) {
            DAVUtil.findStartingProperties(this, repository, repository.getLocation().getURIEncodedPath());
            if (!repository.hasRepositoryUUID()) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NO_REPOS_UUID, "Please upgrade to server 0.19 or later");
                SVNErrorManager.error(err);
            }
        }
    }

    public HTTPStatus doPropfind(String path, HTTPHeader header, StringBuffer body, DefaultHandler handler) throws SVNException {
        return this.myHttpConnection.request("PROPFIND", path, header, body, -1, 0, null, handler);
    }

    public SVNLock doGetLock(String path, DAVRepository repos) throws SVNException {
        DAVBaselineInfo info = DAVUtil.getBaselineInfo(this, repos, path, -1L, false, true, null);
        StringBuffer body = DAVGetLockHandler.generateGetLockRequest(null);
        DAVGetLockHandler handler = new DAVGetLockHandler();
        SVNErrorMessage context = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Failed to fetch lock information");
        HTTPStatus rc = this.myHttpConnection.request("PROPFIND", path, null, body, 200, 207, null, (DefaultHandler)handler, context);
        String id = handler.getID();
        if (id == null) {
            return null;
        }
        String comment = handler.getComment();
        String owner = rc.getHeader().getFirstHeaderValue("X-SVN-Lock-Owner");
        String created = rc.getHeader().getFirstHeaderValue("X-SVN-Creation-Date");
        Date createdDate = created != null ? SVNTimeUtil.parseDate(created) : null;
        path = SVNEncodingUtil.uriDecode(info.baselinePath);
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return new SVNLock(path, id, owner, comment, createdDate, null);
    }

    public SVNLock[] doGetLocks(String path) throws SVNException {
        DAVGetLocksHandler handler = new DAVGetLocksHandler();
        HTTPStatus status = null;
        try {
            status = this.doReport(path, DAVGetLocksHandler.generateGetLocksRequest(null), handler);
        }
        catch (SVNException e) {
            SVNDebugLog.logInfo("error message: " + e.getErrorMessage());
            SVNDebugLog.logInfo("error code: " + e.getErrorMessage().getErrorCode());
            if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.UNSUPPORTED_FEATURE) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "Server does not support locking features");
                SVNErrorManager.error(err, e.getErrorMessage());
            } else if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_DAV_PATH_NOT_FOUND) {
                return new SVNLock[0];
            }
            throw e;
        }
        if (status.getCode() == 501) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "Server does not support locking features");
            SVNErrorManager.error(err, status.getError());
        } else {
            if (status.getCode() == 404) {
                return new SVNLock[0];
            }
            if (status.getError() != null && status.getError().getErrorCode() == SVNErrorCode.UNSUPPORTED_FEATURE) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "Server does not support locking features");
                SVNErrorManager.error(err, status.getError());
            } else if (status.getError() != null) {
                SVNErrorManager.error(status.getError());
            }
        }
        return handler.getLocks();
    }

    public SVNLock doLock(String path, DAVRepository repos, String comment, boolean force, long revision) throws SVNException {
        SVNErrorMessage context;
        DAVGetLockHandler handler;
        HTTPStatus status;
        DAVBaselineInfo info = DAVUtil.getBaselineInfo(this, repos, path, -1L, false, true, null);
        StringBuffer body = DAVGetLockHandler.generateSetLockRequest(null, comment);
        HTTPHeader header = null;
        if (revision >= 0L) {
            header = new HTTPHeader();
            header.setHeaderValue("X-SVN-Version-Name", Long.toString(revision));
        }
        if (force) {
            if (header == null) {
                header = new HTTPHeader();
            }
            header.setHeaderValue("X-SVN-Options", "lock-steal");
        }
        if ((status = this.myHttpConnection.request("LOCK", path, header, body, -1, 0, null, (DefaultHandler)(handler = new DAVGetLockHandler()), context = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Lock request failed"))).getError() != null) {
            SVNErrorManager.error(status.getError());
        }
        if (status != null) {
            String userName = this.myHttpConnection.getLastValidCredentials() != null ? this.myHttpConnection.getLastValidCredentials().getUserName() : null;
            String created = status.getHeader().getFirstHeaderValue("X-SVN-Creation-Date");
            if (userName == null || created == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Incomplete lock data returned");
                SVNErrorManager.error(err);
            }
            Date createdDate = created != null ? SVNTimeUtil.parseDate(created) : null;
            return new SVNLock(info.baselinePath, handler.getID(), userName, comment, createdDate, null);
        }
        return null;
    }

    public void doUnlock(String path, DAVRepository repos, String id, boolean force) throws SVNException {
        if (id == null) {
            SVNLock lock = this.doGetLock(path, repos);
            if (lock != null) {
                id = lock.getID();
            }
            if (id == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_LOCKED, "''{0}'' is not locked in the repository", path);
                SVNErrorManager.error(err);
            }
        }
        HTTPHeader header = new HTTPHeader();
        header.setHeaderValue("Lock-Token", "<" + id + ">");
        if (force) {
            header.setHeaderValue("X-SVN-Options", "lock-break");
        }
        SVNErrorMessage context = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Unlock request failed");
        this.myHttpConnection.request("UNLOCK", path, header, (StringBuffer)null, 204, 0, null, null, context);
    }

    public void doGet(String path, OutputStream os) throws SVNException {
        SVNErrorMessage context = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "GET request failed for ''{0}''", path);
        this.myHttpConnection.request("GET", path, null, (StringBuffer)null, 200, 226, os, null, context);
    }

    public HTTPStatus doReport(String path, StringBuffer requestBody, DefaultHandler handler) throws SVNException {
        return this.doReport(path, requestBody, handler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPStatus doReport(String path, StringBuffer requestBody, DefaultHandler handler, boolean spool) throws SVNException {
        this.myHttpConnection.setSpoolResponse(spool);
        try {
            HTTPStatus hTTPStatus = this.myHttpConnection.request("REPORT", path, null, requestBody, -1, 0, null, handler);
            return hTTPStatus;
        }
        finally {
            this.myHttpConnection.setSpoolResponse(false);
        }
    }

    public void doProppatch(String repositoryPath, String path, StringBuffer requestBody, DefaultHandler handler, SVNErrorMessage context) throws SVNException {
        HTTPHeader header = null;
        if (this.myLocks != null && repositoryPath != null && this.myLocks.containsKey(repositoryPath)) {
            header = new HTTPHeader();
            header.setHeaderValue("If", "(<" + this.myLocks.get(repositoryPath) + ">)");
        }
        try {
            this.myHttpConnection.request("PROPPATCH", path, header, requestBody, 200, 207, null, handler, context);
        }
        catch (SVNException e) {
            if (context == null && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_DAV_REQUEST_FAILED) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_PROPPATCH_FAILED, "At least one property change failed; repository is unchanged");
                SVNErrorManager.error(err);
            }
            throw e;
        }
    }

    public String doMakeActivity() throws SVNException {
        String locationPath = SVNEncodingUtil.uriEncode(this.getLocation().getPath());
        String url = this.getActivityCollectionURL(locationPath, false) + DAVConnection.generateUUID();
        HTTPStatus status = this.myHttpConnection.request("MKACTIVITY", url, null, (StringBuffer)null, 201, 404, null, null);
        if (status.getCode() == 404) {
            url = this.getActivityCollectionURL(locationPath, true) + DAVConnection.generateUUID();
            status = this.myHttpConnection.request("MKACTIVITY", url, null, (StringBuffer)null, 201, 0, null, null);
        }
        return url;
    }

    public HTTPStatus doDelete(String path) throws SVNException {
        return this.myHttpConnection.request("DELETE", path, null, (StringBuffer)null, 404, 204, null, null);
    }

    public HTTPStatus doDelete(String repositoryPath, String path, long revision) throws SVNException {
        HTTPHeader header = new HTTPHeader();
        if (revision >= 0L) {
            header.setHeaderValue("X-SVN-Version-Name", Long.toString(revision));
        }
        header.setHeaderValue("Depth", "infinity");
        StringBuffer request = null;
        if (this.myLocks != null && DAVMergeHandler.hasChildPaths(repositoryPath, this.myLocks)) {
            if (this.myLocks.containsKey(repositoryPath)) {
                header.setHeaderValue("If", "<" + repositoryPath + "> (<" + this.myLocks.get(repositoryPath) + ">)");
            }
            if (this.myKeepLocks) {
                header.setHeaderValue("X-SVN-Options", "keep-locks");
            }
            request = new StringBuffer();
            request.append("<?xml version=\"1.0\" encoding=\"utf-8\"?> ");
            String locationPath = this.getLocation().getPath();
            locationPath = SVNEncodingUtil.uriEncode(locationPath);
            request = DAVMergeHandler.generateLockDataRequest(request, locationPath, repositoryPath, this.myLocks);
        }
        return this.myHttpConnection.request("DELETE", path, header, request, 204, 404, null, null);
    }

    public HTTPStatus doMakeCollection(String path) throws SVNException {
        return this.myHttpConnection.request("MKCOL", path, null, (StringBuffer)null, 201, 0, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPStatus doPutDiff(String repositoryPath, String path, InputStream data) throws SVNException {
        HTTPHeader headers = new HTTPHeader();
        headers.setHeaderValue("Content-Type", "application/vnd.svn-svndiff");
        if (!(data instanceof ByteArrayInputStream) && !(data instanceof IMeasurable)) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                int b;
                while ((b = data.read()) >= 0) {
                    bos.write(b);
                }
            }
            catch (IOException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage());
                SVNErrorManager.error(err, e);
            }
            finally {
                try {
                    data.close();
                }
                catch (IOException e) {}
            }
            data = new ByteArrayInputStream(bos.toByteArray());
        }
        if (this.myLocks != null && this.myLocks.containsKey(repositoryPath)) {
            headers.setHeaderValue("If", "<" + repositoryPath + "> (<" + this.myLocks.get(repositoryPath) + ">)");
        }
        return this.myHttpConnection.request("PUT", path, headers, data, 201, 204, null, null);
    }

    public HTTPStatus doMerge(String activityURL, boolean response, DefaultHandler handler) throws SVNException {
        String locationPath = SVNEncodingUtil.uriEncode(this.getLocation().getPath());
        StringBuffer request = DAVMergeHandler.generateMergeRequest(null, locationPath, activityURL, this.myLocks);
        HTTPHeader header = null;
        if (!response || this.myLocks != null && !this.myKeepLocks) {
            header = new HTTPHeader();
            String value = "";
            if (!response) {
                value = value + "no-merge-response";
            }
            if (this.myLocks != null && !this.myKeepLocks) {
                value = value + " release-locks";
            }
            header.setHeaderValue("X-SVN-Options", value);
        }
        return this.myHttpConnection.request("MERGE", this.getLocation().getURIEncodedPath(), header, request, -1, 0, null, handler);
    }

    public HTTPStatus doCheckout(String activityPath, String repositoryPath, String path, boolean allow404) throws SVNException {
        HTTPStatus status;
        StringBuffer request = new StringBuffer();
        request.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        request.append("<D:checkout xmlns:D=\"DAV:\">");
        request.append("<D:activity-set>");
        request.append("<D:href>");
        request.append(activityPath);
        request.append("</D:href>");
        request.append("</D:activity-set></D:checkout>");
        HTTPHeader header = null;
        if (this.myLocks != null && repositoryPath != null && this.myLocks.containsKey(repositoryPath)) {
            header = new HTTPHeader();
            header.setHeaderValue("If", "(<" + this.myLocks.get(repositoryPath) + ">)");
        }
        if ((status = this.myHttpConnection.request("CHECKOUT", path, header, request, 201, allow404 ? 404 : 0, null, null)).getHeader().hasHeader("Location")) {
            SVNURL location = SVNURL.parseURIEncoded(status.getHeader().getFirstHeaderValue("Location"));
            status.getHeader().setHeaderValue("Location", location.getURIEncodedPath());
        }
        return status;
    }

    public void doCopy(String src, String dst, int depth) throws SVNException {
        HTTPHeader header = new HTTPHeader();
        header.setHeaderValue("Destination", dst);
        header.setHeaderValue("Depth", depth > 0 ? "infinity" : "0");
        SVNErrorMessage context = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "COPY of {0}", src);
        HTTPStatus status = this.myHttpConnection.request("COPY", src, header, (StringBuffer)null, -1, 0, null, null, context);
        if (status.getCode() >= 300 && status.getError() != null) {
            SVNErrorMessage err = status.getError();
            SVNErrorManager.error(err);
        }
    }

    public void close() {
        if (this.myHttpConnection != null) {
            this.myHttpConnection.close();
            this.myHttpConnection = null;
            this.myLocks = null;
            this.myKeepLocks = false;
        }
    }

    private String getActivityCollectionURL(String path, boolean force) throws SVNException {
        if (!force && this.myActivityCollectionURL != null) {
            return this.myActivityCollectionURL;
        }
        DAVOptionsHandler handler = new DAVOptionsHandler();
        this.myHttpConnection.request("OPTIONS", path, null, DAVOptionsHandler.OPTIONS_REQUEST, -1, 0, null, (DefaultHandler)handler);
        this.myActivityCollectionURL = handler.getActivityCollectionURL();
        if (this.myActivityCollectionURL == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_OPTIONS_REQ_FAILED, "The OPTIONS request did not include the requested activity-collection-set; this often means that the URL is not WebDAV-enabled");
            SVNErrorManager.error(err);
        }
        return this.myActivityCollectionURL;
    }

    private static String generateUUID() {
        long time = System.currentTimeMillis();
        String uuid = Long.toHexString(time);
        int zeroes = 16 - uuid.length();
        for (int i = 0; i < zeroes; ++i) {
            uuid = "0" + uuid;
        }
        return uuid;
    }

    public void setLocks(Map locks, boolean keepLocks) {
        this.myLocks = locks;
        this.myKeepLocks = keepLocks;
    }

    public void clearAuthenticationCache() {
        if (this.myHttpConnection != null) {
            this.myHttpConnection.clearAuthenticationCache();
        }
    }
}

