/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.delta;

import java.util.Arrays;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaAlgorithm;

public class SVNVDeltaAlgorithm
extends SVNDeltaAlgorithm {
    private static final int VD_KEY_SIZE = 4;
    private SlotsTable mySlotsTable;

    public void computeDelta(byte[] a, int aLength, byte[] b, int bLength) {
        int dataLength;
        byte[] data = null;
        if (aLength > 0 && bLength > 0) {
            data = new byte[aLength + bLength];
            System.arraycopy(a, 0, data, 0, aLength);
            System.arraycopy(b, 0, data, aLength, bLength);
            dataLength = data.length;
        } else if (aLength == 0) {
            data = b;
            dataLength = bLength;
        } else {
            data = a;
            dataLength = aLength;
        }
        SlotsTable slotsTable = this.getSlotsTable(dataLength);
        this.vdelta(slotsTable, data, 0, aLength, false);
        this.vdelta(slotsTable, data, aLength, dataLength, true);
    }

    private SlotsTable getSlotsTable(int dataLength) {
        if (this.mySlotsTable == null) {
            this.mySlotsTable = new SlotsTable();
        }
        this.mySlotsTable.reset(dataLength);
        return this.mySlotsTable;
    }

    /*
     * Unable to fully structure code
     */
    private void vdelta(SlotsTable table, byte[] data, int start, int end, boolean doOutput) {
        here = start;
        insertFrom = -1;
        block0: while (true) {
            if (end - here < 4) {
                v0 = from = insertFrom >= 0 ? insertFrom : here;
                if (doOutput && from < end) {
                    this.copyFromNewData(data, from, end - from);
                }
                return;
            }
            currentMatch = -1;
            currentMatchLength = 0;
            progress = false;
            key = here;
            do {
                progress = false;
                slot = table.getBucket(table.getBucketIndex(data, key));
                while (slot >= 0) {
                    if (slot >= key - here) {
                        match = slot - (key - here);
                        matchLength = this.findMatchLength(data, match, here, end);
                        if (match < start && match + matchLength > start) {
                            matchLength = start - match;
                        }
                        if (matchLength >= 4 && matchLength > currentMatchLength) {
                            currentMatch = match;
                            currentMatchLength = matchLength;
                            progress = true;
                        }
                    }
                    slot = SlotsTable.access$000(table)[slot];
                }
                if (!progress) continue;
                key = here + currentMatchLength - 3;
            } while (progress && end - key >= 4);
            if (currentMatchLength < 4) {
                table.storeSlot(data, here);
                if (insertFrom < 0) {
                    insertFrom = here;
                }
                ++here;
                continue;
            }
            if (doOutput) {
                if (insertFrom >= 0) {
                    this.copyFromNewData(data, insertFrom, here - insertFrom);
                    insertFrom = -1;
                }
                if (currentMatch < start) {
                    this.copyFromSource(currentMatch, currentMatchLength);
                } else {
                    this.copyFromTarget(currentMatch - start, currentMatchLength);
                }
            }
            if (end - (here += currentMatchLength) < 4) continue;
            last = here - 3;
            while (true) {
                if (last < here) ** break;
                continue block0;
                table.storeSlot(data, last);
                ++last;
            }
            break;
        }
    }

    private int findMatchLength(byte[] data, int match, int from, int end) {
        int here;
        for (here = from; here < end && data[match] == data[here]; ++here) {
            ++match;
        }
        return here - from;
    }

    private static class SlotsTable {
        private int[] mySlots;
        private int[] myBuckets;
        private int myBucketsCount;

        public void reset(int dataLength) {
            this.mySlots = SlotsTable.allocate(this.mySlots, dataLength);
            this.myBucketsCount = dataLength / 3 | 1;
            this.myBuckets = SlotsTable.allocate(this.myBuckets, this.myBucketsCount);
            Arrays.fill(this.mySlots, 0, dataLength, -1);
            Arrays.fill(this.myBuckets, 0, this.myBucketsCount, -1);
        }

        public int getBucketIndex(byte[] data, int index) {
            int hash = 0;
            hash += data[index] & 0xFF;
            hash += hash * 127 + (data[index + 1] & 0xFF);
            hash += hash * 127 + (data[index + 2] & 0xFF);
            hash += hash * 127 + (data[index + 3] & 0xFF);
            return (hash %= this.myBucketsCount) < 0 ? -hash : hash;
        }

        public int getBucket(int bucketIndex) {
            return this.myBuckets[bucketIndex];
        }

        public void storeSlot(byte[] data, int slotIndex) {
            int bucketIndex = this.getBucketIndex(data, slotIndex);
            this.mySlots[slotIndex] = this.myBuckets[bucketIndex];
            this.myBuckets[bucketIndex] = slotIndex;
        }

        private static int[] allocate(int[] array, int length) {
            if (array == null || array.length < length) {
                return new int[length * 3 / 2];
            }
            return array;
        }

        static /* synthetic */ int[] access$000(SlotsTable x0) {
            return x0.mySlots;
        }
    }
}

