/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import de.regnis.q.sequence.QSequenceDifferenceBlock;
import de.regnis.q.sequence.line.QSequenceLineMedia;
import de.regnis.q.sequence.line.QSequenceLineRAFileData;
import de.regnis.q.sequence.line.QSequenceLineResult;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.SVNFileRevision;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVNAnnotationGenerator
implements ISVNFileRevisionHandler {
    private File myTmpDirectory;
    private String myPath;
    private long myCurrentRevision;
    private String myCurrentAuthor;
    private Date myCurrentDate;
    private File myPreviousFile;
    private File myCurrentFile;
    private List myLines;
    private SVNDeltaProcessor myDeltaProcessor;
    private ISVNEventHandler myCancelBaton;
    private long myStartRevision;

    public SVNAnnotationGenerator(String path, File tmpDirectory, long startRevision, ISVNEventHandler cancelBaton) {
        this.myTmpDirectory = tmpDirectory;
        this.myCancelBaton = cancelBaton;
        this.myPath = path;
        if (!this.myTmpDirectory.isDirectory()) {
            this.myTmpDirectory.mkdirs();
        }
        this.myLines = new ArrayList();
        this.myDeltaProcessor = new SVNDeltaProcessor();
        this.myStartRevision = startRevision;
    }

    public void openRevision(SVNFileRevision fileRevision) throws SVNException {
        boolean known;
        Map propDiff = fileRevision.getPropertiesDelta();
        String newMimeType = propDiff != null ? propDiff.get("svn:mime-type") : null;
        if (SVNProperty.isBinaryMimeType(newMimeType)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_IS_BINARY_FILE, "Cannot calculate blame information for binary file ''{0}''", this.myPath);
            SVNErrorManager.error(err);
        }
        this.myCurrentRevision = fileRevision.getRevision();
        boolean bl = known = fileRevision.getRevision() >= this.myStartRevision;
        if (this.myCancelBaton != null) {
            SVNEvent event = SVNEventFactory.createAnnotateEvent(this.myPath, this.myCurrentRevision);
            this.myCancelBaton.handleEvent(event, -1.0);
            this.myCancelBaton.checkCancelled();
        }
        Map props = fileRevision.getRevisionProperties();
        this.myCurrentAuthor = known && props != null && props.get("svn:author") != null ? props.get("svn:author").toString() : null;
        this.myCurrentDate = known && props != null && props.get("svn:date") != null ? SVNTimeUtil.parseDate(fileRevision.getRevisionProperties().get("svn:date").toString()) : null;
        if (this.myPreviousFile == null) {
            this.myPreviousFile = SVNFileUtil.createUniqueFile(this.myTmpDirectory, "annotate", ".tmp");
            SVNFileUtil.createEmptyFile(this.myPreviousFile);
        }
    }

    public void closeRevision(String token) throws SVNException {
    }

    public void applyTextDelta(String token) throws SVNException {
        if (this.myCurrentFile != null) {
            this.myCurrentFile.delete();
        } else {
            this.myCurrentFile = SVNFileUtil.createUniqueFile(this.myTmpDirectory, "annotate", ".tmp");
        }
        this.myDeltaProcessor.applyTextDelta(this.myPreviousFile, this.myCurrentFile, false);
    }

    public OutputStream textDeltaChunk(String token, SVNDiffWindow diffWindow) throws SVNException {
        return this.myDeltaProcessor.textDeltaChunk(diffWindow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void textDeltaEnd(String token) throws SVNException {
        block28: {
            IOException e222;
            RandomAccessFile right;
            RandomAccessFile left;
            block26: {
                this.myDeltaProcessor.textDeltaEnd();
                left = null;
                right = null;
                left = new RandomAccessFile(this.myPreviousFile, "r");
                right = new RandomAccessFile(this.myCurrentFile, "r");
                ArrayList newLines = new ArrayList();
                int lastStart = 0;
                QSequenceLineResult result = QSequenceLineMedia.createBlocks(new QSequenceLineRAFileData(left), new QSequenceLineRAFileData(right));
                try {
                    List blocksList = result.getBlocks();
                    for (int i = 0; i < blocksList.size(); ++i) {
                        int j;
                        QSequenceDifferenceBlock block = (QSequenceDifferenceBlock)blocksList.get(i);
                        int start = block.getLeftFrom();
                        for (j = lastStart; j < Math.min(this.myLines.size(), start); ++j) {
                            newLines.add(this.myLines.get(j));
                            lastStart = j + 1;
                        }
                        if (block.getLeftSize() > 0) {
                            lastStart += block.getLeftSize();
                        }
                        for (j = block.getRightFrom(); j <= block.getRightTo(); ++j) {
                            LineInfo line = new LineInfo();
                            line.revision = this.myCurrentDate != null ? this.myCurrentRevision : -1L;
                            line.author = this.myCurrentAuthor;
                            line.line = result.getRightCache().getLine(j).getBytes();
                            line.date = this.myCurrentDate;
                            newLines.add(line);
                        }
                    }
                    for (int j = lastStart; j < this.myLines.size(); ++j) {
                        newLines.add(this.myLines.get(j));
                    }
                    this.myLines = newLines;
                }
                finally {
                    result.close();
                }
                Object var15_15 = null;
                if (left == null) break block26;
                try {
                    left.close();
                }
                catch (IOException e222) {
                    // empty catch block
                }
            }
            if (right != null) {
                try {
                    right.close();
                }
                catch (IOException e222) {}
            }
            break block28;
            {
                catch (Throwable e3) {
                    IOException e222;
                    SVNDebugLog.logInfo(e3);
                    Object var15_16 = null;
                    if (left != null) {
                        try {
                            left.close();
                        }
                        catch (IOException e222) {
                            // empty catch block
                        }
                    }
                    if (right != null) {
                        try {
                            right.close();
                        }
                        catch (IOException e222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException e222;
                Object var15_17 = null;
                if (left != null) {
                    try {
                        left.close();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                }
                if (right != null) {
                    try {
                        right.close();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        SVNFileUtil.rename(this.myCurrentFile, this.myPreviousFile);
    }

    public void reportAnnotations(ISVNAnnotateHandler handler, String inputEncoding) throws SVNException {
        if (this.myLines == null || handler == null) {
            return;
        }
        inputEncoding = inputEncoding == null ? System.getProperty("file.encoding") : inputEncoding;
        for (int i = 0; i < this.myLines.size(); ++i) {
            String lineAsString;
            LineInfo info = (LineInfo)this.myLines.get(i);
            byte[] bytes = info.line;
            int length = bytes.length;
            if (bytes.length >= 2 && bytes[length - 2] == 13 && bytes[length - 1] == 10) {
                length -= 2;
            } else if (bytes.length >= 1 && (bytes[length - 1] == 13 || bytes[length - 1] == 10)) {
                --length;
            }
            try {
                lineAsString = new String(info.line, 0, length, inputEncoding);
            }
            catch (UnsupportedEncodingException e) {
                lineAsString = new String(info.line, 0, length);
            }
            handler.handleLine(info.date, info.revision, info.author, lineAsString);
        }
    }

    public void dispose() {
        this.myLines = null;
        if (this.myCurrentFile != null) {
            this.myCurrentFile.delete();
        }
        if (this.myPreviousFile != null) {
            this.myPreviousFile.delete();
        }
    }

    private static class LineInfo {
        public byte[] line;
        public long revision;
        public String author;
        public Date date;

        private LineInfo() {
        }
    }
}

