/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.line.diff;

import de.regnis.q.sequence.QSequenceDifferenceBlock;
import de.regnis.q.sequence.core.QSequenceException;
import de.regnis.q.sequence.line.QSequenceLine;
import de.regnis.q.sequence.line.QSequenceLineCache;
import de.regnis.q.sequence.line.QSequenceLineMedia;
import de.regnis.q.sequence.line.QSequenceLineRAByteData;
import de.regnis.q.sequence.line.QSequenceLineResult;
import de.regnis.q.sequence.line.diff.QDiffGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class QDiffSequenceGenerator
implements QDiffGenerator {
    private Map myProperties;

    protected abstract void processBlock(QSequenceDifferenceBlock[] var1, QSequenceLineCache var2, QSequenceLineCache var3, String var4, Writer var5) throws IOException;

    protected QDiffSequenceGenerator(Map properties) {
        this.myProperties = properties == null ? Collections.EMPTY_MAP : properties;
        this.myProperties = Collections.unmodifiableMap(this.myProperties);
    }

    public void generateBinaryDiff(InputStream left, InputStream right, String encoding, Writer output) throws IOException {
        this.println("Binary files are different", output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateTextDiff(InputStream left, InputStream right, String encoding, Writer output) throws IOException {
        QSequenceLineResult result;
        try {
            result = QSequenceLineMedia.createBlocks(QSequenceLineRAByteData.create(left), QSequenceLineRAByteData.create(right));
        }
        catch (QSequenceException ex) {
            throw new IOException(ex.getMessage());
        }
        try {
            List combinedBlocks = QDiffSequenceGenerator.combineBlocks(result.getBlocks(), this.getGutter());
            Iterator it = combinedBlocks.iterator();
            while (it.hasNext()) {
                List segment = (List)it.next();
                if (segment.isEmpty()) continue;
                QSequenceDifferenceBlock[] segmentBlocks = segment.toArray(new QSequenceDifferenceBlock[segment.size()]);
                this.processBlock(segmentBlocks, result.getLeftCache(), result.getRightCache(), encoding, output);
            }
        }
        finally {
            result.close();
        }
    }

    protected Map getProperties() {
        return this.myProperties;
    }

    protected String getEOL() {
        if (this.getProperties().get("eol") instanceof String) {
            return (String)this.getProperties().get("eol");
        }
        return System.getProperty("line.separator", "\n");
    }

    protected int getGutter() {
        Object gutterStr = this.getProperties().get("gutter");
        if (gutterStr == null) {
            return 0;
        }
        try {
            return Integer.parseInt(gutterStr.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    protected String printLine(QSequenceLine line, String encoding) throws IOException {
        String str = new String(line.getBytes(), encoding);
        return str;
    }

    protected void println(Writer output) throws IOException {
        output.write(this.getEOL());
    }

    protected void println(String str, Writer output) throws IOException {
        if (str != null) {
            output.write(str);
        }
        output.write(this.getEOL());
    }

    protected void print(String str, Writer output) throws IOException {
        if (str != null) {
            output.write(str);
        }
    }

    private static List combineBlocks(List blocksList, int gutter) {
        LinkedList combinedBlocks = new LinkedList();
        LinkedList<QSequenceDifferenceBlock> currentList = new LinkedList<QSequenceDifferenceBlock>();
        QSequenceDifferenceBlock lastBlock = null;
        Iterator blocks = blocksList.iterator();
        while (blocks.hasNext()) {
            QSequenceDifferenceBlock currentBlock = (QSequenceDifferenceBlock)blocks.next();
            if (lastBlock != null && currentBlock.getLeftFrom() - 1 - lastBlock.getLeftTo() > gutter && currentBlock.getRightFrom() - 1 - lastBlock.getRightTo() > gutter) {
                combinedBlocks.add(currentList);
                currentList = new LinkedList();
            }
            currentList.add(currentBlock);
            lastBlock = currentBlock;
        }
        if (!combinedBlocks.contains(currentList)) {
            combinedBlocks.add(currentList);
        }
        return combinedBlocks;
    }
}

