/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.line;

import de.regnis.q.sequence.line.QSequenceLine;
import de.regnis.q.sequence.line.QSequenceLineCache;
import de.regnis.q.sequence.line.QSequenceLineFileSystemCacheSegments;
import de.regnis.q.sequence.line.QSequenceLineRAData;
import de.regnis.q.sequence.line.QSequenceLineReader;
import de.regnis.q.sequence.line.QSequenceLineTempDirectoryFactory;
import java.io.IOException;
import java.io.InputStream;

final class QSequenceLineFileSystemCache
implements QSequenceLineCache {
    private final QSequenceLineRAData data;
    private final QSequenceLineFileSystemCacheSegments segments;
    private int lineCount;

    public static QSequenceLineFileSystemCache create(QSequenceLineRAData data, QSequenceLineTempDirectoryFactory tempDirectoryFactory, int maximumBytesInMemory, int maximumSegmentSize) throws IOException {
        QSequenceLineFileSystemCache cache = new QSequenceLineFileSystemCache(data, tempDirectoryFactory, maximumBytesInMemory, maximumSegmentSize);
        QSequenceLineReader reader = new QSequenceLineReader();
        InputStream stream = data.read(0L, data.length());
        reader.read(stream, cache);
        stream.close();
        return cache;
    }

    private QSequenceLineFileSystemCache(QSequenceLineRAData data, QSequenceLineTempDirectoryFactory tempDirectoryFactory, int maximumBytesInMemory, int maximumSegmentSize) {
        this.data = data;
        this.segments = new QSequenceLineFileSystemCacheSegments(tempDirectoryFactory, maximumBytesInMemory, maximumSegmentSize);
    }

    public void close() throws IOException {
        this.segments.close();
    }

    public void addLine(QSequenceLine line) throws IOException {
        this.segments.setFromLengthHash(this.lineCount, line.getFrom(), line.getLength(), new String(line.getBytes()).hashCode());
        if (this.lineCount >= Integer.MAX_VALUE) {
            throw new IOException("Too many lines.");
        }
        ++this.lineCount;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public QSequenceLine getLine(int index) throws IOException {
        long from = this.segments.getFrom(index);
        int length = this.segments.getLength(index);
        byte[] bytes = new byte[length];
        this.data.get(bytes, from, length);
        return new QSequenceLine(from, bytes);
    }

    public int getLineHash(int index) throws IOException {
        return this.segments.getHash(index);
    }
}

