/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;

public class FilterSet
extends DataType
implements Cloneable {
    public static final String DEFAULT_TOKEN_START = "@";
    public static final String DEFAULT_TOKEN_END = "@";
    private String startOfToken = "@";
    private String endOfToken = "@";
    private Vector passedTokens;
    private boolean duplicateToken = false;
    private boolean recurse = true;
    private Hashtable filterHash = null;
    private Vector filters = new Vector();

    public FilterSet() {
    }

    protected FilterSet(FilterSet filterset) {
        this.filters = (Vector)filterset.getFilters().clone();
    }

    protected synchronized Vector getFilters() {
        return this.filters;
    }

    public synchronized Hashtable getFilterHash() {
        if (this.filterHash == null) {
            this.filterHash = new Hashtable(this.getFilters().size());
            Enumeration e = this.getFilters().elements();
            while (e.hasMoreElements()) {
                Filter filter = (Filter)e.nextElement();
                this.filterHash.put(filter.getToken(), filter.getValue());
            }
        }
        return this.filterHash;
    }

    public void setFiltersfile(File filtersFile) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.readFiltersFromFile(filtersFile);
    }

    public void setBeginToken(String startOfToken) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (startOfToken == null || "".equals(startOfToken)) {
            throw new BuildException("beginToken must not be empty");
        }
        this.startOfToken = startOfToken;
    }

    public String getBeginToken() {
        return this.startOfToken;
    }

    public void setEndToken(String endOfToken) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (endOfToken == null || "".equals(endOfToken)) {
            throw new BuildException("endToken must not be empty");
        }
        this.endOfToken = endOfToken;
    }

    public String getEndToken() {
        return this.endOfToken;
    }

    public void setRecurse(boolean recurse) {
        this.recurse = recurse;
    }

    public boolean isRecurse() {
        return this.recurse;
    }

    public synchronized void readFiltersFromFile(File filtersFile) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (!filtersFile.exists()) {
            throw new BuildException("Could not read filters from file " + filtersFile + " as it doesn't exist.");
        }
        if (filtersFile.isFile()) {
            FileInputStream in = null;
            try {
                Properties props = new Properties();
                in = new FileInputStream(filtersFile);
                props.load(in);
                Enumeration<?> e = props.propertyNames();
                Vector filts = this.getFilters();
                while (e.hasMoreElements()) {
                    String strPropName = (String)e.nextElement();
                    String strValue = props.getProperty(strPropName);
                    filts.addElement(new Filter(strPropName, strValue));
                }
            }
            catch (Exception ex) {
                throw new BuildException("Could not read filters from file: " + filtersFile);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioex) {}
                }
            }
        }
        throw new BuildException("Must specify a file not a directory in the filtersfile attribute:" + filtersFile);
    }

    public synchronized String replaceTokens(String line) {
        this.passedTokens = null;
        return this.iReplaceTokens(line);
    }

    private synchronized String iReplaceTokens(String line) {
        String beginToken = this.getBeginToken();
        String endToken = this.getEndToken();
        int index = line.indexOf(beginToken);
        if (index > -1) {
            Hashtable tokens = this.getFilterHash();
            try {
                int endIndex;
                StringBuffer b = new StringBuffer();
                int i = 0;
                String token = null;
                String value = null;
                while ((endIndex = line.indexOf(endToken, index + beginToken.length() + 1)) != -1) {
                    token = line.substring(index + beginToken.length(), endIndex);
                    b.append(line.substring(i, index));
                    if (tokens.containsKey(token)) {
                        value = (String)tokens.get(token);
                        if (this.recurse && !value.equals(token)) {
                            value = this.replaceTokens(value, token);
                        }
                        b.append(value);
                        i = index + beginToken.length() + token.length() + endToken.length();
                    } else {
                        b.append(beginToken);
                        i = index + beginToken.length();
                    }
                    if ((index = line.indexOf(beginToken, i)) > -1) continue;
                }
                b.append(line.substring(i));
                return b.toString();
            }
            catch (StringIndexOutOfBoundsException e) {
                return line;
            }
        }
        return line;
    }

    private synchronized String replaceTokens(String line, String parent) throws BuildException {
        String beginToken = this.getBeginToken();
        String endToken = this.getEndToken();
        if (this.passedTokens == null) {
            this.passedTokens = new Vector();
        }
        if (this.passedTokens.contains(parent) && !this.duplicateToken) {
            this.duplicateToken = true;
            System.out.println("Infinite loop in tokens. Currently known tokens : " + this.passedTokens.toString() + "\nProblem token : " + beginToken + parent + endToken + " called from " + beginToken + this.passedTokens.lastElement().toString() + endToken);
            return parent;
        }
        this.passedTokens.addElement(parent);
        String value = this.iReplaceTokens(line);
        if (value.indexOf(beginToken) == -1 && !this.duplicateToken) {
            this.duplicateToken = false;
            this.passedTokens = null;
        } else if (this.duplicateToken && this.passedTokens.size() > 0) {
            value = (String)this.passedTokens.remove(this.passedTokens.size() - 1);
            if (this.passedTokens.size() == 0) {
                value = beginToken + value + endToken;
                this.duplicateToken = false;
            }
        }
        return value;
    }

    public synchronized void addFilter(Filter filter) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.filters.addElement(filter);
        this.filterHash = null;
    }

    public FiltersFile createFiltersfile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return new FiltersFile();
    }

    public synchronized void addFilter(String token, String value) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.addFilter(new Filter(token, value));
    }

    public synchronized void addConfiguredFilterSet(FilterSet filterSet) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        Enumeration e = filterSet.getFilters().elements();
        while (e.hasMoreElements()) {
            this.addFilter((Filter)e.nextElement());
        }
    }

    public synchronized boolean hasFilters() {
        return this.getFilters().size() > 0;
    }

    public synchronized Object clone() throws BuildException {
        try {
            FilterSet fs = (FilterSet)super.clone();
            fs.filters = (Vector)this.getFilters().clone();
            return fs;
        }
        catch (CloneNotSupportedException e) {
            throw new BuildException(e);
        }
    }

    public class FiltersFile {
        public void setFile(File file) {
            FilterSet.this.readFiltersFromFile(file);
        }
    }

    public static class Filter {
        String token;
        String value;

        public Filter(String token, String value) {
            this.setToken(token);
            this.setValue(value);
        }

        public Filter() {
        }

        public void setToken(String token) {
            this.token = token;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getToken() {
            return this.token;
        }

        public String getValue() {
            return this.value;
        }
    }
}

