/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Authorization
extends DefaultHandler {
    private static final String AUTHORIZEDKEYS_ELEMENT = "AuthorizedKeys";
    private static final String KEY_ELEMENT = "Key";
    private ArrayList authorizedKeys = new ArrayList();

    public Authorization(InputStream inputStream) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        this.authorizedKeys.clear();
        sAXParser.parse(inputStream, (DefaultHandler)new AuthorizedKeysSAXHandler());
    }

    public Authorization() {
    }

    public List getAuthorizedKeys() {
        return (List)this.authorizedKeys.clone();
    }

    public void addKey(String string) {
        this.authorizedKeys.add(string);
    }

    public String toString() {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        string = string + "<!-- SSHTools Public Key Authorization File -->\n";
        string = string + "<AuthorizedKeys>\n";
        string = string + "<!-- Enter authorized public key elements here -->\n";
        Iterator iterator = this.authorizedKeys.iterator();
        while (iterator.hasNext()) {
            string = string + "   <Key>" + iterator.next().toString() + "</" + KEY_ELEMENT + ">\n";
        }
        string = string + "</AuthorizedKeys>";
        return string;
    }

    class AuthorizedKeysSAXHandler
    extends DefaultHandler {
        private String currentElement = null;

        AuthorizedKeysSAXHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.currentElement == null) {
                if (!string3.equals(Authorization.AUTHORIZEDKEYS_ELEMENT)) {
                    throw new SAXException("Unexpected root element " + string3);
                }
            } else if (this.currentElement.equals(Authorization.AUTHORIZEDKEYS_ELEMENT)) {
                if (!string3.equals(Authorization.KEY_ELEMENT)) {
                    throw new SAXException("Unexpected element " + string3);
                }
            } else {
                throw new SAXException("Unexpected element " + string3);
            }
            this.currentElement = string3;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.currentElement != null && this.currentElement.equals(Authorization.KEY_ELEMENT)) {
                String string = new String(cArray, n, n2);
                Authorization.this.authorizedKeys.add(string);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.currentElement != null) {
                if (!this.currentElement.equals(string3)) {
                    throw new SAXException("Unexpected end element found " + string3);
                }
                if (this.currentElement.equals(Authorization.KEY_ELEMENT)) {
                    this.currentElement = Authorization.AUTHORIZEDKEYS_ELEMENT;
                } else if (this.currentElement.equals(Authorization.AUTHORIZEDKEYS_ELEMENT)) {
                    this.currentElement = null;
                } else {
                    throw new SAXException("Unexpected end element " + string3);
                }
            }
        }
    }
}

