/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileContentInfoFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.FileUtil;
import org.apache.commons.vfs.NameScope;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.Selectors;
import org.apache.commons.vfs.operations.DefaultFileOperations;
import org.apache.commons.vfs.operations.FileOperations;
import org.apache.commons.vfs.provider.AbstractFileName;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.DefaultFileContent;
import org.apache.commons.vfs.provider.DefaultFileSelectorInfo;
import org.apache.commons.vfs.provider.DefaultURLStreamHandler;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.util.FileObjectUtils;
import org.apache.commons.vfs.util.RandomAccessMode;

public abstract class AbstractFileObject
implements FileObject {
    private static final FileName[] EMPTY_FILE_ARRAY = new FileName[0];
    private final AbstractFileName name;
    private final AbstractFileSystem fs;
    private DefaultFileContent content;
    private boolean attached;
    private FileType type;
    private FileObject parent;
    private FileName[] children;
    private List objects;
    private FileOperations operations;

    protected AbstractFileObject(FileName name, AbstractFileSystem fs) {
        this.name = (AbstractFileName)name;
        this.fs = fs;
    }

    protected void doAttach() throws Exception {
    }

    protected void doDetach() throws Exception {
    }

    protected abstract FileType doGetType() throws Exception;

    protected boolean doIsHidden() throws Exception {
        return false;
    }

    protected boolean doIsReadable() throws Exception {
        return true;
    }

    protected boolean doIsWriteable() throws Exception {
        return true;
    }

    protected abstract String[] doListChildren() throws Exception;

    protected FileObject[] doListChildrenResolved() throws Exception {
        return null;
    }

    protected void doDelete() throws Exception {
        throw new FileSystemException("vfs.provider/delete-not-supported.error");
    }

    protected void doRename(FileObject newfile) throws Exception {
        throw new FileSystemException("vfs.provider/rename-not-supported.error");
    }

    protected void doCreateFolder() throws Exception {
        throw new FileSystemException("vfs.provider/create-folder-not-supported.error");
    }

    protected void onChildrenChanged(FileName child, FileType newType) throws Exception {
    }

    protected void onChange() throws Exception {
    }

    protected long doGetLastModifiedTime() throws Exception {
        throw new FileSystemException("vfs.provider/get-last-modified-not-supported.error");
    }

    protected void doSetLastModifiedTime(long modtime) throws Exception {
        throw new FileSystemException("vfs.provider/set-last-modified-not-supported.error");
    }

    protected Map doGetAttributes() throws Exception {
        return Collections.EMPTY_MAP;
    }

    protected void doSetAttribute(String atttrName, Object value) throws Exception {
        throw new FileSystemException("vfs.provider/set-attribute-not-supported.error");
    }

    protected Certificate[] doGetCertificates() throws Exception {
        return null;
    }

    protected abstract long doGetContentSize() throws Exception;

    protected abstract InputStream doGetInputStream() throws Exception;

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        throw new FileSystemException("vfs.provider/random-access-not-supported.error");
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        throw new FileSystemException("vfs.provider/write-not-supported.error");
    }

    public String toString() {
        return this.name.getURI();
    }

    public FileName getName() {
        return this.name;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public URL getURL() throws FileSystemException {
        final StringBuffer buf = new StringBuffer();
        try {
            return (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws MalformedURLException {
                    return new URL(UriParser.extractScheme(AbstractFileObject.this.name.getURI(), buf), "", -1, buf.toString(), new DefaultURLStreamHandler(AbstractFileObject.this.fs.getContext(), AbstractFileObject.this.fs.getFileSystemOptions()));
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new FileSystemException("vfs.provider/get-url.error", this.name, (Throwable)e.getException());
        }
    }

    public boolean exists() throws FileSystemException {
        return this.getType() != FileType.IMAGINARY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileType getType() throws FileSystemException {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            this.attach();
            return this.type;
        }
    }

    public boolean isHidden() throws FileSystemException {
        try {
            if (this.exists()) {
                return this.doIsHidden();
            }
            return false;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/check-is-hidden.error", this.name, (Throwable)exc);
        }
    }

    public boolean isReadable() throws FileSystemException {
        try {
            if (this.exists()) {
                return this.doIsReadable();
            }
            return false;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/check-is-readable.error", this.name, (Throwable)exc);
        }
    }

    public boolean isWriteable() throws FileSystemException {
        try {
            if (this.exists()) {
                return this.doIsWriteable();
            }
            FileObject parent = this.getParent();
            if (parent != null) {
                return parent.isWriteable();
            }
            return true;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/check-is-writeable.error", this.name, (Throwable)exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject getParent() throws FileSystemException {
        if (this == this.fs.getRoot()) {
            if (this.fs.getParentLayer() != null) {
                return this.fs.getParentLayer().getParent();
            }
            return null;
        }
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            if (this.parent == null) {
                this.parent = this.fs.resolveFile(this.name.getParent());
            }
        }
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject[] getChildren() throws FileSystemException {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            String[] files;
            FileObject[] childrenObjects;
            if (!this.getType().hasChildren()) {
                throw new FileSystemException("vfs.provider/list-children-not-folder.error", this.name);
            }
            if (this.children != null) {
                return this.resolveFiles(this.children);
            }
            try {
                childrenObjects = this.doListChildrenResolved();
                this.children = this.extractNames(childrenObjects);
            }
            catch (Exception exc) {
                throw new FileSystemException("vfs.provider/list-children.error", new Object[]{this.name}, (Throwable)exc);
            }
            if (childrenObjects != null) {
                return childrenObjects;
            }
            try {
                files = this.doListChildren();
            }
            catch (Exception exc) {
                throw new FileSystemException("vfs.provider/list-children.error", new Object[]{this.name}, (Throwable)exc);
            }
            if (files == null) {
                return null;
            }
            if (files.length == 0) {
                this.children = EMPTY_FILE_ARRAY;
            } else {
                this.children = new FileName[files.length];
                for (int i = 0; i < files.length; ++i) {
                    String file = files[i];
                    this.children[i] = this.getFileSystem().getFileSystemManager().resolveName(this.name, file, NameScope.CHILD);
                }
            }
            return this.resolveFiles(this.children);
        }
    }

    private FileName[] extractNames(FileObject[] objects) {
        if (objects == null) {
            return null;
        }
        FileName[] names = new FileName[objects.length];
        for (int iterObjects = 0; iterObjects < objects.length; ++iterObjects) {
            names[iterObjects] = objects[iterObjects].getName();
        }
        return names;
    }

    private FileObject[] resolveFiles(FileName[] children) throws FileSystemException {
        if (children == null) {
            return null;
        }
        FileObject[] objects = new FileObject[children.length];
        for (int iterChildren = 0; iterChildren < children.length; ++iterChildren) {
            objects[iterChildren] = this.resolveFile(children[iterChildren]);
        }
        return objects;
    }

    private FileObject resolveFile(FileName child) throws FileSystemException {
        return this.fs.resolveFile(child);
    }

    public FileObject getChild(String name) throws FileSystemException {
        FileObject[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            FileName child = children[i].getName();
            if (!child.getBaseName().equals(name)) continue;
            return this.resolveFile(child);
        }
        return null;
    }

    public FileObject resolveFile(String name, NameScope scope) throws FileSystemException {
        return this.fs.resolveFile(this.getFileSystem().getFileSystemManager().resolveName(this.name, name, scope));
    }

    public FileObject resolveFile(String path) throws FileSystemException {
        FileName otherName = this.getFileSystem().getFileSystemManager().resolveName(this.name, path);
        return this.fs.resolveFile(otherName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteSelf() throws FileSystemException {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            if (this.getType() == FileType.IMAGINARY) {
                return false;
            }
            try {
                this.doDelete();
                this.handleDelete();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception exc) {
                throw new FileSystemException("vfs.provider/delete.error", new Object[]{this.name}, (Throwable)exc);
            }
            return true;
        }
    }

    public boolean delete() throws FileSystemException {
        return this.delete(Selectors.SELECT_SELF) > 0;
    }

    public int delete(FileSelector selector) throws FileSystemException {
        int nuofDeleted = 0;
        if (this.getType() == FileType.IMAGINARY) {
            return nuofDeleted;
        }
        ArrayList files = new ArrayList();
        this.findFiles(selector, true, files);
        int count = files.size();
        for (int i = 0; i < count; ++i) {
            boolean deleted;
            AbstractFileObject file = FileObjectUtils.getAbstractFileObject((FileObject)files.get(i));
            if (file.getType() == FileType.FOLDER && file.getChildren().length != 0 || !(deleted = file.deleteSelf())) continue;
            ++nuofDeleted;
        }
        return nuofDeleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFile() throws FileSystemException {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            try {
                if (this.exists() && !FileType.FILE.equals(this.getType())) {
                    throw new FileSystemException("vfs.provider/create-file.error", this.name);
                }
                if (!this.exists()) {
                    this.getOutputStream().close();
                    this.endOutput();
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new FileSystemException("vfs.provider/create-file.error", this.name, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFolder() throws FileSystemException {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            if (this.getType() == FileType.FOLDER) {
                return;
            }
            if (this.getType() != FileType.IMAGINARY) {
                throw new FileSystemException("vfs.provider/create-folder-mismatched-type.error", this.name);
            }
            if (!this.isWriteable()) {
                throw new FileSystemException("vfs.provider/create-folder-read-only.error", this.name);
            }
            FileObject parent = this.getParent();
            if (parent != null) {
                parent.createFolder();
            }
            try {
                this.doCreateFolder();
                this.handleCreate(FileType.FOLDER);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception exc) {
                throw new FileSystemException("vfs.provider/create-folder.error", this.name, (Throwable)exc);
            }
        }
    }

    public void copyFrom(FileObject file, FileSelector selector) throws FileSystemException {
        if (!file.exists()) {
            throw new FileSystemException("vfs.provider/copy-missing-file.error", file);
        }
        if (!this.isWriteable()) {
            throw new FileSystemException("vfs.provider/copy-read-only.error", new Object[]{file.getType(), file.getName(), this}, null);
        }
        ArrayList files = new ArrayList();
        file.findFiles(selector, false, files);
        int count = files.size();
        for (int i = 0; i < count; ++i) {
            FileObject srcFile = (FileObject)files.get(i);
            String relPath = file.getName().getRelativeName(srcFile.getName());
            FileObject destFile = this.resolveFile(relPath, NameScope.DESCENDENT_OR_SELF);
            if (destFile.exists() && destFile.getType() != srcFile.getType()) {
                destFile.delete(Selectors.SELECT_ALL);
            }
            try {
                if (srcFile.getType().hasContent()) {
                    FileUtil.copyContent(srcFile, destFile);
                    continue;
                }
                if (!srcFile.getType().hasChildren()) continue;
                destFile.createFolder();
                continue;
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/copy-file.error", new Object[]{srcFile, destFile}, (Throwable)e);
            }
        }
    }

    public void moveTo(FileObject destFile) throws FileSystemException {
        if (this.canRenameTo(destFile)) {
            if (!this.getParent().isWriteable()) {
                throw new FileSystemException("vfs.provider/rename-parent-read-only.error", new FileName[]{this.getName(), this.getParent().getName()});
            }
        } else if (!this.isWriteable()) {
            throw new FileSystemException("vfs.provider/rename-read-only.error", this.getName());
        }
        if (destFile.exists() && !this.isSameFile(destFile)) {
            destFile.delete(Selectors.SELECT_ALL);
        }
        if (this.canRenameTo(destFile)) {
            try {
                this.attach();
                this.doRename(destFile);
                FileObjectUtils.getAbstractFileObject(destFile).handleCreate(this.getType());
                destFile.close();
                this.handleDelete();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception exc) {
                throw new FileSystemException("vfs.provider/rename.error", new Object[]{this.getName(), destFile.getName()}, (Throwable)exc);
            }
        } else {
            destFile.copyFrom(this, Selectors.SELECT_SELF);
            if ((destFile.getType() == FileType.FILE && destFile.getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FILE) || destFile.getType() == FileType.FOLDER && destFile.getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FOLDER)) && this.getFileSystem().hasCapability(Capability.GET_LAST_MODIFIED)) {
                destFile.getContent().setLastModifiedTime(this.getContent().getLastModifiedTime());
            }
            this.deleteSelf();
        }
    }

    protected boolean isSameFile(FileObject destFile) throws FileSystemException {
        this.attach();
        return this.doIsSameFile(destFile);
    }

    protected boolean doIsSameFile(FileObject destFile) throws FileSystemException {
        return false;
    }

    public boolean canRenameTo(FileObject newfile) {
        return this.getFileSystem() == newfile.getFileSystem();
    }

    public FileObject[] findFiles(FileSelector selector) throws FileSystemException {
        if (!this.exists()) {
            return null;
        }
        ArrayList list = new ArrayList();
        this.findFiles(selector, true, list);
        return list.toArray(new FileObject[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileContent getContent() throws FileSystemException {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            this.attach();
            if (this.content == null) {
                this.content = new DefaultFileContent(this, this.getFileContentInfoFactory());
            }
            return this.content;
        }
    }

    public void refresh() throws FileSystemException {
        try {
            this.detach();
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/resync.error", this.name, (Throwable)e);
        }
    }

    public void close() throws FileSystemException {
        FileSystemException exc = null;
        if (this.content != null) {
            try {
                this.content.close();
            }
            catch (FileSystemException e) {
                exc = e;
            }
        }
        try {
            this.detach();
        }
        catch (Exception e) {
            exc = new FileSystemException("vfs.provider/close.error", this.name, (Throwable)e);
        }
        if (exc != null) {
            throw exc;
        }
    }

    public InputStream getInputStream() throws FileSystemException {
        if (!this.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/read-not-file.error", this.name);
        }
        if (!this.isReadable()) {
            throw new FileSystemException("vfs.provider/read-not-readable.error", this.name);
        }
        try {
            return this.doGetInputStream();
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/read.error", this.name, (Throwable)exc);
        }
    }

    public RandomAccessContent getRandomAccessContent(RandomAccessMode mode) throws FileSystemException {
        if (!this.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/read-not-file.error", this.name);
        }
        if (mode.requestRead()) {
            if (!this.getFileSystem().hasCapability(Capability.RANDOM_ACCESS_READ)) {
                throw new FileSystemException("vfs.provider/random-access-read-not-supported.error");
            }
            if (!this.isReadable()) {
                throw new FileSystemException("vfs.provider/read-not-readable.error", this.name);
            }
        }
        if (mode.requestWrite()) {
            if (!this.getFileSystem().hasCapability(Capability.RANDOM_ACCESS_WRITE)) {
                throw new FileSystemException("vfs.provider/random-access-write-not-supported.error");
            }
            if (!this.isWriteable()) {
                throw new FileSystemException("vfs.provider/write-read-only.error", this.name);
            }
        }
        try {
            return this.doGetRandomAccessContent(mode);
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/random-access.error", this.name, (Throwable)exc);
        }
    }

    public OutputStream getOutputStream() throws FileSystemException {
        return this.getOutputStream(false);
    }

    public OutputStream getOutputStream(boolean bAppend) throws FileSystemException {
        FileObject parent;
        if (this.getType() != FileType.IMAGINARY && !this.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/write-not-file.error", this.name);
        }
        if (!this.isWriteable()) {
            throw new FileSystemException("vfs.provider/write-read-only.error", this.name);
        }
        if (bAppend && !this.getFileSystem().hasCapability(Capability.APPEND_CONTENT)) {
            throw new FileSystemException("vfs.provider/write-append-not-supported.error", this.name);
        }
        if (this.getType() == FileType.IMAGINARY && (parent = this.getParent()) != null) {
            parent.createFolder();
        }
        try {
            return this.doGetOutputStream(bAppend);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/write.error", new Object[]{this.name}, (Throwable)exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detach() throws Exception {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            if (this.attached) {
                try {
                    this.doDetach();
                }
                finally {
                    this.attached = false;
                    this.setFileType(null);
                    this.parent = null;
                    this.fs.fileDetached(this);
                    this.removeChildrenCache();
                }
            }
        }
    }

    private void removeChildrenCache() {
        this.children = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attach() throws FileSystemException {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            if (this.attached) {
                return;
            }
            try {
                this.doAttach();
                this.attached = true;
                if (this.type == null) {
                    this.setFileType(this.doGetType());
                }
                if (this.type == null) {
                    this.setFileType(FileType.IMAGINARY);
                }
            }
            catch (Exception exc) {
                throw new FileSystemException("vfs.provider/get-type.error", new Object[]{this.name}, (Throwable)exc);
            }
            this.fs.fileAttached(this);
        }
    }

    protected void endOutput() throws Exception {
        if (this.getType() == FileType.IMAGINARY) {
            this.handleCreate(FileType.FILE);
        } else {
            this.onChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCreate(FileType newType) throws Exception {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            if (this.attached) {
                this.injectType(newType);
                this.removeChildrenCache();
                this.onChange();
            }
            this.notifyParent(this.getName(), newType);
            this.fs.fireFileCreated(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDelete() throws Exception {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            if (this.attached) {
                this.injectType(FileType.IMAGINARY);
                this.removeChildrenCache();
                this.onChange();
            }
            this.notifyParent(this.getName(), FileType.IMAGINARY);
            this.fs.fireFileDeleted(this);
        }
    }

    protected void handleChanged() throws Exception {
        this.fs.fireFileChanged(this);
    }

    protected void childrenChanged() throws Exception {
        this.childrenChanged(null, null);
    }

    protected void childrenChanged(FileName childName, FileType newType) throws Exception {
        if (this.children != null && childName != null && newType != null) {
            ArrayList<FileName> list = new ArrayList<FileName>(Arrays.asList(this.children));
            if (newType.equals(FileType.IMAGINARY)) {
                list.remove(childName);
            } else {
                list.add(childName);
            }
            this.children = new FileName[list.size()];
            list.toArray(this.children);
        }
        this.onChildrenChanged(childName, newType);
    }

    private void notifyParent(FileName childName, FileType newType) throws Exception {
        FileName parentName;
        if (this.parent == null && (parentName = this.name.getParent()) != null) {
            this.parent = this.fs.getFileFromCache(parentName);
        }
        if (this.parent != null) {
            FileObjectUtils.getAbstractFileObject(this.parent).childrenChanged(childName, newType);
        }
    }

    public void findFiles(FileSelector selector, boolean depthwise, List selected) throws FileSystemException {
        try {
            if (this.exists()) {
                DefaultFileSelectorInfo info = new DefaultFileSelectorInfo();
                info.setBaseFolder(this);
                info.setDepth(0);
                info.setFile(this);
                AbstractFileObject.traverse(info, selector, depthwise, selected);
            }
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/find-files.error", this.name, (Throwable)e);
        }
    }

    private static void traverse(DefaultFileSelectorInfo fileInfo, FileSelector selector, boolean depthwise, List selected) throws Exception {
        FileObject file = fileInfo.getFile();
        int index = selected.size();
        if (file.getType().hasChildren() && selector.traverseDescendents(fileInfo)) {
            int curDepth = fileInfo.getDepth();
            fileInfo.setDepth(curDepth + 1);
            FileObject[] children = file.getChildren();
            for (int i = 0; i < children.length; ++i) {
                FileObject child = children[i];
                fileInfo.setFile(child);
                AbstractFileObject.traverse(fileInfo, selector, depthwise, selected);
            }
            fileInfo.setFile(file);
            fileInfo.setDepth(curDepth);
        }
        if (selector.includeFile(fileInfo)) {
            if (depthwise) {
                selected.add(file);
            } else {
                selected.add(index, file);
            }
        }
    }

    public boolean isContentOpen() {
        if (this.content == null) {
            return false;
        }
        return this.content.isOpen();
    }

    public boolean isAttached() {
        return this.attached;
    }

    protected FileContentInfoFactory getFileContentInfoFactory() {
        return this.getFileSystem().getFileSystemManager().getFileContentInfoFactory();
    }

    protected void injectType(FileType fileType) {
        this.setFileType(fileType);
    }

    private void setFileType(FileType type) {
        if (type != null && type != FileType.IMAGINARY) {
            try {
                this.name.setType(type);
            }
            catch (FileSystemException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        this.type = type;
    }

    public void holdObject(Object strongRef) {
        if (this.objects == null) {
            this.objects = new ArrayList(5);
        }
        this.objects.add(strongRef);
    }

    protected void notifyAllStreamsClosed() {
    }

    public FileOperations getFileOperations() throws FileSystemException {
        if (this.operations == null) {
            this.operations = new DefaultFileOperations(this);
        }
        return this.operations;
    }
}

