/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.commandLine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ResourceBundle;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.commandLine.BasicListener;
import org.netbeans.lib.cvsclient.commandLine.CommandFactory;
import org.netbeans.lib.cvsclient.commandLine.GetOpt;
import org.netbeans.lib.cvsclient.commandLine.ListenerProvider;
import org.netbeans.lib.cvsclient.commandLine.command.CommandProvider;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.ConnectionFactory;
import org.netbeans.lib.cvsclient.connection.PServerConnection;
import org.netbeans.lib.cvsclient.connection.PasswordsFile;
import org.netbeans.lib.cvsclient.connection.StandardScrambler;
import org.netbeans.lib.cvsclient.event.CVSListener;

public class CVSCommand {
    private static final String HELP_OPTIONS = "--help-options";
    private static final String HELP_COMMANDS = "--help-commands";
    private static final String HELP_SYNONYMS = "--help-synonyms";
    private String repository;
    private String localPath;
    private Connection connection;
    private Client client;
    private GlobalOptions globalOptions;
    private int port = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean executeCommand(Command command, PrintStream printStream) throws CommandException, AuthenticationException {
        this.client.setErrorStream(printStream);
        return this.client.executeCommand(command, this.globalOptions);
    }

    public void setRepository(String string) {
        this.repository = string;
    }

    public void setLocalPath(String string) {
        this.localPath = string;
    }

    public void setGlobalOptions(GlobalOptions globalOptions) {
        this.globalOptions = globalOptions;
    }

    private void connect(CVSRoot cVSRoot, String string) throws IllegalArgumentException, AuthenticationException, CommandAbortedException {
        this.connection = ConnectionFactory.getConnection(cVSRoot);
        if ("pserver".equals(cVSRoot.getMethod())) {
            ((PServerConnection)this.connection).setEncodedPassword(string);
            if (this.port > 0) {
                ((PServerConnection)this.connection).setPort(this.port);
            }
        }
        this.connection.open();
        this.client = new Client(this.connection, new StandardAdminHandler());
        this.client.setLocalPath(this.localPath);
    }

    private void addListener(CVSListener cVSListener) {
        if (this.client != null) {
            this.client.getEventManager().addCVSListener(cVSListener);
        }
    }

    private void close(PrintStream printStream) {
        try {
            this.connection.close();
        }
        catch (IOException iOException) {
            printStream.println("Unable to close connection: " + iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCVSRoot(String string) {
        String string2 = null;
        BufferedReader bufferedReader = null;
        if (string == null) {
            string = System.getProperty("user.dir");
        }
        try {
            File file = new File(string);
            File file2 = new File(file, "CVS/Root");
            if (file2.exists()) {
                bufferedReader = new BufferedReader(new FileReader(file2));
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                System.err.println("Warning: could not close CVS/Root file!");
            }
        }
        if (string2 == null) {
            string2 = System.getProperty("cvs.root");
        }
        return string2;
    }

    private static int processGlobalOptions(String[] stringArray, GlobalOptions globalOptions, PrintStream printStream) {
        String string = globalOptions.getOptString();
        GetOpt getOpt = new GetOpt(stringArray, string);
        int n = -1;
        boolean bl = false;
        while (true) {
            n = getOpt.getopt();
            if (n == -1) break;
            boolean bl2 = globalOptions.setCVSCommand((char)n, getOpt.optArgGet());
            if (bl2) continue;
            bl = true;
        }
        if (bl) {
            CVSCommand.showUsage(printStream);
            return -10;
        }
        return getOpt.optIndexGet();
    }

    private static void showUsage(PrintStream printStream) {
        String string = ResourceBundle.getBundle(CVSCommand.class.getPackage().getName() + ".Bundle").getString("MSG_HelpUsage");
        printStream.println(MessageFormat.format(string, HELP_OPTIONS, HELP_COMMANDS, HELP_SYNONYMS));
    }

    private static boolean performLogin(String string, String string2, String string3, int n, GlobalOptions globalOptions) {
        Object object;
        PServerConnection pServerConnection = new PServerConnection();
        pServerConnection.setUserName(string);
        String string4 = null;
        try {
            object = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Enter password: ");
            string4 = ((BufferedReader)object).readLine();
        }
        catch (IOException iOException) {
            System.err.println("Could not read password: " + iOException);
            return false;
        }
        object = StandardScrambler.getInstance().scramble(string4);
        pServerConnection.setEncodedPassword((String)object);
        pServerConnection.setHostName(string2);
        pServerConnection.setRepository(string3);
        pServerConnection.setPort(n);
        try {
            pServerConnection.verify();
        }
        catch (AuthenticationException authenticationException) {
            System.err.println("Could not login to host " + string2);
            return false;
        }
        String string5 = globalOptions.getCVSRoot();
        try {
            PasswordsFile.storePassword(string5, (String)object);
            System.err.println("Logged in successfully to " + string3 + " on host " + string2);
            return true;
        }
        catch (IOException iOException) {
            System.err.println("Error: could not write password file.");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String lookupPassword(String string, String string2, PrintStream printStream) {
        File file = new File(System.getProperty("cvs.passfile", System.getProperty("user.home") + "/.cvspass"));
        BufferedReader bufferedReader = null;
        String string3 = null;
        try {
            String string4;
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string4 = bufferedReader.readLine()) != null) {
                if (string4.startsWith("/1 ")) {
                    string4 = string4.substring("/1 ".length());
                }
                if (string4.startsWith(string + " ")) {
                    string3 = string4.substring(string.length() + 1);
                } else {
                    if (!string4.startsWith(string2 + " ")) continue;
                    string3 = string4.substring(string2.length() + 1);
                }
                break;
            }
        }
        catch (IOException iOException) {
            printStream.println("Could not read password for host: " + iOException);
            String string5 = null;
            return string5;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    printStream.println("Warning: could not close password file.");
                }
            }
        }
        if (string3 == null) {
            printStream.println("Didn't find password for CVSROOT '" + string + "'.");
        }
        return string3;
    }

    public static void main(String[] stringArray) {
        if (CVSCommand.processCommand(stringArray, null, System.getProperty("user.dir"), System.out, System.err)) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    public static boolean processCommand(String[] stringArray, File[] fileArray, String string, PrintStream printStream, PrintStream printStream2) {
        return CVSCommand.processCommand(stringArray, fileArray, string, 0, printStream, printStream2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean processCommand(String[] stringArray, File[] fileArray, String string, int n, PrintStream printStream, PrintStream printStream2) {
        if (!$assertionsDisabled && printStream == null) {
            throw new AssertionError((Object)"The output stream must be defined.");
        }
        if (!$assertionsDisabled && printStream2 == null) {
            throw new AssertionError((Object)"The error stream must be defined.");
        }
        if (stringArray.length > 0) {
            if (HELP_OPTIONS.equals(stringArray[0])) {
                CVSCommand.printHelpOptions(printStream);
                return true;
            }
            if (HELP_COMMANDS.equals(stringArray[0])) {
                CVSCommand.printHelpCommands(printStream);
                return true;
            }
            if (HELP_SYNONYMS.equals(stringArray[0])) {
                CVSCommand.printHelpSynonyms(printStream);
                return true;
            }
        }
        try {
            string = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        GlobalOptions globalOptions = new GlobalOptions();
        globalOptions.setCVSRoot(CVSCommand.getCVSRoot(string));
        int n2 = -1;
        try {
            n2 = CVSCommand.processGlobalOptions(stringArray, globalOptions, printStream2);
            if (n2 == -10) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            printStream2.println("Invalid argument: " + illegalArgumentException);
            return false;
        }
        if (globalOptions.isShowHelp()) {
            CVSCommand.printHelp(n2, stringArray, printStream, printStream2);
            return true;
        }
        if (globalOptions.isShowVersion()) {
            CVSCommand.printVersion(printStream, printStream2);
            return true;
        }
        if (globalOptions.getCVSRoot() == null) {
            printStream2.println("No CVS root is set. Use the cvs.root property, e.g. java -Dcvs.root=\":pserver:user@host:/usr/cvs\" or start the application in a directory containing a CVS subdirectory or use the -d command switch.");
            return false;
        }
        CVSRoot cVSRoot = null;
        String string2 = globalOptions.getCVSRoot();
        try {
            cVSRoot = CVSRoot.parse(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            printStream2.println("Incorrect format for CVSRoot: " + string2 + "\nThe correct format is: " + "[:method:][[user][:password]@][hostname:[port]]/path/to/repository" + "\nwhere \"method\" is pserver.");
            return false;
        }
        if (n2 >= stringArray.length) {
            CVSCommand.showUsage(printStream2);
            return false;
        }
        String string3 = stringArray[n2];
        if (string3.equals("login")) {
            if ("pserver".equals(cVSRoot.getMethod())) {
                return CVSCommand.performLogin(cVSRoot.getUserName(), cVSRoot.getHostName(), cVSRoot.getRepository(), cVSRoot.getPort(), globalOptions);
            }
            printStream2.println("login does not apply for connection type '" + cVSRoot.getMethod() + "'");
            return false;
        }
        Command command = null;
        try {
            command = CommandFactory.getDefault().createCommand(string3, stringArray, ++n2, globalOptions, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            printStream2.println("Illegal argument: " + illegalArgumentException.getMessage());
            return false;
        }
        if (fileArray != null && command instanceof BasicCommand) {
            ((BasicCommand)command).setFiles(fileArray);
        }
        String string4 = null;
        if ("pserver".equals(cVSRoot.getMethod())) {
            string4 = cVSRoot.getPassword();
            if (string4 != null) {
                string4 = StandardScrambler.getInstance().scramble(string4);
            } else {
                if (n > 0) {
                    cVSRoot.setPort(n);
                }
                if ((string4 = CVSCommand.lookupPassword(string2, cVSRoot.toString(), printStream2)) == null) {
                    string4 = StandardScrambler.getInstance().scramble("");
                }
            }
        }
        CVSCommand cVSCommand = new CVSCommand();
        cVSCommand.setGlobalOptions(globalOptions);
        cVSCommand.setRepository(cVSRoot.getRepository());
        if (n > 0) {
            cVSCommand.port = n;
        }
        cVSCommand.setLocalPath(string);
        try {
            boolean bl;
            cVSCommand.connect(cVSRoot, string4);
            CVSListener cVSListener = command instanceof ListenerProvider ? ((ListenerProvider)((Object)command)).createCVSListener(printStream, printStream2) : new BasicListener(printStream, printStream2);
            cVSCommand.addListener(cVSListener);
            boolean bl2 = bl = cVSCommand.executeCommand(command, printStream2);
            return bl2;
        }
        catch (AuthenticationException authenticationException) {
            printStream2.println(authenticationException.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        catch (CommandAbortedException commandAbortedException) {
            printStream2.println("Error: " + commandAbortedException);
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            printStream2.println("Error: " + exception);
            exception.printStackTrace(printStream2);
            boolean bl = false;
            return bl;
        }
        finally {
            if (cVSCommand != null) {
                cVSCommand.close(printStream2);
            }
        }
    }

    private static void printHelpOptions(PrintStream printStream) {
        String string = ResourceBundle.getBundle(CVSCommand.class.getPackage().getName() + ".Bundle").getString("MSG_HelpOptions");
        printStream.println(string);
    }

    private static void printHelpCommands(PrintStream printStream) {
        int n;
        String string = ResourceBundle.getBundle(CVSCommand.class.getPackage().getName() + ".Bundle").getString("MSG_CVSCommands");
        printStream.println(string);
        CommandProvider[] commandProviderArray = CommandFactory.getDefault().getCommandProviders();
        Arrays.sort(commandProviderArray, new CommandProvidersComparator());
        int n2 = 0;
        for (n = 0; n < commandProviderArray.length; ++n) {
            int n3 = commandProviderArray[n].getName().length();
            if (n2 >= n3) continue;
            n2 = n3;
        }
        n2 += 2;
        for (n = 0; n < commandProviderArray.length; ++n) {
            printStream.print("\t" + commandProviderArray[n].getName());
            char[] cArray = new char[n2 - commandProviderArray[n].getName().length()];
            Arrays.fill(cArray, ' ');
            printStream.print(new String(cArray));
            commandProviderArray[n].printShortDescription(printStream);
            printStream.println();
        }
    }

    private static void printHelpSynonyms(PrintStream printStream) {
        int n;
        String string = ResourceBundle.getBundle(CVSCommand.class.getPackage().getName() + ".Bundle").getString("MSG_CVSSynonyms");
        printStream.println(string);
        CommandProvider[] commandProviderArray = CommandFactory.getDefault().getCommandProviders();
        Arrays.sort(commandProviderArray, new CommandProvidersComparator());
        int n2 = 0;
        for (n = 0; n < commandProviderArray.length; ++n) {
            int n3 = commandProviderArray[n].getName().length();
            if (n2 >= n3) continue;
            n2 = n3;
        }
        n2 += 2;
        for (n = 0; n < commandProviderArray.length; ++n) {
            String[] stringArray = commandProviderArray[n].getSynonyms();
            if (stringArray.length <= 0) continue;
            printStream.print("\t" + commandProviderArray[n].getName());
            char[] cArray = new char[n2 - commandProviderArray[n].getName().length()];
            Arrays.fill(cArray, ' ');
            printStream.print(new String(cArray));
            for (int i = 0; i < stringArray.length; ++i) {
                printStream.print(stringArray[i] + " ");
            }
            printStream.println();
        }
    }

    private static void printHelp(int n, String[] stringArray, PrintStream printStream, PrintStream printStream2) {
        if (n >= stringArray.length) {
            CVSCommand.showUsage(printStream);
        } else {
            String string = stringArray[n];
            CommandProvider commandProvider = CommandFactory.getDefault().getCommandProvider(string);
            if (commandProvider == null) {
                CVSCommand.printUnknownCommand(string, printStream2);
            } else {
                commandProvider.printLongDescription(printStream);
            }
        }
    }

    private static void printVersion(PrintStream printStream, PrintStream printStream2) {
        String string = CVSCommand.class.getPackage().getSpecificationVersion();
        printStream.println("Java Concurrent Versions System (JavaCVS) " + string + " (client)");
    }

    private static void printUnknownCommand(String string, PrintStream printStream) {
        String string2 = ResourceBundle.getBundle(CVSCommand.class.getPackage().getName() + ".Bundle").getString("MSG_UnknownCommand");
        printStream.println(MessageFormat.format(string2, string));
        CVSCommand.printHelpCommands(printStream);
    }

    static {
        $assertionsDisabled = !CVSCommand.class.desiredAssertionStatus();
    }

    private static final class CommandProvidersComparator
    implements Comparator {
        private CommandProvidersComparator() {
        }

        public int compare(Object object, Object object2) {
            if (!(object instanceof CommandProvider) || !(object2 instanceof CommandProvider)) {
                throw new IllegalArgumentException("Can not compare objects " + object + " and " + object2);
            }
            return ((CommandProvider)object).getName().compareTo(((CommandProvider)object2).getName());
        }
    }
}

