/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.jfree.util.ObjectUtilities;
import org.jfree.xml.factory.objects.AbstractObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;

public class ClassLoaderObjectDescription
extends AbstractObjectDescription {
    public ClassLoaderObjectDescription() {
        super(Object.class);
        this.setParameterDefinition("class", String.class);
    }

    public Object createObject() {
        try {
            String string = (String)this.getParameter("class");
            return ObjectUtilities.getClassLoader(this.getClass()).loadClass(string).newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setParameterFromObject(Object object) throws ObjectFactoryException {
        if (object == null) {
            throw new ObjectFactoryException("The Object is null.");
        }
        try {
            Constructor<?> constructor = object.getClass().getConstructor(new Class[0]);
            if (!Modifier.isPublic(constructor.getModifiers())) {
                throw new ObjectFactoryException("The given object has no public default constructor. [" + object.getClass() + "]");
            }
            this.setParameter("class", object.getClass().getName());
        }
        catch (Exception exception) {
            throw new ObjectFactoryException("The given object has no default constructor. [" + object.getClass() + "]", exception);
        }
    }
}

