/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.jfree.util.Log;
import org.jfree.xml.factory.objects.AbstractObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;

public class BeanObjectDescription
extends AbstractObjectDescription {
    private TreeSet ignoredParameters = new TreeSet();
    private transient HashMap properties;

    public BeanObjectDescription(Class clazz) {
        this(clazz, true);
    }

    public BeanObjectDescription(Class clazz, boolean bl) {
        super(clazz);
        this.readBeanDescription(clazz, bl);
    }

    private boolean isValidMethod(Method method, int n) {
        if (method == null) {
            return false;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        return method.getParameterTypes().length == n;
    }

    public Object createObject() {
        try {
            Object t = this.getObjectClass().newInstance();
            Iterator iterator = this.getParameterNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (this.isParameterIgnored(string)) continue;
                Method method = this.findSetMethod(string);
                Object object = this.getParameter(string);
                if (object == null) continue;
                method.invoke(t, object);
            }
            return t;
        }
        catch (Exception exception) {
            Log.error("Unable to invoke bean method", exception);
            return null;
        }
    }

    private Method findSetMethod(String string) {
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.properties.get(string);
        return propertyDescriptor.getWriteMethod();
    }

    private Method findGetMethod(String string) {
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.properties.get(string);
        return propertyDescriptor.getReadMethod();
    }

    public void setParameterFromObject(Object object) throws ObjectFactoryException {
        if (object == null) {
            throw new NullPointerException("Given object is null");
        }
        Class clazz = this.getObjectClass();
        if (!clazz.isInstance(object)) {
            throw new ObjectFactoryException("Object is no instance of " + clazz + "(is " + object.getClass() + ")");
        }
        Iterator iterator = this.getParameterNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.isParameterIgnored(string)) continue;
            try {
                Method method = this.findGetMethod(string);
                Object object2 = method.invoke(object, null);
                if (object2 == null) continue;
                this.setParameter(string, object2);
            }
            catch (Exception exception) {
                Log.info("Exception on method invokation.", exception);
            }
        }
    }

    protected void ignoreParameter(String string) {
        this.ignoredParameters.add(string);
    }

    protected boolean isParameterIgnored(String string) {
        return this.ignoredParameters.contains(string);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.readBeanDescription(this.getObjectClass(), false);
    }

    private void readBeanDescription(Class clazz, boolean bl) {
        try {
            this.properties = new HashMap();
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                Method method = propertyDescriptor.getReadMethod();
                Method method2 = propertyDescriptor.getWriteMethod();
                if (!this.isValidMethod(method, 0) || !this.isValidMethod(method2, 1)) continue;
                String string = propertyDescriptor.getName();
                this.properties.put(string, propertyDescriptor);
                if (!bl) continue;
                super.setParameterDefinition(string, propertyDescriptor.getPropertyType());
            }
        }
        catch (IntrospectionException introspectionException) {
            Log.error("Unable to build bean description", introspectionException);
        }
    }
}

