/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.jfree.util.Configuration;
import org.jfree.util.Log;
import org.jfree.util.ReadOnlyIterator;
import org.jfree.xml.factory.objects.ObjectDescription;

public abstract class AbstractObjectDescription
implements ObjectDescription,
Cloneable {
    private Class className;
    private HashMap parameters;
    private HashMap parameterDefs;
    private Configuration config;

    public AbstractObjectDescription(Class clazz) {
        this.className = clazz;
        this.parameters = new HashMap();
        this.parameterDefs = new HashMap();
    }

    public Class getParameterDefinition(String string) {
        return (Class)this.parameterDefs.get(string);
    }

    public void setParameterDefinition(String string, Class clazz) {
        if (clazz == null) {
            this.parameterDefs.remove(string);
        } else {
            this.parameterDefs.put(string, clazz);
        }
    }

    public static Class convertPrimitiveClass(Class clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        throw new IllegalArgumentException("Class 'void' is not allowed here");
    }

    public void setParameter(String string, Object object) {
        if (this.getParameterDefinition(string) == null) {
            throw new IllegalArgumentException("No such Parameter defined: " + string + " in class " + this.getObjectClass());
        }
        Class clazz = AbstractObjectDescription.convertPrimitiveClass(this.getParameterDefinition(string));
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new ClassCastException("In Object " + this.getObjectClass() + ": Value is not assignable: " + object.getClass() + " is not assignable from " + clazz);
        }
        this.parameters.put(string, object);
    }

    public synchronized Iterator getParameterNames() {
        ArrayList arrayList = new ArrayList(this.parameterDefs.keySet());
        Collections.sort(arrayList);
        return new ReadOnlyIterator(arrayList.iterator());
    }

    protected Iterator getDefinedParameterNames() {
        return new ReadOnlyIterator(this.parameters.keySet().iterator());
    }

    public Object getParameter(String string) {
        return this.parameters.get(string);
    }

    public Class getObjectClass() {
        return this.className;
    }

    public ObjectDescription getInstance() {
        try {
            AbstractObjectDescription abstractObjectDescription = (AbstractObjectDescription)super.clone();
            abstractObjectDescription.parameters = (HashMap)this.parameters.clone();
            return abstractObjectDescription;
        }
        catch (Exception exception) {
            Log.error("Should not happen: Clone Error: ", exception);
            return null;
        }
    }

    public ObjectDescription getUnconfiguredInstance() {
        try {
            AbstractObjectDescription abstractObjectDescription = (AbstractObjectDescription)super.clone();
            abstractObjectDescription.parameters = (HashMap)this.parameters.clone();
            abstractObjectDescription.config = null;
            return abstractObjectDescription;
        }
        catch (Exception exception) {
            Log.error("Should not happen: Clone Error: ", exception);
            return null;
        }
    }

    public void configure(Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException("The given configuration is null");
        }
        this.config = configuration;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractObjectDescription)) {
            return false;
        }
        AbstractObjectDescription abstractObjectDescription = (AbstractObjectDescription)object;
        return this.className.equals(abstractObjectDescription.className);
    }

    public int hashCode() {
        return this.className.hashCode();
    }
}

