/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jfree.util.Log;
import org.jfree.xml.ElementDefinitionException;
import org.jfree.xml.FrontendDefaultHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ParserFrontend {
    private FrontendDefaultHandler defaulthandler;
    private SAXParserFactory factory;
    private EntityResolver entityResolver;
    private boolean validateDTD;

    protected ParserFrontend(FrontendDefaultHandler frontendDefaultHandler) {
        if (frontendDefaultHandler == null) {
            throw new NullPointerException();
        }
        this.defaulthandler = frontendDefaultHandler;
    }

    public boolean isValidateDTD() {
        return this.validateDTD;
    }

    public void setValidateDTD(boolean bl) {
        this.validateDTD = bl;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    protected SAXParser getParser() throws ParserConfigurationException, SAXException {
        if (this.factory == null) {
            this.factory = SAXParserFactory.newInstance();
            if (this.isValidateDTD()) {
                try {
                    this.factory.setValidating(true);
                }
                catch (Exception exception) {
                    Log.debug("The parser will not validate the xml document.", exception);
                }
            }
        }
        return this.factory.newSAXParser();
    }

    public void setDefaultHandler(FrontendDefaultHandler frontendDefaultHandler) {
        if (frontendDefaultHandler == null) {
            throw new NullPointerException();
        }
        this.defaulthandler = frontendDefaultHandler;
    }

    public FrontendDefaultHandler getDefaultHandler() {
        return this.defaulthandler;
    }

    protected FrontendDefaultHandler createDefaultHandler(URL uRL) {
        FrontendDefaultHandler frontendDefaultHandler = this.getDefaultHandler().newInstance();
        if (uRL != null) {
            frontendDefaultHandler.setConfigProperty("content-base", uRL.toExternalForm());
        }
        return frontendDefaultHandler;
    }

    protected Object parse(InputSource inputSource, URL uRL) throws ElementDefinitionException {
        try {
            SAXParser sAXParser = this.getParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            try {
                xMLReader.setFeature("http://xml.org/sax/features/validation", this.isValidateDTD());
            }
            catch (SAXException sAXException) {
                Log.debug("The XMLReader will not validate the xml document.", sAXException);
            }
            FrontendDefaultHandler frontendDefaultHandler = this.createDefaultHandler(uRL);
            this.configureReader(xMLReader, frontendDefaultHandler);
            try {
                xMLReader.setContentHandler(frontendDefaultHandler);
                xMLReader.setDTDHandler(frontendDefaultHandler);
                if (this.getEntityResolver() != null) {
                    xMLReader.setEntityResolver(this.getEntityResolver());
                }
                xMLReader.setErrorHandler(frontendDefaultHandler);
                xMLReader.parse(inputSource);
                return frontendDefaultHandler.getResult();
            }
            catch (IOException iOException) {
                throw new ElementDefinitionException(iOException);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ElementDefinitionException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new ElementDefinitionException(sAXException);
        }
    }

    protected void configureReader(XMLReader xMLReader, FrontendDefaultHandler frontendDefaultHandler) {
        try {
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", frontendDefaultHandler.getCommentHandler());
        }
        catch (SAXException sAXException) {
            Log.debug("Comments are not supported by this SAX implementation.");
        }
    }

    public Object parse(URL uRL, URL uRL2) throws ElementDefinitionException, IOException {
        if (uRL == null) {
            throw new NullPointerException("File may not be null");
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
        InputSource inputSource = new InputSource(bufferedInputStream);
        inputSource.setSystemId(uRL.toString());
        Object object = this.parse(inputSource, uRL2);
        bufferedInputStream.close();
        return object;
    }
}

