/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.util.UnitType;

public class UnitTypeTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(UnitTypeTests.class);
    }

    public UnitTypeTests(String string) {
        super(string);
    }

    public void testEquals() {
        UnitTypeTests.assertTrue((boolean)UnitType.ABSOLUTE.equals(UnitType.ABSOLUTE));
        UnitTypeTests.assertTrue((boolean)UnitType.RELATIVE.equals(UnitType.RELATIVE));
        UnitTypeTests.assertFalse((boolean)UnitType.ABSOLUTE.equals(UnitType.RELATIVE));
        UnitTypeTests.assertFalse((boolean)UnitType.RELATIVE.equals(UnitType.ABSOLUTE));
        UnitTypeTests.assertFalse((boolean)UnitType.ABSOLUTE.equals(null));
        UnitTypeTests.assertFalse((boolean)UnitType.RELATIVE.equals(null));
    }

    public void testSerialization() {
        UnitType unitType = UnitType.ABSOLUTE;
        UnitType unitType2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(unitType);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            unitType2 = (UnitType)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        UnitTypeTests.assertTrue((unitType == unitType2 ? 1 : 0) != 0);
    }
}

