/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import org.jfree.util.Log;
import org.jfree.util.PublicCloneable;

public final class ObjectUtilities {
    public static final String THREAD_CONTEXT = "ThreadContext";
    public static final String CLASS_CONTEXT = "ClassContext";
    private static String classLoaderSource = "ThreadContext";
    private static ClassLoader classLoader;

    private ObjectUtilities() {
    }

    public static String getClassLoaderSource() {
        return classLoaderSource;
    }

    public static void setClassLoaderSource(String string) {
        classLoaderSource = string;
    }

    public static boolean equal(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object != null) {
            return object.equals(object2);
        }
        return false;
    }

    public static int hashCode(Object object) {
        int n = 0;
        if (object != null) {
            n = object.hashCode();
        }
        return n;
    }

    public static Object clone(Object object) throws CloneNotSupportedException {
        if (object == null) {
            throw new IllegalArgumentException("Null 'object' argument.");
        }
        if (object instanceof PublicCloneable) {
            PublicCloneable publicCloneable = (PublicCloneable)object;
            return publicCloneable.clone();
        }
        try {
            Method method = object.getClass().getMethod("clone", null);
            if (Modifier.isPublic(method.getModifiers())) {
                return method.invoke(object, null);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.warn("Object without clone() method is impossible.");
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.warn("Object.clone(): unable to call method.");
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.warn("Object without clone() method is impossible.");
        }
        throw new CloneNotSupportedException("Failed to clone.");
    }

    public static Collection deepClone(Collection collection) throws CloneNotSupportedException {
        if (collection == null) {
            throw new IllegalArgumentException("Null 'collection' argument.");
        }
        Collection collection2 = (Collection)ObjectUtilities.clone(collection);
        collection2.clear();
        for (Object e : collection) {
            if (e != null) {
                collection2.add(ObjectUtilities.clone(e));
                continue;
            }
            collection2.add(null);
        }
        return collection2;
    }

    public static synchronized void setClassLoader(ClassLoader classLoader) {
        ObjectUtilities.classLoader = classLoader;
    }

    public static synchronized ClassLoader getClassLoader(Class clazz) {
        if (classLoader != null) {
            return classLoader;
        }
        if (THREAD_CONTEXT.equals(classLoaderSource)) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return classLoader;
        }
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static URL getResource(String string, Class clazz) {
        ClassLoader classLoader = ObjectUtilities.getClassLoader(clazz);
        return classLoader.getResource(string);
    }

    public static URL getResourceRelative(String string, Class clazz) {
        ClassLoader classLoader = ObjectUtilities.getClassLoader(clazz);
        String string2 = ObjectUtilities.convertName(string, clazz);
        return classLoader.getResource(string2);
    }

    private static String convertName(String string, Class clazz) {
        if (string.startsWith("/")) {
            return string.substring(1);
        }
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        String string2 = clazz.getName();
        int n = string2.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        String string3 = string2.substring(0, n);
        return string3.replace('.', '/') + "/" + string;
    }

    public static InputStream getResourceAsStream(String string, Class clazz) {
        URL uRL = ObjectUtilities.getResource(string, clazz);
        if (uRL == null) {
            return null;
        }
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static InputStream getResourceRelativeAsStream(String string, Class clazz) {
        URL uRL = ObjectUtilities.getResourceRelative(string, clazz);
        if (uRL == null) {
            return null;
        }
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Object loadAndInstantiate(String string, Class clazz) {
        try {
            ClassLoader classLoader = ObjectUtilities.getClassLoader(clazz);
            Class<?> clazz2 = classLoader.loadClass(string);
            return clazz2.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

