/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.date.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.date.SerialDate;
import org.jfree.date.SpreadsheetDate;

public class SpreadsheetDateTests
extends TestCase {
    private SerialDate jan1Y1900;
    private SerialDate s2;

    public static Test suite() {
        return new TestSuite(SpreadsheetDateTests.class);
    }

    public SpreadsheetDateTests(String string) {
        super(string);
    }

    protected void setUp() {
        this.jan1Y1900 = new SpreadsheetDate(1, 1, 1900);
        this.s2 = new SpreadsheetDate(2);
    }

    public void test1Jan1900GetDayOfWeek() {
        int n = this.jan1Y1900.getDayOfWeek();
        SpreadsheetDateTests.assertEquals((int)2, (int)n);
    }

    public void test12Nov2001GetDayOfWeek() {
        SpreadsheetDate spreadsheetDate = new SpreadsheetDate(12, 11, 2001);
        int n = ((SerialDate)spreadsheetDate).getDayOfWeek();
        SpreadsheetDateTests.assertEquals((int)2, (int)n);
    }

    public void testS2GetDayOfMonth() {
        int n = this.s2.getDayOfMonth();
        SpreadsheetDateTests.assertEquals((int)1, (int)n);
    }

    public void testS2GetMonth() {
        int n = this.s2.getMonth();
        SpreadsheetDateTests.assertEquals((int)1, (int)n);
    }

    public void testS2GetYYYY() {
        int n = this.s2.getYYYY();
        SpreadsheetDateTests.assertEquals((int)1900, (int)n);
    }

    public void test37986() {
        SpreadsheetDate spreadsheetDate = new SpreadsheetDate(37986);
        SpreadsheetDateTests.assertEquals((int)31, (int)spreadsheetDate.getDayOfMonth());
        SpreadsheetDateTests.assertEquals((int)12, (int)spreadsheetDate.getMonth());
        SpreadsheetDateTests.assertEquals((int)2003, (int)spreadsheetDate.getYYYY());
    }

    public void test37987() {
        SpreadsheetDate spreadsheetDate = new SpreadsheetDate(37987);
        SpreadsheetDateTests.assertEquals((int)1, (int)spreadsheetDate.getDayOfMonth());
        SpreadsheetDateTests.assertEquals((int)1, (int)spreadsheetDate.getMonth());
        SpreadsheetDateTests.assertEquals((int)2004, (int)spreadsheetDate.getYYYY());
    }

    public void test38352() {
        SpreadsheetDate spreadsheetDate = new SpreadsheetDate(38352);
        SpreadsheetDateTests.assertEquals((int)31, (int)spreadsheetDate.getDayOfMonth());
        SpreadsheetDateTests.assertEquals((int)12, (int)spreadsheetDate.getMonth());
        SpreadsheetDateTests.assertEquals((int)2004, (int)spreadsheetDate.getYYYY());
    }

    public void test38353() {
        SpreadsheetDate spreadsheetDate = new SpreadsheetDate(38353);
        SpreadsheetDateTests.assertEquals((int)1, (int)spreadsheetDate.getDayOfMonth());
        SpreadsheetDateTests.assertEquals((int)1, (int)spreadsheetDate.getMonth());
        SpreadsheetDateTests.assertEquals((int)2005, (int)spreadsheetDate.getYYYY());
    }

    public void test36584() {
        SpreadsheetDate spreadsheetDate = new SpreadsheetDate(36584);
        SpreadsheetDateTests.assertEquals((int)28, (int)spreadsheetDate.getDayOfMonth());
        SpreadsheetDateTests.assertEquals((int)2, (int)spreadsheetDate.getMonth());
        SpreadsheetDateTests.assertEquals((int)2000, (int)spreadsheetDate.getYYYY());
    }

    public void test36585() {
        SpreadsheetDate spreadsheetDate = new SpreadsheetDate(36585);
        SpreadsheetDateTests.assertEquals((int)29, (int)spreadsheetDate.getDayOfMonth());
        SpreadsheetDateTests.assertEquals((int)2, (int)spreadsheetDate.getMonth());
        SpreadsheetDateTests.assertEquals((int)2000, (int)spreadsheetDate.getYYYY());
    }

    public void test36586() {
        SpreadsheetDate spreadsheetDate = new SpreadsheetDate(36586);
        SpreadsheetDateTests.assertEquals((int)1, (int)spreadsheetDate.getDayOfMonth());
        SpreadsheetDateTests.assertEquals((int)3, (int)spreadsheetDate.getMonth());
        SpreadsheetDateTests.assertEquals((int)2000, (int)spreadsheetDate.getYYYY());
    }

    public void test01Jan1900ToSerial() {
        int n = this.jan1Y1900.toSerial();
        SpreadsheetDateTests.assertEquals((int)2, (int)n);
    }

    public void test28Feb1900ToSerial() {
        SpreadsheetDate spreadsheetDate = new SpreadsheetDate(28, 2, 1900);
        SpreadsheetDateTests.assertEquals((int)60, (int)spreadsheetDate.toSerial());
    }

    public void test01Mar1900ToSerial() {
        SpreadsheetDate spreadsheetDate = new SpreadsheetDate(1, 3, 1900);
        SpreadsheetDateTests.assertEquals((int)61, (int)spreadsheetDate.toSerial());
    }

    public void test31Dec1999ToSerial() {
        SpreadsheetDate spreadsheetDate = new SpreadsheetDate(31, 12, 1999);
        SpreadsheetDateTests.assertEquals((int)36525, (int)spreadsheetDate.toSerial());
    }

    public void test01Jan2000ToSerial() {
        SpreadsheetDate spreadsheetDate = new SpreadsheetDate(1, 1, 2000);
        SpreadsheetDateTests.assertEquals((int)36526, (int)spreadsheetDate.toSerial());
    }

    public void test31Jan2000ToSerial() {
        SpreadsheetDate spreadsheetDate = new SpreadsheetDate(31, 1, 2000);
        SpreadsheetDateTests.assertEquals((int)36556, (int)spreadsheetDate.toSerial());
    }

    public void test01Feb2000ToSerial() {
        SpreadsheetDate spreadsheetDate = new SpreadsheetDate(1, 2, 2000);
        SpreadsheetDateTests.assertEquals((int)36557, (int)spreadsheetDate.toSerial());
    }

    public void test28Feb2000ToSerial() {
        SpreadsheetDate spreadsheetDate = new SpreadsheetDate(28, 2, 2000);
        SpreadsheetDateTests.assertEquals((int)36584, (int)spreadsheetDate.toSerial());
    }

    public void test29feb2000ToSerial() {
        SpreadsheetDate spreadsheetDate = new SpreadsheetDate(29, 2, 2000);
        SpreadsheetDateTests.assertEquals((int)36585, (int)spreadsheetDate.toSerial());
    }

    public void test1mar2000ToSerial() {
        SpreadsheetDate spreadsheetDate = new SpreadsheetDate(1, 3, 2000);
        SpreadsheetDateTests.assertEquals((int)36586, (int)spreadsheetDate.toSerial());
    }

    public void testSerialization() {
        SpreadsheetDate spreadsheetDate = new SpreadsheetDate(15, 4, 2000);
        SpreadsheetDate spreadsheetDate2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(spreadsheetDate);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            spreadsheetDate2 = (SpreadsheetDate)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        SpreadsheetDateTests.assertEquals((Object)spreadsheetDate, spreadsheetDate2);
    }
}

