/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.general.SeriesException;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;

public class XYSeriesTests
extends TestCase {
    private static final double EPSILON = 1.0E-10;

    public static Test suite() {
        return new TestSuite(XYSeriesTests.class);
    }

    public XYSeriesTests(String string) {
        super(string);
    }

    public void testEquals() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series"));
        xYSeries.add(1.0, 1.1);
        XYSeries xYSeries2 = new XYSeries((Comparable)((Object)"Series"));
        xYSeries2.add(1.0, 1.1);
        XYSeriesTests.assertTrue((boolean)xYSeries.equals(xYSeries2));
        XYSeriesTests.assertTrue((boolean)xYSeries2.equals(xYSeries));
        xYSeries.setKey((Comparable)((Object)"Series X"));
        XYSeriesTests.assertFalse((boolean)xYSeries.equals(xYSeries2));
        xYSeries2.setKey((Comparable)((Object)"Series X"));
        XYSeriesTests.assertTrue((boolean)xYSeries.equals(xYSeries2));
    }

    public void testCloning() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series"));
        xYSeries.add(1.0, 1.1);
        XYSeries xYSeries2 = null;
        try {
            xYSeries2 = (XYSeries)xYSeries.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("XYSeriesTests.testCloning: failed to clone.");
        }
        XYSeriesTests.assertTrue((xYSeries != xYSeries2 ? 1 : 0) != 0);
        XYSeriesTests.assertTrue((xYSeries.getClass() == xYSeries2.getClass() ? 1 : 0) != 0);
        XYSeriesTests.assertTrue((boolean)xYSeries.equals(xYSeries2));
    }

    public void testSerialization() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series"));
        xYSeries.add(1.0, 1.1);
        XYSeries xYSeries2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(xYSeries);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            xYSeries2 = (XYSeries)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        XYSeriesTests.assertEquals((Object)xYSeries, xYSeries2);
    }

    public void testIndexOf() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 1"));
        xYSeries.add(1.0, 1.0);
        xYSeries.add(2.0, 2.0);
        xYSeries.add(3.0, 3.0);
        XYSeriesTests.assertEquals((int)0, (int)xYSeries.indexOf(new Double(1.0)));
    }

    public void testIndexOf2() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 1"), false, true);
        xYSeries.add(1.0, 1.0);
        xYSeries.add(3.0, 3.0);
        xYSeries.add(2.0, 2.0);
        XYSeriesTests.assertEquals((int)0, (int)xYSeries.indexOf(new Double(1.0)));
        XYSeriesTests.assertEquals((int)1, (int)xYSeries.indexOf(new Double(3.0)));
        XYSeriesTests.assertEquals((int)2, (int)xYSeries.indexOf(new Double(2.0)));
    }

    public void testRemove() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 1"));
        xYSeries.add(1.0, 1.0);
        xYSeries.add(2.0, 2.0);
        xYSeries.add(3.0, 3.0);
        XYSeriesTests.assertEquals((int)3, (int)xYSeries.getItemCount());
        xYSeries.remove(new Double(2.0));
        XYSeriesTests.assertEquals((Object)new Double(3.0), (Object)xYSeries.getX(1));
        xYSeries.remove(0);
        XYSeriesTests.assertEquals((Object)new Double(3.0), (Object)xYSeries.getX(0));
    }

    public void testAdditionOfDuplicateXValues() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 1"));
        xYSeries.add(1.0, 1.0);
        xYSeries.add(2.0, 2.0);
        xYSeries.add(2.0, 3.0);
        xYSeries.add(2.0, 4.0);
        xYSeries.add(3.0, 5.0);
        XYSeriesTests.assertEquals((double)1.0, (double)xYSeries.getY(0).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)2.0, (double)xYSeries.getY(1).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)3.0, (double)xYSeries.getY(2).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)4.0, (double)xYSeries.getY(3).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)5.0, (double)xYSeries.getY(4).doubleValue(), (double)1.0E-10);
    }

    public void testUpdate() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"S1"));
        xYSeries.add(new Integer(1), (Number)new Integer(2));
        XYSeriesTests.assertEquals((Object)new Integer(2), (Object)xYSeries.getY(0));
        xYSeries.update(new Integer(1), (Number)new Integer(3));
        XYSeriesTests.assertEquals((Object)new Integer(3), (Object)xYSeries.getY(0));
        try {
            xYSeries.update(new Integer(2), (Number)new Integer(99));
            XYSeriesTests.assertTrue((boolean)false);
        }
        catch (SeriesException seriesException) {
            // empty catch block
        }
    }

    public void testUpdate2() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series"), false, true);
        xYSeries.add(5.0, 55.0);
        xYSeries.add(4.0, 44.0);
        xYSeries.add(6.0, 66.0);
        xYSeries.update(new Double(4.0), (Number)new Double(99.0));
        XYSeriesTests.assertEquals((Object)new Double(99.0), (Object)xYSeries.getY(1));
    }

    public void testAddOrUpdate() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"S1"));
        XYDataItem xYDataItem = xYSeries.addOrUpdate(new Long(1L), new Long(2L));
        XYSeriesTests.assertTrue((xYDataItem == null ? 1 : 0) != 0);
        XYSeriesTests.assertEquals((int)1, (int)xYSeries.getItemCount());
        XYSeriesTests.assertEquals((Object)new Long(2L), (Object)xYSeries.getY(0));
        xYDataItem = xYSeries.addOrUpdate(new Long(2L), new Long(3L));
        XYSeriesTests.assertTrue((xYDataItem == null ? 1 : 0) != 0);
        XYSeriesTests.assertEquals((int)2, (int)xYSeries.getItemCount());
        XYSeriesTests.assertEquals((Object)new Long(3L), (Object)xYSeries.getY(1));
        xYDataItem = xYSeries.addOrUpdate(new Long(1L), new Long(99L));
        XYSeriesTests.assertEquals((Object)new XYDataItem(new Long(1L), new Long(2L)), (Object)xYDataItem);
        XYSeriesTests.assertEquals((int)2, (int)xYSeries.getItemCount());
        XYSeriesTests.assertEquals((Object)new Long(99L), (Object)xYSeries.getY(0));
        XYSeriesTests.assertEquals((Object)new Long(3L), (Object)xYSeries.getY(1));
    }

    public void testAddOrUpdate2() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series"), false, true);
        xYSeries.add(5.0, 5.5);
        xYSeries.add(6.0, 6.6);
        xYSeries.add(3.0, 3.3);
        xYSeries.add(4.0, 4.4);
        xYSeries.add(2.0, 2.2);
        xYSeries.add(1.0, 1.1);
        xYSeries.addOrUpdate(new Double(3.0), new Double(33.3));
        xYSeries.addOrUpdate(new Double(2.0), new Double(22.2));
        XYSeriesTests.assertEquals((double)33.3, (double)xYSeries.getY(2).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)22.2, (double)xYSeries.getY(4).doubleValue(), (double)1.0E-10);
    }

    public void testAdd() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series"), false, true);
        xYSeries.add(5.0, 5.5);
        xYSeries.add(5.1, 5.51);
        xYSeries.add(6.0, 6.6);
        xYSeries.add(3.0, 3.3);
        xYSeries.add(4.0, 4.4);
        xYSeries.add(2.0, 2.2);
        xYSeries.add(1.0, 1.1);
        XYSeriesTests.assertEquals((double)5.5, (double)xYSeries.getY(0).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)5.51, (double)xYSeries.getY(1).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)6.6, (double)xYSeries.getY(2).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)3.3, (double)xYSeries.getY(3).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)4.4, (double)xYSeries.getY(4).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)2.2, (double)xYSeries.getY(5).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)1.1, (double)xYSeries.getY(6).doubleValue(), (double)1.0E-10);
    }

    public void testSetMaximumItemCount() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"S1"));
        XYSeriesTests.assertEquals((int)Integer.MAX_VALUE, (int)xYSeries.getMaximumItemCount());
        xYSeries.setMaximumItemCount(2);
        XYSeriesTests.assertEquals((int)2, (int)xYSeries.getMaximumItemCount());
        xYSeries.add(1.0, 1.1);
        xYSeries.add(2.0, 2.2);
        xYSeries.add(3.0, 3.3);
        XYSeriesTests.assertEquals((double)2.0, (double)xYSeries.getX(0).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)3.0, (double)xYSeries.getX(1).doubleValue(), (double)1.0E-10);
    }

    public void testSetMaximumItemCount2() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"S1"));
        xYSeries.add(1.0, 1.1);
        xYSeries.add(2.0, 2.2);
        xYSeries.add(3.0, 3.3);
        xYSeries.setMaximumItemCount(2);
        XYSeriesTests.assertEquals((double)2.0, (double)xYSeries.getX(0).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)3.0, (double)xYSeries.getX(1).doubleValue(), (double)1.0E-10);
    }
}

