/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYSeries;

public class TableXYDatasetTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(TableXYDatasetTests.class);
    }

    public TableXYDatasetTests(String string) {
        super(string);
    }

    public void testEquals() {
        DefaultTableXYDataset defaultTableXYDataset = new DefaultTableXYDataset();
        DefaultTableXYDataset defaultTableXYDataset2 = new DefaultTableXYDataset();
        TableXYDatasetTests.assertTrue((boolean)defaultTableXYDataset.equals(defaultTableXYDataset2));
        TableXYDatasetTests.assertTrue((boolean)defaultTableXYDataset2.equals(defaultTableXYDataset));
        defaultTableXYDataset.addSeries(this.createSeries1());
        TableXYDatasetTests.assertFalse((boolean)defaultTableXYDataset.equals(defaultTableXYDataset2));
        defaultTableXYDataset2.addSeries(this.createSeries1());
        TableXYDatasetTests.assertTrue((boolean)defaultTableXYDataset.equals(defaultTableXYDataset2));
    }

    public void testCloning() {
        DefaultTableXYDataset defaultTableXYDataset = new DefaultTableXYDataset();
        defaultTableXYDataset.addSeries(this.createSeries1());
        DefaultTableXYDataset defaultTableXYDataset2 = null;
        try {
            defaultTableXYDataset2 = (DefaultTableXYDataset)defaultTableXYDataset.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        TableXYDatasetTests.assertTrue((defaultTableXYDataset != defaultTableXYDataset2 ? 1 : 0) != 0);
        TableXYDatasetTests.assertTrue((defaultTableXYDataset.getClass() == defaultTableXYDataset2.getClass() ? 1 : 0) != 0);
        TableXYDatasetTests.assertTrue((boolean)defaultTableXYDataset.equals(defaultTableXYDataset2));
    }

    public void testSerialization() {
        DefaultTableXYDataset defaultTableXYDataset = new DefaultTableXYDataset();
        defaultTableXYDataset.addSeries(this.createSeries2());
        DefaultTableXYDataset defaultTableXYDataset2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(defaultTableXYDataset);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            defaultTableXYDataset2 = (DefaultTableXYDataset)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        TableXYDatasetTests.assertEquals((Object)defaultTableXYDataset, defaultTableXYDataset2);
    }

    public void testTableXYDataset() {
        XYSeries xYSeries = this.createSeries1();
        XYSeries xYSeries2 = this.createSeries2();
        DefaultTableXYDataset defaultTableXYDataset = new DefaultTableXYDataset();
        defaultTableXYDataset.addSeries(xYSeries);
        defaultTableXYDataset.addSeries(xYSeries2);
        TableXYDatasetTests.assertEquals((int)6, (int)defaultTableXYDataset.getItemCount());
        TableXYDatasetTests.assertEquals((int)6, (int)defaultTableXYDataset.getX(0, 5).intValue());
        TableXYDatasetTests.assertEquals(null, (Object)defaultTableXYDataset.getY(0, 5));
        TableXYDatasetTests.assertEquals((int)6, (int)defaultTableXYDataset.getX(1, 5).intValue());
        TableXYDatasetTests.assertEquals((int)2, (int)defaultTableXYDataset.getY(1, 5).intValue());
        xYSeries2.add(7.0, 2.0);
        TableXYDatasetTests.assertEquals((int)7, (int)defaultTableXYDataset.getItemCount());
        TableXYDatasetTests.assertEquals(null, (Object)defaultTableXYDataset.getY(0, 6));
        TableXYDatasetTests.assertEquals((int)2, (int)defaultTableXYDataset.getY(1, 6).intValue());
        defaultTableXYDataset.removeSeries(xYSeries);
        TableXYDatasetTests.assertEquals((int)7, (int)defaultTableXYDataset.getItemCount());
        defaultTableXYDataset.removeSeries(xYSeries2);
        xYSeries = this.createSeries1();
        defaultTableXYDataset.addSeries(xYSeries);
        TableXYDatasetTests.assertEquals((int)4, (int)defaultTableXYDataset.getItemCount());
    }

    public void test788597() {
        DefaultTableXYDataset defaultTableXYDataset = new DefaultTableXYDataset();
        defaultTableXYDataset.addSeries(this.createSeries1());
        TableXYDatasetTests.assertEquals((int)4, (int)defaultTableXYDataset.getItemCount());
        defaultTableXYDataset.removeAllSeries();
        TableXYDatasetTests.assertEquals((int)0, (int)defaultTableXYDataset.getItemCount());
    }

    public void testRemoveAllValuesForX() {
        DefaultTableXYDataset defaultTableXYDataset = new DefaultTableXYDataset();
        defaultTableXYDataset.addSeries(this.createSeries1());
        defaultTableXYDataset.addSeries(this.createSeries2());
        defaultTableXYDataset.removeAllValuesForX(new Double(2.0));
        TableXYDatasetTests.assertEquals((int)5, (int)defaultTableXYDataset.getItemCount());
        TableXYDatasetTests.assertEquals((Object)new Double(1.0), (Object)defaultTableXYDataset.getX(0, 0));
        TableXYDatasetTests.assertEquals((Object)new Double(3.0), (Object)defaultTableXYDataset.getX(0, 1));
        TableXYDatasetTests.assertEquals((Object)new Double(4.0), (Object)defaultTableXYDataset.getX(0, 2));
        TableXYDatasetTests.assertEquals((Object)new Double(5.0), (Object)defaultTableXYDataset.getX(0, 3));
        TableXYDatasetTests.assertEquals((Object)new Double(6.0), (Object)defaultTableXYDataset.getX(0, 4));
    }

    public void testPrune() {
        DefaultTableXYDataset defaultTableXYDataset = new DefaultTableXYDataset();
        defaultTableXYDataset.addSeries(this.createSeries1());
        defaultTableXYDataset.addSeries(this.createSeries2());
        defaultTableXYDataset.removeSeries(1);
        defaultTableXYDataset.prune();
        TableXYDatasetTests.assertEquals((int)4, (int)defaultTableXYDataset.getItemCount());
    }

    public void testAutoPrune() {
        DefaultTableXYDataset defaultTableXYDataset = new DefaultTableXYDataset(true);
        defaultTableXYDataset.addSeries(this.createSeriesA());
        TableXYDatasetTests.assertEquals((int)2, (int)defaultTableXYDataset.getItemCount());
        defaultTableXYDataset.addSeries(this.createSeriesB());
        TableXYDatasetTests.assertEquals((int)2, (int)defaultTableXYDataset.getItemCount());
        defaultTableXYDataset.removeSeries(1);
        TableXYDatasetTests.assertEquals((int)1, (int)defaultTableXYDataset.getItemCount());
        DefaultTableXYDataset defaultTableXYDataset2 = new DefaultTableXYDataset(true);
        defaultTableXYDataset2.addSeries(this.createSeriesA());
        TableXYDatasetTests.assertEquals((int)2, (int)defaultTableXYDataset2.getItemCount());
        defaultTableXYDataset2.addSeries(this.createSeriesB());
        TableXYDatasetTests.assertEquals((int)2, (int)defaultTableXYDataset2.getItemCount());
        defaultTableXYDataset2.removeSeries(1);
        TableXYDatasetTests.assertEquals((int)1, (int)defaultTableXYDataset2.getItemCount());
    }

    private XYSeries createSeriesA() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"A"), true, false);
        xYSeries.add(1.0, 1.1);
        xYSeries.add(2.0, (Number)null);
        return xYSeries;
    }

    private XYSeries createSeriesB() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"B"), true, false);
        xYSeries.add(1.0, (Number)null);
        xYSeries.add(2.0, 2.2);
        return xYSeries;
    }

    private XYSeries createSeries1() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 1"), true, false);
        xYSeries.add(1.0, 1.0);
        xYSeries.add(2.0, 1.0);
        xYSeries.add(4.0, 1.0);
        xYSeries.add(5.0, 1.0);
        return xYSeries;
    }

    private XYSeries createSeries2() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 2"), true, false);
        xYSeries.add(2.0, 2.0);
        xYSeries.add(3.0, 2.0);
        xYSeries.add(4.0, 2.0);
        xYSeries.add(5.0, 2.0);
        xYSeries.add(6.0, 2.0);
        return xYSeries;
    }
}

