/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.xy.MatrixSeries;

public class MatrixSeriesTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(MatrixSeriesTests.class);
    }

    public MatrixSeriesTests(String string) {
        super(string);
    }

    public void testEquals() {
        MatrixSeries matrixSeries = new MatrixSeries("Test", 8, 3);
        matrixSeries.update(0, 0, 11.0);
        matrixSeries.update(7, 2, 22.0);
        MatrixSeries matrixSeries2 = new MatrixSeries("Test", 8, 3);
        matrixSeries2.update(0, 0, 11.0);
        matrixSeries2.update(7, 2, 22.0);
        MatrixSeriesTests.assertTrue((boolean)matrixSeries.equals(matrixSeries2));
        MatrixSeriesTests.assertTrue((boolean)matrixSeries2.equals(matrixSeries));
        matrixSeries = new MatrixSeries("Test 2", 8, 3);
        MatrixSeriesTests.assertFalse((boolean)matrixSeries.equals(matrixSeries2));
        matrixSeries2 = new MatrixSeries("Test 2", 8, 3);
        MatrixSeriesTests.assertTrue((boolean)matrixSeries.equals(matrixSeries2));
        matrixSeries = new MatrixSeries("Test 2", 10, 3);
        MatrixSeriesTests.assertFalse((boolean)matrixSeries.equals(matrixSeries2));
        matrixSeries2 = new MatrixSeries("Test 2", 10, 3);
        MatrixSeriesTests.assertTrue((boolean)matrixSeries.equals(matrixSeries2));
        matrixSeries = new MatrixSeries("Test 2", 10, 5);
        MatrixSeriesTests.assertFalse((boolean)matrixSeries.equals(matrixSeries2));
        matrixSeries2 = new MatrixSeries("Test 2", 10, 5);
        MatrixSeriesTests.assertTrue((boolean)matrixSeries.equals(matrixSeries2));
    }

    public void testCloning() {
        MatrixSeries matrixSeries = new MatrixSeries("Test", 8, 3);
        matrixSeries.update(0, 0, 11.0);
        matrixSeries.update(7, 2, 22.0);
        MatrixSeries matrixSeries2 = null;
        try {
            matrixSeries2 = (MatrixSeries)matrixSeries.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        MatrixSeriesTests.assertTrue((matrixSeries != matrixSeries2 ? 1 : 0) != 0);
        MatrixSeriesTests.assertTrue((matrixSeries.getClass() == matrixSeries2.getClass() ? 1 : 0) != 0);
        MatrixSeriesTests.assertTrue((boolean)matrixSeries.equals(matrixSeries2));
    }

    public void testSerialization() {
        MatrixSeries matrixSeries = new MatrixSeries("Test", 8, 3);
        matrixSeries.update(0, 0, 11.0);
        matrixSeries.update(7, 2, 22.0);
        MatrixSeries matrixSeries2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(matrixSeries);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            matrixSeries2 = (MatrixSeries)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            MatrixSeriesTests.fail((String)exception.toString());
        }
        MatrixSeriesTests.assertEquals((Object)matrixSeries, matrixSeries2);
    }

    public void testGetItemColumn() {
        MatrixSeries matrixSeries = new MatrixSeries("Test", 3, 2);
        MatrixSeriesTests.assertEquals((int)0, (int)matrixSeries.getItemColumn(0));
        MatrixSeriesTests.assertEquals((int)1, (int)matrixSeries.getItemColumn(1));
        MatrixSeriesTests.assertEquals((int)0, (int)matrixSeries.getItemColumn(2));
        MatrixSeriesTests.assertEquals((int)1, (int)matrixSeries.getItemColumn(3));
        MatrixSeriesTests.assertEquals((int)0, (int)matrixSeries.getItemColumn(4));
        MatrixSeriesTests.assertEquals((int)1, (int)matrixSeries.getItemColumn(5));
    }

    public void testGetItemRow() {
        MatrixSeries matrixSeries = new MatrixSeries("Test", 3, 2);
        MatrixSeriesTests.assertEquals((int)0, (int)matrixSeries.getItemRow(0));
        MatrixSeriesTests.assertEquals((int)0, (int)matrixSeries.getItemRow(1));
        MatrixSeriesTests.assertEquals((int)1, (int)matrixSeries.getItemRow(2));
        MatrixSeriesTests.assertEquals((int)1, (int)matrixSeries.getItemRow(3));
        MatrixSeriesTests.assertEquals((int)2, (int)matrixSeries.getItemRow(4));
        MatrixSeriesTests.assertEquals((int)2, (int)matrixSeries.getItemRow(5));
    }

    public void testGetItem() {
        MatrixSeries matrixSeries = new MatrixSeries("Test", 3, 2);
        matrixSeries.update(0, 0, 0.0);
        matrixSeries.update(0, 1, 1.0);
        matrixSeries.update(1, 0, 2.0);
        matrixSeries.update(1, 1, 3.0);
        matrixSeries.update(2, 0, 4.0);
        matrixSeries.update(2, 1, 5.0);
        MatrixSeriesTests.assertEquals((double)0.0, (double)matrixSeries.getItem(0).doubleValue(), (double)0.001);
        MatrixSeriesTests.assertEquals((double)1.0, (double)matrixSeries.getItem(1).doubleValue(), (double)0.001);
        MatrixSeriesTests.assertEquals((double)2.0, (double)matrixSeries.getItem(2).doubleValue(), (double)0.001);
        MatrixSeriesTests.assertEquals((double)3.0, (double)matrixSeries.getItem(3).doubleValue(), (double)0.001);
        MatrixSeriesTests.assertEquals((double)4.0, (double)matrixSeries.getItem(4).doubleValue(), (double)0.001);
        MatrixSeriesTests.assertEquals((double)5.0, (double)matrixSeries.getItem(5).doubleValue(), (double)0.001);
    }
}

