/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYSeries;

public class DefaultTableXYDatasetTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(DefaultTableXYDatasetTests.class);
    }

    public DefaultTableXYDatasetTests(String string) {
        super(string);
    }

    public void testEquals() {
        DefaultTableXYDataset defaultTableXYDataset = new DefaultTableXYDataset();
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 1"), true, false);
        xYSeries.add(1.0, 1.1);
        xYSeries.add(2.0, 2.2);
        defaultTableXYDataset.addSeries(xYSeries);
        DefaultTableXYDataset defaultTableXYDataset2 = new DefaultTableXYDataset();
        XYSeries xYSeries2 = new XYSeries((Comparable)((Object)"Series 1"), true, false);
        xYSeries2.add(1.0, 1.1);
        xYSeries2.add(2.0, 2.2);
        defaultTableXYDataset2.addSeries(xYSeries2);
        DefaultTableXYDatasetTests.assertTrue((boolean)defaultTableXYDataset.equals(defaultTableXYDataset2));
        DefaultTableXYDatasetTests.assertTrue((boolean)defaultTableXYDataset2.equals(defaultTableXYDataset));
        xYSeries.add(3.0, 3.3);
        DefaultTableXYDatasetTests.assertFalse((boolean)defaultTableXYDataset.equals(defaultTableXYDataset2));
        xYSeries2.add(3.0, 3.3);
        DefaultTableXYDatasetTests.assertTrue((boolean)defaultTableXYDataset.equals(defaultTableXYDataset2));
    }

    public void testCloning() {
        DefaultTableXYDataset defaultTableXYDataset = new DefaultTableXYDataset();
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 1"), true, false);
        xYSeries.add(1.0, 1.1);
        xYSeries.add(2.0, 2.2);
        defaultTableXYDataset.addSeries(xYSeries);
        DefaultTableXYDataset defaultTableXYDataset2 = null;
        try {
            defaultTableXYDataset2 = (DefaultTableXYDataset)defaultTableXYDataset.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        DefaultTableXYDatasetTests.assertTrue((defaultTableXYDataset != defaultTableXYDataset2 ? 1 : 0) != 0);
        DefaultTableXYDatasetTests.assertTrue((defaultTableXYDataset.getClass() == defaultTableXYDataset2.getClass() ? 1 : 0) != 0);
        DefaultTableXYDatasetTests.assertTrue((boolean)defaultTableXYDataset.equals(defaultTableXYDataset2));
    }

    public void testSerialization() {
        DefaultTableXYDataset defaultTableXYDataset = new DefaultTableXYDataset();
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 1"), true, false);
        xYSeries.add(1.0, 1.1);
        xYSeries.add(2.0, 2.2);
        defaultTableXYDataset.addSeries(xYSeries);
        DefaultTableXYDataset defaultTableXYDataset2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(defaultTableXYDataset);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            defaultTableXYDataset2 = (DefaultTableXYDataset)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        DefaultTableXYDatasetTests.assertEquals((Object)defaultTableXYDataset, defaultTableXYDataset2);
    }
}

