/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.TimePeriodFormatException;
import org.jfree.data.time.Year;

public class YearTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(YearTests.class);
    }

    public YearTests(String string) {
        super(string);
    }

    protected void setUp() {
    }

    public void testEqualsSelf() {
        Year year = new Year();
        YearTests.assertTrue((boolean)year.equals(year));
    }

    public void testEquals() {
        Year year = new Year(2002);
        Year year2 = new Year(2002);
        YearTests.assertTrue((boolean)year.equals(year2));
    }

    public void testDateConstructor1() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Date date = new Date(1009843199999L);
        Date date2 = new Date(1009843200000L);
        Year year = new Year(date, timeZone);
        Year year2 = new Year(date2, timeZone);
        YearTests.assertEquals((int)2001, (int)year.getYear());
        YearTests.assertEquals((long)1009843199999L, (long)year.getLastMillisecond(timeZone));
        YearTests.assertEquals((int)2002, (int)year2.getYear());
        YearTests.assertEquals((long)1009843200000L, (long)year2.getFirstMillisecond(timeZone));
    }

    public void testDateConstructor2() {
        TimeZone timeZone = TimeZone.getTimeZone("America/Los_Angeles");
        Year year = new Year(new Date(1009871999999L), timeZone);
        Year year2 = new Year(new Date(1009872000000L), timeZone);
        YearTests.assertEquals((int)2001, (int)year.getYear());
        YearTests.assertEquals((long)1009871999999L, (long)year.getLastMillisecond(timeZone));
        YearTests.assertEquals((int)2002, (int)year2.getYear());
        YearTests.assertEquals((long)1009872000000L, (long)year2.getFirstMillisecond(timeZone));
    }

    public void test1900Previous() {
        Year year = new Year(1900);
        Year year2 = (Year)year.previous();
        YearTests.assertNull((Object)year2);
    }

    public void test1900Next() {
        Year year = new Year(1900);
        Year year2 = (Year)year.next();
        YearTests.assertEquals((int)1901, (int)year2.getYear());
    }

    public void test9999Previous() {
        Year year = new Year(9999);
        Year year2 = (Year)year.previous();
        YearTests.assertEquals((int)9998, (int)year2.getYear());
    }

    public void test9999Next() {
        Year year = new Year(9999);
        Year year2 = (Year)year.next();
        YearTests.assertNull((Object)year2);
    }

    public void testParseYear() {
        Year year = null;
        try {
            year = Year.parseYear("2000");
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            year = new Year(1900);
        }
        YearTests.assertEquals((int)2000, (int)year.getYear());
        try {
            year = Year.parseYear(" 2001 ");
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            year = new Year(1900);
        }
        YearTests.assertEquals((int)2001, (int)year.getYear());
        try {
            year = Year.parseYear("99");
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            year = new Year(1900);
        }
        YearTests.assertEquals((int)1900, (int)year.getYear());
    }

    public void testSerialization() {
        Year year = new Year(1999);
        Year year2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(year);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            year2 = (Year)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        YearTests.assertEquals((Object)year, year2);
    }

    public void testNotCloneable() {
        Year year = new Year(1999);
        YearTests.assertFalse((boolean)(year instanceof Cloneable));
    }

    public void testHashcode() {
        Year year = new Year(1988);
        Year year2 = new Year(1988);
        YearTests.assertTrue((boolean)year.equals(year2));
        int n = year.hashCode();
        int n2 = year2.hashCode();
        YearTests.assertEquals((int)n, (int)n2);
    }
}

